<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    pdf pour le bilan general du test de positionnement

    Bilan pour un utilisateur

    @param integer : $formation numero de la formation
    @param integer : $liste numero de la liste de test de positionnement
    @param integer : $user numero du user
    @param integer : $parcours numero du parcours de la formation

*/
require('../dbpostgres.php3');
$db=pg_connect($server,"","","","$nombase");
//require("$chemin_bo/lib/obj_liste_test.php");
//require("$chemin_bo/lib/obj_individu.php");
require("$chemin_bo/lib/lib_test.php");
require("$chemin_bo/lib/lib_parcours.php");
require('./analyse_fonctions.php');
define('FPDF_FONTPATH',"$chemin_bo/classement/pdf/fpdf/font/");
include("$chemin_bo/classement/pdf/fpdf/fpdf.php");
include("$chemin_bo/classement/pdf/fpdf/pdf_Afide.php");


/*---------------------------------------------------------------------*/
//                  INITIALISATION
/*---------------------------------------------------------------------*/
$obj_liste=new Liste_test($liste);
$nb_test=$obj_liste->getNbTests();
$obj_user=new Individu($user);
$login=$obj_user->login;
$nom=$obj_user->nom;
$prenom=$obj_user->prenom;
//echo "login=$login<br>";
// nom du test
$nom_liste=$obj_liste->toString();
// nom du user
$nom_user=$obj_user->toString();
// tableau pour les couleurs de tests
$tab_couleur_test=array("#ffcc00"=>array("#ffe374","#ffed4a","#ffffc6"),
                                        "#0054ff"=>array("#4c94ff","#95c0ff","#b7e3ff"),
                                        "#009900"=>array("#02bf02","#5aed5a","#7bff7b"),
                                        "#990099"=>array("#d040d0","#e48ee4","#ffb0ff"));
// Les autre couleur (texte, cellule)
$couleur_gris="#cccccc";
$couleur_rouge="#ff0000";
// titre de la page pdf + taille
$titre_page="1 - BILAN GENERAL DES INCOHERENCES ENTRE L'AUTO-POSITIONNEMENT ET LES QCM";
//Dimension d'une page A4
$largeur_page=210;
$hauteur_page=297;

//Marges horizontale et verticale
$marge=10;
$margey=25;



/*---------------------------------------------------------------------*/
//              CREATION DU PDF
/*---------------------------------------------------------------------*/
$pdf=new pdf_Afide();
$pdf->setMargins($marge,$marge);
$pdf->Open();
$pdf->AddPage();
$pdf->setAuthor("AFIDE");
$pdf->setCreator("FPDF");
$pdf->SetFont('Helvetica','B',10);
$pdf->setY($margey);
$pdf->setFillColor(255);
// affichage du titre de la page
$pdf->Cell(0,16,$titre_page,1,2,'C',1);
// nom du test et du user
$pdf->SetFont('Helvetica','B',8);
$pdf->Cell(0,10,"Test : $nom_liste",0,0,'L',0);
$pdf->ln();
$pdf->Cell(0,10,"Identifiant : $nom_user",0,0,'L',0);
$pdf->ln();
// date des rsultats
$tab=dates_test_auto_positionnement($liste);
$datetest=gmdate("d-m-Y  G:i:s",$tab[0]);
if(CHARSET=='UTF-8')
	$chaine_date=utf8_decode($MSG_2132);
else
	$chaine_date=$MSG_2132;
//$pdf->Cell(0,10,"Date des rsultats : $datetest",0,2,'L',0);
$pdf->Cell(0,10,"$chaine_date : $datetest",0,2,'L',0);

/*---------------------------------------------------------------------*/
//                          1er TABLEAU
/*---------------------------------------------------------------------*/
$pdf->SetFont('Helvetica','BU',10);
$pdf->Cell(0,14,"Bilan du test d'auto-positionnement",0,2,'L',0);
// Boucle sur les tests
$pdf->SetFont('Helvetica','B',8);
for($i=0;$i<$nb_test;$i++){
    $obj_test=&$obj_liste->getTest($i);
    // nom du test
    $nom_test=$obj_test->toString();
    // nb de reponses pour ce test
    $nb_reponse=$obj_test->getNbReponses();
    // couleur pout le titre du test
     if($i%4==0)
            reset($tab_couleur_test);
    list($couleur_titre)=each($tab_couleur_test);
    reset($tab_couleur_test["$couleur_titre"]);
    // couleur en R V B
    couleur_hexdec($couleur_titre,&$r,&$v,&$b);
    $pdf->setFillColor($r,$v,$b);
    $pdf->setX($marge);
    $pdf->Cell(50,24,$nom_test,1,0,'L',1);
    $y=$pdf->getY();
    $pdf->setX(70);
    $pdf->Cell(120,8,"Nombre de CASES COCHEES pour le test d'auto-positionnement",1,1,'C',1);
    // boucle sur les reponses
    // taille de la cellule pour une reponse
    $taille_cellule=120/$nb_reponse;
    $pdf->setX(70+$x);
    for($j=0;$j<$nb_reponse;$j++){
        $obj_reponse=&$obj_test->getReponse($j);
        $nom_reponse=$obj_reponse->toString();
        if(CHARSET=='UTF-8')
			$nom_reponse=utf8_decode($nom_reponse);
        list($cle,$couleur_reponse)=each($tab_couleur_test["$couleur_titre"]);
        couleur_hexdec($couleur_reponse,&$r,&$v,&$b);
        $pdf->setFillColor($r,$v,$b);
        $pdf->Cell($taille_cellule,8,$nom_reponse,1,'','C',1);
    }
    // boucle sur les nb de coches
    $pdf->Ln(); // saut de ligne
    $pdf->setX(70+$x);  // repositionnement en abcisse
    for($j=0;$j<$nb_reponse;$j++){
        $obj_reponse=&$obj_test->getReponse($j);
        // numero de la reponse
        $num_reponse=$obj_reponse->getId();
		/*
        $sql="select count(1) from res_liste_test where id_formation=$formation and id_stag=$user and ordre_etape=$i+1 and reponse=$num_reponse";
        $res=pg_query($sql);
		*/
		$etape=$i + 1;
		$res=get_liste_test_reponse_cochee($formation,$liste,$user,$etape,$num_reponse);
        $row=pg_fetch_row($res,0);
        $pdf->Cell($taille_cellule,8,$row[0],1,'','C');
    }
    $pdf->Ln(); // saut de ligne
}
/*---------------------------------------------------------------------*/
//                          2ieme TABLEAU
/*---------------------------------------------------------------------*/
$pdf->SetFont('Helvetica','BU',10);
$pdf->Cell(0,14,"Bilan des QCM",0,2,'L',0);
reset($tab_couleur_test);
/*--------------------------------------------- Ligne 1 ---------------------------*/
$pdf->setX($marge);
$pdf->SetFont('Helvetica','B',8);
$pdf->setFillColor(255);
$pdf->Cell(72,16,"EVALUATION",1,0,'C',1);
$pdf->Cell(24,16,"RESULTATS",1,0,'C',1);
$pdf->Cell(24,16,"ECART (point)",1,0,'C',1);
$pdf->Cell(24,16,"MOYENNE",1,0,'C',1);

$pdf->Ln(); // saut de ligne
 $tabecart=array();
  $tab_coeff_test=array();
    $tabmoyenne_test=array();

//$taille_cellule_test=150/$nb_test;
// boucle sur les test (affiche les noms de test)
//$pdf->setX(34);
for($i=0;$i<$nb_test;$i++){

    $obj_test=&$obj_liste->getTest($i);
    $nom_test=$obj_test->toString();
    //$obj_test=&$obj_liste->getTest($i);
    // recup du n du test
    $num_test=$obj_test->getId();
    $num_serie=numero_serie($num_test,$parcours,$liste);
    $point=0;
    $total=0;
    $coeff_rep=0;
    //$moyenne_test=0;

    // nb de reponses pour ce test (sauf la derniere)
    $nb_reponse=$obj_test->getNbReponses() -1;
    // couleur pout le titre du test
    if($i%4==0)
        reset($tab_couleur_test);
    list($couleur_titre)=each($tab_couleur_test);
    reset($tab_couleur_test["$couleur_titre"]);
    // couleur en R V B
    couleur_hexdec($couleur_titre,&$r,&$v,&$b);
    $pdf->setFillColor($r,$v,$b);
    $pdf->setTextColor(255);
    $pdf->SetFont('Helvetica','B',10);
    $pdf->Cell(144,8,$nom_test,1,0,'L',1);
    $pdf->SetFont('Helvetica','B',8);
    /*
    $pdf->Cell(24,8,"",1,0,'C',1);
    $pdf->Cell(24,8,"",1,0,'C',1);
    $pdf->Cell(24,8,"",1,0,'C',1);
    */
    $pdf->Ln(); // saut de ligne
    //BOUCLE SUR LES RPONSES

    for($j=0;$j<$nb_reponse;$j++){
        $obj_reponse=&$obj_test->getReponse($j);
        $nom_reponse=$obj_reponse->toString();
		 if(CHARSET=='UTF-8')
			$nom_reponse=utf8_decode($nom_reponse);
        list($cle,$couleur_reponse)=each($tab_couleur_test["$couleur_titre"]);
        couleur_hexdec($couleur_reponse,&$r,&$v,&$b);
        $pdf->setFillColor($r,$v,$b);
        $pdf->setTextColor(0);
        $pdf->Cell(72,8,$nom_reponse,1,'','C',1);
        $pdf->setFillColor(255);
        // resultat ------------------------------------------------------------------------------------------------------------------------------
         // le bareme pour cette reponse
        $bareme=$obj_reponse->bareme;
        // numer de reponse
        $num_reponse=$obj_reponse->getId();
        // recup ds un tableau des numero d'exo pour cette reponse ,ce test et le type 'q'
        // NOTE : Prvoir un mthode
        $tabexo=array();
        $tabexo=stock_exo_rep_test($num_test,$num_reponse,'','q');
        // recup moyenne pour cette reponse et type
        $str_moy=moyenne_rep($tabexo,$num_serie,$bareme,$type='q');
        if($str_moy!="X"){
            $tab=explode("/",$str_moy);
            $ecart_courant=$tab[1] - $tab[0];
            //$tabecart[]=$tab[1] - $tab[0];
            $tabecart[]=$ecart_courant;
            $point +=$tab[0];
            $total +=$tab[1];
             // recup coeff_rep
             $coeff_rep +=$tab[1];
            $point_test +=$tab[0];
            $total_test +=$tab[1];
            if($tab[0]==$tab[1])
                $couleur="#008040";
            else
                $couleur="#ff0000";
        }
        else{
            $ecart_courant="0";
            $tabecart[]=0;
            $couleur="#000000";

        }
        couleur_hexdec($couleur,&$r,&$v,&$b);
        //$pdf->setFillColor($r,$v,$b);
        $pdf->setTextColor($r,$v,$b);
        $pdf->Cell(24,8,$str_moy,1,'','C',1);
        //ecart ---------------------------------------------------------------------------------------------------------------------
        $pdf->setTextColor(0);
        $pdf->Cell(24,8,"$ecart_courant",1,'','C',1);
    //$pdf->Ln(); // saut de ligne




        //moyenne -----------------------------------------------------------------------------------------------------------------
         // stockage des coefficient de test
    //$tab_coeff_test[]=$coeff_rep;
    // stockage des moyenne de test
    if($total!=0){
        //$moyenne_test=$point_test * (20/$total_test);
        $moyenne_test=$point * (20/$total);
        $moyenne_test *=100;
        $moyenne_test = round($moyenne_test);
        $moyenne_test /=100;
        //$tabmoyenne_test[]=$moyenne_test;
        $mt =$moyenne_test;
    }
    else{
        //$tabmoyenne_test[]=-1;
        $moyenne_test="X";
        $mt=- 1;
    }


//}
if($total!=0)
    if($point==$total)
        $couleur="#008040";
    else
        $couleur="#ff0000";
else
    $couleur="#000000";
couleur_hexdec($couleur,&$r,&$v,&$b);
$pdf->setTextColor($r,$v,$b);
couleur_hexdec($couleur_gris,&$r,&$v,&$b);
$pdf->setFillColor($r,$v,$b);
$haut_cell=8*$nb_reponse;
// svg coordonnes
if($j==0){
    $oldx=$pdf->getX();
    $oldy=$pdf->getY();
    //print("x=$oldx et y=$oldy<br>");
}
if($j==$nb_reponse -1){

    $ajust= 8;
    if($nb_reponse>1){
        $ajust= ($nb_reponse)*8;
        $pdf->setY($oldy);
         $pdf->setX($oldx);
    }

    $pdf->Cell(24,$ajust,"$moyenne_test/20",1,0,'C',1);
    //$pdf->setX($x);
    //$pdf->setY($y);

}
else{

    $pdf->setX($pdf->getX() + 24);
}
$pdf->Ln(); // saut de ligne
}
$tab_coeff_test[]=$coeff_rep;
$tabmoyenne_test[]=$mt;
}
// total ----------------------------------------------------------------------------------------------------------------------
$pdf->setTextColor(0);
$pdf->Cell(72,16,"TOTAL",1,0,'C',1);
//-------------------------------------------
if($total!=0)
    if($point==$total)
        $couleur="#008040";
    else
        $couleur="#ff0000";
else
    $couleur="#000000";
couleur_hexdec($couleur,&$r,&$v,&$b);
$pdf->setTextColor($r,$v,$b);
couleur_hexdec($couleur_gris,&$r,&$v,&$b);
$pdf->setFillColor($r,$v,$b);
$pdf->Cell(24,16,"$point_test / $total_test",1,0,'C',1);
//------------------------------------------
$somme_ecart=array_sum($tabecart);
if($somme_ecart>1)
    $pt="points";
else
    $pt="point";
couleur_hexdec($couleur_gris,&$r,&$v,&$b);
$pdf->setFillColor($r,$v,$b);
$pdf->setTextColor(0);
$pdf->Cell(24,16,"$somme_ecart $pt",1,0,'C',1);
//------------------------------------------
$somme_totale=array_sum($tabmoyenne_test);
$moyenne_totale=$somme_totale / $nb_test;
$moyenne_totale *=100;
$moyenne_totale=round($moyenne_totale);
$moyenne_totale /=100;
$sz=sizeof($tabmoyenne_test);
// debug
//echo "sz=$sz<br>";
$tabmoy=array();
for($i=0;$i<$sz;$i++){
    //debug
    //echo "tabmoyenne_test[$i]=$tabmoyenne_test[$i]<br>";
    if($tabmoyenne_test[$i]>=0){
        // debug
        //echo "tabmoyenne_test[$i]=$tabmoyenne_test[$i]<br>";
        $tabmoy[]=$tabmoyenne_test[$i];
    }
    //else
        //echo "t=$tabmoyenne_test[$i]<br>";
}
$nb=sizeof($tabmoy);
//debug
//echo "nb=$nb<br>";
if($nb>0){
/*
    $somme_totale=array_sum($tabmoy);
    $moyenne_totale=$somme_totale / $nb;
    $moyenne_totale *=100;
    $moyenne_totale=round($moyenne_totale);
    $moyenne_totale /=100;
    */
     // calcul avec prise en compte des coefficients
    $somme_totale=0;
    for($i=0;$i<$nb;$i++){
        if($tabmoy[$i]!="X")
            $somme_totale +=($tabmoy[$i]*$tab_coeff_test[$i]);

    }
    $moyenne_totale=$somme_totale/(array_sum($tab_coeff_test));
    $moyenne_totale *=100;
    $moyenne_totale=round($moyenne_totale);
    $moyenne_totale /=100;
}
else
    $moyenne_totale="X";
if($moyenne_totale==20)
    $couleur="#008040";
else
    $couleur="#ff0000";
couleur_hexdec($couleur,&$r,&$v,&$b);
$pdf->setTextColor($r,$v,$b);
couleur_hexdec($couleur_gris,&$r,&$v,&$b);
$pdf->setFillColor($r,$v,$b);

$pdf->Cell(24,16,"$moyenne_totale / 20",1,0,'C',1);








// fichier user
$file=$nom."_".$prenom."_general.pdf";


$pdf->Output($file,1);















?>