<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    Dresse le bilan detaill  un test de positionnement

    Bilan pour un utilisateur

    @param integer : $liste numero de la liste de test de positionnement
    @param integer : $user numero du user

*/
require('../dbpostgres.php3');
$db=pg_connect($server,"","","","$nombase");
//require("$chemin_bo/lib/obj_liste_test.php");
require("$chemin_bo/lib/obj_question.php");
//require("$chemin_bo/lib/obj_individu.php");
require("$chemin_bo/lib/lib_test.php");
require("$chemin_bo/lib/lib_parcours.php");
require('./analyse_fonctions.php');

/*---------------------------------------------------------------------*/
//                  INITIALISATION
/*---------------------------------------------------------------------*/
$obj_liste=new Liste_test($liste);
// nombre de test pour la liste
$nb_test=$obj_liste->getNbTests();

$obj_user=new Individu($user);

// tableau pour les couleurs de tests
$tab_couleur_test=array("#ffcc00"=>array("#ffe374","#ffed4a","#ffffc6"),
                                        "#0054ff"=>array("#4c94ff","#95c0ff","#b7e3ff"),
                                        "#009900"=>array("#02bf02","#5aed5a","#7bff7b"),
                                        "#990099"=>array("#d040d0","#e48ee4","#ffb0ff"));

/*---------------------------------------------------------------------*/
//                  AFFICHAGE ENTETE
/*---------------------------------------------------------------------*/
$nompage="bilan_detaille.php";
$titre="";
$path='..';
//$styleCSS="./style_analyse.css";
$styleCSS="../style/".MY_STYLE."/ressourcesAdministratives.css";
include('../entete.php3');

// affichage du titre de la page
print("
<br>
<table class=\"tableau_message\"><tr>
<td><b>$MSG_2133</b></td>
</tr></table>
<br>
");
print("
<br>
<table width=\"90%\"><tr><td>
<b>$MSG_1838 :</b> ".$obj_liste->toString()."<br>
<b>$MSG_80 :</b> ".$obj_user->toString()."<br>
<b>$MSG_2132 :</b> <br>
");
$tab=dates_test_auto_positionnement($liste);

if(CHARSET=="UTF-8")
    $symbole_numero = "°" ;
else
    $symbole_numero = "" ;

print("
<b>- $MSG_1838 :</b> ".gmdate("d-m-Y $MOT_10 G:i:s",$tab[0])."<br>
");

for($i=0;$i<$nb_test;$i++){
    $ind=$i+1;
    print("<b>- $MSG_1267 n".$symbole_numero." $ind :</b> ");
    if($tab[$ind]=="X")
    print("$MSG_913");
    else
        print gmdate("d-m-Y $MOT_10 G:i:s",$tab[$ind]);
    print("<br>");
}

print("
</td></tr></table>
<br><br>
");
/*---------------------------------------------------------------------*/
//  TABLEAU 1
/*---------------------------------------------------------------------*/
print("
<table width=\"90%\"><tr><td>
<b><u>$MSG_2131</u> :</b>
</td></tr>
<tr><td align=\"center\">

");

// calcul du td n 2 (depend du nb de reponses max des tests)
$max_rep=0;
for($i=0;$i<$nb_test;$i++){
    $obj_test=&$obj_liste->getTest($i);
    // nb de reponses pour ce test
    $nb_reponse=$obj_test->getNbReponses() -1;
    if($nb_reponse>$max_rep)
        $max_rep=$nb_reponse;
}
// debug
//echo "max_rep=$max_rep<br>";
print("
<table border=1 width=90%>
<tr bgcolor=\"#cccccc\">
<td>
<b><font face=\"Arial,Helvetica\" size=2>$MSG_2125</font></b>
</td>
<td colspan=$max_rep align=center>
<b><font face=\"Arial,Helvetica\" size=2>$MSG_2126</font></b>
</td>
<td align=center>
<b><font face=\"Arial,Helvetica\" size=2>$MSG_2130</font></b>
</td>
</tr>
");
$existe_erreur=0;
// boucle sur les tests
for($i=0;$i<$nb_test;$i++){
    $obj_test=&$obj_liste->getTest($i);
    $num_theme=$obj_test->getNumTheme();
    // debug
    //echo "theme=$num_theme<br>";
     list($couleur_titre)=each($tab_couleur_test);
    // numero du test
    $num_test=$obj_test->getId();
    // numero de la serie correspondante au test
    $num_serie=numero_serie($num_test,$parcours,$liste);
    // pour le stockage des exercices dont le score est gal  0
    $tab_numqst=array();
    $tab_numrep=array();
    $tab_ordreqst=array();
    // les reponses du test (saul la dernire)
    $nb_reponse=$obj_test->getNbReponses() -1;
    $tab_rep=array();
    // stockage des n de reponses
    for($j=0;$j<$nb_reponse;$j++){
        $obj_reponse=&$obj_test->getReponse($j);
        // numer de reponse
        $num_reponse=$obj_reponse->getId();
        $tab_rep[]=$num_reponse;
    }
    //debug
    /*
    $taille=sizeof($tab_rep);
    for($t=0;$t<$taille;$t++){
        echo "tab_rep[$t]=$tab_rep[$t]<br>";
    }
    */
    // recup des exo avec echec
    recup_exo_echec($num_serie,$num_test,'q',&$tab_numqst,&$tab_numrep,&$tab_ordreqst);
    // debug


    $sz=sizeof($tab_numqst);
    /*
    for($s=0;$s<$sz;$s++){
        echo "tab_numsqt[$s]=$tab_numqst[$s] et tab_numrep[$s]=$tab_numrep[$s] <br>";
    }
    */
    if($sz>0){
        $existe_erreur=1;
        if($nb_reponse==1)
            $colsp=$max_rep;
        else
            $colsp=1;
        print("
        <tr>
        <td bgcolor=\"$couleur_titre\">
        <b><font face=\"Arial,Helvetica\" size=2>".$obj_test->toString()."</font></b>
        </td>
        ");
        for($j=0;$j<$nb_reponse;$j++){
            $obj_reponse=&$obj_test->getReponse($j);
             if($j%4==0)
                reset($tab_couleur_test);
             list($cle,$couleur_reponse)=each($tab_couleur_test["$couleur_titre"]);
            print("
            <td bgcolor=\"$couleur_reponse\" align=\"center\" colspan=\"$colsp\">
            <b><font face=\"Arial,Helvetica\" size=2>".$obj_reponse->toString()."</font></b>
            </td>
            ");
        }
        print("
        <td bgcolor=\"#cccccc\" align=\"center\">
        <b><font face=\"Arial,Helvetica\" size=2>$MSG_2129</font></b>
        </td>
        </tr>
        ");
    }
    for($e=0;$e<$sz;$e++){
        //debug
        //echo "tab_numqst[$e]=$tab_numqst[$e]<br>";
        $id=$tab_numqst[$e];
        $obj_question=new Sondage($id);
        //$obj_question=&$obj_test->getExercice($tab_ordreqst[$e]);
        //$num_question=$obj_question->getId();
        $libelle_question=$obj_question->toString();
        $num_question=$obj_question->getId();
        //debug
        //echo "num_question=$num_question $tab_numqst[$e]<br>";
        //print_r($obj_question);

        print("
        <tr>
        <td>
        <b><font face=\"Arial,Helvetica\" size=2>".$obj_question->toString()."</font></b>
        </td>
        ");

         for($j=0;$j<$nb_reponse;$j++){
            $obj_reponse=&$obj_test->getReponse($j);
            $bareme=$obj_reponse->bareme;
            $num_rep=$obj_reponse->getId();
            print("
            <td align=\"center\" colspan=\"$colsp\">
            ");
            if($num_rep==$tab_numrep[$e]){
                //debug
                //echo "num_rep=$num_rep<br>";
                $num_reponse=$num_rep;
                print("
                <b>X</b>
                ");
            }
            else
                print("
            &nbsp;
            ");
            print("
            </td>
            ");
         }
         //debug
         //echo "qst=$num_question<br>test=$num_test<br>serie=$num_serie<br>";
         $lien="detailqcm.php?theme=$theme&test=$num_test&serie=$num_serie&formation=$formation&user=$user&question=$num_question&reponse=$num_reponse&liste=$liste";
         //debug
         //echo "lien=$lien<br>";
         $tabexo=array();
        $tabexo=stock_exo_rep_test($num_test,$num_reponse,$num_question,'q');
        // recup moyenne pour cette reponse et type
         $str_moy=moyenne_rep($tabexo,$num_serie,$bareme,$type='q');
         print("
         <td align=\"center\">
         <b><font face=\"Arial,Helvetica\" size=2><font color=\"#ff0000\">$str_moy</font><br>
         <!--<a href=\"#\" OnClick=\"window.open('detailqcm.php?id=$num_question&theme=$theme','detail','status=yes,scrollbars=yes,resizable=yes,width=900,height=700');-->
         <a class=\"action\" href=\"#\" OnClick=\"window.open('$lien','detail','status=yes,scrollbars=yes,resizable=yes,width=600,height=400');
         return (false);\">$MSG_2494</a>
         </font></b>
         </td></tr>
         ");
    }

}
if($existe_erreur==0){
    $cols=$max_rep+2;
    print("
    <tr>
    <td colspan=$cols align=center><b><font face=\"Arial,Helvetica\" size=2><font color=\"#ff0000\">$MSG_2128</font></b></td>
    </tr>
    ");
}
print("
</table>
");

/*---------------------------------------------------------------------*/
//  TABLEAU 2
/*---------------------------------------------------------------------*/
print("
<br><br>
<div align=left>
<font face=\"Arial,Helvetica\" size=2>
<b><u>$MSG_2127</u><br><br>
</font></div>
");
$obj_liste=new Liste_test($liste);
$nb_test=$obj_liste->getNbTests();
list($couleur_titre)=each($tab_couleur_test);
print("
<table border=1 width=90%>
<tr bgcolor=\"#cccccc\">
<td>
<b><font face=\"Arial,Helvetica\" size=2>$MSG_2125</font></b>
</td>
<td align=center>
<b><font face=\"Arial,Helvetica\" size=2>$MSG_2126</font></b>
</td>
</tr>
");
// boucle sur les tests
reset($tab_couleur_test);
for($i=0;$i<$nb_test;$i++){
    list($couleur_titre)=each($tab_couleur_test);
    $ordre=$i+1;
    $obj_test=&$obj_liste->getTest($i);
    // nom du test
    $libelle_test=$obj_test->toString();
    // numero du test
    $num_test=$obj_test->getId();
    // debug
    //echo "num_test=$num_test<br>";
    // recup de la derniere reponse
    $nb_reponse=$obj_test->getNbReponses();
    $obj_reponse=$obj_test->getReponse($nb_reponse -1);
    $num_reponse=$obj_reponse->getId();
    $libelle_reponse=$obj_reponse->toString();
    $couleur_reponse=$tab_couleur_test["$couleur_titre"][$nb_reponse -1];
    // debug
    //echo "num_reponse=$num_reponse<br>";
    // test si cette reponse a t coche
	/*
    $sql="select question from res_liste_test where id_stag=$user and id_formation=$formation and id_liste=$liste and ordre_etape=$ordre and reponse=$num_reponse ";
    $res=pg_query($sql);
	*/
	$res=get_liste_test_question_reponse_cochee($formation,$liste,$user,$ordre,$num_reponse);
    $nb=pg_numrows($res);
    if($nb>0){
        print("
        <tr>
        <td bgcolor=\"$couleur_titre\"><b><font face=\"Arial,Helvetica\" size=2>$libelle_test</font></b></td>
        <td bgcolor=\"$couleur_reponse\" align=\"center\"><b><font face=\"Arial,Helvetica\" size=2>$libelle_reponse</font></b></td>
        </tr>
        ");
        for($j=0;$j<$nb;$j++){
            $row=pg_fetch_row($res,$j);
            $obj_question=new Sondage($row[0]);
            $libelle_question=$obj_question->toString();
            print("
            <tr>
            <td><font face=\"Arial,Helvetica\" size=2>$libelle_question</font></td>
            <td align=center><font face=\"Arial,Helvetica\" size=2><b>x</b></font></td>
            </tr>
            ");
        }

    }


}



print("
</table>
</td>
</tr>
</table>
<br>
");


// ajout Elyes Mars 2005 : affichage du bouton retour dans le cas o on vient de la page de stats par utilisateur
if(isset($stats_user))
    print("<br>\n<center><form><input type=\"button\" value=\"$MSG_37\" onClick=\"history.back()\"></form>\n</center>\n");


include('../piedpage.php3');

?>