<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*---------------------------------------------------------------------------------*/
//  Fichier DetailCal.php3
//  Script qui propose les stats pour un exo donn
// (ou un qcm) et pour un calendrier
// Donnes reues : $qcm ou $blanc ou ....
// $num_cal $num_serie $num_grp
/*---------------------------------------------------------------------------------*/




/*if($PHP_SELF == "/classement/DetailCal.php3")$back = 1;
// le test ci dessus est faux pour les site en location
*/
$back=1;
/*if($back == 1){*/
  require('../dbpostgres.php3');
  require('../entete.php3');
  require('./constantes.php3');
  require('./fonctions_stat.php3');
  $db = pg_Connect("$server", "", "", "", "$nombase");
//}
// recup des nom de serie calendrier et groupe
//echo "cal=$num_cal - grp=$num_grp<br>";
$nom_grp=libelle($num_grp,$db,"classe");
$req="select nom,prenom from utilisateurs where num_user in (select distinct g_num_user from gestionnaire where g_num_cal='$num_cal')";
$res=pg_query($req);
$row=pg_fetch_row($res,0);
$formateur=$row[0]." ".$row[1];
$req="select nom_cal from calendrier where num_cal='$num_cal'";
$res=pg_query($req);
$row=pg_fetch_row($res,0);
$nom_cal=$row[0];
/**
 * Fonction qui affiche un graphe par repartition par rapport aux moyennes
 * $tab = tableau de moyenne sur 20
 */
function afficheGraph($tab){
  global $FORM_18,$FORM_19,$MSG_913;
  $donnees=array();
  for($i=0;$i<11;$i++){
    $donnees[$i]=0;
    reset($tab);
    while(list($id,$val)=each($tab)){
      if($val != "X" && $i != 10 && $val >= (float)(2*$i) && $val <= (float)(2*($i+1))){
	if($val != (2*($i+1)) || ($val == (2*($i+1)) && $val == 20)){
	  $donnees[$i]++;
	}
      }
      if($i == 10 && $val =="X"){
	$donnees[10]++;
      }
    }
  }
  $options = array('', 1, '', 1, 3);
  global $num_grp;
  global $num_qstaire;
  $nom_fic=$num_grp;
  $nom_fic .= "_$num_qstaire.png";
  $x=500;
  $y=250;
  $tabLegende=array("$FORM_18 0 $FORM_19 2",
		    "$FORM_18 2 $FORM_19 4",
		    "$FORM_18 4 $FORM_19 6",
		    "$FORM_18 6 $FORM_19 8",
		    "$FORM_18 8 $FORM_19 10",
		    "$FORM_18 10 $FORM_19 12",
		    "$FORM_18 12 $FORM_19 14",
		    "$FORM_18 14 $FORM_19 16",
		    "$FORM_18 16 $FORM_19 18",
		    "$FORM_18 18 $FORM_19 20",
		    "$MSG_913");
  global $couleurs;
  global $texte;
  global $premier_plan;
  global $arriere_plan;

  global $chemin_bo;
  require("./Camembert.php3");
  print("<img src=./cache-graphiques/$nom_fic>\n");

}


/**
 * Fonction de comparaison
 */
function compareScore($int1, $int2){
  if($int1 == "X")return(-1);
  if($int2 == "X")return(1);
  if($int1 < $int2)return(-1);
  if($int == $int2)return(0);
  return(1);
}

/**
 * Fonction qui va trier un tableau contenant une moyenne et une ligne d'un
 * tableau
 */
function triTab($tab){

  $tabNote=array();
  $tabLigne=array();
  for($i=0;$i<sizeof($tab);$i++){
    $tabNote[$i]=$tab[$i][0];
    $tabLigne[$i]=$tab[$i][1];
  }

  //uasort($tabNote,"compareScore");
  asort($tabNote);
  $i=0;
  while(list($id2,$ligne)=each($tabLigne)){
    list($id,$note)=each($tabNote);
    //print($tabLigne[$id]." = ".$note."<br>");
    $tabTmp[$i][1]=$tabLigne[$id];
    $tabTmp[$i][0]=$note;
    $i++;
  }
  return($tabTmp);
}

/**
 * Fonction qui retourne une chaine de caracteres representant
 * l interieur d'un tableau html tri par moyenne
 * $tab = Tableau tri
 */
function retourneTabHtml($tab){

  for($i=sizeof($tab)-1;$i>=0;$i--){
    $j=$i;
    $rowspan=1;
    $td=0;

    if($tab[$j+1][0] != $tab[$i][0]){
      while($tab[$j-1][0] == $tab[$i][0] && ($j>=1) ){
	$rowspan++;
	$td=1;
	$j=$j-1;
      }
    }
    //ligne unique
    if($tab[$i+1][0] != $tab[$i][0] &&
       $tab[$i-1][0] != $tab[$i][0] ){
      $td=1;
    }
    $affiche.="\t<tr>\n";
    if($td == 1){
      $affiche.=("\t\t<td rowspan=$rowspan align=\"center\"><b>");
      if($tab[$i][0] != -1)$affiche.=sizeof($tab)-$i;
      else $affiche.="Non class";
      $affiche.="</b></td>\n";
    }
    $affiche.=$tab[$i][1];
    $td=0;
  }
  return($affiche);
}


$tabMoyenne=array();
$pas_repondu=0;
$Tab_Val_Max_Qcm=array();
$Tab_Val_Max_Blanc=array();
$affiche;
$tabLigne=array();

/***************************************************
 * Stats pour un qcm
 ***************************************************/

if($qcm == 1){

  //recherche du nom du qcm
  $req_nom_qcm="SELECT libelle_qstaire FROM questionnaire
                WHERE num_qstaire='$num_qstaire' ";
  $resul=pg_query($req_nom_qcm);
  $nb=pg_numrows($resul);
  if($nb != 1)
    die("Erreur: base de donnes corrompue ou donnes incohrentes");

  $titres=pg_fetch_row($resul,0);
  $titre=$titres[0];

  print("<center>\n\n");

  if($back == 1){
    //Menu
    $menu=2;
    //include('./menuStatCal.php3');
  }

  //affichage du titre
  print("<h2>$MSG_905 <i>$titre</i></h2>\n");

  //on cherche les utilisateurs de ce groupe
  $req_user_grp="SELECT DISTINCT nom,prenom,num_user FROM utilisateurs u, gestionutil gu
                 WHERE gu.gu_num_user = u.num_user
                 AND gu.gu_num_gest_gr = '$num_grp'
                 ORDER BY nom";
  $resul=pg_query($req_user_grp);
  $nb=pg_numrows($resul);
  if($nb < 1)
    print("<h3>$ERROR_61</h3>\n\n");
  else{
    $affiche.=("<table border=\"1\">\n");
    $affiche.=("\t<tr bgcolor=\"#FFCCCC\">\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_906</td>\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_616</td>\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_2416</td>\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_901</td>\n");
    if($back == 1)$affiche.=("\t\t<td align=\"center\">$FORM_1</td>\n");
    $affiche.=("\t</tr>\n");
    $score_max_qcm=0;
    $score_user_qcm=0;
    for($i=0;$i<$nb;$i++){
      $rowUser=pg_fetch_row($resul,$i);
      //$tabLigne[$i][1]=("\t<tr>\n");
      $tabLigne[$i][1].=("\t\t<td align=\"center\">$rowUser[1] $rowUser[0]</td>\n");
      $score_qcm_user=getScoreQcm($rowUser[2],$num_qstaire,$num_cal);

      $score_user_qcm += $score_qcm_user;

      if( $pas_repondu == 1){
	$max_points_possible_qcm=0;
	$pas_repondu=0;
      }
      else{
	$max_points_possible_qcm=$Tab_Val_Max_Qcm[$num_qstaire];
	$score_max_qcm += $Tab_Val_Max_Qcm[$num_qstaire];
      }
      $tabLigne[$i][1].=("\t\t<td align=\"center\">$score_qcm_user / $max_points_possible_qcm</td>\n");

      $tab_Moyenne_Couleur=calculMoyenne($score_qcm_user,$max_points_possible_qcm);
      $moyenne=$tab_Moyenne_Couleur[0];
      $bgcolor=$tab_Moyenne_Couleur[1];
      $tabLigne[$i][1].=("\t\t<td align=\"center\" bgcolor=$bgcolor>$moyenne</td>\n");
      if($back == 1){
	$tabLigne[$i][1].=("\t\t<td align=\"center\"><a href=\"ScoreTotal.php3?num=$rowUser[2]&nom=$rowUser[0]&pre=$rowUser[1]&lstU=1\">$FORM_37</a></td>\n");
      }
      $tabLigne[$i][1].=("\t</tr>\n");
      $tabMoyenne[$i]=$moyenne;
      if(!is_double($moyenne) && $moyenne == "X")
	$tabLigne[$i][0]=-1;
      else $tabLigne[$i][0]=$moyenne;
    }


    //on trie le tableu de moyenne/ligne html
    $tabLigneTriee=triTab($tabLigne);
    //On recupere la partie interieur du tableau
    $affiche.=retourneTabHtml($tabLigneTriee);


    $affiche.=("\t<tr>\n");
    $affiche.=("\t\t<td align=\"center\" colspan=\"2\"><b>$MSG_869</b></td>\n");
    $affiche.=("\t\t<td align=\"center\"><b>$score_user_qcm / $score_max_qcm</b></td>\n");
    $moyenne="X";
    $bgcolor="#FFFFFF";

    if($score_max_qcm != 0){
      $moyenne=sprintf("%.2f",($score_user_qcm * (20/$score_max_qcm)));
      if($moyenne<10)$bgcolor="$mauvaise_reponse";
      else $bgcolor="$bonne_reponse";
    }
    $affiche.=("\t\t<td align=\"center\" bgcolor=$bgcolor colspan=\"2\"><b>$moyenne</b></td>\n");
    $affiche.=("\t</tr>\n");
    $affiche.=("</table>\n");
    $affiche.=("<br><br>\n");
    print("<h3>$MSG_907</h3>\n");
    afficheGraph($tabMoyenne);
    print("<br><br>\n");
    print("<h3>$MSG_908</h3>\n");
    print($affiche);
  }
}


/******************************************************
 *Cas ou c le total des QCMs
 *****************************************************/
$tabLigne=array();
if($totqcm == 1){
  print("<center>\n\n");
  if($back == 1){
    //menu
    $menu=3;
    //include('./menuStatCal.php3');
  }
  //affichage du titre
  print("<h2>$MSG_909</h2>\n");
  //on cherche les utilisateurs de ce groupe
  $req_user_grp="SELECT DISTINCT nom,prenom,num_user FROM utilisateurs u, gestionutil gu
                 WHERE gu.gu_num_user = u.num_user
                 AND gu.gu_num_gest_gr = '$num_grp'
                 ORDER BY nom";
  $resul=pg_query($req_user_grp);
  $nb=pg_numrows($resul);
  if($nb < 1)
    print("<h3>$ERROR_61</h3>\n\n");
  else{
    $affiche.=("<table border=\"1\">\n");
    $affiche.=("\t<tr bgcolor=\"#FFCCCC\">\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_906</td>\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_616</td>\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_2416</td>\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_901</td>\n");
    if($back == 1)
      $affiche.=("\t\t<td align=\"center\">$FORM_1</td>\n");
    $affiche.=("\t</tr>\n");
  }

  for($i=0;$i<$nb;$i++){
    //On affiche le nom
    $rowUser=pg_fetch_row($resul,$i);
    //$affiche.=("\t<tr>\n");
    $tabLigne[$i][1].=("\t\t<td align=\"center\">$rowUser[0] $rowUser[1]</td>\n");
    //pour chaque qcm on cherche le score
    $total_qcm=0;
    $total_qcm_max=0;
    for($j=0;$j<sizeof($tab_num_qstaire);$j++){
      $total_qcm += getScoreQcm($rowUser[2],$tab_num_qstaire[$j],$num_cal);

      if( $pas_repondu == 1){
	$max_points_possible_qcm=0;
	$pas_repondu=0;
      }
      else{
	$max_points_possible_qcm=$Tab_Val_Max_Qcm[$tab_num_qstaire[$j]];
	$score_max_qcm += $Tab_Val_Max_Qcm[$tab_num_qstaire[$j]];
      }
      $total_qcm_max += $max_points_possible_qcm;
    }

    //calcul de la moyenne
    $tab_Moyenne_Couleur=calculMoyenne($total_qcm,$total_qcm_max);
    $moyenne=$tab_Moyenne_Couleur[0];
    $bgcolor=$tab_Moyenne_Couleur[1];

    $tabMoyenne[$i]=$moyenne;

    $tabLigne[$i][1].=("\t\t<td align=\"center\">$total_qcm / $total_qcm_max</td>\n");
    $tabLigne[$i][1].=("\t\t<td align=\"center\" bgcolor=$bgcolor>$moyenne</td>\n");
    if($back == 1){
      $tabLigne[$i][1].=("\t\t<td align=\"center\"><a href=\"ScoreTotal.php3?num=$rowUser[2]&nom=$rowUser[0]&pre=$rowUser[1]&lstU=1\">$FORM_37</a></td>\n");
    }
    $tabLigne[$i][1].=("\t</tr>\n");

    $total_grp_qcm +=$total_qcm;
    $total_grp_qcm_max +=$total_qcm_max;
    if(!is_double($moyenne) && $moyenne == "X")
      $tabLigne[$i][0]=-1;
    else $tabLigne[$i][0]=$moyenne;
  }


  //on trie le tableu de moyenne/ligne html
  $tabLigneTriee=triTab($tabLigne);
  //On recupere la partie interieur du tableau
  $affiche.=retourneTabHtml($tabLigneTriee);

  //calcul de la moyenne generale
  $moyenne="X";
  $bgcolor="#FFFFFF";
  if($total_grp_qcm != 0){
    $moyenne=sprintf("%.2f",($total_grp_qcm * (20/$total_grp_qcm_max)));
    if($moyenne<10)$bgcolor="$mauvaise_reponse";
    else $bgcolor="$bonne_reponse";
  }


  $affiche.=("\t<tr>\n");
  $affiche.=("\t\t<td align=\"center\" colspan=\"2\"><b>$MSG_869</b></td>\n");
  $affiche.=("\t\t<td align=\"center\"><b>$total_grp_qcm / $total_grp_qcm_max</b></td>\n");
  $affiche.=("\t\t<td align=\"center\" bgcolor=$bgcolor colspan=\"2\">$moyenne</td>\n");
  $affiche.=("\t</tr>\n");
  $affiche.=("</table>\n");
  print("<h3>$MSG_907</h3>\n");
  afficheGraph($tabMoyenne);
  print("<br><br>\n");
  print("<h3>$MSG_908</h3>\n");
  print($affiche);
  print("<br>\n");
}

/***************************************************
 * Stats pour une serie
 ***************************************************/
if($blanc == 1){

  //recherche du nom de la serie
  $req_nom_blanc="SELECT titre FROM serie_exo
                WHERE id='$num_serie' ";
  $resul=pg_query($req_nom_blanc);
  $nb=pg_numrows($resul);
  if($nb != 1)
    die("Erreur: base de donnes corrompue ou donnes incohrentes");

  $titres=pg_fetch_row($resul,0);
  $titre=$titres[0];

  print("<center>\n\n");

  if($back == 1){
    //Menu
    $menu=6;
    //include('./menuStatCal.php3');
  }

  //affichage du titre
  print("<h2>Statistiques dtailles pour la srie <i>$titre</i></h2>\n");

  //on cherche les utilisateurs de ce groupe
  $req_user_grp="SELECT DISTINCT nom,prenom,num_user FROM utilisateurs u, gestionutil gu
                 WHERE gu.gu_num_user = u.num_user
                 AND gu.gu_num_gest_gr = '$num_grp'
                 ORDER BY nom";
  $resul=pg_query($req_user_grp);
  $nb=pg_numrows($resul);
  if($nb < 1)
    print("<h3>$ERROR_61</h3>\n\n");
  else{
    $affiche.=("<table border=\"1\">\n");
    $affiche.=("\t<tr bgcolor=\"#FFCCCC\">\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_906</td>\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_616</td>\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_2416</td>\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_901</td>\n");
    if($back == 1)$affiche.=("\t\t<td align=\"center\">$FORM_1</td>\n");
    $affiche.=("\t</tr>\n");
    $score_max_blanc=0;
    $score_user_blanc=0;
    for($i=0;$i<$nb;$i++){
      $rowUser=pg_fetch_row($resul,$i);
      //$tabLigne[$i][1]=("\t<tr>\n");
      $tabLigne[$i][1].=("\t\t<td align=\"center\">$rowUser[1] $rowUser[0]</td>\n");
      $score_blanc_user=getScoreBlanc($rowUser[2],$num_serie,$num_cal);

      $score_user_blanc += $score_blanc_user;

      if( $pas_repondu == 1){
	$max_points_possible_blanc=0;
	$pas_repondu=0;
      }
      else{
	//$max_points_possible_blanc=$Tab_Val_Max_Blanc[$num_serie];
        $max_points_possible_blanc=20;
	//$score_max_blanc += $Tab_Val_Max_Blanc[$num_serie];
      }
      $tabLigne[$i][1].=("\t\t<td align=\"center\">$score_blanc_user / $max_points_possible_blanc</td>\n");

      $tab_Moyenne_Couleur=calculMoyenne($score_blanc_user,$max_points_possible_blanc);
      $moyenne=$tab_Moyenne_Couleur[0];
      $bgcolor=$tab_Moyenne_Couleur[1];
      $tabLigne[$i][1].=("\t\t<td align=\"center\" bgcolor=$bgcolor>$moyenne</td>\n");
      if($back == 1){
	$tabLigne[$i][1].=("\t\t<td align=\"center\"><a href=\"ScoreTotal.php3?num=$rowUser[2]&nom=$rowUser[0]&pre=$rowUser[1]&lstU=1\">$FORM_37</a></td>\n");
      }
      $tabLigne[$i][1].=("\t</tr>\n");
      $tabMoyenne[$i]=$moyenne;
      if(!is_double($moyenne) && $moyenne == "X")
	$tabLigne[$i][0]=-1;
      else $tabLigne[$i][0]=$moyenne;
    }
    $score_max_blanc=20*$nb;

    //on trie le tableu de moyenne/ligne html
    $tabLigneTriee=triTab($tabLigne);
    //On recupere la partie interieur du tableau
    $affiche.=retourneTabHtml($tabLigneTriee);


    $affiche.=("\t<tr>\n");
    $affiche.=("\t\t<td align=\"center\" colspan=\"2\"><b>$MSG_869</b></td>\n");
    $affiche.=("\t\t<td align=\"center\"><b>$score_user_blanc / $score_max_blanc</b></td>\n");
    $moyenne="X";
    $bgcolor="#FFFFFF";

    if($score_max_blanc != 0){
      $moyenne=sprintf("%.2f",($score_user_blanc * (20/$score_max_blanc)));
      if($moyenne<10)$bgcolor="$mauvaise_reponse";
      else $bgcolor="$bonne_reponse";
    }
    $affiche.=("\t\t<td align=\"center\" bgcolor=$bgcolor colspan=\"2\"><b>$moyenne</b></td>\n");
    $affiche.=("\t</tr>\n");
    $affiche.=("</table>\n");
    $affiche.=("<br><br>\n");
    print("<h3>Statistiques dtailles pour les blancs</h3>\n");
    afficheGraph($tabMoyenne);
    print("<br><br>\n");
    print("<h3>$MSG_908</h3>\n");
    print($affiche);
  }
}


/******************************************************
 *Cas ou c le total des Blancs
 *****************************************************/
$tabLigne=array();
if($totblanc == 1){
  print("<center>\n\n");
  if($back == 1){
    //menu
    $menu=7;
    //include('./menuStatCal.php3');
  }
  //affichage du titre
  print("<h2>Statistiques dtaills pour l'ensemble des blancs</h2>\n");
  //on cherche les utilisateurs de ce groupe
  $req_user_grp="SELECT DISTINCT nom,prenom,num_user FROM utilisateurs u, gestionutil gu
                 WHERE gu.gu_num_user = u.num_user
                 AND gu.gu_num_gest_gr = '$num_grp'
                 ORDER BY nom";
  $resul=pg_query($req_user_grp);
  $nb=pg_numrows($resul);
  if($nb < 1)
    print("<h3>$ERROR_61</h3>\n\n");
  else{
    $affiche.=("<table border=\"1\">\n");
    $affiche.=("\t<tr bgcolor=\"#FFCCCC\">\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_906</td>\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_616</td>\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_2416</td>\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_901</td>\n");
    if($back == 1)
      $affiche.=("\t\t<td align=\"center\">$FORM_1</td>\n");
    $affiche.=("\t</tr>\n");
  }

  for($i=0;$i<$nb;$i++){
    //On affiche le nom
    $rowUser=pg_fetch_row($resul,$i);
    //$affiche.=("\t<tr>\n");
    $tabLigne[$i][1].=("\t\t<td align=\"center\">$rowUser[0] $rowUser[1]</td>\n");
    //pour chaque qcm on cherche le score
    $total_blanc=0;
    $total_blanc_max=0;
    for($j=0;$j<sizeof($tab_num_serie);$j++){
      $total_blanc += getScoreBlanc($rowUser[2],$tab_num_serie[$j],$num_cal);

      if( $pas_repondu == 1){
	$max_points_possible_blanc=0;
	$pas_repondu=0;
      }
      else{
	$max_points_possible_blanc=$Tab_Val_Max_Blanc[$tab_num_serie[$j]];
	$score_max_blanc += $Tab_Val_Max_Blanc[$tab_num_serie[$j]];
      }
      //$total_blanc_max += $max_points_possible_blanc;
    }
    $total_blanc_max=20;
    //calcul de la moyenne
    $tab_Moyenne_Couleur=calculMoyenne($total_blanc,$total_blanc_max);
    $moyenne=$tab_Moyenne_Couleur[0];
    $bgcolor=$tab_Moyenne_Couleur[1];

    $tabMoyenne[$i]=$moyenne;

    $tabLigne[$i][1].=("\t\t<td align=\"center\">$total_blanc / $total_blanc_max</td>\n");
    $tabLigne[$i][1].=("\t\t<td align=\"center\" bgcolor=$bgcolor>$moyenne</td>\n");
    if($back == 1){
      $tabLigne[$i][1].=("\t\t<td align=\"center\"><a href=\"ScoreTotal.php3?num=$rowUser[2]&nom=$rowUser[0]&pre=$rowUser[1]&lstU=1\">$FORM_37</a></td>\n");
    }
    $tabLigne[$i][1].=("\t</tr>\n");

    $total_grp_blanc +=$total_blanc;
    $total_grp_blanc_max +=$total_blanc_max;
    if(!is_double($moyenne) && $moyenne == "X")
      $tabLigne[$i][0]=-1;
    else $tabLigne[$i][0]=$moyenne;
  }


  //on trie le tableu de moyenne/ligne html
  $tabLigneTriee=triTab($tabLigne);
  //On recupere la partie interieur du tableau
  $affiche.=retourneTabHtml($tabLigneTriee);

  //calcul de la moyenne generale
  $moyenne="X";
  $bgcolor="#FFFFFF";
  if($total_grp_blanc != 0){
    $moyenne=sprintf("%.2f",($total_grp_blanc * (20/$total_grp_blanc_max)));
    if($moyenne<10)$bgcolor="$mauvaise_reponse";
    else $bgcolor="$bonne_reponse";
  }


  $affiche.=("\t<tr>\n");
  $affiche.=("\t\t<td align=\"center\" colspan=\"2\"><b>$MSG_869</b></td>\n");
  $affiche.=("\t\t<td align=\"center\"><b>$total_grp_blanc / $total_grp_blanc_max</b></td>\n");
  $affiche.=("\t\t<td align=\"center\" bgcolor=$bgcolor colspan=\"2\">$moyenne</td>\n");
  $affiche.=("\t</tr>\n");
  $affiche.=("</table>\n");
  print("<h3>$MSG_907</h3>\n");
  afficheGraph($tabMoyenne);
  print("<br><br>\n");
  print("<h3>$MSG_908</h3>\n");
  print($affiche);
  print("<br>\n");
}


/********************************************************
 *detail sur un exo tlc
 *******************************************************/
print("<center>\n");
if(isset($num_exo)){
  $tabLigne=array();
  if($back == 1){
    //menu
    $menu=4;
    //include('./menuStatCal.php3');
  }
  $nom_exo=ereg_replace('__',' ',$nom_exo);
  print("<h2>$MSG_910 <i>$nom_exo</i> </h2>\n");

  //on cherche les utilisateurs de ce groupe
  $req_user_grp="SELECT DISTINCT nom,prenom,num_user FROM utilisateurs u, gestionutil gu
                 WHERE gu.gu_num_user = u.num_user
                 AND gu.gu_num_gest_gr = '$num_grp'
                 ORDER BY nom";
  $resul=pg_query($req_user_grp);
  $nb=pg_numrows($resul);
  if($nb < 1)
    print("<h3>$ERROR_61</h3>\n\n");
  else{
    $affiche.=("<table border=\"5\" bordercolor=\"#000000\" cellpadding=\"2\" cellspacing=\"0\">\n");
    $affiche.=("\t<tr bgcolor=\"#cecfce\">\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_906</td>\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_616</td>\n");
     //Quel est le mode de rendu de l'exo
    $resexo=pg_query("select mode_rendu from exotlc where num_exo= '$num_exo';");
    $rowexo=pg_fetch_row($resexo,0);
    if($rowexo[0]=="pf"){
            $affiche.=("\t\t<td align=\"center\">Ractivit du formateur</td>\n");
    }
    $affiche.=("\t\t<td align=\"center\">$MSG_2416</td>\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_901</td>\n");
    /*if($back == 1)
      $affiche.=("\t\t<td align=\"center\">$FORM_1</td>\n");
    */
    $affiche.=("\t</tr>\n");


    //$rowUser[2]
    for($i=0;$i<$nb;$i++){
      $rowUser=pg_fetch_row($resul,$i);
      $totaldate=0;
      if($rowexo[0]=="pf"){
            $resrendu=pg_query("select * from reception_exostlc where num_stag='$rowUser[2]' and num_exo='$num_exo' and num_cal=$num_cal;");
            $nbrendu=pg_numrows($resrendu);
            $rescorr=pg_query("select num_user,date_correction from resexouser where num_user='$rowUser[2]' AND num_exo='$num_exo' AND num_cal='$num_cal';");
            $nbcorr=pg_numrows($rescorr);
            //si le stagiaire a rendu son exo et a t corriger
            if($nbrendu!=0 && $nbcorr!=0){
                        $ok=1;
                        $rowrendu=pg_fetch_row($resrendu,0);
                        $daterendu=$rowrendu[3];
                        $rowcorr=pg_fetch_row($rescorr,0);
                        $datecorr=$rowcorr[1];
                        $totaldate=$datecorr-$daterendu;
                        /////////////////////////////////////////
                        //ractivit du formateur
                        ////////////////////////////////////////
                        //$totaldate=$totaldate/$cptdate;
                        //$totaldateTP=$totaldateTP+$totaldate;
                        $nbminute=intval($totaldate/60);
                        $nbheure=intval($nbminute/60);
                        $nbjour=intval($nbheure/24);
                        if($nbjour>=1){
                                    //$nbheure=$nbheure-(24*$nbjour);
                                    $reste=$totaldate-(24*60*60*$nbjour);
                                    $nbheure=intval(($reste/60)/60);
                                    $reste=$reste-(60*60*$nbheure);
                                    $nbminute=intval($reste/60);
                        }
                        else if($nbheure>=1){
                                    $reste=$totaldate-(60*60*$nbheure);
                                    $nbminute=intval($reste/60);
                        }
                        $affichetmp="\t<td align=\"center\">";
                        if($nbjour>=1){
                                    $affichetmp.="<b>$nbjour</b> jour(s)";
                        }
                        if($nbheure>=1){
                                    $affichetmp.=" <b>$nbheure</b> heure(s)";
                        }
                        $affichetmp.=" <b>$nbminute</b> minute(s)";
                        $affichetmp.="</td>\n";

            }
            else {
                        $ok=0;
            }

       }

      //On affiche le debut d'une ligne du tableau avec le nom de l'utilisateur
      //$affiche.=("\t<tr>\n");
      $tabLigne[$i][1].=("\t\t<td align=\"center\">$rowUser[1] $rowUser[0]</td>\n");
      if($rowexo[0]=="pf"){
            $col=3;
            if($ok==1)$tabLigne[$i][1].=$affichetmp;
            else {
                        $tabLigne[$i][1].=("\t\t<td align=\"center\"> - </td>\n");
            }
      }
      else $col=2;

      //on cherche son score
      $req_score_exo="SELECT resultat, notesur
                    FROM exotlc, gestexotlc
                    WHERE gesttlc_exo = num_exo
                    AND num_exo = '$num_exo'
                    AND gesttlc_user ='$rowUser[2]' ";
      $score_exo=0;
      $score_exo_max=0;
      $resul2=pg_query($req_score_exo);
      $nb2=pg_numrows($resul2);
      for($j=0;$j<$nb2;$j++){
	$rowScore=pg_fetch_row($resul2,$j);
	$score_exo += $rowScore[0];
	$score_exo_max += $rowScore[1];
      }

      $tot_score += $score_exo;
      $tot_score_max += $score_exo_max;

      //calcul de la moyenne
      $tab_Moyenne_Couleur=calculMoyenne2($score_exo,$score_exo_max);
      $moyenne=$tab_Moyenne_Couleur[0];
      $bgcolor=$tab_Moyenne_Couleur[1];

      $tabMoyenne[$i]=$moyenne;

      //on affiche le resultat
      $tabLigne[$i][1].=("\t\t<td align=\"center\">$score_exo / $score_exo_max</td>\n");
      $tabLigne[$i][1].=("\t\t<td align=\"center\" bgcolor=$bgcolor>$moyenne</td>\n");
      /*
      if($back == 1){
	$tabLigne[$i][1].=("\t\t<td align=\"center\"><a href=\"ScoreTotal.php3?num=$rowUser[2]&nom=$rowUser[0]&pre=$rowUser[1]&lstU=1\">$FORM_37</a></td>\n");
      }
      */
      $tabLigne[$i][1].=("\t</tr>\n");
      if(!is_double($moyenne) && $moyenne == "X")
	$tabLigne[$i][0]=-1;
      else $tabLigne[$i][0]=$moyenne;
    }


    //on trie le tableu de moyenne/ligne html
    $tabLigneTriee=triTab($tabLigne);
    //On recupere la partie interieur du tableau
    $affiche.=retourneTabHtml($tabLigneTriee);

    //le total

    //on calcul la moyenne
    $moyenne="X";
    $bgcolor="#FFFFFF";
    if($tot_score_max != 0){
      $moyenne=sprintf("%.2f",($tot_score * (20/$tot_score_max)));
      if($moyenne<10)$bgcolor="$mauvaise_reponse";
      else $bgcolor="$bonne_reponse";
    }
    $affiche.=("\t<tr>\n");
    $affiche.=("\t\t<td align=\"center\" colspan=\"$col\"><b>$MSG_869</b></td>\n");
    $affiche.=("\t\t<td align=\"center\"><b>$tot_score / $tot_score_max</b></td>\n");
    $affiche.=("\t\t<td align=\"center\" bgcolor=$bgcolor colspan=\"2\"><b>$moyenne</b></td>\n");
    $affiche.=("\t</tr>\n");

    $affiche.=("</table>\n");
    print("<h3>$MSG_907</h3>\n");
    afficheGraph($tabMoyenne);
    print("<br><br>\n");
    print("<h3>$MSG_908</h3>\n");
    print($affiche);
    print("<br>\n");
  }
}


$tabMoyenneUtil=array();
/******************************************************
 * Details pour tous les exos du calendrier
 *****************************************************/
if(isset($tab_num_exo)){

  print("<center>\n\n");
  if($back == 1){
    //menu
    $menu=5;
    //include('./menuStatCal.php3');
  }
  //affichage du titre
  print("<h2>$MSG_911</h2>\n");
  //on cherche les utilisateurs de ce groupe
  $req_user_grp="SELECT DISTINCT nom,prenom,num_user FROM utilisateurs u, gestionutil gu
                 WHERE gu.gu_num_user = u.num_user
                 AND gu.gu_num_gest_gr = '$num_grp'
                 ORDER BY nom";
  $resul=pg_query($req_user_grp);
  $nb=pg_numrows($resul);
  if($nb < 1)
    print("<h3>$ERROR_61</h3>\n\n");
  else{
    $affiche.=("<table border=\"5\" cellpadding=\"2\" cellspacing=\"0\" bordercolor=\"#000000\">\n");
    $affiche.=("\t<tr bgcolor=\"#cecfce\">\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_906</td>\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_616</td>\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_2416</td>\n");
    $affiche.=("\t\t<td align=\"center\">$MSG_901</td>\n");
    /*if($back == 1)
      $affiche.=("\t\t<td align=\"center\">$FORM_1</td>\n");
    */
    $affiche.=("\t</tr>\n");

    //Pour chaque utilisateur
    for($i=0;$i<$nb;$i++){
      //On affiche le nom
      $rowUser=pg_fetch_row($resul,$i);
      //$affiche.=("\t<tr>\n");
      $tabLigne[$i][1].=("\t\t<td align=\"center\">$rowUser[0] $rowUser[1]</td>\n");
      //legende concernant les differentes lignes pour le tracage du graph
      //(par opposition  la legende des exercices)
      $tabLegende2[$i]="$rowUser[0] $rowUser[1]";
      $score_exo=0;
      $score_exo_max=0;
      reset($tab_num_exo);
      //Pour chaque exo
      while(list($id,$valeur)=each($tab_num_exo)){
	$req_score_exo ="SELECT score, surtotal
                         FROM resexouser
                         WHERE num_user='$rowUser[2]'
                         AND num_exo='$valeur' ";

	$resul2=pg_query($req_score_exo);
	$nb2=pg_numrows($resul2);
	for($j=0;$j<$nb2;$j++){
	  $rowScore=pg_fetch_row($resul2,$j);
	  $score_exo += $rowScore[0];
	  $score_exo_max += $rowScore[1];
	  $tabTmp=calculMoyenne2($rowScore[0],$rowScore[1]);
	  $tabMoyenneUtil[$valeur]=$tabTmp[0];	 
	}
	$tabNumExo[$valeur]=1;
	$tabPoints[$rowUser[2]]=$tabMoyenneUtil;
      }


      //somme
      $score_exo_tot += $score_exo;
      $score_exo_max_tot += $score_exo_max;

      //calcul de la moyenne
      $tab_Moyenne_Couleur=calculMoyenne2($score_exo,$score_exo_max);
      $moyenne=$tab_Moyenne_Couleur[0];
      $bgcolor=$tab_Moyenne_Couleur[1];

      $tabMoyenne[$i]=$moyenne;
      $tabLigne[$i][1].=("\t\t<td align=\"center\">$score_exo / $score_exo_max </td>\n");

      $tabLigne[$i][1].=("\t\t<td align=\"center\" bgcolor=$bgcolor>$moyenne</td>\n");
      /*if($back == 1){
	$tabLigne[$i][1].=("\t\t<td align=\"center\"><a href=\"ScoreTotal.php3?num=$rowUser[2]&nom=$rowUser[0]&pre=$rowUser[1]&lstU=1\">$FORM_37</a></td>\n");
      }*/
      $tabLigne[$i][1].=("\t</tr>");

      if(!is_double($moyenne) && $moyenne == "X"){
	$tabLigne[$i][0]=-1;
      }
      else {
	$tabLigne[$i][0]=$moyenne;
      }
      //$points[$i]=$moyenne;
    }

    /******************** GRAPH **********************************/

    $k=0;
    //print("taille de tabPoints = ".sizeof($tabPoints)."<br>");
    while(list($numexo,$rien)=each($tabNumExo)){
      //print("ici <br>");
      reset($tabPoints);
      while(list($numuser,$tab)=each($tabPoints)){
	if(isset($tab[$numexo])){
	  $tabNoteExo[$numuser][$k]=$tab[$numexo];
	  //print("numuser = $numuser , exo = $k ($numexo), note = $tab[$numexo] <br>");
	}
      }
      $k++;
    }

    $largeur=950;
    $hauteur=350;
    $margex=150;
    $titre=$MSG_912;
    $nomFic="general_tlc_"."$num_cal".".png";
    include("./librairies/Graph2.php");

     print("<a href=\"#\" onClick=\"javascript:window.open('./cache-graphiques/$nomFic','Evolution','resizable=no,location=no,width=");
     print($largeur+50);
     print(",height=");
     print($hauteur+50);
     print(",menubar=no,scrollbars=yes,status=no')\">$MSG_912</a>\n");
    //print("<a href=javascript:popup('cache/$nomFic')>Evolution des notes</a>\n");
    /*************** FIN GRAPH *************************************/



    //on trie le tableu de moyenne/ligne html
    $tabLigneTriee=triTab($tabLigne);
    //On recupere la partie interieur du tableau
    $affiche.=retourneTabHtml($tabLigneTriee);

    //calcul de la moyenne
    $moyenne="X";
    $bgcolor="#FFFFFF";
    if($score_exo_max_tot != 0){
      $moyenne=sprintf("%.2f",($score_exo_tot * (20/$score_exo_max_tot)));
      if($moyenne<10)$bgcolor="$mauvaise_reponse";
      else $bgcolor="$bonne_reponse";
    }
    $affiche.=("\t<tr>\n");    
    $affiche.=("\t\t<td align=\"center\" colspan=\"2\"><b>$MSG_869</b> </td>\n");
    $affiche.=("\t\t<td align=\"center\"><b>$score_exo_tot / $score_exo_max_tot </b></td>\n");
    $affiche.=("\t\t<td align=\"center\" bgcolor=$bgcolor colspan=\"2\"><b>$moyenne</b></td>\n");
    $affiche.=("\t</tr>");
    
    $affiche.=("</table>\n");
    print("<h3>$MSG_907</h3>\n");
    afficheGraph($tabMoyenne);
    print("<br><br>\n");
    print("<h3>$MSG_908</h3>\n");
    print($affiche);
    print("<br>\n");
  }
}

print("<br>\n");
print("<form><input type=\"button\" value=\"$MSG_37\" onClick=\"history.back()\"></form>\n");
if($back == 1)include("../piedpage.php3");
?>