<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/********************************************
*                       TRI PAR CLASSE
********************************************/
require('../dbpostgres.php3');
$path='..';
$styleCSS="style.css";
require('../entete.php3');
require('./fonct_javascript.php');
require("./fonct_classt.php");
require("../lib/lib_statistiques.php");
// connexion  la base
$db = pg_Connect("$server", "", "", "", "$nombase");


//******************
// options de tri:
// 1=> nom de groupe
// 2=>note
//******************

if(!isset($classement))
            $classement=2;


// recherche des groupes qui ont des utilisateurs avec des exotlc corrigs
// et/ou des sries
//PLSQL
$res=get_groupes_evaluation_finie($classement);
$nb_group=pg_numrows($res);

print("
<span class=\"titre\">$MSG_1561</span>
");
$exo=0;
$tabGroup=array();
for($i=0;$i<$nb_group;$i++)
{
            // on rcupre toutes les formations lies  ce groupe
            // PLSQL
            $liste_form_group=get_formations_groupe(pg_result($res,$i,0));
            $nb_form_group=pg_numrows($liste_form_group);

            // pour chaque formation
            // test si la formation a des evaluations corriges
            $tab_form_ok=array();
            $ind_tab_form=0;
            for($k=0;$k<$nb_form_group;$k++)
            {
                        // des series ?
                        $res_test_res_serie=get_resultats_series_formation(pg_result($liste_form_group,$k,0));
                        // des exostlc ?
                        $res_test_resexouser=get_resultats_exos_formation(pg_result($liste_form_group,$k,0));

                        // si au moins une srie ou un exotlc, on stocke la formation dans tab_form_ok
                        if(pg_numrows($res_test_res_serie)>0 || pg_numrows($res_test_resexouser)>0)
                        {
                                    $tab_form_ok[$ind_tab_form]=pg_result($liste_form_group,$k,0);
                                    $ind_tab_form++;
                        }
            }
            $nb_form_ok=count($tab_form_ok);

            // si le groupe a des formations avec des evaluations
            if($nb_form_ok>0)
            {
                        $tab_form=array();
                        // on fait la moyenne gnrale de chaque formation puis on fait
                        // la moyenne gnrale du groupe.
                        $moy_generale_form=0;
                        for($h=0;$h<$nb_form_ok;$h++)
                        {
                                    //calcul de la moyenne gnrale de la formation (sries + exotlc)
                                    // moyenne de toutes les sries de la formation
                                    // !!! attention il ne faut pas compter les sries qui n'ont que des sondages !!!
                                    $sql_serie="select id_serie, score
                                                            from res_serie
                                                            where id_formation='$tab_form_ok[$h]'
                                                            and score >=0
                                                            and date_fin>0
                                                            group by id_serie,score";
                                    $moy_series=pg_query($sql_serie);
                                    $nb_note_series=pg_numrows($moy_series);
                                    if($nb_note_series>0)
                                    {
                                                $moy_cal_series=0;
                                                $cpt=0;

                                                for($s=0;$s<$nb_note_series;$s++)
                                                {
                                                            if(rechSondage(pg_result($moy_series,$s,0))==0)
                                                            {
                                                                        $moy_cal_series += pg_result($moy_series,$s,1);
                                                                        $cpt++;
                                                            }
                                                }

                                                if($cpt==0) $moy_cal_series=-1;
                                                else $moy_cal_series = ($moy_cal_series/$cpt);
                                    }
                                    else $moy_cal_series=-1;

                                    // moyenne de tous les exotlc de la formation
                                    $sql_exo="select num_user, sum(score) as somme, sum(surtotal) as total
                                                from resexouser
                                                where num_cal='$tab_form_ok[$h]'
                                                and num_cal <> 0
                                                group by num_user";
                                    $moy_exos=pg_query($sql_exo);
                                    $nb_res_exotlc=pg_numrows($moy_exos);

                                    if($nb_res_exotlc>0)
                                    {
                                                $moy_cal_exos=0;
                                                for($q=0;$q<$nb_res_exotlc;$q++)
                                                {
                                                            $moy_exos_user=((pg_result($moy_exos,$q,1)/pg_result($moy_exos,$q,2))*20);
                                                            $moy_cal_exos+=round($moy_exos_user,2);
                                                }
                                                $moy_cal_exos=($moy_cal_exos/$nb_res_exotlc);
                                    }
                                    else $moy_cal_exos=-1;

                                    // calcul de la moyenne gnrale de la formation selon
                                    // que des sries et/ou des exotlc ont t faits
                                    if($moy_cal_series !=-1 && $moy_cal_exos !=-1)
                                                $moy_generale_form=(($moy_cal_series+$moy_cal_exos)/2);
                                    elseif($moy_cal_series==-1 && $moy_cal_exos !=-1)
                                                $moy_generale_form=$moy_cal_exos;
                                    elseif($moy_cal_exos==-1 && $moy_cal_series !=-1)
                                                $moy_generale_form=$moy_cal_series;
                                    else $moy_generale_form=-1;


                                    if($moy_generale_form!=-1)
                                    {
                                                // on arrondi la moyenne de la formation courante
                                                // puis on la stocke dans un tableau lie  son numro (num_form=>moyenne)
                                                $moy_generale_form=round($moy_generale_form,2);
                                                $tab_form[$tab_form_ok[$h]]=$moy_generale_form;
                                    }
                        }

                        //on cre un tableau avec les moyennes de chaque formation du groupe
                        $moy_form=array_values($tab_form);

                        // On calcule la moyenne du groupe
                        $moyenne_gen_group=0;
                        $nb_moy_form=count($moy_form);
                        if($nb_moy_form!=0)
                        {
                                    for($moy=0;$moy<$nb_moy_form;$moy++)
                                                $moyenne_gen_group += $moy_form[$moy];

                                    // on stocke la moyenne du groupe lie  son numro (num_groupe=>moyenne)
                                    $tabGroup[pg_result($res,$i,0)]=round(($moyenne_gen_group/$nb_moy_form),2);
                        }
            }
}
// tri des groupes par notes dcroissantes
if($classement ==2) arsort($tabGroup);
// on stocke les moyennes de chaque groupe dans un tableau
$moy_group=array_values($tabGroup);
// on fait de mme pour les numro de groupe
$num_group=array_keys($tabGroup);

print("
<table class=\"cols\" width=\"90%\" align=\"center\">
<tr bgcolor=\"#FFFFFF\" align=\"center\">
");
if($classement==2)print("<td width=\"33%\"><b>$MSG_1559</b></td>");
else print("<td width=\"33%\">&nbsp;&nbsp;</td>");

print("
<td width=\"33%\">
<a href=\"Score_par_classe.php?classement=1\">
<b>$MSG_682</b></a>");
if($classement == 1) print("<img src=\"../images/fleche0.gif\" border=\"0\">");
print("
</td>
<td width=\"33%\">
<a href=\"Score_par_classe.php?classement=2\">
<b>$MSG_2416</b></a>");
if($classement == 2) print("<img src=\"../images/fleche0.gif\" border=\"0\">");
print("
</td>
</tr>
</table>
");
$nb_grp=count($num_group);
for($i=0;$i<$nb_grp;$i++)
{
            // on rcupre le nom du groupe
            $sql="select nom from classe where id='$num_group[$i]'";
            $nom_groupe=pg_query($sql);
            $nom_group=pg_result($nom_groupe,0);
            $rang_form=$i+1;
            print("
            <div class=\"barre\">
            <table  border=\"0\" width=\"100%\">
            <tr>
            <td align=\"center\" width=\"33%\">
            ");
            if($classement==2) print("$rang_form");
            else print("&nbsp;&nbsp;");
            print("
            </td>
            <td align=\"center\" width=\"33%\">
            <a href=\"#\" onClick=\"pageDetails($num_group[$i],$moy_group[$i],'$nom_group');return(false);\">$nom_group</a>
            </td>
            <td align=\"center\" width=\"33%\">&nbsp;&nbsp;&nbsp;&nbsp;$moy_group[$i]/20
            </td>
            </tr>
            </table>
            </div>
            ");

}// fin du for avec $i

?>
