<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/*******************************************************************
 * Script qui affiche les scores par types d'exercices: exotlc ou sries
 * donnes reues : classement (1 ou 2), type (old ou current)
 *******************************************************************/

//fichiers pour config lang, IP et postgresql
require('../dbpostgres.php3');
$path='..';
$styleCSS="./style.css";
// fichier d'entete
require('../entete.php3');
//fichiers des fonctions javascript
require('./fonct_javascript.php');
// fichiers des fonctions PLPGSQL
require("../lib/lib_statistiques.php");
//fonctions de calcul des stats
require("./fonct_classt.php");

// connexion  la base
$db = pg_Connect("$server", "", "", "", "$nombase");

/*******************************************************
*             TRI DES RESULTATS PAR FORMATION
*******************************************************/




//*********************
// option pour le tri
// 1=> formations
// 2=> notes
//*********************

if(!isset($classement)) $classement=2;


// appel de la fonction PLSQL
$res=get_formations_evaluations_finies($date_form,$classement);
$nb_form=pg_numrows($res);

if($date_form=="current")
            print("
            <span class=\"titre\">$MSG_1555</span><br><br>
            <div class=\"adv\">
                        <img src=\"../images/iconicolas.gif\"><b>&nbsp;$MSG_1556</b><br>
                        <img src=\"../images/dynamic.gif\" height=\"20\" width=\"20\"><b>&nbsp;$MSG_1558</b>
            </div>
            ");
else
            print("
            <span class=\"titre\">$MSG_1557</span><br><br>
            <div class=\"adv\">
                        <img src=\"../images/dynamic.gif\" height=\"20\" width=\"20\"><b>&nbsp;$MSG_1558</b>
            </div>
            ");



//************************************************************
// Rcupration des rsultats de chaque formation et chargement
// dans un tableau associatif (num_formation => moyenne_formation)
//************************************************************
$tab_form=array();
for($i=0;$i<$nb_form;$i++)
            MoyGenCal(pg_result($res,$i,0),&$tab_form);

//on trie les moyennes par ordre dcroissant si classement par note demand
if($classement == 2)
            if(sizeof($tab_form)>0)
                        arsort($tab_form);

// on extrait les cls dans un tableau et les valeurs dans un autre
// tableau des numros de formation
$keys=array_keys($tab_form);
// tableau des moyennes de formations correspondantes
$values=array_values($tab_form);

// dbut d'affichage de la liste des formations
// affichage des intituls de chaque colonne
print("
<br>
<table class=\"cols\" width=\"90%\" align=\"center\" border=\"0\" cellpadding=\"2\" cellspacing=\"0\">
<tr bgcolor=\"#FFFFFF\" align=\"center\">
<td>PDF</td>
");
if($classement == 2) print("<td width=\"15%\">$MSG_1559</td>");
print("
<td width=\"40%\">
<a href=\"Score_par_exo.php?tri=form&date_form=$date_form&classement=1\">
$MSG_635</a>");
if($classement==1) print("<img src=\"../images/fleche0.gif\" border=\"0\">");
print("
</td>
<td width=\"20%\">
<a href=\"Score_par_exo.php?tri=form&date_form=$date_form&classement=2\">
$MSG_862</a>");
if($classement==2) print("<img src=\"../images/fleche0.gif\" border=\"0\">");
print("
</td>
<td width=\"12,5%\">$MSG_1619</td>
<td width=\"12,5%\"><img src=\"../images/infos.jpeg\" height=\"20\">
</td>
</tr>
</table>
");

//*********************************************************
//                                  calcul des rsultats
//*********************************************************
$nb_form_ok=sizeof($tab_form);
// variable d'incrmentation pour les calques javascript
// une par type d'evaluation (en ajouter si nouveaux types d'evaluations)
$exo=0;
$serie=0;
for($i=0;$i<$nb_form_ok;$i++)
{
            // on rcupre le nom de la formation
            // appel de la fonction PLSQL
            $nom_f=get_nom_calendrier($keys[$i]);

            // on recupere le nombre de stagiaires inscrit dans la formation
            $nbstag_form=nbStag($keys[$i]);
            // nombre de stagiaire ayant effectus es valuations
            $nbstag_resul=nbStagTravail($keys[$i]);

            $rang_form=$i+1;
            //PLSQL
            $res_liste_series_form = stats_series_formation($keys[$i]);
            $nb_series_form=pg_num_rows($res_liste_series_form);

            // fonction PLSQL
            $res_liste_exos_form= stats_exos_formation($keys[$i]);


            $nb_exos_form=pg_num_rows($res_liste_exos_form);

            if($nb_series_form >0) $moy_totale_series=MoySerieForm($res_liste_series_form,$nb_series_form);

            if($nb_exos_form>0) $moy_totale_exos=MoyExosForm($res_liste_exos_form,$nb_exos_form);

            // tableaux pour le tri des sries selon leur contenu
            $tabMulti=array();
            $tabSondage=array();
            $tabBlanc=array();
            $tabAleatMono=array();
            $tabAleatMulti=array();
            $tabQCM=array();
            $titreSerie=array();
            $tabTestPosit=array();

            // tri des sries de la formation selon leur contenu
            dispatchSerie($res_liste_series_form,$nb_series_form,&$tabMulti,&$tabBlanc,&$tabSondage,&$tabQCM,&$tabAleatMono,&$tabAleatMulti,&$titreSerie,$keys[$i],&$aleat);


            // tableaux pour le tri des exos selon leur type
            $tabPF=array();
            $tabMail=array();
            $titreExo=array();

            // tri des exos selon leur type
            dispatchExo($res_liste_exos_form,$nb_exos_form,&$tabPF,&$tabMail,&$titreExo,$keys[$i]);

            /** tableaux pour grer l'affichage des types d'evaluations dans les calques javascript
            * ici les sries et les exotlc
            * A venir les drag&drop .....
            * crer un nouveau tableau pour chaque nouveau type d'evaluations:
            * =>avec le nom du calque qui fait apparaitre la moyenne
            * =>le nom de sa variable d'incrmentation
            * =>le nom de la fonct javascript qui fait disparaitre le calque (laissez ShowRienEval et modifiez l en consquence comme
            * pour les autres evaluations)
            * =>le libelle du calque
            * =>la variable contenant la moyenne pour ce type d'evaluation
            * =>le nom du calque qui masque la moyenne
            * =>le nom de la fonction qui fait disparaitre le calque (laissez ShowEval et la modifier)
            * =>le nom du calque qui va afficher le details des eval de ce nouveau type
            * =>le tableau qui contient la liste des eval ainsi que leur moyenne respectives
            **/
            $infos_display=array();
            $display_serie=array("serieplus",$serie,"ShowRienEval",$MSG_1620,$moy_totale_series,"seriemoins","ShowEval","serie",$titreSerie);
            $display_exo=array("exoplus",$exo,"ShowRienEval",$MSG_1621,$moy_totale_exos,"exomoins","ShowEval","ex",$titreExo);

            if($nb_series_form >0 && $nb_exos_form>0)
            {
                        $infos_display[0]=$display_serie;
                        $infos_display[1]=$display_exo;
            }
            elseif($nb_series_form >0 && $nb_exos_form==0)
                        $infos_display[0]=$display_serie;

            elseif($nb_series_form ==0 && $nb_exos_form>0)
                        $infos_display[0]=$display_exo;


            /********************************************************
            *                                 affichage des rsultats
            *
            *********************************************************/
            print("
            <!--
            <table class=\"texte_tab\"  width=\"90%\" align=\"center\" border=\"1\" bordercolor=\"#000000\" cellpadding=\"2\" cellspacing=\"0\">
            <tr bgcolor=\"#cccccc\" align=\"center\">
            <td align=\"center\" cellpadding=\"2\" cellspacing=\"0\" width=\"15%\">
            -->
            <div class=\"barre\" id=\"lplus$i\" style=\"display:none\">
            <table border=\"0\" width=\"100%\" cellpadding=\"2\" cellspacing=\"0\">
            <tr bgcolor=\"#cccccc\" align=\"center\">
            <td><a href=\"./pdf/affiche_pdf.php?form=$keys[$i]&moy_form=$values[$i]\"><img src=\"../images/pdf.jpg\" height=\"22\"></a></td>
            <td align=\"center\" cellpadding=\"2\" cellspacing=\"0\" width=\"15%\">
            ");
            if($classement ==2) print("$rang_form");
            print("
            </td>
            <td align=\"center\" width=\"40%\"><a href=\"#\" onClick=\"ShowPrev($i);return(false);\">$nom_f</a></td>
            <td align=\"center\" width=\"20%\">$values[$i]/20</td>
            <td align=\"center\" width=\"12,5%\">$nbstag_resul/$nbstag_form</td>
            <td width=\"12,5%\" align=\"center\" valign=\"middle\">");

            // si parcours dynamique
            // on affiche l'icone correspondant
            $dyn=0;
            if(parcoursDyn($keys[$i]))
            {
                        $dyn=1;
                        print("<img src=\"../images/dynamic.gif\" height=\"20\" width=\"20\">");
            }
            else
            {
                        // on affiche l'icone si les evaluations de la formation n'ont pas t faites par tous les stagiaires
                        if($date_form !="old" && testEvalFiniesForm($keys[$i]) == 0)
                        {
                                    $finie=0;
                                    print("<img src=\"../images/iconicolas.gif\" height=\"20\">");
                        }
            }
            print("
            </td>
            </tr>
            </table>
            </div>
            <div class=\"barre\" id=\"lmoins$i\">
            <table border=\"0\" width=\"100%\" cellpadding=\"2\" cellspacing=\"0\">
            <tr bgcolor=\"#cccccc\" align=\"center\">
            <td><a href=\"./pdf/affiche_pdf.php?form=$keys[$i]&moy_form=$values[$i]\"><img src=\"../images/pdf.jpg\" height=\"22\"></a></td>
            <td align=\"center\" align=\"center\" cellpadding=\"2\" cellspacing=\"0\" width=\"15%\">
            ");
            if($classement ==2) print("$rang_form");
            print("
            </td>
            <td align=\"center\" width=\"40%\"><a href=\"#\" onClick=\"ShowAll($i);return(false);\">$nom_f</a></td>
            <td align=\"center\" width=\"20%\">$values[$i]/20</td>
            <td align=\"center\" width=\"12,5%\">$nbstag_resul/$nbstag_form</td>
            <td width=\"12,5%\" align=\"center\" valign=\"middle\">
            ");

            if($dyn == 1) print("<img src=\"../images/dynamic.gif\" height=\"20\" width=\"20\">");
            else if($date_form!="old" && $finie==0) print("<img src=\"../images/iconicolas.gif\">");

            print("
            </td>
            </tr>
            </table>
            </div>
            <!--
            </td>
            </tr>
            </table>
            -->
            <div id=\"rep$i\" style=\"display:none\">
            ");

            while(list($id,$display)=each($infos_display))
            {
                        print("
                        <!--
                        <table class=\"texte_tab\" align=\"center\" width=\"85%\" border=\"1\" cellpadding=\"2\" cellspacing=\"0\">
                        <tr bgcolor=\"#d9dde3\" align=\"center\">
                        <td>
                        -->

                        <div  class=\"barre_grise\" id=\"$display[0]$display[1]\" style=\"display:none\">
                        <table border=\"0\" width=\"60%\" align=\"center\">
                        <tr>
                        <td align=\"center\" width=\"60%\"><a href=\"#\" onClick=\"$display[2]($display[1],'$display[0]');return(false);\">$display[3]</a></td>
                        <td align=\"right\">&nbsp;&nbsp;$display[4]/20</td>
                        </tr>
                        </table>
                        </div>

                        <div class=\"barre_grise\" id=\"$display[5]$display[1]\">
                        <table border=\"0\" width=\"60%\" align=\"center\">
                        <tr>
                        <td align=\"center\" width=\"60%\"><a href=\"#\" onClick=\"$display[6]($display[1],'$display[5]');return(false);\">$display[3]</a></td>
                        <td align=\"right\">&nbsp;&nbsp;$display[4]/20</td>
                        </tr>
                        </table>
                        </div>

                        <!--
                        </td>
                        </tr>
                        </table>
                        -->
                        <div id=\"$display[7]$display[1]\" style=\"display:none\">
                        <table class=\"texte_tab\" width=\"80%\" border=\"1\" align=\"center\" bgcolor=\"#e8e8e8\" cellpadding=\"2\" cellspacing=\"0\">
                        ");

                        while(list($id,$tab)=each($display[8]))
                        {
                                    $type=substr($tab[0],0,strpos($tab[0],"-"));
                                    print("
                                    <tr align=\"center\">
                                    <td width=\"10%\" valign=\"middle\"><img src=\"$tab[2]\" height=\"20\"></td>
                                    <td width=\"80%\" valign=\"middle\">
                                    <a href=\"#\" onClick=\"window.open('details_score_serie.php?form=$keys[$i]&type=$type&aleat=$aleat&nb_stag=$nbstag_form','choix','status=yes,scrollbars=yes,resizable=yes,width=900,height=700');\">
                                    ".substr(strstr($tab[0],"-"),1)."
                                    </a>
                                    </td>
                                    <td>$tab[1]</td>
                                    </tr>
                                    ");
                        }
                        print("
                        </table>
                        </div>
                        ");

            }
            if($nb_series_form >0 && $nb_exos_form>0)
            {
                        $exo++;
                        $serie++;
            }
            elseif($nb_series_form >0 && $nb_exos_form==0)
                        $serie++;
            elseif($nb_series_form ==0 && $nb_exos_form>0)
                        $exo++;

            print("</div>");

}// fin du for avec $i

require('../piedpage.php3');
?>