<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    Fichier fiche_sondage_src.php
    Action : donne le dtail des sondages de type SRC
    Donnes reues : $form (formation) et $serie
*/
include('../dbpostgres.php3');
$db=pg_connect("$server","","","","$nombase");
require("$chemin_bo/lib/lib_test.php");
require("./fonct_classt.php");

//--------------------------------------------------------
//      FONCTION PHP
//--------------------------------------------------------
// fonction qui recupere la reponse pour un src (pour tous les votants)
//ex 2questions 3 rponses et 2 votants
// votant n1 : 011-110
// votant n2 : 100-111
// retourne un tableau de la forme 1,1,1- 2,2,1
function tab_reponse_test($num_cal,$serie,$ordre,$nb_votant){
    global $nb_reponse,$nb_question;
    $tabrep=array();
    $ind=$ordre +1;
    // recup de la reponse
    $sql="select reponse from res_serie_exo where id_formation=$num_cal and id_serie=$serie and ordre_etape=$ind";
    //echo "sql=$sql<br>";
    $res=pg_query($sql);
    $nb_votant=pg_numrows($res);
    $liste="";
    // boucle sur la questions
    for($q=0;$q<$nb_question;$q++){
        // boucle sur les reponses
        $lst="";
        for($r=0;$r<$nb_reponse;$r++){
            // boucle sur le nom de votants
            $somme=0;
            for($i=0;$i<$nb_votant;$i++){
                $row=pg_fetch_row($res,$i);
                $tab=explode(";",$row[0]);
                $somme +=substr($tab[$q],$r,1);
            }
            $lst .="$somme";
            if($r<$nb_reponse -1)
                $lst .=",";
        }
        $liste .="$lst";
        if($q<$nb_question)
            $liste .=";";
    }
    $tabrep=explode(";",$liste);
    return $tabrep;
}

//--------------------------------------------------------
//      AFFICHAGE ENTETE
//--------------------------------------------------------
print("
<html>
<head>
<link type=\"text/css\" href=\"style.css\" rel=\"Stylesheet\">
</head>
<body>
");

//--------------------------------------------------------
//      INITIALISATION
//--------------------------------------------------------
// recup des src de la serie
$sql="select id_exo from asso_exo_serie where id_serie=$serie and type_exo='o'";
$res=pg_query($sql);
$nb_src=pg_numrows($res);
// Effectif
$nb_stag=nbStag($form);
// BOUCLE SUR LES SRC
for($s=0;$s<$nb_src;$s++){
    $row=pg_fetch_row($res,$s);
    $obj_test=new Test($row[0]);
    // Numero et nom du test
    $id_test=$obj_test->getId();
    $libelle_test=$obj_test->toString();
    // debug
    //echo "id_test=$id_test<br>";
    // Nombre du question et nombre de rponses
    $nb_question=$obj_test->getNbExercices();
    $nb_reponse=$obj_test->getNbReponses();
    // type reponse radio ou checkbox
    $type_reponse=$obj_test->getType_reponse();
    if($type_reponse=='c')
        $type_bouton="checkbox";
    else
        $type_bouton="radio";
    // Question commune
    $question_commune=$obj_test->getQuestion_commune();
    if($question_commune!="")
        print("
        <center>
        <font face=\"Arial,Helvetica size=\"2\">
        <b>Sondage <i>$libelle_test</i> ($type_bouton)<br>$question_commune</b></font>
        </center>
        ");

    // recup de la reponse pour le test courant
    $tab_reponse_test=tab_reponse_test($form,$serie,$s,&$nb_votant);
    //debug
    //echo "nb_vote=$nb_votant<br>";
    //print_r($tab_reponse_test);



    $rang_etape=1;
    // Boucle sur les questions
    for($i=0;$i<$nb_question;$i++){
        $obj_question=&$obj_test->getExercice($i);
        $libelle_question=$obj_question->toString();

        print("
        <span class=\"texte\">
        <table align=\"center\"  border=\"1\" width=\"80%\" cellpadding=\"2\" cellspacing=\"0\">
        <tr bgcolor=\"#c7c7c7\">
        <td align=\"center\"><b>$libelle_question</b></td>
        </tr>
        </table>
        ");


        print("
        <table border=\"1\" align=\"center\" width=\"75%\" cellpadding=\"2\" cellspacing=\"0\">
        <tr bgcolor=\"#e6e6e6\">
        <td colspan=\"3\"><b>$nb_votant $MSG_1641 / $nb_stag</b></td>
        </tr>
        ");
        $tab_rep=explode(",",$tab_reponse_test[$i]);
        for($j=0;$j<$nb_reponse;$j++){
            $obj_reponse=&$obj_test->getReponse($j);
            $id_reponse=$obj_reponse->getId();
            $libelle_reponse=$obj_reponse->toString();
            $res_nb_avis=$tab_rep[$j];
            $pourcent=round(($res_nb_avis)/($nb_votant)*100,2);
            print("
            <tr bgcolor=\"#e6e6e6\">
            <td>$libelle_reponse</td>
            <td width=\"30%\"><img src=\"../images/sondage.gif\" height=\"10\" width=\"$pourcent\">&nbsp;$pourcent%</td>
            </tr>
            ");
        }
        print("</table>");
        $rang_etape++;
    }
    print("<br>");
}

print("
<center><a href=\"javascript:history.go(-1);\"><b>[$MSG_37]</b></a></center>
</span>
</body>
</html>
");
?>