<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
* Fonction qui nettoie les tables rsultats de la base.
*
* Fonction qui retire les resultats d'utilisteurs non prsents
* dans la base, des exercices ou de sries effaces, ...
*/

function nettoieBase()
{
            // nettoyage de la table resexouser: on retire les utilisateurs non prsents dans utilisateurs
            $req1="delete from resexouser
                         where num_user not in (select num_user from utilisateurs)";
            $result=pg_query($req1);

            // nettoyage de la table resexouser: on retire les formations non prsentes dans calendrier
            $req2="delete from resexouser
                         where num_cal not in (select num_cal from calendrier)
                         and num_cal <> 0";
            $result=pg_query($req2);

            // on retire les lignes dont le num_exo n'est pas dans exotlc
            $req3="delete from resexouser
                         where num_exo not in (select num_exo from exotlc)";
            $result=pg_query($req3);


            // de mme pour la table res_serie
            $req4="delete from res_serie
                        where id_stag not in (select num_user from utilisateurs)";
            $result=pg_query($req4);

            $req5="delete from res_serie
                        where id_serie not in (select id from serie_exo)";
            $result=pg_query($req5);

            $req6="delete from res_serie
                        where id_formation not in (select num_cal from calendrier)";
            $result=pg_query($req6);

}

/**
* Fonction qui teste si un parcours est dynamique
*
* La fonction retourne 0 si le parcours est normal
* et >0 si parcours dynamique
*
* @param integer numro de calendrier
*/
function parcoursDyn($cal)
{
            // test si parcours est dynamique
            //PLSQL
            $res=check_dynamique_parcours($cal);
            $nb=pg_numrows($res);
            if($nb>0) return(pg_result($res,0,0));
            else return(0);
}

/**
*  Fonction rcursive qui rempli un tableau avec les sous parcours lis  celui
*  pass en paramtre.
*
*  Retourne un tableau de parcours
*
* @param integer numro de parcours
*/
function recup_ss_parcours($parc,$tab_ss_parc)
{
            //PLSQL
            $res_ss_parc=get_sous_parcours($parc);

            if(pg_numrows($res_ss_parc)!=0)
            {
                        $chaine_parc=pg_result($res_ss_parc,0,0);
                        $tab_temp_ss_parc=array();
                        $tab_temp_ss_parc=explode(",",$chaine_parc);

                        for($i=0;$i<count($tab_temp_ss_parc);$i++)
                        {
                                    $tab_ss_parc[]=$tab_temp_ss_parc[$i];
                                    recup_ss_parcours($tab_temp_ss_parc[$i],&$tab_ss_parc);
                        }
            }
}

/**
* Fonction qui teste si un parcours est fini
* Donnes recues : $parcours $tab
*
* Retourne 1 si fini et 0 sinon
*
* @param integer numro de stagiaire
* @param integer numro de formation
* @param array dtail des tapes du parcours
*/
function parcours_fini($tab,$id_stag,$id_cal){

    $fini=0;

    // somme des nb d'etape des parcours
    $nbparc=sizeof($tab);
    $parcours_principal=$tab[0];
    $somme_etape=0;
    $somme_etape_libre=0;
    for($i=0;$i<$nbparc;$i++){
        $req="select * from gestparcours where g_num_parcours='$tab[$i]';";
        $res=pg_exec($req);
        $somme_etape +=pg_numrows($res);
        // somme etape libre autre que etape titre
        $req="select * from gestparcours where g_num_parcours='$tab[$i]' and obligation <>'o' and type_etape <>'I'";
        $res=pg_exec($req);
        $somme_etape_libre +=pg_numrows($res);           
    }

    //recup de l'avancement du stagiaire
    //$req="select avancement,etape_libre from gestionparcours where gp_num_user='$id_stag' and num_cal='$id_cal';";
    //$res=pg_exec($req);
    $res=get_avancement_stagiaire($id_stag,$id_cal);
    $row=pg_fetch_row($res,0);
    // recup des etapes libres

    $stock=explode(",",$row[1]);
    $nbetape_libre=sizeof($stock)-1;

    $avancement=$row[0]+$nbetape_libre;

    if($avancement >=$somme_etape){
        // il faudra tester si les valuations Exotlc (s'il y en a) ont t corriges A Suivre ....
        // recup des tapes exotlc du parcours courant
        $indice=$nbparc -1;
        $parcours_courant=$tab[$indice];
        $req="select * from gestparcours where g_num_parcours='$parcours_courant' and type_etape='E'";
        $resexo=pg_exec($req);
        $nbexo=pg_num_rows($resexo);
        if($nbexo==0)
            $fini=1;

        else {
            // boucle sur ls exos
            $fini=1;
            for($e=0;$e<$nbexo;$e++){
                $rowexo=pg_fetch_row($resexo,$e);

                // test si corrig
                $req="select * from resexouser where num_exo='$rowexo[4]' and num_user='$id_stag' and num_cal='$id_cal'";
                $restest=pg_exec($req);
                if(pg_numrows($restest)==0){
                    $fini=0;
                    break;
                }
            }
        }
    }
    return $fini;

}


// fonction qui teste si toutes les evaluations ont t faites
//pour une formation et un stagiaire
function testEvalFinies($id_form, $id_user)
{
            // test si parcours dynamique
            $id_parc=parcoursDyn($id_form);
            $tab_ss_parc=array();
            $ind=0;
            if($id_parc>0)
            {
                        // on rcupre tous les ss-parcours de ce parcours (!!!  si un ss_parcours est aussi dynamique, on rcupre ces ss_parcours, etc...)
                        recup_ss_parcours($id_parc,&$tab_ss_parc);
                        return(parcours_fini($tab_ss_parc,$id_user,$id_form));
            }
            else
            {
                        // on compte le nombre de sries de la formation
                        // PLSQL
                        $result_serie=get_nb_series($id_form);
                        $nb_series=pg_result($result_serie,0);

                        // on compte le nombre d'exotlc de la formation
                        // PLSQL
                        $result_exotlc=get_nb_exos($id_form);
                        $nb_exos=pg_result($result_exotlc,0);

                        if($nb_series > 0 && $nb_exos>0)
                        {
                                    // on compte le nombre de sries faites
                                    //PLSQL
                                    $nb_series_faites=get_nb_series_finies($id_form,$id_user);
                                    if($nb_series_faites <$nb_series) return(0);
                                    else
                                    {
                                                // on compte le nombre d'exo faits
                                                // PLSQL
                                                $nb_exos_faits=get_nb_exos_finis($id_form,$id_user);
                                                if($nb_exos_faits<$nb_exos) return(0);
                                                else return(1);
                                    }
                        }
                        elseif($nb_series>0 && $nb_exos==0)
                        {
                                    // on compte le nombre de sries faites
                                    //PLSQL
                                    $nb_series_faites=get_nb_series_finies($id_form,$id_user);
                                    if($nb_series_faites <$nb_series) return(0);
                                    else return(1);
                        }
                        elseif($nb_exos>0 && $nb_series==0)
                        {
                                    // on compte le nombre d'exo faits
                                    // PLSQL
                                    $nb_exos_faits=get_nb_exos_finis($id_form,$id_user);
                                    if($nb_exos_faits<$nb_exos) return(0);
                                    else return(1);
                        }
            }
}



// fonction qui teste si toutes les valuations d'une formation ont t faites
// fonctionne que pour les formations sans parcours dynamiques
function testEvalFiniesForm($id_form)
{
            // liste de stagiaires lis  la formation
            //PLSQL
            $result=get_individus_formation($id_form);
            $nbstag=pg_num_rows($result);

             // on compte le nombre de sries de la formation
             // PLSQL
            $nb_series=get_nb_series($id_form);

            // on compte le nombre d'exotlc de la formation
            // PLSQL
            $nb_exos=get_nb_exos($id_form);

            $i=0;
            $retour=0;
            while($i<$nbstag && $retour !=1)
            {
                        $id_user=pg_result($result,$i,0);
                        if($nb_series > 0 && $nb_exos>0)
                        {
                                    // on compte le nombre de sries faites
                                     //PLSQL
                                    $nb_series_faites=get_nb_series_finies($id_form,$id_user);

                                    if($nb_series_faites <$nb_series) return(0);
                                    else
                                    {
                                                // on compte le nombre d'exo faits
                                                //PLSQL
                                                $nb_exos_faits=get_nb_exos_finis($id_form,$id_user);

                                                if($nb_exos_faits<$nb_exos) return(0);
                                                else $retour=1;
                                    }
                        }
                        elseif($nb_series>0 && $nb_exos==0)
                        {
                                    // on compte le nombre de sries faites
                                    //PLSQL
                                    $nb_series_faites=get_nb_series_finies($id_form,$id_user);

                                    if($nb_series_faites <$nb_series) return(0);
                                    else $retour=1;
                        }
                        elseif($nb_exos>0 && $nb_series==0)
                        {
                                    // on compte le nombre d'exo faits
                                    //PLSQL
                                    $nb_exos_faits=get_nb_exos_finis($id_form,$id_user);

                                    if($nb_exos_faits<$nb_exos) return(0);
                                    else $retour = 1;
                        }
                        $i++;

            }
            return(1);
}

// fonction qui qui teste si la srie passe en paramtres
//ne contiennent que des sondages
function rechSondage($id_serie)
{
            // PLSQL
            $res_test_alea=check_aleatoire_serie($id_serie);
            $res_test_sondage=get_types_etapes_serie($id_serie,$res_test_alea);

            if(pg_numrows($res_test_sondage)==1 && (pg_result($res_test_sondage,0)=='s' || pg_result($res_test_sondage,0)=='o'))
                        $sondage=1;
            else $sondage=0;

            return($sondage);
}


function calculeMoyTypeSerie($form,$tab)
{
            $nb_serie=sizeof($tab);
            $moyenne=0;
            $nb_serie_reel=0;

            for($i=0;$i<$nb_serie;$i++)
            {
                        if(rechSondage($tab[$i]) ==0)
                        {
                                    $res=stats_serie_formation($form,$tab[$i]);
                                    $nb_note=pg_num_rows($res);
                                    $note=0;
                                    for($j=0;$j<$nb_note;$j++)
                                                $note+=pg_result($res,$j,0);
                                    if($nb_note>0) $moyenne+=$note/$nb_note;
                                    $nb_serie_reel++;
                        }
            }
            if($nb_serie_reel>0)
                        return(round($moyenne/$nb_serie_reel,2));

}

function calculeMoyTypeExo($form,$tab)
{
            $nb_exo=sizeof($tab);
            $moyenne=0;
            for($i=0;$i<$nb_exo;$i++)
            {
                        /*$req="select score,surtotal
                        from resexouser
                        where num_cal='$form'
                        and num_exo='$tab[$i]'";

                        $res=pg_query($req);
                        */
                        $res=stats_exo_formation($form,$tab[$i]);
                        $nb_note=pg_num_rows($res);
                        $note=0;
                        for($j=0;$j<$nb_note;$j++)
                                    $note += (pg_result($res,$j,0)/pg_result($res,$j,1))*20;
                        if($nb_note>0) $moyenne+=$note/$nb_note;
            }
            return(round($moyenne/$nb_exo,2));
}


// fonction qui retourne le nombre de stagiaires de la formation
function nbStag($cal)
{
            //PLSQL
            $result=get_individus_formation($cal);
            $nbstag=pg_num_rows($result);
            return($nbstag);

}

function nbStagTravail($cal)
{
            //PLSQL
            $res=get_stagiaires_evaluation_finie_formation($cal);
            return(pg_num_rows($res));
}


function dispatchSerie($res,$nb,$tabMulti,$tabBlanc,$tabSondage,$tabQCM,$tabAleatMono,$tabAleatMulti,$titreSerie,$form,$aleat=''){
    global $MSG_1622,$MSG_1623,$MSG_1624,$MSG_1625,$MSG_1626,$MSG_1627;
    for($i=0;$i<$nb;$i++){
        $num_serie=pg_result($res,$i,0);
        $test_aleatoire="select mode from serie_aleatoire where num_serie='$num_serie'";
        $res_test_aleatoire=pg_query($test_aleatoire);
        $nb_rows=pg_num_rows($res_test_aleatoire);

        if(($nb_rows !=1) && ($nb_rows !=2)){
            // test ds la table asso_exo_serie_aleat pour le test de positionnement
            $sql="SELECT * FROM asso_exo_serie_aleatoire WHERE id_serie='$num_serie'";
            $res_assoexoserie=pg_query($sql);
            if(pg_num_rows($res_assoexoserie)>0)
                $nb_rows=3;
        }
        $aleat=$nb_rows;
        //PLSQL
        $res_type_serie=get_types_etapes_serie($num_serie,$nb_rows);

                        /*if($nb_rows>0) $table="asso_exo_serie_aleatoire";
                        else $table="asso_exo_serie";

                        $type_serie="select distinct type_exo
                                                from $table
                                                where id_serie='$num_serie'";
                        $res_type_serie=pg_query($type_serie);
                        */

        if(($nb_rows>0)&&($nb_rows<3)){
            if(pg_result($res_test_aleatoire,0) == 1)
                $tabAleatMono[]=$num_serie;
            else
                $tabAleatMulti[]=$num_serie;
        }
        else{
            if(pg_num_rows($res_type_serie)>1){
                if(pg_num_rows($res_type_serie)==2){
                    $res1=pg_result($res_type_serie,0,0);
                    $res2=pg_result($res_type_serie,1,0);
                    if(($res1=='q' && ($res2=='m' || $res2=='s' || $res2=='o')) || ($res1=='m' && ($res2=='q' || $res2=='s' || $res2=='o')))
                        $tabQCM[]=$num_serie;
                    else
                        if(($res1=='s' && $res2=='o') || ($res1=='o' && $res2=='s'))
                            $tabSondage[]=$num_serie;
                        else
                            $tabMulti[]=$num_serie;
                }
                else
                    $tabMulti[]=$num_serie;
            }
            else{
                $type=pg_result($res_type_serie,0);
                switch ($type){
                    case 'o' :
                    case 's' : $tabSondage[]=$num_serie;
                    break;
                    case 'f' : $tabBlanc[]=$num_serie;
                    break;
                    case 'm' :
                    case 'q' : $tabQCM[]=$num_serie;
                    break;
                }
            }
        }
    }

    if(sizeof($tabMulti)>0){
        $titreSerie[0][0]="m-".$MSG_1623;
        $titreSerie[0][1]=calculeMoyTypeSerie($form,$tabMulti)."/20";
        $titreSerie[0][2]="../images/icoserie.gif";
    }
    if(sizeof($tabBlanc)>0){
        $titreSerie[1][0]="f-".$MSG_1622;
        $titreSerie[1][1]=calculeMoyTypeSerie($form,$tabBlanc)."/20";
        $titreSerie[1][2]="../images/icoremplir.gif";
    }
    if(sizeof($tabSondage)>0){
        $titreSerie[2][0]="s-".$MSG_1624;
        $titreSerie[2][1]="&nbsp;";
        $titreSerie[2][2]="../images/icosonde.gif";
    }
    if(sizeof($tabQCM)>0){
        $titreSerie[3][0]="q-".$MSG_1625;
        $titreSerie[3][1]=calculeMoyTypeSerie($form,$tabQCM)."/20";
        $titreSerie[3][2]="../images/icoqcm.gif";
    }
    if(sizeof($tabAleatMono)>0){
        $titreSerie[4][0]="a-".$MSG_1627;
        $titreSerie[4][1]=calculeMoyTypeSerie($form,$tabAleatMono)."/20";
        $titreSerie[4][2]="../images/icoserie.gif";
    }
    if(sizeof($tabAleatMulti)>0){
        $titreSerie[5][0]="A-".$MSG_1626;
        $titreSerie[5][1]=calculeMoyTypeSerie($form,$tabAleatMulti)."/20";
        $titreSerie[5][2]="../images/icoserie.gif";
    }
}

function dispatchExo($res_liste_exos_form,$nb_exos_form,$tabPF,$tabMail,$titreExo,$form)
{
            global $MSG_1628,$MSG_1629;
            for($i=0;$i<$nb_exos_form;$i++)
            {
                        $num_exo=pg_result($res_liste_exos_form,$i,0);
                        $type_exo="select mode_rendu
                                                from exotlc
                                                where num_exo='$num_exo'";
                        $res_type_exo=pg_query($type_exo);
                        $mode=pg_result($res_type_exo,0,0);
                        if($mode=='m'|| empty($mode)) $tabMail[]=$num_exo;
                        else $tabPF[]=$num_exo;

            }

            if(sizeof($tabPF)>0)
            {
                        $titreExo[0][0]="pf-".$MSG_1628;
                        $titreExo[0][1]=calculeMoyTypeExo($form,$tabPF)."/20";
                        $titreExo[0][2]="../images/icotlc.gif";
            }

            if(sizeof($tabMail)>0)
            {
                        $titreExo[1][0]="ma-".$MSG_1629;
                        $titreExo[1][1]=calculeMoyTypeExo($form,$tabMail)."/20";
                        $titreExo[1][2]="../images/icotlc.gif";
            }
}








function MoySerieForm($res_liste_series_form,$nb_series_form)
{
            $somme=0;
            $cpt=0;
            for($i=0;$i<$nb_series_form;$i++)
            {
                        if(rechSondage(pg_result($res_liste_series_form,$i,0))==0)
                        {
                                     $somme+=pg_result($res_liste_series_form,$i,1);
                                     $cpt++;
                        }
            }
            return(round($somme/$cpt,2));
}


function MoyExosForm($res_liste_exos_form,$nb_exos_form)
{
            $somme=0;
            for($i=0;$i<$nb_exos_form;$i++)
            {
                        $rapport=pg_result($res_liste_exos_form,$i,1)/pg_result($res_liste_exos_form,$i,2);
                        $note20=$rapport*20;
                        //$note20=round($note20,2);
                        $somme+=$note20;

            }
            return(round($somme/$nb_exos_form,2));
}

function MoyGenCal($cal,$tab_form)
{

            global  $moy_cal_series,$moy_cal_exos;

            //calcul de la moyenne gnrale de la formation (sries + exotlc)
            // moyenne de toutes les sries de la formation
            // PLSQL
            $moy_series = stats_series_formation($cal);
            /*if(!$moy_series)
            {
                        $sql_serie="select id_serie, score
                                    from res_serie
                                    where id_formation='$cal'
                                    and score >=0
                                    and date_fin >0";

                        $moy_series=pg_query($sql_serie);
            }*/

            $nb_note_series=pg_numrows($moy_series);
            if($nb_note_series>0)
            {
                        $moy_cal_series=0;
                        $cpt=0;

                        for($s=0;$s<$nb_note_series;$s++)
                        {

                                    if(rechSondage(pg_result($moy_series,$s,0))==0)
                                    {
                                                $moy_cal_series += pg_result($moy_series,$s,1);
                                                $cpt++;
                                    }

                        }
                        if($cpt==0)
                                    $moy_cal_series=-1;
                        else
                                    $moy_cal_series = ($moy_cal_series/$cpt);

            }
            else $moy_cal_series=-1;

            // moyenne de tous les exotlc de la formation
            //PLSQL
            $moy_exos=stats_exos_formation($cal);
            /*if(!$moy_exos)
            {
                        $sql_exo="select score, surtotal
                                    from resexouser
                                    where num_cal='$cal'";
                        $moy_exos=pg_query($sql_exo);
            }*/

            $nb_note_exos=pg_num_rows($moy_exos);
            $moy_cal_exos=0;

            if($nb_note_exos>0)
            {
                        for($j=0;$j<$nb_note_exos;$j++)
                                    $moy_cal_exos+=round(((pg_result($moy_exos,$j,1)/pg_result($moy_exos,$j,2))*20),2);
                        $moy_cal_exos=round($moy_cal_exos/$nb_note_exos,2);
            }
            else $moy_cal_exos=-1;

            // calcul de la moyenne gnrale de la formation
            if($moy_cal_series !=-1)
            {
                        if($moy_cal_exos !=-1) $moy_generale_form=(($moy_cal_series+$moy_cal_exos)/2);

                        if($moy_cal_exos == -1) $moy_generale_form=$moy_cal_series;
            }
            elseif($moy_cal_series == -1)
            {
                        if($moy_cal_exos != -1) $moy_generale_form=$moy_cal_exos;

                        if($moy_cal_exos == -1) $moy_generale_form=-1;

            }

            if($moy_generale_form != -1)
            {
                        $moy_generale_form=round($moy_generale_form,2);
                        //on stocke la moyenne de la srie lie  son numro
                        $tab_form[$cal]=$moy_generale_form;
            }
}

/************************************ fonctions de score_par_user.php***************************************************/
function calculeMoyGenStag($classement,$tab_stag)
{
            /*if($classement==1) $order="order by nom asc";
            else $order="";*/

            // on sort les numro de user classs par ordre alphabtique
            $res=get_stagiaires_evaluation_finie($classement);
            /*if(!$res)
            {
                        $req="select id_stag, nom
                        from res_serie, utilisateurs
                        where num_user=id_stag
                        and score >=0
                        union
                        select ru.num_user, nom
                        from resexouser ru, utilisateurs u
                        where u.num_user=ru.num_user
                        and num_cal <>0
                        $order";
                        $res=pg_query($req);
            }*/

            $nb_user=pg_numrows($res);

            for($i=0;$i<$nb_user;$i++)
            {

                        //calcul de la moyenne gnrale du stagiaire (sries + exotlc)
                        // moyenne de toutes les sries du stagiaire

                        $sql_serie="select id_serie, score
                                                from res_serie
                                                where id_stag='".pg_result($res,$i,0)."'
                                                and score >=0
                                                and date_fin>0
                                                group by id_serie,score";
                        $moy_series=pg_query($sql_serie);
                        $nb_note_series=pg_numrows($moy_series);
                        if($nb_note_series>0)
                        {
                                    $moy_cal_series=0;
                                    $cpt=0;

                                    // on boucle sur les sries corriges pour retirer celles qui n'auraient que des sondages !!!!!
                                    for($s=0;$s<$nb_note_series;$s++)
                                    {
                                                if(rechSondage(pg_result($moy_series,$s,0))==0)
                                                {
                                                            $moy_cal_series += pg_result($moy_series,$s,1);
                                                            $cpt++;
                                                }
                                    }
                                    if($cpt==0) $moy_cal_series=-1;
                                    else $moy_cal_series = ($moy_cal_series/$cpt);
                        }
                        else $moy_cal_series=-1;


                        // moyenne de tous les exotlc de la formation
                        $sql_exo="select sum(score) as somme, sum(surtotal) as total
                                    from resexouser
                                    where num_user='".pg_result($res,$i,0)."'
                                    and num_cal<>0";

                        $moy_exos=pg_query($sql_exo);

                        if(pg_result($moy_exos,0,"total"))
                                    $moy_cal_exos=round(((pg_result($moy_exos,0,"somme")/pg_result($moy_exos,0,"total"))*20),2);
                        else
                                    $moy_cal_exos=-1;


                        // calcul de la moyenne gnrale de la formation
                        if($moy_cal_series !=-1 && $moy_cal_exos !=-1)
                                    $moy_generale_form=(($moy_cal_series+$moy_cal_exos)/2);

                        elseif($moy_cal_series==-1)
                                    $moy_generale_form=$moy_cal_exos;

                        elseif($moy_cal_exos==-1)
                                    $moy_generale_form=$moy_cal_series;
                        else $moy_generale_form=-1;

                        if($moy_generale_form !=-1)
                        {
                                    
                                    $moy_generale_form=round($moy_generale_form,2);
                                    //on stocke la moyenne du stagiaire lie  son numro
                                    $tab_stag[pg_result($res,$i,0)]=$moy_generale_form;
                        }
            }
}
?>

