<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*---------------------------------------------------------------------------------------*/  
//  Fichier graphFormSuivi.php3
//  Action : reprsentation graphique par grille,par groupe,par stagiaire
//  Donne recue : $theme,$numcal,$groupe
/*---------------------------------------------------------------------------------------*/

require("../dbpostgres.php3");
require("./lib-graphique.php3");
require('../lib/lib_statistiques.php');
$db = pg_Connect("$server", "", "", "", "$nombase") or die ("$ERROR_2");

// vidage du cache des images
if($reload == 1)
{
            $dir=$chemin_bo."/classement/cache-graphiques/";
            $open=opendir($dir);
            while(($file=readdir($open)))
            {
                        if($file!="." && $file !=".." && (substr($file,0,5) == "calgp"))
                                    $del=unlink($dir.$file);


            }
            header("Location=./graphFormSuivi.php3?numcal=$numcal&theme=$theme&groupe=$groupe&reload=0");
}
/*-------------------------------------------------------------------*/
//      FONCTIONS PHP
/*-------------------------------------------------------------------*/
/**
* Fonction qui retourne la note globale sur 20
*
* Calcule la note du suivi presentiel pour une grille,
* une formation, un groupe ou un stagiaire.
*
* @param integer : numro de calendrier
* @param integer : numro de stagiaire (null par dfaut)
* @param integer : numro de grille
* @return float : note sur 20
*/
function note_globale_grille($numcal,$numuser="",$numgrille)
{
        $note=0;
        $resnote=get_infos_presentiel_stagiaire($numcal,$numuser,$numgrille,"null","null");
        $nbnote=pg_num_rows($resnote);
        if($nbnote>0)
        {
                for($i=0;$i<$nbnote;$i++)
                {
                        $rownote=pg_fetch_row($resnote,$i);
                        $notesur20=($rownote[7]*20)/$rownote[8];
                        $note +=$notesur20;
                }
                return $note/$nbnote;
        }
        else
                return $note;
}

/**
* Fonction qui retourne la note globale sur 20
*
* Calcule la note du suivi presentiel pour une capacit,
* une formation, un groupe ou un stagiaire.
*
* @param integer : numro de calendrier
* @param integer : numro de stagiaire (null par dfaut)
* @param integer : numro de grille
* @param integer : numro de titre capacit
* @param integer : numro de capacit
* @return float : note sur 20
*/

function note_globale_capacite($numcal,$numuser="",$numgrille,$numtitrecapacite,$numcapacite)
{
        $note=0;
        $resnote=get_infos_presentiel_stagiaire($numcal,$numuser,$numgrille,$numtitrecapacite,$numcapacite);
        $nbnote=pg_numrows($resnote);
        if($nbnote>0)
        {
                for($i=0;$i<$nbnote;$i++)
                {
                        $rownote=pg_fetch_row($resnote,$i);
                        $notesur20=($rownote[7]*20)/$rownote[8];
                        $note +=$notesur20;
                }
                return $note/$nbnote;
        }
        else
                return (-1);
}

/**
* Fonction qui retourne le numero du jour
*
* Retourne le numro du jour en fonction du numero
* de date et du numero de calendrier
*
* @param integer : numro de formation
* @param integer : numro de date
* @return integer : numro de jour
*/
function numero_du_jour($numdate,$numcal)
{
            //recup des dates du calendrier
            $req="select jour from dates where num_date in (select num_date from gest_cal where numtype='3' and gnum_cal='$numcal')";
            $res=pg_exec($req);
            // stockage et tri
            $nb=pg_numrows($res);
            for($i=0;$i<$nb;$i++)
            {
                        $row=pg_fetch_row($res,$i);
                        $tab[]=$row[0];
            }
            sort($tab);
            for($i=0;$i<$nb;$i++)
            {
                        if($tab[$i]==$numdate)
                                    break;
            }
            return $i;
}


/*---------------------------------------------------------------------------------------*/
//      Affichage entete
/*---------------------------------------------------------------------------------------*/
$nompage="grphFormSuivi.php3";
$titre="<span class=\"titre\">Statistiques presentielles par formation</span>";
$styleCSS="style.css";
require('../entete.php3');
print("
<table border=\"0\" align=\"center\" cellspacing=\"0\" cellpadding=\"0\">
<tr>
<td align=\"center\">
<a href=\"graphFormSuivi.php3?numcal=$numcal&theme=$theme&groupe=$groupe&reload=1\">
<img src=\"../images/refresh.gif\" border=\"0\">
</a>
</td>
</tr>
<tr>
<td align=\"center\">
<font color=\"#FF0000\" size=\"1\">Rinitialiser</font>
</td>
</tr>
</table>
<br>
");
/*---------------------------------------------------------------------------------------*/
//              Fonctions javascript
/*---------------------------------------------------------------------------------------*/  
print("
<script language=\"javascript\">
function validegrille(){
        document.formgrille.submit();
} 
function validestagiaire(){
        document.formstag.submit();
}
function validetitre(){
        document.formtitre.submit();
}
function validecapacite(){
        document.formcapa.submit();
}
</script> 
");
/*---------------------------------------------------------------------------------------*/
//      Info propres  la formation
/*---------------------------------------------------------------------------------------*/
//Nom de la formation
$resform=pg_exec($db,"select nom_cal,datedeb,datefin from calendrier where num_cal='$numcal';");
$rowform=pg_fetch_row($resform,0);
$nom_formation=$rowform[0];
//Dates de dbut et fin de formation 
$resdate=pg_exec($db,"select d1.jour,d2.jour from dates d1,dates d2 where d1.num_date='$rowform[1]' and d2.num_date='$rowform[2]';");
$rowdate=pg_fetch_row($resdate,0); 
//formatage date
$tabdeb=explode("-",$rowdate[0]);
$debut=formater_date($tabdeb,MY_LANG);
$tabfin=explode("-",$rowdate[1]);
$fin=formater_date($tabfin,MY_LANG);

//Nom du formateur
$resnom=pg_exec($db,"select nom,prenom from utilisateurs where num_user in 
(select distinct g_num_user from gestionnaire where g_num_cal='$numcal');");
$rownom=pg_fetch_row($resnom,0);
$nom_formateur=$rownom[0];
$prenom_formateur=$rownom[1];
//Nom du groupe
$resgroupe=pg_exec($db,"select nom from classe where id='$groupe';");
$rowgroupe=pg_fetch_row($resgroupe,0);
$nom_groupe=$rowgroupe[0];

/*---------------------------------------------------------------------------------------*/
//      Prparation des donnes et Affichage du graphe (histogramme)
//      Stat par grille pour un groupe
/*---------------------------------------------------------------------------------------*/

if(!empty($grille))
{
            // recup du nom de la grille
            $req="select libelle_grille from grille where num_grille='$grille';";
            $res=pg_exec($req);
            $row=pg_fetch_row($res,0);
            $nomgrille=$row[0];
            // recup des dates du calendrier
            $req="select distinct num_date,gnum_cal from gest_cal where numtype='3' and gnum_cal in
            (select num_cal from notation where num_cal='$numcal' and num_grille='$grille')";
            $res=pg_exec($req);
            $nbdate=pg_numrows($res);

            if($nbdate>0)
            {
                        // stockage des dates et calendriers
                        for($d=0;$d<$nbdate;$d++)
                        {
                                    $row=pg_fetch_row($res,$d);
                                    // recup du jour
                                    $resjour=pg_exec($db,"select jour from dates where num_date='$row[0]';");
                                    $rowjour=@pg_fetch_row($resjour,0);
                                    $stock["$rowjour[0]"][]="$row[0],$row[1]";
                        }
                        // tri croissant sur les jours
                        ksort($stock);
                        //recup des notations par jour
                        while(list($jour)=each($stock))
                        {

                                    while(list($cle2,$val)=each($stock["$jour"]))
                                    {
                                                $tabval=explode(",",$val);
                                                $req="select notation from notation where num_cal='$tabval[1]' and num_grille='$grille'";
                                                $resnote=pg_exec($req);
                                                $nbnote=pg_numrows($resnote);
                                                $numjour=numero_du_jour($jour,$tabval[1]);
                                                // les carton par jour
                                                $rouge=0;
                                                $orange=0;
                                                $vert=0;
                                                for($n=0;$n<$nbnote;$n++)
                                                {
                                                            $rownote=pg_fetch_row($resnote,$n);
                                                            $tabnote=explode(",",$rownote[0]);
                                                            switch($tabnote[$numjour])
                                                            {
                                                                        case 1 : $rouge +=1;
                                                                        break;
                                                                        case 2 : $orange +=1;
                                                                        break;
                                                                        case 3 : $vert +=1;
                                                                        break;
                                                            }
                                                }
                                                $tabjournote[]="$rouge,$orange,$vert";
                                    }

                        }


                        for($d=0;$d<$nbdate;$d++)
                        {
                                    $tabdonnees=explode(",",$tabjournote[$d]);
                                    $donnees[0][]=$tabdonnees[0];
                                    $donnees[1][]=$tabdonnees[1];
                                    $donnees[2][]=$tabdonnees[2];
                        }
                        reset($stock);
                        while(list($jour)=each($stock))
                        {
                                    $dt=explode("-",$jour);
                                    $jour=formater_date($dt,MY_LANG,"y");
                                    $abscisses[]=$jour;
                        }
                        // calcul de la moyenne pour le groupe
                        $notegrille=note_globale_grille($numcal,"",$grille);
                        $notegrille *=100;
                        $notegrille=round($notegrille);
                        $notegrille /=100;
                        $couleurs[0] = array("009900", "0066CC", "000000", "000000", "EEEEEE", "FFFFFF");
                        $couleurs[1] = array("403015", "333333", "001530");
                        $couleurs[2] = array("FF0000", "FFA500", "00FF00");

                        // debug
                        $options = array(2, 2, 1, 1, 1,2);
                        $legende = array("$MSG_975", "$MSG_976", "$MSG_974","$MSG_1211 : $notegrille / 20");

                        // titre du graphe
                        $titre="$MSG_226 : \"$nomgrille\" $MSG_682 : \"$nom_groupe\"";
                        // nom du graph
                        $nomgraph="calgpgri_".$numcal."-".$groupe."-".$grille.".png";

                        dessiner_graphique("histogramme", $titre, "d", 650, 200, 20, 20, $options, $donnees, $legende, $abscisses, $couleurs,$nomgraph);
            }
            else

                        $error="<span class=\"texte_alert\">$MSG_1219</span>";


}
else

            $error="<span class=\"texte_alert\">$MSG_2343</span>";

print("
<br>
<br>
<table class=\"texte_tab\" id=\"cadre\" width=\"100%\" cellpadding=\"2\" cellspacing=\"1\">
<tr>
<td class=\"case\" id=\"titre\">$MSG_635</td>
<td class=\"case\" id=\"titre\">$MSG_682</td>
<td class=\"case\" id=\"titre\">$MSG_17</td>
<td class=\"case\" id=\"titre\">$MSG_226</td>
<td class=\"case\" id=\"titre\">$MSG_1215</td>
</tr>
<tr>
<td class=\"presentiel\" id=\"ligne\">$nom_formation<br>$MSG_135 $debut $MSG_136 $fin</td>
<td class=\"presentiel\" id=\"ligne\">$nom_groupe</td>
<td class=\"presentiel\" id=\"ligne\">$nom_formateur</td>
<td class=\"presentiel\" id=\"ligne\">
<form name=\"formgrille\">
<select name=\"grille\" onchange=\"validegrille();\" id=\"texte\">
<option value=\"\">$MSG_845</option>
");
// recup des grilles
$resgrille=pg_query("select * from grille where num_grille in (select distinct num_grille from notation where num_cal='$numcal');");
$nbgrille=pg_numrows($resgrille);
for($i=0;$i<$nbgrille;$i++)
{
            $rowgrille=pg_fetch_row($resgrille,$i);
            if($rowgrille[0]==$grille)
                        print("<option value=\"$rowgrille[0]\" selected>$rowgrille[1]</option>");
            else
                        print("<option value=\"$rowgrille[0]\">$rowgrille[1]</option>");
}

print("
</select>
<input type=hidden name=\"theme\" value=\"$theme\">
<input type=hidden name=\"numcal\" value=\"$numcal\">
<input type=hidden name=\"groupe\" value=\"$groupe\">
</form>
</td>

");
// calcul des % de carton vert orange et rouge
if($grille!="")
{
            print("
            <td class=\"case\" id=\"ligne\">
            ");
            //recup des cartons rouge orange vert
            $r=0;
            $o=0;
            $v=0;
            $total_carton=0;
            $tabrov=array();

            for($j=0;$j<$nbdate;$j++)
            {
                        $tabrov=explode(",",$tabjournote[$j]);
                        $r+=$tabrov[0];
                        $o+=$tabrov[1];
                        $v+=$tabrov[2];
            }
            $total_carton=$r+$o+$v;
            $pourcent_rouge=$r/$total_carton;
            $pourcent_rouge*=100;
            $pourcent_rouge=round($pourcent_rouge);
            $pourcent_orange=$o/$total_carton;
            $pourcent_orange*=100;
            $pourcent_orange=round($pourcent_orange);
            $pourcent_vert=$v/$total_carton;
            $pourcent_vert*=100;
            $pourcent_vert=round($pourcent_vert);
            print("
            <table border=\"0\" cellspacing=\"0\" cellpadding=\"1\">
            <tr>
            <td>
            <img width=20 height=20 src=\"../images/cartr.jpg\" >
            <br><font size=2>$pourcent_rouge %</font>
            </td>
            <td>
            <img width=20 height=20 src=\"../images/carto.jpg\" >
            <br><font size=2>$pourcent_orange %</font>
            </td>
            <td>
            <img width=20 height=20 src=\"../images/cartv.jpg\" >
            <br><font size=2>$pourcent_vert %</font>
            </td>
            </tr>
            </table>
            </td>
            </tr>
            ");

}
print("
</table>
");
if($grille!="")
            print("<img src=\"./cache-graphiques/$nomgraph\">\n");
else        print("$error");

/*---------------------------------------------------------------------------------------*/
//      Prparation des donnes et Affichage du graphe (histogramme)
//      Stat par grille pour un stagiaire
/*---------------------------------------------------------------------------------------*/
if($stagiaire!="")
{
            // recup nom et prenom stagiaire
            $req="select nom,prenom from utilisateurs where num_user='$stagiaire'";
            $resstag=pg_exec($req);
            $rowstag=pg_fetch_row($resstag,0);
            $nomstagiaire=$rowstag[0];
            $prenomstagiaire=$rowstag[1];
            // recup des dates du calendrier
            $req="select distinct num_date,gnum_cal from gest_cal where numtype='3' and gnum_cal in
            (select num_cal from notation where num_cal='$numcal' and num_grille='$grille' and num_user='$stagiaire')";
            $res=pg_exec($req);
            $nbdate=pg_numrows($res);
            if($nbdate>0)
            {
                        // stockage des dates et calendriers
                        $stock=array();
                        for($d=0;$d<$nbdate;$d++)
                        {
                                    $row=pg_fetch_row($res,$d);
                                    // recup du jour
                                    $resjour=pg_exec($db,"select jour from dates where num_date='$row[0]';");
                                    $rowjour=pg_fetch_row($resjour,0);
                                    $stock["$rowjour[0]"][]="$row[0],$row[1]";
                        }
                        // tri croissant sur les jours
                        ksort($stock);
                        //recup des notations par jour
                        $tabjournote=array();
                        while(list($jour)=each($stock))
                        {
                                    //debug
                                    $tabnote=array();
                                    while(list($cle2,$val)=each($stock["$jour"]))
                                    {
                                                $tabval=explode(",",$val);
                                                $req="select notation from notation where num_cal='$tabval[1]' and num_grille='$grille' and num_user='$stagiaire'";
                                                $resnote=pg_exec($req);
                                                $nbnote=pg_numrows($resnote);
                                                $numjour=numero_du_jour($jour,$tabval[1]);
                                                // les carton par jour
                                                $rouge=0;
                                                $orange=0;
                                                $vert=0;
                                               for($n=0;$n<$nbnote;$n++)
                                               {
                                                            $rownote=pg_fetch_row($resnote,$n);
                                                            $tabnote=explode(",",$rownote[0]);
                                                            switch($tabnote[$numjour])
                                                            {
                                                                        case 1 : $rouge +=1;
                                                                        break;
                                                                        case 2 : $orange +=1;
                                                                        break;
                                                                        case 3 : $vert +=1;
                                                                        break;
                                                            }
                                                }
                                                $tabjournote[]="$rouge,$orange,$vert";
                                    }
                        }

                        $donnees=array();
                        for($d=0;$d<$nbdate;$d++)
                        {
                                    $tabdonnees=explode(",",$tabjournote[$d]);
                                    $donnees[0][]=$tabdonnees[0];
                                    $donnees[1][]=$tabdonnees[1];
                                    $donnees[2][]=$tabdonnees[2];
                        }

                        reset($stock);
                        $abscisses=array();
                        while(list($jour)=each($stock))
                        {
                                    $dt=explode("-",$jour);
                                    $jour=formater_date($dt,MY_LANG,"y");
                                    $abscisses[]=$jour;
                        }
                        // calcul de la moyenne pour le stagiaire
                        $notegrille=note_globale_grille($numcal,$stagiaire,$grille);
                        $notegrille *=100;
                        $notegrille=round($notegrille);
                        $notegrille /=100;
                        $couleurs[0] = array("009900", "0066CC", "000000", "000000", "EEEEEE", "FFFFFF");
                        $couleurs[1] = array("403015", "333333", "001530");
                        $couleurs[2] = array("FF0000", "FFA500", "00FF00");
                        $options = array(2, 2, 1, 1, 1, 2);
                        $legende = array("$MSG_975", "$MSG_976", "$MSG_974","$MSG_1211 : $notegrille / 20");

                        // titre du graphe
                        $titre="$MSG_226 : \"$nomgrille\" $MSG_2324 : \"$nomstagiaire $prenomstagiaire\"";
                        // nom du graph
                        $nomgraph="calgpgri_".$numcal."-".$groupe."-".$grille."-".$stagiaire.".png";

                        dessiner_graphique("histogramme", $titre, "d", 650, 200, 20, 20, $options, $donnees, $legende, $abscisses, $couleurs,$nomgraph);

            }
            else

                        $error="<span class=\"texte_alert\">$MSG_1217</span>";


}
else

            $error="<span class=\"texte_alert\">$MSG_2386</span>";

if(!empty($grille))
{
            print("
            <table class=\"texte_tab\" id=\"cadre\" width=\"100%\"cellpadding=\"2\" cellspacing=\"1\">
            <tr>
            <td class=\"case\" id=\"titre\">$MSG_635</td>
            <td class=\"case\" id=\"titre\">$MSG_682</td>
            <td class=\"case\" id=\"titre\">$MSG_17</td>
            <td class=\"case\" id=\"titre\">$MSG_226</td>
            <td class=\"case\" id=\"titre\">$MSG_2324</td>
            <td class=\"case\" id=\"titre\">$MSG_1215</td>
            </tr>
            <tr>
            <td class=\"presentiel\" id=\"ligne\">$nom_formation<br>$MSG_135 $debut $MSG_136 $fin</td>
            <td class=\"presentiel\" id=\"ligne\">$nom_groupe</td>
            <td class=\"presentiel\" id=\"ligne\">$nom_formateur</td>
            <td class=\"presentiel\" id=\"ligne\">$nomgrille</td>
            <td class=\"presentiel\" id=\"ligne\">
            <form name=\"formstag\">
            <select name=\"stagiaire\" onchange=\"validestagiaire();\" id=\"texte\">
            <option value=\"\">$MSG_2387</option>
            ");
            // recup des stagiaires (ds la table notation) pour cette formation
            $req="select num_user,nom,prenom from utilisateurs where num_user in (select num_user from notation where num_cal='$numcal')";
            $resuser=pg_exec($req);
            $nbuser=pg_numrows($resuser);
            for($s=0;$s<$nbuser;$s++)
            {
                        $rowuser=pg_fetch_row($resuser,$s);
                        if($rowuser[0]==$stagiaire)
                                    print("
                                    <option value=\"$rowuser[0]\" selected>$rowuser[2] $rowuser[1]</option>
                                    ");
                        else
                                    print("
                                    <option value=\"$rowuser[0]\">$rowuser[2] $rowuser[1]</option>
                                    ");
            }
            print("
            </select>
            <input type=hidden name=\"theme\" value=\"$theme\">
            <input type=hidden name=\"numcal\" value=\"$numcal\">
            <input type=hidden name=\"groupe\" value=\"$groupe\">
            <input type=hidden name=\"grille\" value=\"$grille\">
            <input type=hidden name=\"titrecapacite\" value=\"$titrecapacite\">
            <input type=hidden name=\"capacite\" value=\"$capacite\">
            </form>
            </td>

            ");
            // calcul des % de carton vert orange et rouge
            if($grille!="" && $stagiaire!="" && $nbdate>0)
            {
                        print("<td class=\"case\" id=\"ligne\">");
                        //recup des cartons rouge orange vert
                        $r=0;
                        $o=0;
                        $v=0;
                        $total_carton=0;
                        $tabrov=array();

                        for($j=0;$j<$nbdate;$j++)
                        {
                                    $tabrov=explode(",",$tabjournote[$j]);
                                    $r+=$tabrov[0];
                                    $o+=$tabrov[1];
                                    $v+=$tabrov[2];
                        }
                        $total_carton=$r+$o+$v;
                        $pourcent_rouge=$r/$total_carton;
                        $pourcent_rouge*=100;
                        $pourcent_rouge=round($pourcent_rouge);
                        $pourcent_orange=$o/$total_carton;
                        $pourcent_orange*=100;
                        $pourcent_orange=round($pourcent_orange);
                        $pourcent_vert=$v/$total_carton;
                        $pourcent_vert*=100;
                        $pourcent_vert=round($pourcent_vert);
                        print("
                        <table border=\"0\" cellspacing=\"0\" cellpadding=\"1\">
                        <tr>
                        <td>
                        <img width=20 height=20 src=\"../images/cartr.jpg\" >
                        <br><font size=2>$pourcent_rouge %</font>
                        </td>
                        <td>
                        <img width=20 height=20 src=\"../images/carto.jpg\" >
                        <br><font size=2>$pourcent_orange %</font>
                        </td>
                        <td>
                        <img width=20 height=20 src=\"../images/cartv.jpg\" >
                        <br><font size=2>$pourcent_vert %</font>
                        </td>
                        </tr>
                        </table>
                        </td>
                        </tr>
                        ");
            }
            print("
            </table>");
            if($stagiaire!="")
                        print("<img src=\"./cache-graphiques/$nomgraph\">\n");
}

/*---------------------------------------------------------------------------------------*/
//      Slection titrecapacit et capacit
/*---------------------------------------------------------------------------------------*/

if(!empty($stagiaire))
{
            print("
            <table class=\"texte_tab\" id=\"cadre\" width=\"100%\" cellpadding=\"2\" cellspacing=\"1\">
            <tr>
            <td class=\"case\" id=\"titre\">$MSG_219</td>
            <td class=\"case\" id=\"titre\">$MSG_220</td>
            </tr>
            <tr>
            <td class=\"presentiel\" id=\"ligne\">
            <form name=\"formtitre\">");
            if(!empty($stagiaire))
                        print("<select name=\"titrecapacite\" onchange=\"validetitre();\" id=\"texte\">");
            else
                        print("<select name=\"titrecapacite\" onchange=\"validetitre();\" id=\"texte\" disabled>");
            print("
            <option value=\"\">$MSG_846</option>
            ");
            // recup des titre de capacite pour cette formation,catte grille,ce stagiaire
            $req="select * from titrecapacite where num_titrecapacite in (select num_titrecapacite from comment_presentiel where num_cal='$numcal' and num_grille='$grille' and notesur <>'0')";
            $restitre=pg_exec($req);
            $nbtitre=pg_numrows($restitre);
            for($t=0;$t<$nbtitre;$t++)
            {
                        $rowtitre=pg_fetch_row($restitre,$t);
                        if($rowtitre[0]==$titrecapacite)
                                    print("
                                    <option value=\"$rowtitre[0]\" selected>$rowtitre[1]</option>
                                    ");
                        else
                                    print("
                                    <option value=\"$rowtitre[0]\">$rowtitre[1]</option>
                                    ");

            }
            print("
            </select>
            <input type=hidden name=\"theme\" value=\"$theme\">
            <input type=hidden name=\"numcal\" value=\"$numcal\">
            <input type=hidden name=\"groupe\" value=\"$groupe\">
            <input type=hidden name=\"grille\" value=\"$grille\">
            <input type=hidden name=\"stagiaire\" value=\"$stagiaire\">
            <input type=hidden name=\"nomstagiaire\" value=\"$nomstagiaire\">
            <input type=hidden name=\"prenomstagiaire\" value=\"$prenomstagiaire\">
            </form>
            </td>

            ");
            // selection capacite
            print("
            <td class=\"presentiel\" id=\"ligne\">
            <form name=\"formcapa\">
            ");
            if(!empty($titrecapacite))
                        print("<select name=\"capacite\" onchange=\"validecapacite();\" id=\"texte\">");
            else
                        print("<select name=\"capacite\" onchange=\"validecapacite();\" id=\"texte\" disabled>");
            print("
            <option value=\"\">$MSG_2344</option>
            ");
            // recup des titre de capacite pour cette formation,catte grille,ce stagiaire
            $req="select * from capacite where num_capacite in
            (select num_capacite from comment_presentiel where num_cal='$numcal' and num_grille='$grille'
            and num_titrecapacite='$titrecapacite' and notesur <>'0')";
            $restitre=pg_exec($req);
            $nbtitre=pg_numrows($restitre);
            for($t=0;$t<$nbtitre;$t++)
            {
            $rowtitre=pg_fetch_row($restitre,$t);
            if($rowtitre[0]==$capacite)
                        print("
                        <option value=\"$rowtitre[0]\" selected>$rowtitre[1]</option>
                        ");
            else
                        print("
                        <option value=\"$rowtitre[0]\">$rowtitre[1]</option>
                        ");

            }
            print("
            </select>
            <input type=hidden name=\"theme\" value=\"$theme\">
            <input type=hidden name=\"numcal\" value=\"$numcal\">
            <input type=hidden name=\"groupe\" value=\"$groupe\">
            <input type=hidden name=\"grille\" value=\"$grille\">
            <input type=hidden name=\"stagiaire\" value=\"$stagiaire\">
            <input type=hidden name=\"titrecapacite\" value=\"$titrecapacite\">
            </form>
            </td>
            </tr>
            </table>");
}

/*---------------------------------------------------------------------------------------*/
//      Prparation des donnes et Affichage du graphe linaire
//      Stat par capacit pour le groupe
/*---------------------------------------------------------------------------------------*/
if($titrecapacite!="")
{
            if($capacite!="")
            {

                        print("
                        <table class=\"texte_tab\" id=\"cadre\" width=\"100%\" cellpadding=\"2\" cellspacing=\"1\">
                        <tr>
                        <td class=\"case\" id=\"titre\">$MSG_635</td>
                        <td class=\"case\" id=\"titre\">$MSG_682</td>
                        <td class=\"case\" id=\"titre\">$MSG_17</td>
                        <td class=\"case\" id=\"titre\">$MSG_226</td>
                        <td class=\"case\" id=\"titre\">$MSG_1215</td>
                        </tr>
                        <tr>
                        <td class=\"presentiel\" id=\"ligne\">$nom_formation<br>du $debut au $fin</td>
                        <td class=\"presentiel\" id=\"ligne\">$nom_groupe</td>
                        <td class=\"presentiel\" id=\"ligne\">$nom_formateur</td>
                        <td class=\"presentiel\" id=\"ligne\">$nomgrille</td>
                        <td class=\"presentiel\" id=\"ligne\">
                        ");
                        // recup des cartons pour la capacite pour le groupe
                        $req="select notation
                        from notation
                        where num_cal='$numcal'
                        and num_grille='$grille'
                        and num_titrecapacite='$titrecapacite'
                        and num_capacite='$capacite'";
                        $resnotation=pg_exec($req);
                        $nbnotation=pg_numrows($resnotation);
                        if($nbnotation>0)
                        {
                                    $r=0;
                                    $o=0;
                                    $v=0;
                                    $total_carton=0;

                                    for($n=0;$n<$nbnotation;$n++)
                                    {
                                                $tabrov=array();
                                                $rownotation=pg_fetch_row($resnotation,$n);
                                                $tabrov=explode(",",$rownotation[0]);
                                                $sz=sizeof($tabrov);
                                                for($s=0;$s<$sz;$s++)
                                                {
                                                            switch($tabrov[$s])
                                                            {
                                                            case 1 : $r+=1;
                                                            break;
                                                            case 2 : $o+=1;
                                                            break;
                                                            case 3 : $v+=1;
                                                            break;
                                                            }
                                                }
                                    }
                                    $total_carton=$r+$o+$v;
                                    $pourcent_rouge=$r/$total_carton;
                                    $pourcent_rouge*=100;
                                    $pourcent_rouge=round($pourcent_rouge);
                                    $pourcent_orange=$o/$total_carton;
                                    $pourcent_orange*=100;
                                    $pourcent_orange=round($pourcent_orange);
                                    $pourcent_vert=$v/$total_carton;
                                    $pourcent_vert*=100;
                                    $pourcent_vert=round($pourcent_vert);
                                    print("
                                    <table align=\"center\" cellspacing=\"0\" cellpadding=\"1\">
                                    <tr>
                                    <td>
                                    <img width=20 height=20 src=\"../images/cartr.jpg\">
                                    <br><font size=2>$pourcent_rouge %</font>
                                    </td>
                                    <td>
                                    <img width=20 height=20 src=\"../images/carto.jpg\">
                                    <br><font size=2>$pourcent_orange %</font>
                                    </td>
                                    <td>
                                    <img width=20 height=20 src=\"../images/cartv.jpg\">
                                    <br><font size=2>$pourcent_vert %</font>
                                    </td>
                                    </tr>
                                    </table>

                                    ");
                                    print("
                                    &nbsp;
                                    </td>
                                    </tr>
                                    </table>");
                        }

                        if($nbdate>0)
                        {
                                    // recup des dates et notes du groupe
                                    $req="select num_date,note,notesur from comment_presentiel where num_cal='$numcal'
                                    and num_grille='$grille'
                                    and num_titrecapacite='$titrecapacite'
                                    and num_capacite='$capacite'
                                    and notesur<>'0' order by num_date";
                                    $resnote=pg_exec($req);
                                    $nbnote=pg_numrows($resnote);

                                    // stockage
                                    $tab=array();
                                    for($i=0;$i<$nbnote;$i++)
                                    {
                                                $rownote=pg_fetch_row($resnote,$i);
                                                //ramne la note sur 20
                                                $note=($rownote[1]*20)/$rownote[2];
                                                //arrondi
                                                $note*=100;
                                                $note=round($note);
                                                $note/=100;

                                                $ind=$rownote[0];

                                                $tab["$ind"][]=$note;

                                    }
                                    ksort($tab);
                                    // moyenne par date
                                    $tabmoy=array();
                                    $points=array();
                                    $points[0]=0;
                                    $couleur_ligne=array();
                                    $couleur_ligne[]=0;

                                    reset($tab);
                                    while(list($cle,$val)=each($tab))
                                    {
                                                $sz=sizeof($tab["$cle"]);
                                                $moyenne=(array_sum($tab["$cle"]))/$sz;

                                                // on arrondi la moyenne
                                                $moyenne*=100;
                                                $moyenne=round($moyenne);
                                                $moyenne/=100;
                                                $tabmoy[]=$moyenne;
                                                $ind=$cle+1;
                                                $points[$ind]=$moyenne;
                                                // association des couleurs en fonction de la moyenne

                                                if($moyenne>=15)
                                                            $couleur_ligne[$ind]=2; //vert
                                                else
                                                            if($moyenne<=10)
                                                                        $couleur_ligne[$ind]=0; // rouge
                                                            else
                                                                        $couleur_ligne[$ind]=1; // orange
                                    }

                                    reset($points);
                                    $nomFic="calgpcapa_".$numcal."-".$groupe."-".$grille."-".$titrecapacite."-".$capacite.".png";
                                    //recup du nom de la capacite
                                    $req="select libelle_capacite from capacite where num_capacite='$capacite'";
                                    $rescapa=pg_exec($req);
                                    $rowcapa=pg_fetch_row($rescapa,0);
                                    $titre="Grille : \"$nomgrille\"  -  $MSG_220 : \"$rowcapa[0] \"  -  $MSG_682 : $nom_groupe";
                                    $largeur=650;
                                    $tabLegende=array();

                                    $moyenne_capa=note_globale_capacite($numcal,"",$grille,$titrecapacite,$capacite);
                                    if($moyenne_capa>=0){
                                                $moyenne_capa*=100;
                                                $moyenne_capa=round($moyenne_capa);
                                                $moyenne_capa/=100;
                                                $tabLegende[]="$MSG_1211 : $moyenne_capa / 20";
                                    }
                                    else
                                                $tabLegende[]="$MSG_1211 : $MSG_1218";

                                    include('./librairies/Graph.php3');
                                    print("<img src=\"./cache-graphiques/$nomFic\" border=\"1\">\n");
                        }
                        else
                                    print("<span class=\"texte_alert\">$MSG_1219</span>");


            }
            else
                        print("<span class=\"texte_alert\">$MSG_2344</span>");

}
else
{
        if($grille!="" && $stagiaire!="")
            print("<span class=\"texte_alert\">Choisissez un titre de capacit</span>");
}

if($stagiaire!="" && $capacite!="" )
{
            if( $nbdate>0)
            {

                        // recup des dates et notes du stagiaire pour la capacite
                        $req="select num_date,note,notesur
                        from comment_presentiel
                        where num_cal='$numcal'
                        and num_grille='$grille'
                        and num_user='$stagiaire'
                        and num_titrecapacite='$titrecapacite'
                        and num_capacite='$capacite'
                        and notesur<>'0'
                        order by num_date";
                        $resnote=pg_exec($req);
                        $nbnote=pg_numrows($resnote);

                        // stockage
                        $tab=array();

                        for($i=0;$i<$nbnote;$i++)
                        {
                                    $rownote=pg_fetch_row($resnote,$i);
                                    //ramne la note sur 20
                                    $note=($rownote[1]*20)/$rownote[2];
                                    //arrondi
                                    $note*=100;
                                    $note=round($note);
                                    $note/=100;
                                    $ind=$rownote[0];
                                    $tab[$ind]=$note;

                        }
                        ksort($tab);
                        // moyenne par date
                        $tabmoy=array();
                        $points=array();
                        $points[0]=0;
                        $couleur_ligne=array();
                        $couleur_ligne[]=0;

                        reset($tab);
                        while(list($cle,$val)=each($tab))
                        {
                                    $sz=sizeof($tab["$cle"]);
                                    $moyenne=$val;
                                    // on arrondi la moyenne
                                    $moyenne*=100;
                                    $moyenne=round($moyenne);
                                    $moyenne/=100;
                                    $tabmoy[]=$moyenne;
                                    $ind=$cle+1;

                                    $points[$ind]=$moyenne;
                                    // association des couleurs en fonction de la moyenne

                                    if($moyenne>=15)
                                    $couleur_ligne[$ind]=2; //vert
                                    else
                                    if($moyenne<=10)
                                                $couleur_ligne[$ind]=0; // rouge
                                    else
                                                $couleur_ligne[$ind]=1; // orange
                        }

                        reset($points);
                        //essai affichage
                        $nomFic="calgpcapa_".$numcal."-".$groupe."-".$grille."-".$titrecapacite."-".$capacite."-".$stagiaire.".png";
                        //recup du nom de la capacite
                        $req="select libelle_capacite from capacite where num_capacite='$capacite'";
                        $rescapa=pg_exec($req);
                        $rowcapa=pg_fetch_row($rescapa,0);
                        $titre="$MSG_226 : \"$nomgrille\"  -  $MSG_220 : \"$rowcapa[0] \"  -  $MSG_2324 : $nomstagiaire $prenomstagiaire";
                        $largeur=650;
                        $tabLegende=array();
                        $moyenne_capa=note_globale_capacite($numcal,$stagiaire,$grille,$titrecapacite,$capacite);
                        if($moyenne_capa>=0)
                        {
                                    $moyenne_capa*=100;
                                    $moyenne_capa=round($moyenne_capa);
                                    $moyenne_capa/=100;
                                    $tabLegende[]="$MSG_1211 : $moyenne_capa / 20";
                        }
                        else
                                    $tabLegende[]="$MSG_1211 : $MSG_1218";
                        include('./librairies/Graph.php3');


                        print("
                        <table class=\"texte_tab\" id=\"cadre\" width=\"100%\" cellpadding=\"2\" cellspacing=\"1\">
                        <tr>
                        <td class=\"case\" id=\"titre\">$MSG_635</td>
                        <td class=\"case\" id=\"titre\">$MSG_682</td>
                        <td class=\"case\" id=\"titre\">$MSG_17</td>
                        <td class=\"case\" id=\"titre\">$MSG_226</td>
                        <td class=\"case\" id=\"titre\">$MSG_2324</td>
                        <td class=\"case\" id=\"titre\">$MSG_1215</td>
                        </tr>
                        <tr>
                        <td class=\"presentiel\" id=\"ligne\">$nom_formation<br>du $debut au $fin</td>
                        <td class=\"presentiel\" id=\"ligne\">$nom_groupe</td>
                        <td class=\"presentiel\" id=\"ligne\">$nom_formateur</td>
                        <td class=\"presentiel\" id=\"ligne\">$nomgrille</td>
                        <td class=\"presentiel\" id=\"ligne\">$prenomstagiaire $nomstagiaire</td>

                        ");

                        // recup des cartons pour la capa pour le stagiaire
                        $req="select notation
                        from notation
                        where num_cal='$numcal'
                        and num_grille='$grille'
                        and num_user='$stagiaire'
                        and num_titrecapacite='$titrecapacite'
                        and num_capacite='$capacite'";
                        $resnotation=pg_exec($req);
                        $nbnotation=pg_numrows($resnotation);
                        if($nbnotation>0)
                        {
                                    $r=0;
                                    $o=0;
                                    $v=0;
                                    $total_carton=0;

                                    for($n=0;$n<$nbnotation;$n++)
                                    {
                                                $tabrov=array();
                                                $rownotation=pg_fetch_row($resnotation,$n);
                                                $tabrov=explode(",",$rownotation[0]);
                                                $sz=sizeof($tabrov);
                                                for($s=0;$s<$sz;$s++)
                                                {
                                                            switch($tabrov[$s])
                                                            {
                                                                        case 1 : $r+=1;
                                                                        break;
                                                                        case 2 : $o+=1;
                                                                        break;
                                                                        case 3 : $v+=1;
                                                                        break;
                                                            }
                                                }
                                    }
                                    $total_carton=$r+$o+$v;
                                    $pourcent_rouge=$r/$total_carton;
                                    $pourcent_rouge*=100;
                                    $pourcent_rouge=round($pourcent_rouge);
                                    $pourcent_orange=$o/$total_carton;
                                    $pourcent_orange*=100;
                                    $pourcent_orange=round($pourcent_orange);
                                    $pourcent_vert=$v/$total_carton;
                                    $pourcent_vert*=100;
                                    $pourcent_vert=round($pourcent_vert);
                                    print("
                                    <td class=\"presentiel\" id=\"ligne\">
                                    <table border=\"0\" cellspacing=\"0\" cellpadding=\"1\">
                                    <tr>
                                    <td>
                                    <img width=20 height=20 src=\"../images/cartr.jpg\" >
                                    <br><font size=2>$pourcent_rouge %</font>
                                    </td>
                                    <td>
                                    <img width=20 height=20 src=\"../images/carto.jpg\" >
                                    <br><font size=2>$pourcent_orange %</font>
                                    </td>
                                    <td>
                                    <img width=20 height=20 src=\"../images/cartv.jpg\" >
                                    <br><font size=2>$pourcent_vert %</font>
                                    </td>
                                    </tr>
                                    </table>
                                    </td>
                                    </tr>
                                    </table>
                                    <img src=\"./cache-graphiques/$nomFic\" border=\"1\">");

            }
}

print("</table>");


}       // FIN IF($GRILLE!="")
print("
<br>");
if(!empty($theme))
            print("
            <b>[<a href=\"../classement/suivi_presentiel.php?type=theme&theme=$theme\">$MSG_37</a>]</b>");
else
{
            if($type=="form_old")
                        $type="form_old";
            elseif($type=="form_current")
                        $type="form_current";
            print("<b>[<a href=\"../classement/suivi_presentiel.php?type=$type\"><font size=2 color=\"#000000\">$MSG_37</font></a>]</b>");
}

require('../piedpage.php3');
?>
