<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


//Script qui trace un graph
//les paramtres  passer :
// $largeur, $hauteur et un tableau de $points et le titre ($titre)
//ainsi ke $nomFic
//echo "nom_fic dans Graph.php3=$nomFic<br>";
if(!(isset($largeur))){
  $largeur=1000;
}

if(!(isset($hauteur))){
  $hauteur=300;
}

if(!(isset($points))){
  srand((float) microtime()*1000000);
  for($i=0;$i<10;$i++){
    $nb = rand(0,20);
    $points[$i]=($nb);
  }
}

if(!isset($margex))
     $margex=250;
$margey=40;


// /*****************Modif *********************/
// while(list($id,$val)=each($points)){
//   $points[$id] = $val *10;
// }
// reset($points);
// $largeur *= 10;
// $hauteur *= 10;
// $margex *= 10;
// $margey *= 10;
// /*************** Fin modif *****************/

$image = imagecreate($largeur,$hauteur);

$maroon = ImageColorAllocate($image,100,0,0);
$white = ImageColorAllocate($image,255,255,255);
$red = ImageColorAllocate($image,255,0,0);
$blue = ImageColorAllocate($image,0,0,255);
$grey = ImageColorAllocate($image,200,200,200);
$black = ImageColorAllocate($image,0,0,0);
$green = ImageColorAllocate($image,0,128,0);
$orange = ImageColorAllocate($image,255,165,0);

if(!isset($Cbackground)){
  $background=ImageColorAllocate($image,255,255,255);;
}
else{
  $background=ImageColorAllocate($image,$Cbackground[0],
				 $Cbackground[1],
				 $Cbackground[2]);
}

ImageFilledRectangle($image,0,0,$largeur,$hauteur,$background);
ImageFilledRectangle($image,0,$margey,$largeur-$margex,$hauteur-$margey,$grey);
//ImageFilledRectangle($image,0,$margey,$largeur-$margex,$hauteur-$margey,$orange);

//Tracage de la grille
$taillefont=2;
$nb_separation=10;
$haut = ($hauteur-(2*$margey)) / ($nb_separation);

//axe vertical
//imageLine($image,40,$hauteur-$margey,40,0+$margey,$maroon);
imageLine($image,40,$hauteur-$margey,40,0+$margey,$green);

for($i=0;$i<=($nb_separation);$i++){

  $ypos=$margey + $hauteur - (int)($i*$haut);
  $ypos=$ypos-(2*$margey);

  if($i != ($nb_separation /2)){
    //Dans le cas d'un graph multi ligne, on ne trace pas
    //tous les reperes horizontaux (trop fouilli sinon)
    if(!isset($tabNoteExo))
      ImageLine($image,0+40, $ypos,$largeur-$margex,
		$ypos,$maroon);
  }
  else
    ImageLine($image,0+40, $ypos,$largeur-$margex,
	      $ypos,$red);

  $valeur=(20/$nb_separation)*$i;
  $valeur=$valeur*100;
  $valeur=round($valeur);
  $valeur=$valeur/100;
  $center=imagefontwidth($taillefont) * strlen($valeur);
  $center = (int)($margex - $center);
  imagestring($image, $taillefont,0,$ypos-(imagefontheight($taillefont)/2) , $valeur , $maroon);
}


$largeur_grille=$largeur-$margex-40;
$largeur_col=$largeur_grille/(sizeof($points));//+((2*sizeof($points))*$espace_col);

//cacul de l'chelle
$echelle=(($hauteur-(2*$margey))/20);
$tc=5; //tc = taille de la croix;

$point1=array();
$point2=array();
//on dessine les lignes
for($i=0;$i<sizeof($points);$i++){
  $point2[0]=($i*$largeur_col+40);
  $point2[1]=(($hauteur-$margey) - ($points[$i] * $echelle));
  if($i != 0){
    //Si il s'agit de multiligne, on trace la moyenne en pointill
    if(isset($tabNoteExo))
      imageDashedLine($image,$point1[0],$point1[1],$point2[0],$point2[1],$blue);
    else
      imageLine($image,$point1[0],$point1[1],$point2[0],$point2[1],$blue);
  }

  imageLine($image,$point2[0]-$tc/2,$point2[1]-$tc/2,$point2[0]+$tc/2,$point2[1]+$tc/2,$red);
  imageLine($image,$point2[0]-$tc/2,$point2[1]+$tc/2,$point2[0]+$tc/2,$point2[1]-$tc/2,$red);

  //label des colonnes
  $taille_label=imagefontwidth($taillefont) * strlen($i+1);
  imagestring($image,$taillefont,($largeur_col*$i)+40+$espace_col,$hauteur-($margey),$i+1,$black);

  imagestring($image,$taillefont,($largeur_col*$i)+40+$espace_col-(imagefontwidth($taillefont)/2),$point2[1]-15,$points[$i],$red);

  $point1[0]=$point2[0];
  $point1[1]=$point2[1];
}

$titlefont = 5;

$txtsz = imagefontwidth($titlefont) * strlen($titre);

$xpos = (int)(($largeur -$margex- $txtsz)/2); // center the title
$xpos = max(1, $xpos); // force positive coordinates
$ypos = $margey/3; // distance from top
imagestring($image, $titlefont, $xpos, $ypos, $titre , $black);

//legende
if(!isset($tabLegende)){
  $tabLegende=array("legende 1","legende 2","legende 3","legende 4","legende 5","legende 6","legende 7","legende 8","legende 9","legende 10");
}
$margeLegende = 10;
$espace=30;
//on cherche la legende la plus longue
$chaine_la_plus_longue=0;
while(list($id,$chaine)=each($tabLegende)){
  if((imagefontwidth($taillefont) * strlen($chaine)) > $chaine_la_plus_longue)
    $chaine_la_plus_longue = (imagefontwidth($taillefont) * strlen($chaine));
}

//on affiche la legende
if(! isset($tabLegende2)){
  reset($tabLegende);
  while(list($id,$chaine)=each($tabLegende)){
    $num_leg=$id+1;
    imagestring($image,
		$taillefont,
		/*$largeur - $chaine_la_plus_longue, */
		($largeur-$margex)+$espace,
		$margey + $id*$margeLegende,
		"$num_leg : " . "$chaine" ,
		$black);
    $tmp=$id;
  }
}

/*********** Multi Ligne *********************/



$taille_echantillon=10;
if(isset($tabNoteExo)){

  //Correspondance entre le numero d'utilisateur et une couleur
  $tabLegendeCouleur=array();
  $indice=0;
  while(list($exo,$tabUser)=each($tabNoteExo)){
    $tabLegendeCouleur[$exo]=$indice;
    $indice++;
  }



  $espace_leg1_leg2=($tmp+2)*$margeLegende;
  //Legende des lignes

  //la moyenne
  imagedashedLine($image,
	    ($largeur-$margex)+$espace-$taille_echantillon,
	    $margey + $margeLegende/2+ $espace_leg1_leg2+$eppaisseur_ligne,
	    ($largeur-$margex)+$espace,
	    $margey + $margeLegende/2+ $espace_leg1_leg2+$eppaisseur_ligne,
	    $blue);

  imagestring($image,
	      $taillefont,
	      /*$largeur - $chaine_la_plus_longue, */
	      ($largeur-$margex)+$espace,
	      $margey + /*$margeLegende*/+ $espace_leg1_leg2,
	      " Moyenne" ,
	      $black);


  reset($tabLegende2);
  while(list($id,$chaine)=each($tabLegende2)){
    $eppaisseur_ligne=imagefontwidth($taillefont);
    //print("$eppaisseur_ligne <br>");
    if($id > 0){
      $coul=ajouter_hexcouleur($image, $tabCouleurLigne[$id-1]);
      imageLine($image,
		($largeur-$margex)+$espace-$taille_echantillon,
		$margey + $id*$margeLegende+ $espace_leg1_leg2+$eppaisseur_ligne,
		($largeur-$margex)+$espace,
		$margey + $id*$margeLegende+ $espace_leg1_leg2+$eppaisseur_ligne,
		$coul);

      imagestring($image,
		  $taillefont,
		  /*$largeur - $chaine_la_plus_longue, */
		  ($largeur-$margex)+$espace,
		  $margey + $id*$margeLegende+ $espace_leg1_leg2,
		  " $chaine" ,
		  $black);
    }
  }


  reset($tabNoteExo);
  while(list($exo,$tabUser)=each($tabNoteExo)){
    //on dessine les lignes
    for($i=0;$i<sizeof($tabUser);$i++){
      if(! in_array(-1,$tabUser)){
	$point2[0]=($i*$largeur_col+40);
	$point2[1]=(($hauteur-$margey) - ($tabUser[$i] * $echelle));
	if($i != 0){
	  $coul=ajouter_hexcouleur($image, $tabCouleurLigne[$tabLegendeCouleur[$exo]]);
	  //$coul=ajouter_hexcouleur($image, $couleurs[1][round($exo%10)]);
	  imageLine($image,$point1[0],$point1[1],$point2[0],$point2[1],$coul);
	}

	//label des colonnes
	$taille_label=imagefontwidth($taillefont) * strlen($i+1);
	imagestring($image,$taillefont,($largeur_col*$i)+40+$espace_col,$hauteur-($margey),$i+1,$black);

	//imagestring($image,$taillefont,($largeur_col*$i)+40+$espace_col-(imagefontwidth($taillefont)/2),$point2[1]-15,$points[$i],$red);

	$point1[0]=$point2[0];
	$point1[1]=$point2[1];
      }else{
	$i=sizeof($tabUser);
      }
    }
  }
}
/*********** Fin Multi Ligne *********************/

//Titre
if(!(isset($titre))){
  $titre="Titre du Graph";
}
else{
  $titre=ereg_replace("_"," ",$titre);
  $titre=ereg_replace("'","",$titre);
  $titre=ereg_replace("@","'",$titre);
}

//echo "bo=$serverback<br>";
ImagePNG($image,"cache-graphiques/$nomFic");
ImageDestroy($image);

?>