<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

define('FPDF_FONTPATH',"./fpdf/font/");
require("./fpdf/fpdf.php");
require("./fpdf/pdf_Afide.php");
require('../../dbpostgres.php3');

// connexion  la base
$db = pg_Connect("$server", "", "", "", "$nombase");
/********************************* fonctions php**********************************************/
// fonction qui recherche la srie passe en paramtres qui contiennent que des sondages
function rechSondage($id_serie)
{
            // recup des tapes de la srie
            $test_alea="select num_serie from serie_aleatoire where num_serie='$id_serie'";
            $res_test_alea=pg_query($test_alea);

            if(pg_numrows($res_test_alea) > 0)
                        $aleatoire="asso_exo_serie_aleatoire";
            else $aleatoire="asso_exo_serie";

            $test_sondage="select distinct type_exo from $aleatoire where id_serie='$id_serie'";

            $res_test_sondage=pg_query($test_sondage);
            if(pg_numrows($res_test_sondage)==1 && pg_result($res_test_sondage,0)=='s')
                        $sondage=1;
            else
                        $sondage=0;

            return($sondage);
}

function MoySerieForm($res_liste_series_form,$nb_series_form)
{
            $somme=0;
            $cpt=0;
            for($i=0;$i<$nb_series_form;$i++)
            {
                        if(rechSondage(pg_result($res_liste_series_form,$i,0))==0)
                        {
                                     $somme+=pg_result($res_liste_series_form,$i,1);
                                     $cpt++;
                        }
            }
            return(round($somme/$cpt,2));
}

function MoyExosForm($res_liste_exos_form,$nb_exos_form)
{
            $somme=0;
            for($i=0;$i<$nb_exos_form;$i++)
            {
                        $rapport=pg_result($res_liste_exos_form,$i,1)/pg_result($res_liste_exos_form,$i,2);
                        $note20=$rapport*20;
                        $somme+=$note20;

            }
            return(round($somme/$nb_exos_form,2));
}

function calculeMoyTypeSerie($form,$tab)
{
            $nb_serie=sizeof($tab);
            $moyenne=0;

            for($i=0;$i<$nb_serie;$i++)
            {
                        $req="select score
                                    from res_serie
                                    where id_formation='$form'
                                    and id_serie='$tab[$i]'
                                    and score>=0";
                        $res=pg_query($req);
                        $nb_note=pg_num_rows($res);
                        $note=0;
                        for($j=0;$j<$nb_note;$j++)
                                    $note+=pg_result($res,$j,0);
                        $moyenne+=$note/$nb_note;
            }

            return(round($moyenne/$nb_serie,2));

}

function calculeMoyTypeExo($form,$tab)
{
            $nb_exo=sizeof($tab);
            $moyenne=0;
            for($i=0;$i<$nb_exo;$i++)
            {
                        $req="select score,surtotal
                        from resexouser
                        where num_cal='$form'
                        and num_exo='$tab[$i]'
                        and surtotal <>0";

                        $res=pg_query($req);
                        $nb_note=pg_num_rows($res);
                        $note=0;
                        for($j=0;$j<$nb_note;$j++)
                                    $note += (pg_result($res,$j,0)/pg_result($res,$j,1))*20;
                        $moyenne+=$note/$nb_note;
            }
            return(round($moyenne/$nb_exo,2));
}


function dispatchSerie($res,$nb,$tabMulti,$tabBlanc,$tabSondage,$tabQCM,$tabAleatMono,$tabAleatMulti,$titreSerie,$form)
{
            for($i=0;$i<$nb;$i++)
            {
                        $num_serie=pg_result($res,$i,0);

                        $test_aleatoire="select mode from serie_aleatoire where num_serie='$num_serie'";
                        $res_test_aleatoire=pg_query($test_aleatoire);
                        $nb_rows=pg_num_rows($res_test_aleatoire);
                        if($nb_rows>0) $table="asso_exo_serie_aleatoire";
                        else $table="asso_exo_serie";
                        $type_serie="select distinct type_exo
                                                from $table
                                                where id_serie='$num_serie'";
                        $res_type_serie=pg_query($type_serie);
                        if(pg_num_rows($res_type_serie)>1)
                        {
                                    if($nb_rows>0)
                                    {
                                                if(pg_result($res_test_aleatoire,0) == 1)$tabAleatMono[]=$num_serie;
                                                else     $tabAleatMulti[]=$num_serie;
                                    }
                                    else $tabMulti[]=$num_serie;
                        }
                        else
                        {
                                    $type=pg_result($res_type_serie,0);
                                    switch ($type)
                                    {
                                                case 's' : $tabSondage[]=$num_serie;
                                                            break;
                                                case 'f' : $tabBlanc[]=$num_serie;
                                                            break;
                                                case 'q' : $tabQCM[]=$num_serie;
                                                            break;
                                   }
                        }
            }

            if(sizeof($tabMulti)>0)
            {
                        $titreSerie[0][0]="m-Sries multi-exercices";
                        $titreSerie[0][1]=calculeMoyTypeSerie($form,$tabMulti)."/20";
                        $titreSerie[0][2]="../images/icoserie.png";
            }
            if(sizeof($tabBlanc)>0)
            {
                        $titreSerie[1][0]="f-Sries de \"Remplir les blancs\"";
                        $titreSerie[1][1]=calculeMoyTypeSerie($form,$tabBlanc)."/20";
                        $titreSerie[1][2]="../images/icoremplir.png";
            }
            if(sizeof($tabSondage)>0)
            {
                        $titreSerie[2][0]="s-Sries de sondage";
                        $titreSerie[2][1]="X";
                        $titreSerie[2][2]="../images/icosonde.png";
            }
            if(sizeof($tabQCM)>0)
            {
                        $titreSerie[3][0]="q-Sries de QCM";
                        $titreSerie[3][1]=calculeMoyTypeSerie($form,$tabQCM)."/20";
                        $titreSerie[3][2]="../images/icoqcm.png";
            }
            if(sizeof($tabAleatMono)>0)
            {
                        $titreSerie[4][0]="a-Sries Alatoires Mono-thme";
                        $titreSerie[4][1]=calculeMoyTypeSerie($form,$tabAleatMono)."/20";
                        $titreSerie[4][2]="../images/icoserie.png";
            }
            if(sizeof($tabAleatMulti)>0)
            {
                        $titreSerie[5][0]="A-Sries Alatoires Multi_thme";
                        $titreSerie[5][1]=calculeMoyTypeSerie($form,$tabAleatMulti)."/20";
                        $titreSerie[5][2]="../images/icoserie.png";
            }

}
function dispatchExo($res_liste_exos_form,$nb_exos_form,$tabPF,$tabMail,$titreExo,$form)
{
            for($i=0;$i<$nb_exos_form;$i++)
            {
                        $num_exo=pg_result($res_liste_exos_form,$i,0);
                        $type_exo="select mode_rendu
                                                from exotlc
                                                where num_exo='$num_exo'";
                        $res_type_exo=pg_query($type_exo);
                        $mode=pg_result($res_type_exo,0,0);
                        if($mode=='m'|| empty($mode)) $tabMail[]=$num_exo;
                        else $tabPF[]=$num_exo;

            }

            if(sizeof($tabPF)>0)
            {
                        $titreExo[0][0]="pf-Exercices de type \"plate-forme\"";
                        $titreExo[0][1]=calculeMoyTypeExo($form,$tabPF)."/20";
                        $titreExo[0][2]="../images/icotlc.png";
            }

            if(sizeof($tabMail)>0)
            {
                        $titreExo[1][0]="ma-Exercices de type \"Mail\"";
                        $titreExo[1][1]=calculeMoyTypeExo($form,$tabMail)."/20";
                        $titreExo[1][2]="../images/icotlc.png";
            }
}
function calculeMoySeries($form,$nom_cal,$type,$tabResult)
{
            switch($type)
            {
                        case 'f':
                                    $liste="select r.id_serie,titre
                                                            from serie_exo,res_serie r,asso_exo_serie a
                                                            where id_formation='$form'
                                                            and type_exo='f'
                                                            and score>=0
                                                            and date_fin>0
                                                            and a.id_serie IN (select id_serie
                                                                                                from asso_exo_serie
                                                                                                group by id_serie
                                                                                                having count(distinct type_exo)=1)
                                                            and r.id_serie=id
                                                            and id=a.id_serie
                                                            group by r.id_serie, titre,score";
                                    $res=pg_query($liste);
                                    $nb=pg_num_rows($res);

                                    for($i=0;$i<$nb;$i++)
                                    {
                                                $nb_user="select count(distinct id_stag)
                                                                        from res_serie
                                                                        where id_serie='".pg_result($res,$i,0)."'
                                                                        and id_formation='$form'
                                                                        and score>=0";
                                                $res_nb_user=pg_query($nb_user);
                                                $moy_serie="select avg(score)
                                                                        from res_serie
                                                                        where id_serie='".pg_result($res,$i,0)."'
                                                                        and id_formation='$form'
                                                                        and score>=0";
                                                $res_moy_serie=pg_query($moy_serie);

                                                $tabResult[$i][0]=pg_result($res,$i,1);
                                                $tabResult[$i][1]=round(pg_result($res_moy_serie,0,0),2)."/20";
                                                $tabResult[$i][2]=pg_result($res_nb_user,0,0);
                                                $tabResult[$i][3]=pg_result($res,$i,0);

                                    }
                                    break;

                        case 'q':
                                    $liste="select r.id_serie,titre
                                                            from serie_exo,res_serie r,asso_exo_serie a
                                                            where id_formation='$form'
                                                            and type_exo='q'
                                                            and score>=0
                                                            and date_fin>0
                                                            and a.id_serie IN (select id_serie
                                                                                                from asso_exo_serie
                                                                                                group by id_serie
                                                                                                having count(distinct type_exo)=1)
                                                            and r.id_serie=id
                                                            and id=a.id_serie
                                                            group by r.id_serie, titre,score";
                                    $res=pg_query($liste);
                                    $nb=pg_num_rows($res);

                                    for($i=0;$i<$nb;$i++)
                                    {
                                                $nb_user="select count(distinct id_stag)
                                                                        from res_serie
                                                                        where id_serie='".pg_result($res,$i,0)."'
                                                                        and id_formation='$form'
                                                                        and score>=0";
                                                $res_nb_user=pg_query($nb_user);
                                                $moy_serie="select avg(score)
                                                                        from res_serie
                                                                        where id_serie='".pg_result($res,$i,0)."'
                                                                        and id_formation='$form'
                                                                        and score>=0";
                                                $res_moy_serie=pg_query($moy_serie);

                                                $tabResult[$i][0]=pg_result($res,$i,1);
                                                $tabResult[$i][1]=round(pg_result($res_moy_serie,0,0),2)."/20";
                                                $tabResult[$i][2]=pg_result($res_nb_user,0,0);
                                                $tabResult[$i][3]=pg_result($res,$i,0);
                                    }
                                    break;

                        case 's':
                                    $liste="select r.id_serie,titre
                                                            from serie_exo,res_serie r,asso_exo_serie a
                                                            where id_formation='$form'
                                                            and type_exo='s'
                                                            and date_fin>0
                                                            and a.id_serie IN (select id_serie
                                                                                                from asso_exo_serie
                                                                                                group by id_serie
                                                                                                having count(distinct type_exo)=1)
                                                            and r.id_serie=id
                                                            and id=a.id_serie
                                                            group by r.id_serie, titre,score";

                                    $res=pg_query($liste);
                                    $nb=pg_num_rows($res);

                                    for($i=0;$i<$nb;$i++)
                                    {
                                                $nb_user="select count(distinct id_stag)
                                                                        from res_serie
                                                                        where id_serie='".pg_result($res,$i,0)."'
                                                                        and id_formation='$form'
                                                                        and score>=0";
                                                $res_nb_user=pg_query($nb_user);


                                                $tabResult[$i][0]=pg_result($res,$i,1);
                                                $tabResult[$i][1]="X";
                                                $tabResult[$i][2]=pg_result($res_nb_user,0,0);
                                                $tabResult[$i][3]=pg_result($res,$i,0);
                                    }
                                    break;

                        case 'm':
                                    $liste="select id_serie,titre
                                                            from serie_exo,res_serie
                                                            where  id_formation='$form'
                                                            and score>=0
                                                            and date_fin>0
                                                            and id_serie IN (select id_serie
                                                                                                from asso_exo_serie
                                                                                                group by id_serie
                                                                                                having count(distinct type_exo)>1)

                                                            and id=id_serie
                                                            group by id_serie,titre";
                                    $res=pg_query($liste);
                                    $nb=pg_num_rows($res);

                                    for($i=0;$i<$nb;$i++)
                                    {
                                                $nb_user="select count(distinct id_stag)
                                                                        from res_serie
                                                                        where id_serie='".pg_result($res,$i,0)."'
                                                                        and id_formation='$form'
                                                                        and score>=0";
                                                $res_nb_user=pg_query($nb_user);
                                                $moy_serie="select avg(score)
                                                                        from res_serie
                                                                        where id_serie='".pg_result($res,$i,0)."'
                                                                        and id_formation='$form'
                                                                        and score>=0";
                                                $res_moy_serie=pg_query($moy_serie);

                                                $tabResult[$i][0]=pg_result($res,$i,1);
                                                $tabResult[$i][1]=round(pg_result($res_moy_serie,0,0),2)."/20";
                                                $tabResult[$i][2]=pg_result($res_nb_user,0,0);
                                                $tabResult[$i][3]=pg_result($res,$i,0);
                                    }
                                    break;

                        case 'a':
                                    $liste="select r.id_serie,titre,score
                                                            from serie_aleatoire,res_serie r,asso_exo_serie_aleatoire a
                                                            where id_formation='$form'
                                                            and mode='1'
                                                            and score>=0
                                                            and date_fin>0
                                                            and r.id_serie=num_serie
                                                            and num_serie=a.id_serie
                                                            group by r.id_serie, titre,score";

                                    $res=pg_query($liste);
                                    $nb=pg_num_rows($res);

                                    for($i=0;$i<$nb;$i++)
                                    {
                                                $nb_user="select count(distinct id_stag)
                                                                        from res_serie
                                                                        where id_serie='".pg_result($res,$i,0)."'
                                                                        and id_formation='$form'
                                                                        and score>=0";
                                                $res_nb_user=pg_query($nb_user);
                                                $moy_serie="select avg(score)
                                                                        from res_serie
                                                                        where id_serie='".pg_result($res,$i,0)."'
                                                                        and id_formation='$form'
                                                                        and score>=0";
                                                $res_moy_serie=pg_query($moy_serie);

                                                $tabResult[$i][0]=pg_result($res,$i,1);
                                                $tabResult[$i][1]=round(pg_result($res_moy_serie,0,0),2)."/20";
                                                $tabResult[$i][2]=pg_result($res_nb_user,0,0);
                                                $tabResult[$i][3]=pg_result($res,$i,0);
                                    }
                                    break;

                        case 'A':
                                    $liste="select r.id_serie,titre,score
                                                            from serie_exo,serie_aleatoire,res_serie r,asso_exo_serie_aleatoire a
                                                            where id_formation='$form'
                                                            and mode='2'
                                                            and score>=0
                                                            and date_fin>0
                                                            and r.id_serie=num_serie
                                                            and id=r.id_serie
                                                            and num_serie=a.id_serie
                                                            group by r.id_serie, titre,score";

                                    $res=pg_query($liste);
                                    $nb=pg_num_rows($res);

                                    for($i=0;$i<$nb;$i++)
                                    {
                                                $nb_user="select count(distinct id_stag)
                                                                        from res_serie
                                                                        where id_serie='".pg_result($res,$i,0)."'
                                                                        and id_formation='$form'
                                                                        and score>=0";
                                                $res_nb_user=pg_query($nb_user);
                                                $moy_serie="select avg(score)
                                                                        from res_serie
                                                                        where id_serie='".pg_result($res,$i,0)."'
                                                                        and id_formation='$form'
                                                                        and score>=0";
                                                $res_moy_serie=pg_query($moy_serie);

                                                $tabResult[$i][0]=pg_result($res,$i,1);
                                                $tabResult[$i][1]=round(pg_result($res_moy_serie,0,0),2)."/20";
                                                $tabResult[$i][2]=pg_result($res_nb_user,0,0);
                                                $tabResult[$i][3]=pg_result($res,$i,0);
                                    }
                                    break;
                        }
}

function detailSerie($serie,$form,$tabDetail)
{
            $test_aleat="select num_serie from serie_aleatoire where num_serie='$serie'";
            $res_test_aleat=pg_query($test_aleat);
            $test_aleat_bool=pg_num_rows($res_test_aleat);

            $liste_exos_serie="select distinct ordre_etape, type_exo
                                                from res_serie_exo
                                                where id_serie='$serie'
                                                and id_formation='$form'
                                                order by ordre_etape";
            $res_liste_exos_serie=pg_query($liste_exos_serie);
            $nb_ex=pg_num_rows($res_liste_exos_serie);

            for($i=0;$i<$nb_ex;$i++)
            {
                        $type_ex=pg_result($res_liste_exos_serie,$i,1);
                        $etape=pg_result($res_liste_exos_serie,$i,0);

                        if($test_aleat_bool>0) $table="asso_exo_serie_aleatoire";
                        else $table="asso_exo_serie";

                        switch($type_ex)
                        {
                                    case 'f' :
                                                            $req="select text
                                                                        from gest_ftb,$table
                                                                        where id_serie='$serie'
                                                                        and ordre='$etape'
                                                                        and id_exo=id";
                                                            $type=MENU_70;
                                                                        break;

                                    case 'q':

                                                            $req="select libelle_question
                                                                        from question,$table
                                                                        where  id_serie='$serie'
                                                                        and ordre='$etape'
                                                                        and id_exo=num_question";
                                                            $type=$MSG_547;
                                                                        break;

                                    case 's':             $req="select question
                                                                        from question_sondage,$table
                                                                        where id_serie='$serie'
                                                                        and ordre='$etape'
                                                                        and id_exo=num_sondage";
                                                            $type=$MSG_1483;
                                                                        break;
                        }

                        $res_nom_exo=pg_query($req);
                        $moy_question="select score,point
                                                            from $table a, res_serie_exo r
                                                            where point<>0
                                                            and id_formation='$form'
                                                            and a.id_serie='$serie'
                                                            and ordre_etape='$etape'
                                                            and a.id_serie=r.id_serie
                                                            and ordre=ordre_etape
                                                            group by score,point";
                        $res_moy_question=pg_query($moy_question);
                        $nb_result=pg_num_rows($res_moy_question);

                        $nb_stag_exo="select count(id_stag)
                                                            from res_serie_exo
                                                            where id_serie='$serie'
                                                            and id_formation='$form'
                                                            and ordre_etape='$etape'";
                        $res_nb_stag_exo=pg_query($nb_stag_exo);

                        if($type_ex !='s')
                        {
                                    $score=0;
                                    $point=0;
                                    for($j=0;$j<$nb_result;$j++)
                                    {
                                                $score+=pg_result($res_moy_question,$j,0);
                                                $point+=pg_result($res_moy_question,$j,1);
                                    }
                                    $note20=round(($score/$point)*20,2);
                        }
                        else $note20="X";

                        if($type_ex =='f')
                        {
                                    $libelle=eregi_replace("\[IMG file='([^]']*)'\]", "", pg_result($res_nom_exo,0,0));
                                    $libelle=substr(eregi_replace("\[SWF file='([^']*)'  hauteur='([0-9]*)' largeur='([0-9]*)'\]", "",$libelle),0,70)."...";
                        }
                        else
                                    $libelle=pg_result($res_nom_exo,0,0);

                        $tabDetail[$i][0]=$libelle;
                        $tabDetail[$i][1]=$note20;
                        $tabDetail[$i][2]=$type_ex;
            }
}




/******************************************************************************************/

//Recuperation des parametres
$num_formation=$_GET['form'];
$moy_gen=$_GET['moy_form'];

// nom de la formation
$nom_form="select nom_cal from calendrier where num_cal='$num_formation'";
$res_nom_form=pg_query($nom_form);
$nom_f=pg_result($res_nom_form,0,0);

// date du jour
$date=date("d-m-Y");

// titre de la page
$titre_page="Statistiques de la formation $nom_f  la date du $date";

// moyenne gnrale
$Moyenne_gale="Moyenne gnrale de la formation";


// moyennes par type d'evaluations
$liste_series_form="select id_serie,score
                        from res_serie
                        where id_formation='$num_formation'
                        and score >=0
                        and date_fin>0";
$res_liste_series_form = pg_query($liste_series_form);
$nb_series_form=pg_num_rows($res_liste_series_form);

$liste_exos_form=" select num_exo,score, surtotal
                        from resexouser
                        where num_cal='$num_formation'
                        and surtotal <> 0";
$res_liste_exos_form=pg_query($liste_exos_form);
$nb_exos_form=pg_num_rows($res_liste_exos_form);

if($nb_series_form >0)
{
            $moy_totale_series=MoySerieForm($res_liste_series_form,$nb_series_form);
            // tableaux pour le tri des sries selon leur contenu
            $tabMulti=array();
            $tabSondage=array();
            $tabBlanc=array();
            $tabAleatMono=array();
            $tabAleatMulti=array();
            $tabQCM=array();
            $titreSerie=array();

            // tri des sries de la formation selon leur contenu
            dispatchSerie($res_liste_series_form,$nb_series_form,&$tabMulti,&$tabBlanc,&$tabSondage,&$tabQCM,&$tabAleatMono,&$tabAleatMulti,&$titreSerie,$num_formation);
}

if($nb_exos_form>0)
{
            $moy_totale_exos=MoyExosForm($res_liste_exos_form,$nb_exos_form);

            // tableaux pour le tri des exos selon leur type
            $tabPF=array();
            $tabMail=array();
            $titreExo=array();

            // tri des exos selon leur type
            dispatchExo($res_liste_exos_form,$nb_exos_form,&$tabPF,&$tabMail,&$titreExo,$num_formation);
}

//Dimension d'une page A4
$largeur_page=210;
$hauteur_page=297;

//Marges horizontale et verticale
$marge=10;
$margey=20;

//largeur et hauteur utiles
$larg_utile=$largeur_page-$marge;
$haut_utile=$hauteur_page-$margey;

//largeur du tableau d'affichage
$larg_tab=$larg_utile-50;

//Creation du PDF
$pdf=new pdf_Afide();
$pdf->setMargins($marge,$marge);
$pdf->setHeaderTitre($titre_page);
$pdf->Open();
$pdf->AddPage();
$pdf->setAuthor("AFIDE");
$pdf->setCreator("FPDF");
$pdf->SetFont('Helvetica','B',14);
$pdf->setY($margey);
$pdf->setFillColor(220);
$pdf->Cell(0,10,$titre_page,1,2,'C',1);

//Le cadre de la page
$pdf->setFillColor(255,255,255);
$pdf->Rect($marge,$pdf->getY()+4,$largeur_page-2*$marge,$hauteur_page-$margey-$pdf->getY());
$pdf->setY($pdf->getY()+15);
$pdf->setX($pdf->getX()+2);
$pdf->SetFont('Helvetica','',12);
$pdf->SetTextColor(0,0,0);

// affichage de la moyenne gnrale de la formation
$pdf->setFillColor(220);
$pdf->setX($marge+(($larg_utile-$larg_tab)/2));
$pdf->Cell($larg_tab,10,"Informations gnrales",1,2,'C',1);

//$pdf->Rect($marge+(($larg_utile-$larg_tab)/2),$pdf->getY()+5,$larg_tab,100);
$pdf->setY($pdf->getY());
$pdf->setX($marge+(($larg_utile-$larg_tab)/2));
$pdf->SetTextColor(0,0,0);
$pdf->setFillColor(255,255,255);
$pdf->Cell($larg_tab-20,10,$Moyenne_gale,1,0,'',1);
$pdf->setX(($marge+(($larg_utile-$larg_tab)/2))+($larg_tab-20));
$pdf->Cell(20,10,$moy_gen."/20",1,2,'',1);

if($nb_series_form>0)
{
            //$pdf->Rect($marge+(($larg_utile-$larg_tab)/2),$pdf->getY()+5,$larg_tab,10);
            $pdf->setY($pdf->getY());
            $pdf->setX($marge+(($larg_utile-$larg_tab)/2));
            $pdf->SetTextColor(0,0,0);
            //$pdf->image("../../images/icoserie.gif",($largeur_page/2)-$largeur_image/2,$pdf->getY()+15,$largeur_image);
            $pdf->Cell($larg_tab-20,10,"Moyenne de la formation pour les sries",1,0,'',1);
            $pdf->setX(($marge+(($larg_utile-$larg_tab)/2))+($larg_tab-20));
            $pdf->Cell(20,10,$moy_totale_series."/20",1,2,'',1);
}

if($nb_exos_form>0)
{
            //$pdf->Rect($marge+(($larg_utile-$larg_tab)/2),$pdf->getY()+5,$larg_tab,10);
            $pdf->setY($pdf->getY());
            $pdf->setX($marge+(($larg_utile-$larg_tab)/2));
            $pdf->SetTextColor(0,0,0);
            $pdf->Cell($larg_tab,10,"Moyenne de la formation pour les exercices  tlcharger",1,0,'',1);
            $pdf->setX(($marge+(($larg_utile-$larg_tab)/2))+($larg_tab-20));
            $pdf->Cell(20,10,$moy_totale_exos."/20",1,2,'',1);
}


if($nb_series_form>0)
{
            $pdf->setY($pdf->getY()+10);
            $pdf->setX($marge+(($larg_utile-$larg_tab)/2));
            $pdf->setFillColor(220);
            $pdf->Cell($larg_tab,10,"Moyenne par type de sries",1,2,'C',1);
            $pdf->setFillColor(255,255,255);
            while(list($id,$tab)=each($titreSerie))
            {
                        $pdf->setY($pdf->getY());
                        $pdf->setX($marge+(($larg_utile-$larg_tab)/2));
                        $libelle=substr(strstr($tab[0],"-"),1);
                        $pdf->Image("../$tab[2]",$marge+(($larg_utile-$larg_tab)/2),$pdf->getY(),10,10);
                        $pdf->setX($marge+(($larg_utile-$larg_tab)/2)+10);
                        $pdf->Cell($larg_tab-20,10,$libelle,1,0,'C',1);
                        $pdf->setX(($marge+(($larg_utile-$larg_tab)/2))+($larg_tab-20));

                        $pdf->Cell(20,10,$tab[1],1,2,'C',1);
            }
}


if($nb_exos_form>0)
{
            $pdf->setY($pdf->getY()+10);
            $pdf->setX($marge+(($larg_utile-$larg_tab)/2));
            $pdf->setFillColor(220);
            $pdf->Cell($larg_tab,10,"Moyenne par type d'exercices",1,2,'C',1);
            $pdf->setFillColor(255,255,255);
            while(list($id,$tabexo)=each($titreExo))
            {
                        $pdf->setY($pdf->getY());
                        $pdf->setX($marge+(($larg_utile-$larg_tab)/2));
                        $libelle=substr(strstr($tabexo[0],"-"),1);
                        $pdf->Cell($larg_tab-20,10,$libelle,1,0,'C',1);
                        $pdf->setX(($marge+(($larg_utile-$larg_tab)/2))+($larg_tab-20));
                        $pdf->Cell(20,10,$tabexo[1],1,2,'C',1);
            }
}


if(sizeof($titreSerie)>0)
{
            reset($titreSerie);
            while(list($id,$tabserie)=each($titreSerie))
            {
                        $pdf->AddPage();
                        $pdf->SetFont('Helvetica','B',14);
                        $pdf->setY($margey);
                        $pdf->setFillColor(220);
                        $pdf->Cell(0,10,$titre_page,1,2,'C',1);

                        //Le cadre de la page
                        $pdf->setFillColor(255,255,255);
                        $pdf->Rect($marge,$pdf->getY()+4,$largeur_page-2*$marge,$hauteur_page-$margey-$pdf->getY());
                        $pdf->setY($pdf->getY()+4);
                        $pdf->setX($pdf->getX());
                        $pdf->SetFont('Helvetica','',12);
                        $pdf->SetTextColor(0,0,0);

                        $pdf->setX($marge);
                        $libelle=substr(strstr($tabserie[0],"-"),1);
                        $type=substr($tabserie[0],0,strpos($tabserie[0],"-"));

                        // affichage du type de sries en dbut de page
                        $pdf->setFillColor(220);
                        $pdf->Cell($larg_utile-40,10,$libelle,1,0,'C',1);
                        $pdf->setX($marge+($larg_utile-40));
                        $pdf->Cell(30,10,$tabserie[1],1,2,'C',1);
                        $pdf->setY($pdf->getY()+5);
                        $pdf->setFillColor(255,255,255);
                        $tabResult=array();
                        calculeMoySeries($num_formation,$nom_f,$type,&$tabResult);
                        reset($tabResult);
                        while(list($num,$ligne)=each($tabResult))
                        {
                                    //print_r($ligne);
                                    $pdf->setX($marge+10);
                                    $pdf->setFillColor(220);
                                    $pdf->Cell($larg_utile-40,10,$ligne[0],1,0,'C',1);
                                    $pdf->setX($marge+($larg_utile-40));
                                    $pdf->Cell(20,10,$ligne[1],1,2,'C',1);
                                    $pdf->setFillColor(255,255,255);

                                    $tabDetail=array();
                                    detailSerie($ligne[3],$num_formation,&$tabDetail);
                                    while(list($ind,$row)=each($tabDetail))
                                    {
                                                $pdf->setX($marge+20);
                                                $pdf->Cell($larg_utile-50,10,"$row[0]",1,0,'C',1);
                                                $pdf->setX($marge+($larg_utile-50));
                                                $pdf->Cell(20,10,"$row[1]",1,2,'C',1);

                                    }
                                    $pdf->setY($pdf->getY()+5);

                        }
            }
}

/*if(sizeof($titreExo)>0)
{
            reset($titreExo);
            while(list($id,$tabex)=each($titreExo))
            {
                        $pdf->AddPage();
                        $pdf->SetFont('Helvetica','B',14);
                        $pdf->setY($margey);
                        $pdf->setFillColor(220);
                        $pdf->Cell(0,10,$titre_page,1,2,'C',1);

                        //Le cadre de la page
                        $pdf->setFillColor(255,255,255);
                        $pdf->Rect($marge,$pdf->getY()+4,$largeur_page-2*$marge,$hauteur_page-$margey-$pdf->getY());
                        $pdf->setY($pdf->getY()+4);
                        $pdf->setX($pdf->getX());
                        $pdf->SetFont('Helvetica','',12);
                        $pdf->SetTextColor(0,0,0);

                        $pdf->setX($marge);
                        $libelle=substr(strstr($tabex[0],"-"),1);
                        $type=substr($tab[0],0,strpos($tabex[0],"-"));
                        $pdf->Cell($larg_utile-40,10,$libelle,1,0,'C',1);
                        $pdf->setX($marge+($larg_utile-40));
                        $pdf->Cell(30,10,$tabex[1],1,2,'',1);
                        $pdf->setY($pdf->getY()+10);

                        $tabResult=array();
                        calculeMoySeries($num_formation,$nom_f,$type,&$tabResult);
                        reset($tabResult);
                        while(list($num,$ligne)=each($tabResult))
                        {
                                    $pdf->setX($marge+10);
                                    $pdf->Cell($larg_utile-40,10,$ligne[0],1,0,'C',1);
                                    $pdf->setX($marge+($larg_utile-40));
                                    $pdf->Cell(20,10,$ligne[1],1,2,'',1);
                        }
            }
}*/

$pdf->Output();


?>