<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*-----------------------------------------------------------------------------------------*/
//       fichier:  plpgsql_fonctions.php  gestion des requetes SQL
// ce fichier contient toutes les fonctions necessaires  l'interrogation des bd
/*-----------------------------------------------------------------------------------------*/
/*
CONVENTION PROPOSEE:

Le maximum des requetes SQL doivent etre ecritent sous la forme de fonctions
en PLPGSQL en base, c'est a dire la totalit des requetes retournant  une valeur.

Les requetes retournant plusieurs lignes ne pouvant etre traites ainsi, elles doivent
tre ecrite sous la forme de fonctions PHP qui retournent une variable resultat (pg_exec)

*/

 /////////////////////////////////////////////////////////////////////////////////////
 /*modele de commentairePHPDOC --ne pas fac-- modifiable*/

/**
*courte description sur 1 SEULE ligne
*
*longue description sur PLUSIEURS LIGNES
*
*   @param  type description param1
*   @param  type description param2
*   @param  type description param3
*
*    @return type description    (pas gr par phpdoc)
*
*
*/

 /////////////////////////////////////////////////////////////////////////////////////


/*-----------------------------------------------------------------------------------------*/
//                         LES FONCTIONS  D'ACCESS AUX FONCTIONS PLPGSQL
/*-----------------------------------------------------------------------------------------*/
/*
                            DOIVENT RETOURNER UNE VARIABLE
*/
/*
CONVENTION DE NOMAGE :
Il faut tablir une correspondance entre le nom de la fonction php et le nom de la fonction
PLPGSQL. Ainsi, on utilisera le meme nom pour les 2 fonctions, a ceci prs que le nom de
 la fonction PLPGSQL est precede de _af_ afin de la distinguer des fonctions systeme.
Exemple:

la fonction php function check_access($droit, $cal, $user) correspond  _af_check_access dans la base

*/


/*--------------------------------------------------------------------------------------------*/
//                                       FONCTIONS PL/SQL POUR LES STATS
/*-------------------------------------------------------------------------------------------*/
/**
*   obtenir la liste des sries d'une formation ainsi que sa note sur 20
*
*   Retourne les numros de sries ainsi que leur note.
*
*    @param  integer  le numro de formation
*/
function liste_series_form($calendrier)
{
            $liste_series_form="SELECT * from _af_liste_series_form($calendrier) AS (serie smallint,score real)";
            $res_liste_series_form = pg_query($liste_series_form);
            return ($res_liste_series_form);
}

/**
*   obtenir la liste des exercices  tlcharger d'une formation, le score et le nombre de point de l'exercice
*
*   Retourne les numros d'exercices, le score et le nombre de points
*
*    @param  integer  le numro de formation
*/
function liste_exos_form($calendrier)
{

            $liste_exos_form="SELECT * from _af_liste_exos_form($calendrier) AS (num_exo integer, note integer, point integer)";
            $res_liste_exos_form = pg_query($liste_exos_form);
            return ($res_liste_exos_form);
}

/**
*   obtenir la liste des formations qui ont des valuations corriges
*
*   Retourne les numros de formation ainsi que le nom
*
*    @param  integer le type de classement
*    @param  string paramtre de date
*/
function liste_form_avec_eval($date_form,$classement)
{
            $req="select * from _af_stats_liste_formations('$date_form',$classement) AS (num_cal integer, nom_cal varchar)";
            //echo "$liste_series_form<br>";
            $res = pg_query($req);
            return ($res);
}
/**
*   obtenir la liste des groupes qui ont des valuations corriges
*
*   Retourne les numros de groupes ainsi que le nom
*
*    @param  integer le type de classement
*
*/
function get_liste_groupe_eval($classement)
{
            $req="select * from _af_get_liste_groupe_eval($classement) AS (num_grp integer, nom_groupe varchar)";
            //echo "$liste_series_form<br>";
            $res = pg_query($req);
            return ($res);
}
/**
*   obtenir la liste des stagiaires d'un groupes qui ont des valuations corriges
*
*   Retourne les numros des stagiaires, leur nom et prenoms
*
*    @param  integer numro de groupe
*
*/
function get_liste_stag_groupe_eval($groupe)
{
            $req="select * from _af_get_liste_stag_groupe_eval($groupe) AS (num_user integer, nom varchar, prenom varchar)";
            //echo "$liste_series_form<br>";
            $res = pg_query($req);
            return ($res);
}

/**
*   obtenir la liste des formations d'un stagiaire d'un groupe qui a des valuations corriges
*
*   Retourne les numros et noms de formations
*
*    @param  integer numro de groupe
*    @param integer numro de stagiaire
*
*/
function get_form_user_groupe_eval($groupe,$user)
{
            $req="select * from _af_get_form_user_groupe_eval($groupe,$user) AS (num_cal integer, nom_cal varchar)";
            //echo "$liste_series_form<br>";
            $res = pg_query($req);
            return ($res);
}

/**
*   Obtenir le nombre de sries de la formation
*
*   Retourne le nombre de sries de la formation
*
*    @param  integer numro de formation
*
*
*/
function get_nb_series_form($form)
{
            $req="select _af_get_nb_series_form($form)";
            //echo "$liste_series_form<br>";
            $res = pg_query($req);
            $nb = pg_fetch_row($res,0);


            return $nb[0];
}
/**
*   Obtenir le nombre d'exercices  tlcharger de la formation
*
*   Retourne le nombre d'exercices  tlcharger de la formation
*
*    @param  integer numro de formation
*
*
*/
function get_nb_exos_form($form)
{
            $req="select _af_get_nb_exos_form($form)";
            //echo "$liste_series_form<br>";
            $res = pg_query($req);
            $nb = pg_fetch_row($res,0);


            return $nb[0];


}
/**
*   Obtenir le nombre de sries valides par un stagiaire d'une formation
*
*   Retourne le nombre de sries valides
*
*    @param  integer numro de formation
*    @param integer numro de stagiaire
*
*/
function get_nb_series_faites($form,$stag)
{
            $req="select _af_get_nb_series_faites($form,$stag)";
            //echo "$liste_series_form<br>";
            $res = pg_query($req);
            $nb = pg_fetch_row($res,0);


            return $nb[0];
}
/**
*   Obtenir le nombre d'exercices valids par un stagiaire d'une formation
*
*   Retourne le nombre d'exercices valids
*
*    @param  integer numro de formation
*    @param integer numro de stagiaire
*
*/
function get_nb_exos_faits($form,$stag)
{
            $req="select _af_get_nb_exos_faits($form,$stag)";
            //echo "$liste_series_form<br>";
            $res = pg_query($req);
            $nb = pg_fetch_row($res,0);


            return $nb[0];
}
/**
*   Obtenir les numros de stagiaires lis  une formation
*
*   Retourne les numros de stagiaires
*
*    @param  integer numro de formation
*
*
*/
function get_stag_form($form)
{
            $req="select * from _af_get_stag_form($form) AS (num_user integer)";
            //echo "$liste_series_form<br>";
            $res = pg_query($req);
            return $res;
}
 /**
*   Obtenir le nombre de stagiaires ayant commenc des valuations d'une formation
*
*   Retourne le nombre de stagiaires
*
*    @param  integer numro de formation
*
*
*/
function get_stag_avec_eval($form)
{
            $req="select * FROM _af_get_stag_avec_eval($form) AS (num_user integer)";
            //echo "$liste_series_form<br>";
            $res = pg_query($req);

            return $res;
}
/**
*   Obtenir les formations lies  un groupe donn
*
*   Retourne la liste des formations lies au groupe donn
*
*    @param  integer numro de groupe
*
*
*/
function get_form_de_groupe($groupe)
{
            $req="select * FROM _af_get_form_de_groupe($groupe) AS (num_cal integer)";
            //echo "$liste_series_form<br>";
            $res = pg_query($req);

            return $res;
}
/**
*   Obtenir la liste des stagiaires ayant des evaluations valides
*
*   Retourne la liste des stagiaires
*
*    @param  integer type de classement
*
*
*/
function get_liste_stag_avec_eval($classement)
{
            $req="select * FROM _af_get_liste_stag_avec_eval($classement) AS (id_stag integer,nom_stag varchar)";
            //echo "$liste_series_form<br>";
            $res = pg_query($req);

            return $res;
}

/**
*   Tester si une formation a un parcours dynamique
*
*   Retourne la liste des parcours dynamiques de la formation
*   si il y en a.
*
*    @param  integer numro de calendrier
*
*
*/
function test_parcours_dyn($cal)
{
            $req="select * FROM _af_test_parcours_dyn($cal) AS (num_cal integer)";
            $res = pg_query($req);
            return $res;
}

/**
*   Rcuprer les sous parcours d'un parcours donn
*
*   Retourne la liste des sous-parcours du parcours
*
*    @param  integer numro de parcours
*
*
*/
function recup_sous_parcours($parcours)
{
            $req="select * FROM _af_recup_ss_parcours($parcours) AS (num_parc integer)";
            $res = pg_query($req);
            return $res;
}

/**
*   Test si la srie donne est alatoire
*
*   Retourne 0 si non alatoire et >0 sinon
*
*    @param  integer numro de srie
*
*
*/
function test_si_serie_aleatoire($serie)
{
            $req="select _af_test_serie_aleatoire($serie)";
            $res = pg_query($req);
            return (pg_result($res,0,0));
}


?>