<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*--------------------------------------------------------------------------------------------*/
//  Fichier resultat_src.php
//  Action : affiche les rsultats d'une question de sondage (SRC)
//  Donnes reues : $num_user,$num_cal,$id_serie,$id_exo,
//                               $ordre (test) ,$ordre_question
/*--------------------------------------------------------------------------------------------*/
require('../dbpostgres.php3');
$db=pg_connect("$server","","","","$nombase");
require("$chemin_bo/lib/lib_test.php");

/*--------------------------------------------------------------------------------------------*/
//              INITIALISATION
/*--------------------------------------------------------------------------------------------*/
// l'objet srie
$obj_serie=new Serie($id_serie);
$libelle_serie=$obj_serie->toString();

// l'objet test
$obj_test=new Test($id_exo);
// lbelle,nb de reponse et theme
$libelle_test=$obj_test->toString();
$nb_reponse=$obj_test->getNbReponses();
$num_theme=$obj_test->getNumTheme();
// reponse radio ou checkbox
$type_reponse=$obj_test->getType_reponse();
if($type_reponse=='c')
    $type_bouton="checkbox";
else
    $type_bouton="radio";
// question commune
$question_commune=$obj_test->getQuestion_commune();

// l'objet question
$obj_question=$obj_test->getExercice($ordre_question);
$libelle_question=$obj_question->toString();
$num_question=$ordre_question + 1;

// recup du repertoire pour les mdias
$sql="select nom_rep from themedir where num_themedir=$num_theme";
$res=pg_query($sql);
$row=pg_fetch_row($res,0);
$nomrep=$row[0];

// media question ?
$obj_media_question=$obj_question->getMedia();
$media_question=$obj_media_question->toString();

// recup du resultat pour la question
$sql="select reponse from res_serie_exo where id_formation=$num_cal and id_serie=$id_serie and id_stag=$num_user and ordre_etape=$ordre";
$resrep=pg_query($sql);
$rowrep=pg_fetch_row($resrep,0);
$tab=explode(";",$rowrep[0]);
$tabrep=$tab[$ordre_question];

$hauteur=20 * $nb_reponse;
$nbtotal=1;

/*--------------------------------------------------------------------------------------------*/
//          AFFICHAGE ENTETE + RESULTATS
/*--------------------------------------------------------------------------------------------*/
print("
<html>
<head>
<title>resultat_src.php</title>
</head>
<body bgcolor=\"#ffffff\">
<br><br>
<table border=1 cellpadding=0 cellspacing=0 width=95% align=center>
<tr bgcolor=\"#c7c7c7\">
<td colspan=2 align=center><b>SONDAGE - RESULTAT</b></td>
</tr>
<tr bgcolor=\"#e6e6e6\">
<td colspan=2>
<b>Srie : </b>$libelle_serie<br>
<b>SRC : </b>$libelle_test (type $type_bouton)<br>
<b>Question commune : </b>$question_commune<br>
<b>Question N $num_question : </b>$libelle_question<br>
</td>
<tr>
");
if($media_question){
    $lien_media="http://$serverfront/data/exostlc/$nomrep/media_qcm/$media_question";
    print("
    <tr>
    <td><center>
    ");
    if(est_image($media_question))
        print("
        <img src=\"$lien_media\" border=0 vspace=5>
        ");
    if(strtolower(substr($media_question,-3))=='swf'){
        $largeur_media=$obj_media_question->getLargeur();
        $longueur_media=$obj_media_question->getLongueur();
        if($largeur_media!=0 && $longueur_media!=0)
            print("
            <embed src=\"$lien_media\"
            quality=high pluginspage=\"http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash\"
            type=\"application/x-shockwave-flash\"
            width=\"$largeur_media\" height=\"$longueur_media\" border=0 vspace=5>
            </embed>
            ");

    }
    print("
    </center>
    </td>
    </tr>
    ");
}

print("
<tr bgcolor=\"#e6e6e6\">
<td colspan=2>
<table width=100% cellspacing=2 height=\"$hauteur\">
");
for($i=0;$i<$nb_reponse;$i++){
    $obj_reponse=&$obj_test->getReponse($i);
    $libelle_reponse=$obj_reponse->toString();
    $num_media=$obj_reponse->media;
    $obj_media_reponse=new Media_exo($num_media);
    $media_reponse=$obj_media_reponse->toString();
    if(substr($tabrep,$i,1)==1)
        $nbprop=1;
    else
        $nbprop=0;
    $pourcent=round(($nbprop/$nbtotal * 100),2);
    print("
    <tr>
    <td align=left valign=middle height=50 width=70%><b>$libelle_reponse</b>
    ");
    if($media_reponse){
        $lien_media="http://$serverfront/data/exostlc/$nomrep/media_qcm/$media_reponse";
        if(est_image($media_reponse))
            print("
            <img src=\"$lien_media\" border=0 vspace=5>
            ");
        if(strtolower(substr($media_reponse,-3))=='swf'){
             $largeur_media=$obj_media_reponse->getLargeur();
            $longueur_media=$obj_media_reponse->getLongueur();
            if($largeur_media!=0 && $longueur_media!=0)
            print("
            <embed src=\"$lien_media\"
            quality=high pluginspage=\"http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash\"
            type=\"application/x-shockwave-flash\"
            width=\"$largeur_media\" height=\"$longueur_media\" border=0 vspace=5>
            </embed>
            ");

        }


    }
    print("
    </td>
    <td align=left valign=middle nowrap>
    <img src=\"../images/sondage.gif\" width=\"$pourcent\" height=10>$pourcent %
    </td>
    </tr>
    ");
}
print("
</table>
</td>
</tr>
");
print("
<tr bgcolor=\"e6e6e6\">
<td colspan=2 valign=middle align=center>
<table width=80% border=0>
<tr>
<td><font face=\"Arial,Helvetica\" size=2> 1 votant</td>
</tr>
</table>
</td>
</tr>
");
print("
</table>
<br><br>
<center><b>[ <a href=\"#\" Onclick=\"window.close();\"><font face=\"Arial,Helvetica\" color=\"#000000\">$MSG_956</font></a> ] </b></center>
</body>
</html>
");
?>