<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*--------------------------------------------------------------------------*/
//  Fichier resultsolo.php
//  Action : Affiche les rsultats pour la srie dont l'identifiant est pass en paramtre
//  Donne reue :      $num_sondage
//                                     $idserie
/*--------------------------------------------------------------------------*/
require('../dbpostgres.php3');
$db = pg_Connect("$server", "", "", "", "$nombase");
//debug
//echo "num_sondage=$num_sondage<br>";

/*--------------------------------------------------------------------------*/
//      INITIALISATION
/*--------------------------------------------------------------------------*/
// RECUP DES INFOS DANS QUESTION SONDAGE
$resq=pg_query("select * from question_sondage where num_sondage=$num_sondage");
//echo "select * from question_sondage where num_sondage=$num_sondage";
$rowq=pg_fetch_row($resq,0);
$question=$rowq[1];
$qphoto=$rowq[3];
$largeur=$rowq[4];
$hauteur=$rowq[5];

// REQUETE SUR THEMEDIR POUR AVOIR LE NOM DU REPERTOIRE
$requete="SELECT nom_rep FROM THEMEDIR WHERE num_themedir='$theme'";
$result=pg_query($requete);
$row=pg_fetch_row($result,0);
$repertoire=$row[0];

// recup des propositions
$resp=pg_query("select * from proposition_sondage where num_sondage=$num_sondage");
$nbproposition=pg_numrows($resp);

// REQUETE SUR SERIE_EXO POUR AVOIR LE LIBELLE
$requete="SELECT titre FROM SERIE_EXO WHERE id='$idserie'";
$resultserie=pg_query($requete);
$rowserie=pg_fetch_row($resultserie,0);

$test_serie_aleatoire="select num_serie from serie_aleatoire where num_serie='$idserie'";
$res_test_serie_aleatoire=pg_query($test_serie_aleatoire);
if(pg_num_rows($res_test_serie_aleatoire)>0) $table="asso_exo_serie_aleatoire";
else $table="asso_exo_serie";


// RECUPERATION DU NOMBRE TOTAL DE VOTANTS
$resnbtotal=pg_query("select * from RES_SERIE_EXO R, $table A
                        where A.id_serie=R.id_serie
                        and R.id_stag='$num_user'
                        and A.id_serie=$idserie
                        and A.type_exo='s'
                        and ordre=ordre_etape
                        and id_exo='$num_sondage';");
$nbtotal=pg_numrows($resnbtotal);


/*--------------------------------------------------------------------------*/
//      AFFICHAGE ENTETE
/*--------------------------------------------------------------------------*/
$nompage="resultsolo.php";
$titre="Rsultat du sondage";
print("
<html>
<head>
<title>$nompage</title>
</head>
<body bgcolor=\"#FFFFFF\">
<br><br><br>
<table border=\"6\" bordercolor=\"black\" cellpadding=\"0\" cellspacing=\"0\" width=\"95%\" align=\"center\">");


/*--------------------------------------------------------------------------*/
//      AFFICHAGE RESULTAT
/*--------------------------------------------------------------------------*/

    print("
    <tr bgcolor=\"#C7C7C7\">
    <td colspan=\"3\"><div align=\"center\"><b>SONDAGE - RESULTATS</b></div></td>
    </tr>
    <tr bgcolor=\"#E6E6E6\">
    <td colspan=\"2\">
    <blockquote>
    <b><u>Question :</u></b><br>
    $question
    <br><br>
    <b><u>Srie :</u></b><br>
    $rowserie[0]
    </td>
    <td>");

    if($qphoto!="" && $qphoto!=0)
    {
        // AFFICHAGE DU MEDIA DE LA QUESTION
        // utiliser qphoto(=num), repertoire dans THEMEDIR, table=ficmediaqcm=$liste_cat[3][2]
        $requete="SELECT nom_fic FROM ficmediaqcm WHERE num_fic='$qphoto'";
        //echo "$requete<br>";
        $result=pg_exec($requete);
        $rowMedia=@pg_fetch_row($result,0);
        $nomMedia=$rowMedia[0];

        $exten=strtolower(substr($nomMedia,-3));
        if ($exten=="swf")
        {
                // On vrifie que la largeur et la hauteur ont bien t saisies
                if($largeur=="" || $hauteur=="" || $largeur==0 || $hauteur==0) print("$ERROR_72");
                else
                {
                        echo "<embed src=\"http://$serverfront/data/exostlc/$repertoire/media_qcm/$nomMedia\"
                        quality=high pluginspage=\"http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash\" type=\"application/x-shockwave-flash\" width=$largeur height=$hauteur border=4>
                        </embed> ";
                }
        }
        else
        {
            if(!empty($nomMedia))
                        print("<img src=\"http://$serverfront/data/exostlc/$repertoire/media_qcm/$nomMedia\" border=\"4\">");
            else     print("<font color=\"red\"><blink>!! ERREUR fichier media introuvable !!</blink></font>");
        }


    }  // FIN IF MEDIA QUESTION
    else print("&nbsp;");
    print("</td></tr>");

    $hauteur=20*$nbproposition;
    print("
    <tr bgcolor=\"#E6E6E6\">
    <td colspan=\"3\">
    <table width=\"100%\" border=\"0\" cellspacing=\"2\" height=\"$hauteur\">");

    if($nbtotal==0)
        print("<br><center><font face=\"Arial, Helvetica\" size=3 color=red>Ce sondage n'a aucun rsultat</font></center><br>");

    // PARCOURS DES PROPOSITION
    for($i=0;$i<$nbproposition;$i++)
    {
        $rowp=pg_fetch_row($resp,$i);
        // REQUETE SUR PROPOSITION POUR OBTENIR LE LIBELLE
        $resprop=pg_query($db,"select libelle_prop from proposition where num_prop=$rowp[1]");
        $rowlibprop=pg_fetch_array($resprop,0);

        // REQUETE SUR RES_SERIE_EXO ET SERIE_EXO POUR AVOIR NOMBRE DE VOTE
        $resnbprop=pg_query("select * from RES_SERIE_EXO R, $table A
                        where A.id_serie=R.id_serie
                        and A.id_serie=$idserie
                        and R.id_stag='$num_user'
                        and R.reponse='$rowp[1]'
                        and A.type_exo='s'
                        and ordre=ordre_etape
                        and id_exo='$num_sondage';");
        $nbprop=pg_numrows($resnbprop);

        if ($nbtotal!=0)
        {
                $pourcent=round(($nbprop/$nbtotal*100),2);
                $taille=$pourcent;
                // echo "sondage=$num_sondage<br>proposition $i (n$rowp[1]) : nbprop=$nbprop & pourcent=$pourcent<br>";
        }

        print("
        <tr>
        <td width=\"1%\">&nbsp;<td>
        <td width=\"79%\" align=\"left\" valign=\"middle\" height=50><b>$rowlibprop[0]</b></td>");

        if($nbtotal!=0)
                print("<td width=\"20%\" align=\"left\" valign=\"middle\" nowrap><img src=\"../images/sondage.gif\" width=\"$taille\" height=\"10\">&nbsp;$pourcent %</td></tr>");
        else
                print("<td width=\"20%\" align=\"left\" valign=\"middle\" nowrap>PAS DE RESULTAT</td></tr>");

    }
    print("
    </table>
    </td>
    </tr>
    ");
    print("
    <tr bgcolor=\"#E6E6E6\">
    <td colspan=\"3\" valign=\"middle\" height=\"50\" align=center>
    <table width=\"80%\" border=0><tr><td><font face=\"Arial, Helvetica\" size=3>Nombre de votants actuel : <b>$nbtotal</b></td></tr></table>
    </td>
    </tr>
    ");

// Fin du tableau
print("</table><br><br>
<center><b>[ <a href=\"#\" Onclick=\"window.close()\"><font face=\"Arial\" color=\"#000000\">$MSG_956</font></a> ] </b></center>");
//Fin de page
print("
</body>
</html>
");

?>
