<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/
                        
/*-------------------------------------------------------------------*/
//      Fichier graph.php3 propre au suivi presentiel
//      Script qui trace un graph
//      les paramtres  passer :
//      $largeur, $hauteur et un tableau de $points et le titre ($titre)
//      ainsi ke $nomFic
/*-------------------------------------------------------------------*/
/*-------------------------------------------------------------------*/
//                      INITIALISATION
/*-------------------------------------------------------------------*/
// largeur du cadre pour le graphe
if(!(isset($largeur))){
  $largeur=1000;
}
// largeur du cadre pour le graphe
if(!(isset($hauteur))){
  $hauteur=250;
}
// Tableau points par dfaut
if(!(isset($points))){
  srand((float) microtime()*1000000);
  for($i=0;$i<10;$i++){
    $nb = rand(0,20);
    $points[$i]=($nb);
  }
}

if(!isset($margex))
     $margex=250;
$margey=40;

/*-------------------------------------------------------------------*/
//                      CREATION du graphe
/*-------------------------------------------------------------------*/
// Le cadre de l'image
$image = imagecreate($largeur,$hauteur);
// Les couleurs et background
$maroon = ImageColorAllocate($image,100,0,0);
$white = ImageColorAllocate($image,255,255,255);
$red = ImageColorAllocate($image,255,0,0);
$blue = ImageColorAllocate($image,0,0,255);
//$grey = ImageColorAllocate($image,200,200,200);
$grey = ImageColorAllocate($image,238,238,238);
$black = ImageColorAllocate($image,0,0,0);
$green = ImageColorAllocate($image,0,128,0);
$orange = ImageColorAllocate($image,255,165,0);
if(!isset($Cbackground)){
        $background=ImageColorAllocate($image,255,255,255);;
}
else{
        $background=ImageColorAllocate($image,$Cbackground[0],
         $Cbackground[1],
        $Cbackground[2]);
}
ImageFilledRectangle($image,0,0,$largeur,$hauteur,$background);
ImageFilledRectangle($image,0,$margey,$largeur-$margex,$hauteur-$margey,$grey);
//ImageFilledRectangle($image,0,$margey,$largeur-$margex,$hauteur-$margey,$black);
//Tracage de la grille
$taillefont=2;
$nb_separation=10;
$haut = ($hauteur-(2*$margey)) / ($nb_separation);
//axe vertical
imageLine($image,40,$hauteur-$margey,40,0+$margey,$maroon);
//imageLine($image,40,$hauteur-$margey,40,0+$margey,$white);

for($i=0;$i<=($nb_separation);$i++){
        $ypos=$margey + $hauteur - (int)($i*$haut);
        $ypos=$ypos-(2*$margey);
        if($i != ($nb_separation /2)){
                //Dans le cas d'un graph multi ligne, on ne trace pas
                //tous les reperes horizontaux (trop fouilli sinon)
                if(!isset($tabNoteExo))
                        ImageLine($image,0+40, $ypos,$largeur-$margex,
                $ypos,$maroon);
        }
        else
                ImageLine($image,0+40, $ypos,$largeur-$margex,
        $ypos,$red);
        $valeur=(20/$nb_separation)*$i;
        $valeur=$valeur*100;
        $valeur=round($valeur);
        $valeur=$valeur/100;
        $center=imagefontwidth($taillefont) * strlen($valeur);
        $center = (int)($margex - $center);
        imagestring($image, $taillefont,0,$ypos-(imagefontheight($taillefont)/2) , $valeur , $maroon);
        //imagestring($image, $taillefont,0,$ypos-(imagefontheight($taillefont)/2) , $valeur , $white);
}

$largeur_grille=$largeur-$margex-40;
//$largeur_col=$largeur_grille/(sizeof($points));//+((2*sizeof($points))*$espace_col);
$largeur_col=$largeur_grille/$nbdate;
//cacul de l'chelle
$echelle=(($hauteur-(2*$margey))/20);
$tc=5; //tc = taille de la croix;
$point1=array();
$point2=array();
//on dessine les lignes
//for($i=0;$i<sizeof($points);$i++){
//echo "nbdate=$nbdate<br>";
// Boucle sur les valeurs de $points
$i=0;
//for($i=0;$i<$nbdate+1;$i++){
while(list($numdate,$valpoint)=each($points)){
         //debug
        //echo "numdate=$numdate et i=$i<br>";
        if($numdate>=0) {

        $dif=0;
        if($numdate>$i){
                $dif=$numdate-$i;
                //echo "dif=$dif<br>";
                for($x=0;$x<$dif;$x++)
                        $i++;
        }
        //prev($points);
        $point2[0]=($i*$largeur_col+40);
        //echo "point2=$point2[0]<br>";
        // $point2[0]=($i*$largeur_col+40) +($largeur_col*($numdate-$i));
        //$point2[1]=(($hauteur-$margey) - ($points[$i] * $echelle));
        $point2[1]=(($hauteur-$margey) - ($valpoint * $echelle));
        if($i != 0){
                //recup des couleurs
                switch($couleur_ligne[$i]){
                        case 0 : $coul=$red;
                        break;
                        case 1 : $coul=$orange;
                        break;
                        case 2 : $coul=$green;
                        break;
                }
                //imageLine($image,$point1[0],$point1[1],$point2[0],$point2[1],$blue);
                imageLine($image,$point1[0],$point1[1],$point2[0],$point2[1],$coul);

        }
        imageLine($image,$point2[0]-$tc/2,$point2[1]-$tc/2,$point2[0]+$tc/2,$point2[1]+$tc/2,$red);
        imageLine($image,$point2[0]-$tc/2,$point2[1]+$tc/2,$point2[0]+$tc/2,$point2[1]-$tc/2,$red);
        //label des colonnes
        $taille_label=imagefontwidth($taillefont) * strlen($i+1);
        if($dif!=0){
                $j=$i-1;
                imagestring($image,$taillefont,($largeur_col*($i-1))+40+$espace_col,$hauteur-($margey),"j".$i,$black);
        }
        imagestring($image,$taillefont,($largeur_col*$i)+40+$espace_col,$hauteur-($margey),"j".$i,$black);
        imagestring($image,$taillefont,($largeur_col*$i)+40+$espace_col-(imagefontwidth($taillefont)/2),$point2[1]-15,$points[$i],$red);
        //imagestring($image,$taillefont,($largeur_col*$i)+40+$espace_col-(imagefontwidth($taillefont)/2),$point2[1]-15,$valpoint,$red);
        if($dif==0) {
                $point1[0]=$point2[0];
                $point1[1]=$point2[1];
        }
        }
        else {
                break;
        }

$i++;
}
// taille police
$titlefont = 2;
$txtsz = imagefontwidth($titlefont) * strlen($titre);
$xpos = (int)(($largeur -$margex- $txtsz)/2); // center the title
$xpos = max(1, $xpos); // force positive coordinates
$ypos = $margey/3; // distance from top
imagestring($image, $titlefont, $xpos, $ypos, $titre , $green);
//legende

if(!isset($tabLegende)){
        $tabLegende=array("legende 1","legende 2","legende 3","legende 4","legende 5","legende 6","legende 7","legende 8","legende 9","legende 10");
}
$margeLegende = 10;
$espace=30;
//on cherche la legende la plus longue
$chaine_la_plus_longue=0;
while(list($id,$chaine)=each($tabLegende)){
        if((imagefontwidth($taillefont) * strlen($chaine)) > $chaine_la_plus_longue)
        $chaine_la_plus_longue = (imagefontwidth($taillefont) * strlen($chaine));
}

//on affiche la legende
if(! isset($tabLegende2)){
        reset($tabLegende);
        while(list($id,$chaine)=each($tabLegende)){
                $num_leg=$id+1;
                imagestring($image,
                $taillefont,
                //$largeur - $chaine_la_plus_longue,
                ($largeur-$margex)+$espace,
                $margey + $id*$margeLegende,
                "$num_leg : " . "$chaine" ,
                $black);
        $tmp=$id;
        }
}



//Titre
if(!(isset($titre))){
  $titre="Titre du Graph";
}
else{
  $titre=ereg_replace("_"," ",$titre);
  $titre=ereg_replace("'","",$titre);
  $titre=ereg_replace("@","'",$titre);
}


ImagePNG($image,"../stat_presentiel/cache/$nomFic");
ImageDestroy($image);

?>