<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*---------------------------------------------------------------------------------------*/  
//  Fichier graphFormSuivi.php3
//  Action : reprsentation graphique par grille,par groupe,par stagiaire
//  Donne recue : $theme,$numcal,$groupe
/*---------------------------------------------------------------------------------------*/
// debug
//header("Content-type:image/png");
include("../dbpostgres.php3"); 
include("./lib-graphique.php");

$db = pg_Connect("$server", "", "", "", "$nombase") or die ("$ERROR_2");
/*-------------------------------------------------------------------*/
//      FONCTIONS PHP
/*-------------------------------------------------------------------*/
// fonction qui retourne la note globale sur 20 pour une grille (pour 1 formation pour un groupe ou un stagiaire)
function note_globale_grille($numcal,$numuser="",$numgrille){
        $note=0;
        if($numuser!="")
                $req="select note,notesur from comment_presentiel where num_cal='$numcal' and num_user='$numuser' and num_grille='$numgrille' and notesur<>0";
        else
                 $req="select note,notesur from comment_presentiel where num_cal='$numcal' and num_grille='$numgrille' and notesur<>0";
        $resnote=pg_query($req);
        $nbnote=pg_numrows($resnote);
        if($nbnote>0){
                for($i=0;$i<$nbnote;$i++){
                        $rownote=pg_fetch_row($resnote,$i);
                        $notesur20=($rownote[0]*20)/$rownote[1];
                        $note +=$notesur20;
                }
                return $note/$nbnote;
        }
        else
                return $note;
}

// fonction qui retourne la note globale sur 20 pour une capacite (pour 1 formation pour un groupe ou un stagiaire)
function note_globale_capacite($numcal,$numuser="",$numgrille,$numtitrecapacite,$numcapacite){
        $note=0;
        if($numuser!="")
                $req="select note,notesur from comment_presentiel where num_cal='$numcal'
                and num_user='$numuser'
                and num_grille='$numgrille'
                and num_titrecapacite='$numtitrecapacite'
                and num_capacite='$numcapacite'
                and notesur<>0";
        else
                 $req="select note,notesur from comment_presentiel where num_cal='$numcal'
                 and num_grille='$numgrille'
                 and num_titrecapacite='$numtitrecapacite' and
                 num_capacite='$numcapacite'
                 and notesur<>0";
        $resnote=pg_query($req);
        $nbnote=pg_numrows($resnote);
        if($nbnote>0){
                for($i=0;$i<$nbnote;$i++){
                        $rownote=pg_fetch_row($resnote,$i);
                        $notesur20=($rownote[0]*20)/$rownote[1];
                        $note +=$notesur20;
                }
                return $note/$nbnote;
        }
        else
                return (-1);
}
/*------------------------------------------------------------------------*/
// Fonction qui retourne le numero du jour en fonction du numero
//  de date et du numero de calendrier
/*------------------------------------------------------------------------*/
function numero_du_jour($numdate,$numcal){
    //recup des dates du calendrier
    $req="select jour from dates where num_date in (select num_date from gest_cal where numtype='3' and gnum_cal='$numcal')";
    $res=pg_query($req);
    // stockage et tri
    $nb=pg_numrows($res);
    for($i=0;$i<$nb;$i++){
        $row=pg_fetch_row($res,$i);
        $tab[]=$row[0];
    }
    sort($tab);
    for($i=0;$i<$nb;$i++){
        if($tab[$i]==$numdate)
            break;
    }
    return $i;


}
/*---------------------------------------------------------------------------------------*/
//      Affichage entete
/*---------------------------------------------------------------------------------------*/
$nompage="graphFormSuivi.php";
$titre=$MSG_1212;
$styleCSS="../style/".MY_STYLE."/ressourcesAdministratives.css";
include('../entete.php3');
//header("Content-type:image/png");
/*---------------------------------------------------------------------------------------*/
//              Fonctions javascript
/*---------------------------------------------------------------------------------------*/
print("
<script language=\"javascript\">
function validegrille(){
        document.formgrille.submit();
}
function validestagiaire(){
        document.formstag.submit();
}
function validetitre(){
        document.formtitre.submit();
}
function validecapacite(){
        document.formcapa.submit();
}
</script>
");
/*---------------------------------------------------------------------------------------*/
//      Info propres  la formation
/*---------------------------------------------------------------------------------------*/
//Nom de la formation
$resform=pg_query("select nom_cal,datedeb,datefin from calendrier where num_cal='$numcal';");
$rowform=pg_fetch_row($resform,0);
$nom_formation=$rowform[0];
//Dates de dbut et fin de formation
$resdate=pg_query("select d1.jour,d2.jour from dates d1,dates d2 where d1.num_date='$rowform[1]' and d2.num_date='$rowform[2]';");
$rowdate=pg_fetch_row($resdate,0);
//formatage date
$tabdeb=explode("-",$rowdate[0]);
$debut=formater_date($tabdeb,MY_LANG);
$tabfin=explode("-",$rowdate[1]);
$fin=formater_date($tabfin,MY_LANG);

//Nom du formateur
$resnom=pg_query("select nom,prenom from utilisateurs where num_user in
(select distinct g_num_user from gestionnaire where g_num_cal='$numcal');");
$rownom=pg_fetch_row($resnom,0);
$nom_formateur=$rownom[0];
$prenom_formateur=$rownom[1];
//Nom du groupe
$resgroupe=pg_query("select nom from classe where id='$groupe';");
$rowgroupe=pg_fetch_row($resgroupe,0);
$nom_groupe=$rowgroupe[0];

/*---------------------------------------------------------------------------------------*/
//      TABLEAU PRINCIPAL
/*---------------------------------------------------------------------------------------*/
print("
<table width=\"90%\">
<tr class=\"couleur1\">
<td align=\"center\" width=\"67%\">
");
if($grille!=""){
/*---------------------------------------------------------------------------------------*/
//      Prparation des donnes et Affichage du graphe (histogramme)
//      Stat par grille pour un groupe
/*---------------------------------------------------------------------------------------*/
// recup du nom de la grille
$req="select libelle_grille from grille where num_grille='$grille';";
$res=pg_query($req);
$row=pg_fetch_row($res,0);
$nomgrille=$row[0];
 // recup des dates du calendrier
        $req="select distinct num_date,gnum_cal from gest_cal where numtype='3' and gnum_cal in
        (select num_cal from notation where num_cal='$numcal' and num_grille='$grille')";
        $res=pg_query($req);
        $nbdate=pg_numrows($res);
        //debug
        //echo "nbdate=$nbdate<br>";
        if($nbdate>0){
        // stockage des dates et calendriers
        for($d=0;$d<$nbdate;$d++){
                $row=pg_fetch_row($res,$d);
                // recup du jour
                $resjour=pg_query("select jour from dates where num_date='$row[0]';");
                $rowjour=@pg_fetch_row($resjour,0);
                //debug
                //echo "jour=$rowjour[0] et cal=$row[1] et date=$row[0]<br>";
                $stock["$rowjour[0]"][]="$row[0],$row[1]";
        }
        // tri croissant sur les jours
        ksort($stock);
        //recup des notations par jour
        while(list($jour)=each($stock)){
                //debug
                //echo "$jour : ";
                while(list($cle2,$val)=each($stock["$jour"])){
                        $tabval=explode(",",$val);
                        $req="select notation from notation where num_cal='$tabval[1]' and num_grille='$grille'";
                        $resnote=pg_query($req);
                        $nbnote=pg_numrows($resnote);
                        $numjour=numero_du_jour($jour,$tabval[1]);
                        // les carton par jour
                        $rouge=0;
                        $orange=0;
                        $vert=0;
                        for($n=0;$n<$nbnote;$n++){
                                $rownote=pg_fetch_row($resnote,$n);
                                $tabnote=explode(",",$rownote[0]);
                                switch($tabnote[$numjour]){
                                        case 1 : $rouge +=1;
                                        break;
                                        case 2 : $orange +=1;
                                        break;
                                        case 3 : $vert +=1;
                                        break;
                                }
                        }
                        $tabjournote[]="$rouge,$orange,$vert";
                }
                //echo "<br>";

        }
        // debug
        /*
        reset($tabjournote);
        $sz=sizeof($tabjournote);
        for($s=0;$s<$sz;$s++){
                echo "$tabjournote[$s]<br>";
        }
        */
        // Paramtrage
          //$donnees[0] = array("1", "1", "1","7","0","2","0");
	//$donnees[1] = array("3", "2", "2","9","8","1","1");
	//$donnees[2] = array("1", "2", "2","3","10","0","1");
        for($d=0;$d<$nbdate;$d++){
                $tabdonnees=explode(",",$tabjournote[$d]);
                $donnees[0][]=$tabdonnees[0];
                $donnees[1][]=$tabdonnees[1];
                $donnees[2][]=$tabdonnees[2];
        }
	//$donnees[3] = array("10", "25", "43", "15", "29", "5", "14");
	//$abscisses = array("11-12-2002", "12-12-2002", "13-12-2002", "28-12-2002", "02-01-2003", "03-01-2003","04-01-2003");
        reset($stock);
         while(list($jour)=each($stock)){
                $dt=explode("-",$jour);
                $jour=formater_date($dt,MY_LANG,"y");
                $abscisses[]=$jour;
         }
         // calcul de la moyenne pour le groupe
         $notegrille=note_globale_grille($numcal,"",$grille);
        $notegrille *=100;
        $notegrille=round($notegrille);
        $notegrille /=100;
	$couleurs[0] = array("009900", "0066CC", "000000", "000000", "EEEEEE", "FFFFFF");
	$couleurs[1] = array("403015", "333333", "001530");
	$couleurs[2] = array("FF0000", "FFA500", "00FF00");
	//$options = array(2, 2, 1, 1, 1, 2);
        // debug
        $options = array(2, 2, 1, 1, 1,2);
	$legende = array("$MSG_975", "$MSG_976", "$MSG_974","$MSG_1211 : $notegrille / 20");
    //$f=$chemin_bo."stat_presentiel/test2.png";
    //debug
    /*
    echo "f=$f<br>";
    if(unlink($f))
        echo "fichier effac<br>";
    else
        echo "pas effac<br>";

    */
    // titre du graphe
    $titre="$MSG_226 : \"$nomgrille\" $MSG_682 : \"$nom_groupe\"";
    // nom du graph
    $nomgraph="calgpgri_".$numcal."-".$groupe."-".$grille.".png";
	//dessiner_graphique("histogramme", "--- Test / Prsentiel ---", "d", 600, 200, 20, 20, $options, $donnees, $legende, $abscisses, $couleurs,$nomgraph);

    dessiner_graphique("histogramme", $titre, "d", 650, 200, 20, 20, $options, $donnees, $legende, $abscisses, $couleurs,$nomgraph);

    //clearstatcache();
          print("<img src=\"cache_graph/$nomgraph\">\n");
    }
    else
        print("
        <b>$MSG_1216<b>
        ");
}
else
    print("
    <b>$MSG_2343</b>
    ");
print("
</td>
 <td align=\"center\" width=\"33%\">
");

/*---------------------------------------------------------------------------------------*/
//      Affichage info + slection grille
/*---------------------------------------------------------------------------------------*/
print("
<table border=\"0\" width=\"100%\">
<tr class=\"couleur2\">
<td><b>$MSG_635</b></td>
<td align=\"center\">$nom_formation<br>$MSG_135 $debut<br>$MSG_136 $fin</td>
</tr>
<tr class=\"couleur3\">
<td><b>$MSG_682</b></td>
<td align=\"center\">$nom_groupe</td>
</tr>
<tr class=\"couleur2\">
<td><b>$MSG_17</b></td>
<td align=\"center\">$nom_formateur</td>
</tr>
<form name=\"formgrille\">
<tr class=\"couleur3\">
<td><b>$MSG_226</b></td>
<td align=\"center\">
    <select name=\"grille\" onchange=\"validegrille();\">
    <option value=\"\">$MSG_845</option>
    ");
    // recup des grilles
    $resgrille=pg_query("select * from grille where num_grille in (select distinct num_grille from notation where num_cal='$numcal');");
    $nbgrille=pg_numrows($resgrille);
    for($i=0;$i<$nbgrille;$i++){
        $rowgrille=pg_fetch_row($resgrille,$i);
        if($rowgrille[0]==$grille)
            print("
            <option value=\"$rowgrille[0]\" selected>$rowgrille[1]</option>
            ");
        else
            print("
            <option value=\"$rowgrille[0]\">$rowgrille[1]</option>
            ");
    }

    print("
    </select>
    <input type=\"hidden\" name=\"theme\" value=\"$theme\">
    <input type=\"hidden\" name=\"numcal\" value=\"$numcal\">
    <input type=\"hidden\" name=\"groupe\" value=\"$groupe\">

</td>
</tr>
</form>
");
// calcul des % de carton vert orange et rouge
if($grille!=""){
print("
<tr class=\"couleur2\">
<td><b>$MSG_1215</b></td>
<td align=\"center\">
");
//recup des cartons rouge orange vert
$r=0;
$o=0;
$v=0;
$total_carton=0;
$tabrov=array();
//debug
//echo "nbdate=$nbdate<br>";
for($j=0;$j<$nbdate;$j++){
        $tabrov=explode(",",$tabjournote[$j]);
        $r+=$tabrov[0];
        $o+=$tabrov[1];
        $v+=$tabrov[2];
}
$total_carton=$r+$o+$v;
$pourcent_rouge=$r/$total_carton;
$pourcent_rouge*=100;
$pourcent_rouge=round($pourcent_rouge);
$pourcent_orange=$o/$total_carton;
$pourcent_orange*=100;
$pourcent_orange=round($pourcent_orange);
$pourcent_vert=$v/$total_carton;
$pourcent_vert*=100;
$pourcent_vert=round($pourcent_vert);
print("
<table border=\"0\">
<tr>
    <td><font size=\"1\">
        <img width=\"20\" height=\"20\" src=\"../images/cartr.gif\" align=\"absmiddle\"> $pourcent_rouge %<br>
        <img width=\"20\" height=\"20\" src=\"../images/carto.gif\" align=\"absmiddle\"> $pourcent_orange %<br>
        <img width=\"20\" height=\"20\" src=\"../images/cartv.gif\" align=\"absmiddle\"> $pourcent_vert %
        </font>
    </td>
</tr>
</table>
</td>
</tr>
");
}
print("
</table>
</td></tr>
");
if($grille!=""){
// a suivre grille pour un stagiaire ...
print("
<tr class=\"couleur1\">
<td align=\"center\">
");
/*---------------------------------------------------------------------------------------*/
//      Prparation des donnes et Affichage du graphe (histogramme)
//      Stat par grille pour un stagiaire
/*---------------------------------------------------------------------------------------*/

if($stagiaire!=""){
// recup nom et prenom stagiaire
$req="select nom,prenom from utilisateurs where num_user='$stagiaire'";
$resstag=pg_query($req);
$rowstag=pg_fetch_row($resstag,0);
$nomstagiaire=$rowstag[0];
$prenomstagiaire=$rowstag[1];
 // recup des dates du calendrier
        $req="select distinct num_date,gnum_cal from gest_cal where numtype='3' and gnum_cal in
        (select num_cal from notation where num_cal='$numcal' and num_grille='$grille' and num_user='$stagiaire')";
        $res=pg_query($req);
        $nbdate=pg_numrows($res);
        if($nbdate>0){
        // debug
        //echo "nbdate=$nbdate<br>";
          // stockage des dates et calendriers
        $stock=array();
        for($d=0;$d<$nbdate;$d++){
                $row=pg_fetch_row($res,$d);
                // recup du jour
                $resjour=pg_query("select jour from dates where num_date='$row[0]';");
                $rowjour=pg_fetch_row($resjour,0);
                //debug
                //echo "jour=$rowjour[0] et cal=$row[1] et date=$row[0]<br>";
                $stock["$rowjour[0]"][]="$row[0],$row[1]";
        }
        // tri croissant sur les jours
        ksort($stock);
        //recup des notations par jour
          $tabjournote=array();
        while(list($jour)=each($stock)){
                //debug
                //echo "$jour : ";
                                $tabnote=array();
                while(list($cle2,$val)=each($stock["$jour"])){
                        $tabval=explode(",",$val);
                        $req="select notation from notation where num_cal='$tabval[1]' and num_grille='$grille' and num_user='$stagiaire'";
                        $resnote=pg_query($req);
                        $nbnote=pg_numrows($resnote);
                        $numjour=numero_du_jour($jour,$tabval[1]);
                        // les carton par jour
                        $rouge=0;
                        $orange=0;
                        $vert=0;
                                               for($n=0;$n<$nbnote;$n++){
                                $rownote=pg_fetch_row($resnote,$n);
                                $tabnote=explode(",",$rownote[0]);
                                switch($tabnote[$numjour]){
                                        case 1 : $rouge +=1;
                                        break;
                                        case 2 : $orange +=1;
                                        break;
                                        case 3 : $vert +=1;
                                        break;
                                }
                        }
                        $tabjournote[]="$rouge,$orange,$vert";
                }
                //echo "<br>";

        }
        // debug
        /*
        reset($tabjournote);
        $sz=sizeof($tabjournote);
        for($s=0;$s<$sz;$s++){
                echo "$tabjournote[$s]<br>";
        }
        */
        // Paramtrage
          //$donnees[0] = array("1", "1", "1","7","0","2","0");
	//$donnees[1] = array("3", "2", "2","9","8","1","1");
	//$donnees[2] = array("1", "2", "2","3","10","0","1");
        $donnees=array();
        for($d=0;$d<$nbdate;$d++){
                $tabdonnees=explode(",",$tabjournote[$d]);
                $donnees[0][]=$tabdonnees[0];
                $donnees[1][]=$tabdonnees[1];
                $donnees[2][]=$tabdonnees[2];
        }
	//$donnees[3] = array("10", "25", "43", "15", "29", "5", "14");
	//$abscisses = array("11-12-2002", "12-12-2002", "13-12-2002", "28-12-2002", "02-01-2003", "03-01-2003","04-01-2003");
        reset($stock);
        $abscisses=array();
         while(list($jour)=each($stock)){
                $dt=explode("-",$jour);
                $jour=formater_date($dt,MY_LANG,"y");
                $abscisses[]=$jour;
         }
           // calcul de la moyenne pour le stagiaire
         $notegrille=note_globale_grille($numcal,$stagiaire,$grille);
        $notegrille *=100;
        $notegrille=round($notegrille);
        $notegrille /=100;
	$couleurs[0] = array("009900", "0066CC", "000000", "000000", "EEEEEE", "FFFFFF");
       // $couleurs[0] = array("009900", "0066CC", "000000", "ff0000", "EEEEEE", "FFFFFF");
	$couleurs[1] = array("403015", "333333", "001530");
	$couleurs[2] = array("FF0000", "FFA500", "00FF00");
	$options = array(2, 2, 1, 1, 1, 2);
	$legende = array("$MSG_975", "$MSG_976", "$MSG_974","$MSG_1211 : $notegrille / 20");
    //$f=$chemin_bo."stat_presentiel/test2.png";
    //debug
    /*
    echo "f=$f<br>";
    if(unlink($f))
        echo "fichier effac<br>";
    else
        echo "pas effac<br>";

    */
    // titre du graphe
    $titre="$MSG_226 : \"$nomgrille\" $MSG_2324 : \"$nomstagiaire $prenomstagiaire\"";
    // nom du graph
    $nomgraph="calgpgri_".$numcal."-".$groupe."-".$grille."-".$stagiaire.".png";
	//dessiner_graphique("histogramme", "--- Test / Prsentiel ---", "d", 600, 200, 20, 20, $options, $donnees, $legende, $abscisses, $couleurs,$nomgraph);
    dessiner_graphique("histogramme", $titre, "d", 650, 200, 20, 20, $options, $donnees, $legende, $abscisses, $couleurs,$nomgraph);
    //clearstatcache();
          print("<img src=\"cache_graph/$nomgraph\">\n");
    }
    else
        print("
        <b>$MSG_1217</b>
        ");
}
else
        print("
        <b>$MSG_2386</b>
        ");

print("
</td>
 <td align=\"center\" width=\"33%\">
");
/*---------------------------------------------------------------------------------------*/
//      Slection stagiaire
/*---------------------------------------------------------------------------------------*/
print("
<table border=\"0\" width=\"100%\">
<tr class=\"couleur2\">
<td><b>$MSG_635</b></td>
<td align=\"center\">$nom_formation<br>$MSG_135 $debut<br>$MSG_136 $fin</td>
</tr>
<tr class=\"couleur3\">
<td><b>$MSG_682</b></td>
<td align=\"center\">$nom_groupe</td>
</tr>
<tr class=\"couleur2\">
<td><b>$MSG_17</b></td>
<td align=\"center\">$nom_formateur</td>
</tr>
<tr class=\"couleur3\">
<td><b>$MSG_226</b></td>
<td align=\"center\">$nomgrille</td>
</tr>
<form name=\"formstag\">
<tr class=\"couleur2\">
<td><b>$MSG_2324</b></td>
<td align=\"center\">
    <select name=\"stagiaire\" onchange=\"validestagiaire();\">
    <option value=\"\">$MSG_2387</option>
    ");
    // recup des stagiaires (ds la table notation) pour cette formation
    $req="select num_user,nom,prenom from utilisateurs where num_user in (select num_user from notation where num_cal='$numcal')";
    $resuser=pg_query($req);
    $nbuser=pg_numrows($resuser);
    for($s=0;$s<$nbuser;$s++){
            $rowuser=pg_fetch_row($resuser,$s);
            if($rowuser[0]==$stagiaire)
                    print("
                    <option value=\"$rowuser[0]\" selected>$rowuser[2] $rowuser[1]</option>
                    ");
            else
                    print("
                    <option value=\"$rowuser[0]\">$rowuser[2] $rowuser[1]</option>
                    ");
    }
    print("
    </select>
    <input type=\"hidden\" name=\"theme\" value=\"$theme\">
    <input type=\"hidden\" name=\"numcal\" value=\"$numcal\">
    <input type=\"hidden\" name=\"groupe\" value=\"$groupe\">
    <input type=\"hidden\" name=\"grille\" value=\"$grille\">
    <input type=\"hidden\" name=\"titrecapacite\" value=\"$titrecapacite\">
    <input type=\"hidden\" name=\"capacite\" value=\"$capacite\">

</td>
</tr>
</form>
");
// calcul des % de carton vert orange et rouge
if($grille!="" && $stagiaire!="" && $nbdate>0){
print("
<tr class=\"couleur3\">
<td><b>$MSG_1215</b></td>
<td align=\"center\">
");
//recup des cartons rouge orange vert
$r=0;
$o=0;
$v=0;
$total_carton=0;
$tabrov=array();
//debug
//echo "nbdate=$nbdate<br>";
for($j=0;$j<$nbdate;$j++){
        $tabrov=explode(",",$tabjournote[$j]);
        $r+=$tabrov[0];
        $o+=$tabrov[1];
        $v+=$tabrov[2];
}
$total_carton=$r+$o+$v;
$pourcent_rouge=$r/$total_carton;
$pourcent_rouge*=100;
$pourcent_rouge=round($pourcent_rouge);
$pourcent_orange=$o/$total_carton;
$pourcent_orange*=100;
$pourcent_orange=round($pourcent_orange);
$pourcent_vert=$v/$total_carton;
$pourcent_vert*=100;
$pourcent_vert=round($pourcent_vert);
print("
<table border=\"0\">
<tr>
<td>
    <font size=\"1\">
    <img width=\"20\" height=\"20\" src=\"../images/cartr.gif\" align=\"absmiddle\"> $pourcent_rouge %<br>
    <img width=\"20\" height=\"20\" src=\"../images/carto.gif\" align=\"absmiddle\"> $pourcent_orange %<br>
    <img width=\"20\" height=\"20\" src=\"../images/cartv.gif\" align=\"absmiddle\"> $pourcent_vert %
    </font>
</td>
</tr>
</table>
</td>
</tr>
");
}
print("
</table>
</td></tr>
");
print("
<tr class=\"couleur1\">
<td align=center>
");
/*---------------------------------------------------------------------------------------*/
//      Prparation des donnes et Affichage du graphe linaire
//      Stat par capacit pour le groupe
/*---------------------------------------------------------------------------------------*/
if($titrecapacite!="")
        if($capacite!=""){
                if($nbdate>0){
               // recup des dates et notes du groupe
                $req="select num_date,note,notesur from comment_presentiel where num_cal='$numcal'
                and num_grille='$grille'
                and num_titrecapacite='$titrecapacite'
                and num_capacite='$capacite'
                and notesur<>'0' order by num_date";
                $resnote=pg_query($req);
                $nbnote=pg_numrows($resnote);
                // debug
                //echo "nbnote=$nbnote et nbdate=$nbdate<br>";
                // stockage
                $tab=array();
                for($i=0;$i<$nbnote;$i++){
                        $rownote=pg_fetch_row($resnote,$i);
                        //ramne la note sur 20
                        $note=($rownote[1]*20)/$rownote[2];
                        //arrondi
                        $note*=100;
                        $note=round($note);
                        $note/=100;
                        //$ind=$rownote[0]++;
                        $ind=$rownote[0];
                        //$tab[$rownote[0]][]=$note;
                        $tab["$ind"][]=$note;

                }
                ksort($tab);
                // moyenne par date
                $tabmoy=array();
                $points=array();
                $points[0]=0;
                $couleur_ligne=array();
                $couleur_ligne[]=0;
                //essai
                /*
                $couleur_ligne[]=0;
                 $couleur_ligne[]=0;
                  $couleur_ligne[]=1;
                   $couleur_ligne[]=2;
                  */

                // debug
                reset($tab);
                while(list($cle,$val)=each($tab)){
                        //echo "<br>cle=$cle<br>";
                        $sz=sizeof($tab["$cle"]);
                        //$sz=sizeof($tab);
                        //echo "sz=$sz<br>";
                        $moyenne=(array_sum($tab["$cle"]))/$sz;
                        //$moyenne=(array_sum($tab))/$sz;
                        /*
                        while(list($cle1,$valeur)=each($tab["$cle"])){
                                echo "cle1=$cle1 et valeur=$valeur - ";
                        }
                        */
                        // on arrondi la moyenne
                        $moyenne*=100;
                        $moyenne=round($moyenne);
                        $moyenne/=100;
                        $tabmoy[]=$moyenne;
                        $ind=$cle+1;
                        $points[$ind]=$moyenne;
                        // association des couleurs en fonction de la moyenne
                        //$couleur_ligne=array();
                        if($moyenne>=15)
                                $couleur_ligne[$ind]=2; //vert
                        else
                                if($moyenne<=10)
                                        $couleur_ligne[$ind]=0; // rouge
                                else
                                        $couleur_ligne[$ind]=1; // orange
                }
                //debug
                /*
                  $taille=sizeof($points);
               while(list($index,$valeur)=each($points)){
                        echo "index=$index et valeur=$valeur<br>";
               }
               */
                reset($points);
                //essai affichage
                //$nomFic="$user"."_$num_qcm".".png";
                $nomFic="calgpcapa_".$numcal."-".$groupe."-".$grille."-".$titrecapacite."-".$capacite.".png";
                //recup du nom de la capacite
                $req="select libelle_capacite from capacite where num_capacite='$capacite'";
                $rescapa=pg_query($req);
                $rowcapa=pg_fetch_row($rescapa,0);
                $titre="$MSG_220 : \"$rowcapa[0] \" $MSG_682 : $nom_groupe";
                $largeur=650;
                $tabLegende=array();

                $tabLegende[]="$MSG_226 : ".$nomgrille;
                $tabLegende[]="Titre : A suivre ...";
                $tabLegende[]="";
                $moyenne_capa=note_globale_capacite($numcal,"",$grille,$titrecapacite,$capacite);
                if($moyenne_capa>=0){
                        $moyenne_capa*=100;
                        $moyenne_capa=round($moyenne_capa);
                        $moyenne_capa/=100;
                        $tabLegende[]="$MSG_1211 : $moyenne_capa / 20";
                }
                else
                         $tabLegende[]="$MSG_1211 : $MSG_1218";
                include('./Graph.php');
                print("<img src=\"cache/$nomFic\">\n");
                }
                else
                        print("
                         <b>$MSG_1219</b>
                         ");

        }
        else
                print("
                <b>$MSG_2344</b>
                ");
else
        print("
        <b>$MSG_216</b>
        ");
print("
</td>
<td align=\"center\" width=\"33%\">
");
/*---------------------------------------------------------------------------------------*/
//      Slection titrecapacit et capacit
/*---------------------------------------------------------------------------------------*/
// A suivre
print("
<table border=\"0\" width=\"100%\">
<form name=\"formtitre\">
<tr class=\"couleur2\">
<td><b>$MSG_219</b></td>
<td>

    <select name=\"titrecapacite\" onchange=\"validetitre();\">
    <option value=\"\">$MSG_846</option>
    ");
    // recup des titre de capacite pour cette formation,catte grille,ce stagiaire
    $req="select * from titrecapacite where num_titrecapacite in (select num_titrecapacite from comment_presentiel where num_cal='$numcal' and num_grille='$grille' and notesur <>'0')";
    $restitre=pg_query($req);
    $nbtitre=pg_numrows($restitre);
    for($t=0;$t<$nbtitre;$t++){
            $rowtitre=pg_fetch_row($restitre,$t);
            if($rowtitre[0]==$titrecapacite)
                    print("
                    <option value=\"$rowtitre[0]\" selected>$rowtitre[1]</option>
                    ");
            else
                    print("
                    <option value=\"$rowtitre[0]\">$rowtitre[1]</option>
                    ");

    }
    print("
    </select>
    <input type=\"hidden\" name=\"theme\" value=\"$theme\">
    <input type=\"hidden\" name=\"numcal\" value=\"$numcal\">
    <input type=\"hidden\" name=\"groupe\" value=\"$groupe\">
    <input type=\"hidden\" name=\"grille\" value=\"$grille\">
    <input type=\"hidden\" name=\"stagiaire\" value=\"$stagiaire\">
    <input type=\"hidden\" name=\"nomstagiaire\" value=\"$nomstagiaire\">
    <input type=\"hidden\" name=\"prenomstagiaire\" value=\"$prenomstagiaire\">

</td>
</tr>
</form>
");
// selection capacite
print("

<tr class=\"couleur3\">
<form name=\"formcapa\">
<td><b>$MSG_220</b></td>
<td align=\"center\">
    <select name=\"capacite\" onchange=\"validecapacite();\">
    <option value=\"\">$MSG_2344</option>
    ");
    // recup des titre de capacite pour cette formation,catte grille,ce stagiaire
    $req="select * from capacite where num_capacite in
    (select num_capacite from comment_presentiel where num_cal='$numcal' and num_grille='$grille'
    and num_titrecapacite='$titrecapacite' and notesur <>'0')";
    $restitre=pg_query($req);
    $nbtitre=pg_numrows($restitre);
    for($t=0;$t<$nbtitre;$t++){
            $rowtitre=pg_fetch_row($restitre,$t);
            if($rowtitre[0]==$capacite)
                    print("
                    <option value=\"$rowtitre[0]\" selected>$rowtitre[1]</option>
                    ");
            else
                    print("
                    <option value=\"$rowtitre[0]\">$rowtitre[1]</option>
                    ");

    }
    print("
    </select>
    <input type=\"hidden\" name=\"theme\" value=\"$theme\">
    <input type=\"hidden\" name=\"numcal\" value=\"$numcal\">
    <input type=\"hidden\" name=\"groupe\" value=\"$groupe\">
    <input type=\"hidden\" name=\"grille\" value=\"$grille\">
    <input type=\"hidden\" name=\"stagiaire\" value=\"$stagiaire\">
    <input type=\"hidden\" name=\"titrecapacite\" value=\"$titrecapacite\">
</td>
</tr>
</form>
");
if($capacite!=""){
print("
<tr class=\"couleur2\">
<td><b>$MSG_1215</b></td>
<td align=\"center\">
");
// recup des cartons pour la capacite pour le groupe
//$req="select notation from notation where num_cal='$numcal' and num_grille='$grille' and
  $req="select notation from notation where num_cal='$numcal'
        and num_grille='$grille'
        and num_titrecapacite='$titrecapacite'
        and num_capacite='$capacite'";
        $resnotation=pg_query($req);
        $nbnotation=pg_numrows($resnotation);
        if($nbnotation>0){
        $r=0;
        $o=0;
        $v=0;
        $total_carton=0;
        //debug
        //echo "nbnotation=$nbnotation<br>";
        for($n=0;$n<$nbnotation;$n++){
                $tabrov=array();
                $rownotation=pg_fetch_row($resnotation,$n);
                //echo "rownotation=$rownotation[0]<br>";
                $tabrov=explode(",",$rownotation[0]);
                $sz=sizeof($tabrov);
                for($s=0;$s<$sz;$s++){
                        switch($tabrov[$s]){
                                case 1 : $r+=1;
                                break;
                                case 2 : $o+=1;
                                break;
                                case 3 : $v+=1;
                                break;
                        }
                }
        }
        $total_carton=$r+$o+$v;
        //echo "total_carton=$total_carton<br>";
        $pourcent_rouge=$r/$total_carton;
        $pourcent_rouge*=100;
        $pourcent_rouge=round($pourcent_rouge);
        $pourcent_orange=$o/$total_carton;
        $pourcent_orange*=100;
        $pourcent_orange=round($pourcent_orange);
        $pourcent_vert=$v/$total_carton;
        $pourcent_vert*=100;
        $pourcent_vert=round($pourcent_vert);
print("
<table border=\"0\">
<tr>
<td>
    <font size=\"1\">
    <img width=\"20\" height=\"20\" src=\"../images/cartr.gif\" align=\"absmiddle\"> $pourcent_rouge %<br>
    <img width=\"20\" height=\"20\" src=\"../images/carto.gif\" align=\"absmiddle\"> $pourcent_orange %<br>
    <img width=\"20\" height=\"20\" src=\"../images/cartv.gif\" align=\"absmiddle\"> $pourcent_vert %
    </font>
</td>
</tr>
</table>
");
}
}
print("
&nbsp;</td>
</tr>

</table>
</td></tr>
");
if($stagiaire!="" && $capacite!="" ){
        if( $nbdate>0){
        print("
         <tr class=\"couleur1\">
        <td>
        ");
         // recup des dates et notes du stagiaire pour la capacite
                $req="select num_date,note,notesur from comment_presentiel where num_cal='$numcal'
                and num_grille='$grille'
                and num_user='$stagiaire'
                and num_titrecapacite='$titrecapacite'
                and num_capacite='$capacite'
                and notesur<>'0' order by num_date";
                $resnote=pg_query($req);
                $nbnote=pg_numrows($resnote);
                // debug
                //echo "nbnote=$nbnote et nbdate=$nbdate<br>";
                // stockage
                $tab=array();
                //$tab[0][]=0;
                for($i=0;$i<$nbnote;$i++){
                        $rownote=pg_fetch_row($resnote,$i);
                        //ramne la note sur 20
                        $note=($rownote[1]*20)/$rownote[2];
                        //arrondi
                        $note*=100;
                        $note=round($note);
                        $note/=100;
                        //$ind=$rownote[0]++;
                        $ind=$rownote[0];
                        //$tab["$rownote[0]"][]=$note;
                        $tab["$ind"]=$note;

                }
                ksort($tab);
                // moyenne par date
                $tabmoy=array();
                $points=array();
                $points[0]=0;
                $couleur_ligne=array();
                $couleur_ligne[]=0;
                //essai
                /*
                $couleur_ligne[]=0;
                 $couleur_ligne[]=0;
                  $couleur_ligne[]=1;
                   $couleur_ligne[]=2;
                  */

                // debug
                reset($tab);
                while(list($cle,$val)=each($tab)){
                        //echo "<br>cle=$cle<br>";
                        $sz=sizeof($tab["$cle"]);
                        //$moyenne=(array_sum($tab["$cle"]))/$sz;
                        $moyenne=$val;
                        //echo "moy=$moyenne - ";
                        /*
                        while(list($cle1,$valeur)=each($tab["$cle"])){
                                echo "cle1=$cle1 et valeur=$valeur - ";
                        }
                        */
                        // on arrondi la moyenne
                        $moyenne*=100;
                        $moyenne=round($moyenne);
                        $moyenne/=100;
                        $tabmoy[]=$moyenne;
                        $ind=$cle+1;
                        //echo "ind=$ind<br>";

                        $points[$ind]=$moyenne;
                        // association des couleurs en fonction de la moyenne
                        //$couleur_ligne=array();
                        if($moyenne>=15)
                                $couleur_ligne[$ind]=2; //vert
                        else
                                if($moyenne<=10)
                                        $couleur_ligne[$ind]=0; // rouge
                                else
                                        $couleur_ligne[$ind]=1; // orange
                }
                //debug
                /*
                $taille=sizeof($points);
               while(list($index,$valeur)=each($points)){
                        echo "index=$index et valeur=$valeur<br>";
               }
               */
                 reset($points);
                //essai affichage
                //$nomFic="$user"."_$num_qcm".".png";
                $nomFic="calgpcapa_".$numcal."-".$groupe."-".$grille."-".$titrecapacite."-".$capacite."-".$stagiaire.".png";
                //recup du nom de la capacite
                $req="select libelle_capacite from capacite where num_capacite='$capacite'";
                $rescapa=pg_query($req);
                $rowcapa=pg_fetch_row($rescapa,0);
                $titre="$MSG_220 : \"$rowcapa[0] \" $MSG_2324 : $nomstagiaire";
                $largeur=650;
                $tabLegende=array();
                $tabLegende[]="$MSG_226 : ".$nomgrille;
                $tabLegende[]="Titre : A suivre ...";
                $tabLegende[]="";
                $moyenne_capa=note_globale_capacite($numcal,$stagiaire,$grille,$titrecapacite,$capacite);
                if($moyenne_capa>=0){
                        $moyenne_capa*=100;
                        $moyenne_capa=round($moyenne_capa);
                        $moyenne_capa/=100;
                        $tabLegende[]="$MSG_1211 : $moyenne_capa / 20";
                }
                else
                        $tabLegende[]="$MSG_1211 : $MSG_1218";
                include('./Graph.php');
                print("<img src=\"cache/$nomFic\">\n");


        print("
        </td>
        <td align=\"center\" width=\"33%\">
        <table border=\"0\" width=\"100%\">
        <tr class=\"couleur2\">
        <td><b>$MSG_635</b></td>
        <td align=\"center\">$nom_formation<br>$MSG_135 $debut<br>$MSG_136 $fin</td>
        </tr>
        <tr class=\"couleur3\">
        <td><b>$MSG_682</b></td>
        <td align=\"center\">$nom_groupe</td>
        </tr>
        <tr class=\"couleur2\">
        <td><b>$MSG_17</b></td>
        <td align=\"center\">$nom_formateur</td>
        </tr>
        <tr class=\"couleur3\">
        <td><b>$MSG_226</b></td>
        <td align=\"center\">$nomgrille</td>
        </tr>
        <tr class=\"couleur2\">
        <td><b>$MSG_2324</b></td>
        <td align=\"center\">$prenomstagiaire $nomstagiaire</td>
        </tr>
        <tr class=\"couleur3\">
        <td><b>$MSG_1215</b></td>
        <td align=\"center\">
        ");
        // recup des cartons pour la capa pour le stagiaire
        $req="select notation from notation where num_cal='$numcal'
        and num_grille='$grille'
        and num_user='$stagiaire'
        and num_titrecapacite='$titrecapacite'
        and num_capacite='$capacite'";
        $resnotation=pg_query($req);
        $nbnotation=pg_numrows($resnotation);
        if($nbnotation>0){
        $r=0;
        $o=0;
        $v=0;
        $total_carton=0;
        //debug
        //echo "nbnotation=$nbnotation<br>";
        for($n=0;$n<$nbnotation;$n++){
                $tabrov=array();
                $rownotation=pg_fetch_row($resnotation,$n);
                //echo "rownotation=$rownotation[0]<br>";
                $tabrov=explode(",",$rownotation[0]);
                $sz=sizeof($tabrov);
                for($s=0;$s<$sz;$s++){
                        switch($tabrov[$s]){
                                case 1 : $r+=1;
                                break;
                                case 2 : $o+=1;
                                break;
                                case 3 : $v+=1;
                                break;
                        }
                }
        }
        $total_carton=$r+$o+$v;
        //echo "total_carton=$total_carton<br>";
        $pourcent_rouge=$r/$total_carton;
        $pourcent_rouge*=100;
        $pourcent_rouge=round($pourcent_rouge);
        $pourcent_orange=$o/$total_carton;
        $pourcent_orange*=100;
        $pourcent_orange=round($pourcent_orange);
        $pourcent_vert=$v/$total_carton;
        $pourcent_vert*=100;
        $pourcent_vert=round($pourcent_vert);
print("
<table border=\"0\">
<tr>
<td>
    <font size=\"1\">
    <img width=\"20\" height=\"20\" src=\"../images/cartr.gif\" align=\"absmiddle\"> $pourcent_rouge %<br>
    <img width=\"20\" height=\"20\" src=\"../images/carto.gif\" align=\"absmiddle\"> $pourcent_orange %<br>
    <img width=\"20\" height=\"20\" src=\"../images/cartv.gif\" align=\"absmiddle\"> $pourcent_vert %
    </font>
</td>
</tr>
</table>
");
}
}
        // debug
        //echo "nbdate=$nbdate<br>";
        print("
        </td>
        </tr>
        </table>
        </td>
        </tr>

        ");
}
}       // FIN IF($GRILLE!="")
print("
</table><br>");
print("<a class=\"retour\" href=\"lstFormSuivi.php?theme=$theme\">$MSG_37</a><br>");

include('../piedpage.php3');
?>
