<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/
                                                                
//<!--<script language="php">-->
/* ========================================================
				[ Librairie graphique ]

					BICHLER Olivier
					  03/06/2001

			http://www.guidewebmaster.net
			<webmaster@guidewebmaster.net>

		Pour tout bug, merci de me contacter !
======================================================== */

/*
	Les couleurs, valables pour tous les graphiques, rassembles dans le tableau $couleurs[0]
		[0] = Couleur titre
		[1] = Couleur pied
		[2] = Couleur texte
		[3] = Couleur de premier-plan (lignes...)
		[4] = Couleur de second-plan du graphique (except pour le camembert)
		[5] = Couleur d'arrre-plan (fond...)
		[6] = Couleur des lignes des ordonnes

	/!\ Pour bien comprendre les options possibles des graphiques, je vous conseil d'essayer les 3 exemples fournis avec le script !
*/

function ajoute_hexcouleur(&$img, $couleur) {
	$rouge = HexDec(substr($couleur, 0, 2));
	$vert = HexDec(substr($couleur, 2, 2));
	$bleu = HexDec(substr($couleur, 4, 2));

	return ImageColorAllocate($img, $rouge, $vert, $bleu);
}

function dessiner_degrade($x, $deb_couleur, $fin_couleur, $gamma_facteur, $nb_couleurs) {
	/*
		--- Dessin d'un dgrad ---
			=> Requis : librairie GD, PHP 4 et ventuellement les fonctions graphiques, du mme auteur.
		Version : 28/05/2001
		Auteur : BICHLER Olivier - http://www.guidewebmaster.net - <webmaster@guidewebmaster.net>
		Arguments :
		- La largeur du dgrad en pixels (la hauteur est toujours de 1 pixel,  vous de la redimensionner par la suite).
		- La couleur du dbut du dgrad. Ex: $deb_couleur = "990000";
		- La couleur de fin du dgrad (peut tre plus fonc que celle du dbut). Ex: $fin_couleur = "FF0000";
		- La correction gamma (> 1 = plus clair). Ex: $gamma_facteur = 2;
		- Le nombre de couleurs qui doivent composer le dgrad (peut tre utile si vous dsirez gagner de la place par exemple). Ex: $nb_couleurs = 256;
		Au final, la fonction retourne l'image du dgrad.
	*/

	/* Dbut */
	$rouge[0] = HexDec(substr($deb_couleur, 0, 2));
	$vert[0] = HexDec(substr($deb_couleur, 2, 2));
	$bleu[0] = HexDec(substr($deb_couleur, 4, 2));

	/* Fin */
	$rouge[1] = HexDec(substr($fin_couleur, 0, 2));
	$vert[1] = HexDec(substr($fin_couleur, 2, 2));
	$bleu[1] = HexDec(substr($fin_couleur, 4, 2));

	$histo = imagecreatetruecolor($x, 1);
	$increment = (($x / $nb_couleurs) < 1) ? 1 : ($x / $nb_couleurs);
	$unite_rouge = ($rouge[1] - $rouge[0]) / $x;
	$unite_vert = ($vert[1] - $vert[0]) / $x;
	$unite_bleu = ($bleu[1] - $bleu[0]) / $x;

	for ($i = 0; $i < $x; $i+= $increment) {
		$rouge[2] = $rouge[0] + $i * $unite_rouge;
		$vert[2] = $vert[0] + $i * $unite_vert;
		$bleu[2] = $bleu[0] + $i * $unite_bleu;

		$histo_couleur = imagecolorallocate($histo, round($rouge[2]), round($vert[2]), round($bleu[2]));
		imageline($histo, $i, 0, $i * $increment, 0, $histo_couleur);
	}

	imagegammacorrect($histo, 1, $gamma_facteur);
	return $histo;
}

function dessiner_histogramme($x, $y, $bx, $by, $options, $donnees, $abscisses, $couleurs) {
	/*
		--- Dessin d'un histogramme ---
			=> Requis : librairie GD, PHP 4 et les fonctions graphiques, du mme auteur.
		Version : 28/05/2001
		Auteur : BICHLER Olivier - http://www.guidewebmaster.net - <webmaster@guidewebmaster.net>
			Inspir du script Les Visiteurs, de J-Pierre DEZELUS <jpdezelus@phpinfo.net>
		Arguments :
		- La hauteur du graphique en pixels.
		- La largeur en pixels.
		- La bordure de gauche.
		- La bordure du bas.
		- Les options : sous la forme d'un tableau avec
			[1] = Taille legende
			[2] = Taille axes
			[3] = Taille valeurs
			[4] =	"0" = Pas de valeurs
					"1" = Valeurs  l'horizontal
					"2" = Valeurs  la vertical
			[5] = correction gamma pour les dgrads
			Ex: $options = array('', 2, 1, 1, 2, 2);
		- Les donnes du graphique sous forme d'un tableau ou plusieurs tableaux. Ex:
			$donnees[0] = array(62, 20, 3);
			$donnees[1] = array(85, 12, 1);
			$donnees[0] correspond  une srie et $donnees[1] correspond  une deuxime srie. Il y aura donc deux barres par abscisses, soit 6 barres en tout.
		- L'tiquette des abscisses sous forme d'un tableau. Ex: $abscisses = array("Internet Explorer", "Netscape", "Autre");
		- Le titre du graphique. Ex: $titre = "Les navigateurs";
		- Les couleurs, sous forme d'un tableau dans 2 tableaux. Ex:
			$couleurs[1] = array("990000", "009900", "000099");
			$couleurs[2] = array("FF0000", "00FF00", "0000FF");
			$couleurs[1] comprend les couleurs de dpart et $couleurs[2] celles d'arriv. C'est ainsi que les histogrammes peuvent tre en dgrad et que l'on peut mettre en vidence la plus petite et la plus grande valeur.
		Au final, la fonction affiche l'image.
		PS: J'avoue que tous ces paramtres sont pas vidents  comprendre tout de suite, mais un histogramme est complexe et grce  ces nombreuses options on peut dj bien personnaliser le graphique.
	*/

	$nb_series = sizeof($donnees);
	$nb_barres = sizeof($donnees[0]);
	$deb_couleurs = $couleurs[1];
	$fin_couleurs = $couleurs[2];

	/* Valeur(s) maximum(s) et minimum(s) */
	$valeur_max = 0;
	for ($i = 0; $i < $nb_series; $i++) {
		$val_max[$i] = 0;
		$val_min[$i] = 0;
		for ($j = 0; $j < $nb_barres; $j++) {
			if ($donnees[$i][$j] > $val_max[$i]) {
				$val_max[$i] = $donnees[$i][$j];
			}

			if ($donnees[$i][$j] < $val_min[$i] || $val_min[$i] < 1) {
				$val_min[$i] = $donnees[$i][$j];
			}

			if ($donnees[$i][$j] > $valeur_max) {
				$valeur_max = abs($donnees[$i][$j]);
			}
		}
	}

	$bx2 = (strlen($valeur_max) + 4) * imagefontwidth($options2[1]) + 2;
	$bx = ($bx2 > ($bx + 4 * imagefontwidth($options[1]))) ? $bx2 : $bx;

    

	/* Calcul de l'chelle */
	if ($options[4] == 1) {
		$marge_valeur = imagefontheight($options[3]);
	}
	elseif ($options[4] == 2) {
		$marge_valeur = imagefontwidth($options[3]) * strlen($valeur_max);
	}

	$hauteur_unite = ($y - ($by)) / 4;
	$largeur_unite = ($x - ($bx + $nb_barres * 4 + 5)) / $nb_barres;
	$largeur_barre = ($x - ($bx + $nb_barres * 4 + 5)) / $nb_barres / $nb_series;
	$unite = (double) floor(ceil(($valeur_max + ($valeur_max * $marge_valeur / $hauteur_unite / 2)) / 10) * 2.5);

	/* Cration de l'image et dfinitions des couleurs */
	$img = imagecreatetruecolor($x, $y);
	$img_couleurs["texte"] = ajoute_hexcouleur($img, $couleurs[0][2]);
	$img_couleurs["premier_plan"] = ajoute_hexcouleur($img, $couleurs[0][3]);
	$img_couleurs["second_plan"] = ajoute_hexcouleur($img, $couleurs[0][4]);
	$img_couleurs["arriere_plan"] = ajoute_hexcouleur($img, $couleurs[0][5]);
	$img_couleurs["cadrillage"] = ajoute_hexcouleur($img, $couleurs[0][6]);

	/* Sries */

	for ($i = 0; $i < $nb_series; $i++) {
		// Cherche la couleur du milieu
		$deb_rouge = HexDec(substr($deb_couleurs[$i], 0, 2));
		$deb_vert = HexDec(substr($deb_couleurs[$i], 2, 2));
		$deb_bleu = HexDec(substr($deb_couleurs[$i], 4, 2));

		$fin_rouge = HexDec(substr($fin_couleurs[$i], 0, 2));
		$fin_vert = HexDec(substr($fin_couleurs[$i], 2, 2));
		$fin_bleu = HexDec(substr($fin_couleurs[$i], 4, 2));

		$mil_rouge = ($fin_rouge > $deb_rouge) ? sprintf("%02X", ($fin_rouge - $deb_rouge) / 2 + $deb_rouge) : sprintf("%02X", ($deb_rouge - $fin_rouge) / 2 + $fin_rouge);
		$mil_vert = ($fin_vert > $deb_vert) ? sprintf("%02X", ($fin_vert - $deb_vert) / 2 + $deb_vert) : sprintf("%02X", ($deb_vert - $fin_vert) / 2 + $fin_vert);
		$mil_bleu = ($fin_bleu > $deb_bleu) ? sprintf("%02X", ($fin_bleu - $deb_bleu) / 2 + $deb_bleu) : sprintf("%02X", ($deb_bleu - $fin_bleu) / 2 + $fin_bleu);
		$mil_couleurs[$i] = $mil_rouge.$mil_vert.$mil_bleu;
		$mil_rouge = HexDec($mil_rouge);
		$mil_vert = HexDec($mil_vert);
		$mil_bleu = HexDec($mil_bleu);

		$nb_couleurs = round((255 - $nb_series - 10) / $nb_series);
		$img_histo[$i] = dessiner_degrade($largeur_barre, $deb_couleurs[$i], $fin_couleurs[$i], $options[5], $nb_couleurs);

		$deb_couleurs[$i] = imagecolorallocate($img, $deb_rouge, $deb_vert, $deb_bleu);
		$mil_couleurs[$i] = imagecolorallocate($img, $mil_rouge, $mil_vert, $mil_bleu);
		$fin_couleurs[$i] = imagecolorallocate($img, $fin_rouge, $fin_vert, $fin_bleu);
	}

	imagefill($img, 0, 0, $img_couleurs["arriere_plan"]);
	imagefilledrectangle($img, $bx, 0, $x - 1, $y - $by, $img_couleurs["second_plan"]);

	/* Repres */
	for ($i = 0; $i < 5; $i++) {
		$deb = (int) (($bx - (imagefontwidth($options[2]) * strlen($i * $unite))) / 2);
		imagestring($img, $options[2], $deb, ($y - $by - 1) - ($i * $hauteur_unite), $i * $unite, $img_couleurs["texte"]);
		$y2 = $y - ($i * $hauteur_unite) - $by;
		imageline($img, $bx + 1, $y2, $x - 2, $y2, $img_couleurs["cadrillage"]);
	}
	imagerectangle($img, $bx, 0, $x - 1, $y - $by, $img_couleurs["premier_plan"]);

	/* Histogrammes */
	for ($i = 0; $i < $nb_barres; $i++) {
		$deb = (int) ($bx + 4 + ($i * $largeur_unite) + ($i * 4) + ($largeur_unite - (imagefontwidth($options[2]) * strlen($abscisses[$i]))) / 2);
		imagestring($img, $options[2], $deb + 1, $y - ($by + imagefontheight($options[2]) / 2) + ($by / 2), $abscisses[$i], $img_couleurs["texte"]);

		for ($j = 0; $j < $nb_series; $j++) {
			$y2 = (($y - $by + 1) - ($donnees[$j][$i] * $hauteur_unite) / $unite);
			imagecopyresized($img, $img_histo[$j], $bx + 5 + ($j * $largeur_barre) + ($i * $largeur_unite) + ($i * 4), $y2, 0, 0, $largeur_barre, ($donnees[$j][$i] * $hauteur_unite) / $unite, $largeur_barre, 1);
			imagerectangle($img, $bx + 4 + ($j * $largeur_barre) + ($i * $largeur_unite) + ($i * 4), $y2 - 1, $bx + 4 + ($j * $largeur_barre) + ($i * $largeur_unite) + ($i * 4) + $largeur_barre, $y - $by, $img_couleurs["premier_plan"]);

			/* Valeurs */
			if ($donnees[$j][$i] == $val_min[$j]) {
				$couleur = $deb_couleurs[$j];
			}
			elseif ($donnees[$j][$i] == $val_max[$j]) {
				$couleur = $fin_couleurs[$j];
			} else {
				$couleur = $mil_couleurs[$j];
			}

			$deb = (int) ($bx + 4 + ($j * $largeur_barre) + ($i * $largeur_unite) + ($i * 4) - (imagefontwidth($options[3]) * strlen(abs($donnees[$j][$i])) / 2) + ($largeur_barre / 2));
			$debup = (int) ($bx + 4 + ($j * $largeur_barre) + ($i * $largeur_unite) + ($i * 4) + ($largeur_barre / 2) - imagefontheight($options[3]) / 2);

			if ($options[4] == 1) {
				imagestring($img, $options[3], $deb, $y2 - 10, abs($donnees[$j][$i]), $couleur);
			}
			elseif ($options[4] == 2) {
				imagestringup($img, $options[3], $debup, $y2 - 6, abs($donnees[$j][$i]), $couleur);
			}
		}
	}
	return $img;
}

function dessiner_legende($x, $y, $bx, $by, $options, $legende, $couleurs) {
	/*
		--- Dessin d'une lgende ---
			=> Requis : librairie GD, PHP 4 et ventuellement les fonctions graphiques, du mme auteur.
		Version : 27/05/2001
		Auteur : BICHLER Olivier - http://www.guidewebmaster.net - <webmaster@guidewebmaster.net>
		Arguments :
		- La hauteur de la lgende en pixels.
		- La largeur en pixels.
		- L'espacement entre la couleur et le texte.
		- L'espacement entre les diffrentes lignes composants la lgende.
		- Les options : sous la forme d'un tableau avec
			[1] = Taille du texte de la lgende (de 1  5).
			[5] = Correction gamma pour les dgrads.
			Ex: $options = array(2, 2);
		- Le texte de la lgende, sous forme d'un tableau. Ex: $legende = array("Rouge", "Bleu");
		- Les couleurs de la lgende, galement sous forme d'un tableau. Ex: $couleurs[1] = array("FF0000", "00FF00");
		Au final, la fonction affiche l'image.
	*/
	$nb_series = sizeof($legende);
	$longueur_legende = 0;
	for ($i = 0; $i < $nb_series; $i++) {
		if ((strlen($legende[$i]) * imagefontwidth($options[1])) > $longueur_legende) {
			$longueur_legende = strlen($legende[$i]) * imagefontwidth($options[1]);
		}
	}

	$cotes_carres_1 = ($y - (($nb_series - 1) * $by) - 1) / $nb_series;
	$cotes_carres_2 = $x - ($longueur_legende + $bx) - 1;
	$cotes_carres = ($cotes_carres_1 < $cotes_carres_2) ? $cotes_carres_1 : $cotes_carres_2;
	$cotes_carres = ($cotes_carres > 25) ? 25 : $cotes_carres;
	$milieu_legende = ($x - ($cotes_carres + $bx + $longueur_legende)) / 2;

	$img = imagecreatetruecolor($x, $y);
	$img_couleurs["texte"] = ajoute_hexcouleur($img, $couleurs[0][2]);
	$img_couleurs["premier_plan"] = ajoute_hexcouleur($img, $couleurs[0][3]);
	$img_couleurs["arriere_plan"] = ajoute_hexcouleur($img, $couleurs[0][5]);
	imagefill($img, 0, 0, $img_couleurs["arriere_plan"]);

	for ($i = 0; $i < $nb_series; $i++) {
		$y = $i * $cotes_carres + $i * $by;
		$y_milieu = ($i * $cotes_carres + $i * $by) + ($cotes_carres - imagefontheight($options[1])) / 2;

		if (is_array($couleurs[2])) {
			$img_degrade = dessiner_degrade($cotes_carres, $couleurs[1][$i], $couleurs[2][$i], $options[5], $cotes_carres / 2);
			imagecopyresized($img, $img_degrade, $milieu_legende + 1, $y + 1, 0, 0, $cotes_carres, $cotes_carres, $cotes_carres, 1);
		} else {
			$couleur = ajoute_hexcouleur($img, $couleurs[1][$i]);
			imagefilledrectangle($img, $milieu_legende + 1, $y + 1, $milieu_legende + $cotes_carres - 1, $cotes_carres - 1 + $y, $couleur);
		}

		imagerectangle($img, $milieu_legende, $y, $milieu_legende + $cotes_carres, $cotes_carres + $y, $img_couleurs["premier_plan"]);
		imagestring($img, $options[1], $milieu_legende + $bx + $cotes_carres, $y_milieu, $legende[$i], $img_couleurs["texte"]);
	}
	return $img;
}

function dessiner_camembert($x, $y, $options, $donnees, $couleurs) {
	/*
		--- Dessin d'un graphique en camembert ---
			=> Requis : librairie GD, PHP 4 et les fonctions graphiques, du mme auteur.
		Version : 27/05/2001
		Auteur : BICHLER Olivier - http://www.guidewebmaster.net - <webmaster@guidewebmaster.net>
			Inspir du script de Cedric Fronteau <charlie@nexen.net>.
		Arguments :
		- La hauteur du graphique en pixels.
		- La largeur en pixels.
		- Les options : sous la forme d'un tableau avec
			[1] = Taille legende
			[3] = Taille valeurs
			[4] =	"0" = Pas de valeurs
					"1" = Valeurs
					"2" = Valeurs en pourcents
					"3" = Valeurs en pourcents et valeurs
			Ex: $options = array('', 2, '', 1, 2);
		- Les donnes, sous la forme d'un tableau avec clefs et valeurs. Ex: $donnees = array("10", "25", "19");
		- Les couleurs des diffrentes parts, sous forme d'un tableau. Ex: $couleurs[1] = array("0000FF", "0000FF", "00FF00");
		Au final, la fonction affiche l'image.
	*/

	$total = 0;
	$nb_valeurs = sizeof($donnees);
	for ($i = 0; $i < $nb_valeurs; $i++) {
		$total+= $donnees[$i];
	}

	$img = imagecreatetruecolor($x, $y);
	$img_couleurs["texte"] = ajoute_hexcouleur($img, $couleurs[0][2]);
	$img_couleurs["premier_plan"] = ajoute_hexcouleur($img, $couleurs[0][3]);
	$img_couleurs["arriere_plan"] = ajoute_hexcouleur($img, $couleurs[0][5]);
	imagefill($img, 0, 0, $img_couleurs["arriere_plan"]);

	$diametre = min($x, $y);
	$centre_x = floor($diametre / 2) + (int) (($x - $diametre) / 2);
	$centre_y = floor($diametre / 2) + (int) (($y - $diametre) / 2);
	$debut = 0; 
	for ($i = 0; $i < $nb_valeurs; $i++, $debut = $fin) {
		$couleur = ajoute_hexcouleur($img, $couleurs[1][$i]);

		/* Dessin de l'arc */
		$fin = round($debut + $donnees[$i] / $total * 360);
		imagearc($img, $centre_x, $centre_y, $diametre, $diametre, $debut, $fin, $couleur);

		/* Dessin des lignes dlimitants l'arc */
		$ligne1_x = round(cos(deg2rad($debut)) * $diametre / 2 + $centre_x);
		$ligne1_y = round(sin(deg2rad($debut)) * $diametre / 2 + $centre_y);
		$ligne2_x = round(cos(deg2rad($fin)) * $diametre / 2 + $centre_x);
		$ligne2_y = round(sin(deg2rad($fin)) * $diametre / 2 + $centre_y);

		imageline($img, $centre_x, $centre_y, $ligne1_x, $ligne1_y, $couleur); 
		imageline($img, $centre_x, $centre_y, $ligne2_x, $ligne2_y, $couleur); 

		$valeur_pc = round(($donnees[$i] / $total) * 100)."%";
		$milieu = floor(($fin - $debut) / 2 + $debut);
		$py = round(sin(deg2rad($milieu)) * ($diametre / 3) + $centre_y);
		$px = round(cos(deg2rad($milieu)) * ($diametre / 3) + $centre_x);
		imagefilltoborder($img, $px, $py, $couleur, $couleur);

		if ($debut > 90 && $debut < 180) {
			$py = round(sin(deg2rad($milieu)) * ($diametre / 3) + $centre_y - (imagefontheight($options[3]) / 2));
			$px = round(cos(deg2rad($milieu)) * ($diametre / 3) + $centre_x);
			$px_pc = round(cos(deg2rad($milieu)) * ($diametre / 3) + $centre_x);
		} else {
			$py = round(sin(deg2rad($milieu)) * ($diametre / 3) + $centre_y - (imagefontheight($options[3]) / 2));
			$px = round(cos(deg2rad($milieu)) * ($diametre / 3) + $centre_x - (imagefontwidth($options[3]) * strlen($donnees[$i]) / 2));
			$px_pc = round(cos(deg2rad($milieu)) * ($diametre / 3) + $centre_x - (imagefontwidth($options[3]) * strlen($valeur_pc) / 2));
		}

		if ($options[4] == 1) {
			imagestring($img, $options[3], $px, $py, $donnees[$i], $img_couleurs["texte"]);
		}
		elseif ($options[4] == 2) {
			imagestring($img, $options[3], $px_pc, $py, $valeur_pc, $img_couleurs["texte"]);
		}
		elseif ($options[4] == 3) {
			imagestring($img, $options[3], $px, $py + (imagefontheight($options[3]) / 2), $donnees[$i], $img_couleurs["texte"]);
			imagestring($img, $options[3], $px_pc, $py - (imagefontheight($options[3]) / 2), $valeur_pc, $img_couleurs["texte"]);
		}

		imageline($img, $centre_x, $centre_y, $ligne1_x, $ligne1_y, $img_couleurs["premier_plan"]);
		imageline($img, $centre_x, $centre_y, $ligne2_x, $ligne2_y, $img_couleurs["premier_plan"]);
	}

	imagearc($img, $centre_x, $centre_y, $diametre, $diametre, 0, 360, $img_couleurs["premier_plan"]); 
	return $img;
}

function dessiner_graphique($type, $titre, $pos_legende, $x, $y, $bx, $by, $options, $donnees, $legende, $abscisses, $couleurs,$graph) {
	/*
		--- Dessin d'un graphique en camembert ---
			=> Requis : librairie GD, PHP 4 et les fonctions graphiques, du mme auteur.
		Version : 01/06/2001
		Auteur : BICHLER Olivier - http://www.guidewebmaster.net - <webmaster@guidewebmaster.net>
		Arguments :
		- Le type de graphique
			"histogramme"
			"camembert"
		- Le titre du graphique
		- La position de la lgende
			"d" = Droite
			"g" = Gauche
			"h" = Haut
			"b" = Bas
			"" = Pas de lgende
		- La hauteur du graphique en pixels.
		- La largeur en pixels.
		- Les bordures x.
		- Les bordures y.
		- Les options : sous la forme d'un tableau avec
			[0] = Taille titre
			[1] = Taille legende
			[2] = Taille axes
			[3] = Taille valeurs
			[4] =	"0" = Pas de valeurs
					"1" = Valeurs ( l'horizontal pour l'histo)
					"2" = Valeurs en pourcents pour le camembert ou valeurs  la vertical pour l'histo
					"3" = Valeurs et valeurs en pourcents pour le camembert
			[5] = correction gamma pour les dgrads
			Ex: $options = array(2, 2, 1, 1, 2, 2);
		- Les donnes, sous la forme d'un tableau avec clefs et valeurs. Ex: $donnees = array("Hommes" => "10", "Femmes" => "25", "Extra-terrestres" => "19");
		- La lgende, sous forme d'un tableau. Ex: $legende = array("Srie 1", "Srie 2", "Srie 3");
		- L'axe des abscisses, pour l'histogramme, sous la forme d'un tableau. Ex: $abscisses = array("Lundi", "Mardi", "Mercredi");
		- Les couleurs des diffrentes parts, sous forme d'un tableau. Ex: $couleurs[1] = array("0000FF", "0000FF", "00FF00");
		Au final, la fonction affiche l'image.
	*/

	/* Dterminer la longueur max de la lgende */
	$longueur_legende = 0;
	for ($i = 0; $i < sizeof($legende); $i++) {
		if (strlen($legende[$i]) > $longueur_legende) {
			$longueur_legende = strlen($legende[$i]);
		}
	}

	/* La partie du graphe que prend la lgende (8 = 1/8, 4 = 1/4...) */
	if ($type == "histogramme") {
		$div = 8;
	}
	elseif ($type == "camembert") {
		$div = 4;
	}

	/* Dterminer les dimensions */
	if ($pos_legende == "d" || $pos_legende == "g") {
		$lx1 = 10 + 5 + imagefontwidth($options[1]) * $longueur_legende;
		$lx2 = ($x - $bx * 3) / $div;
		$lx = ($lx2 > $lx1) ? $lx2 : $lx1;
		$ly = ($y - $by * 2) / 2;

		$gx = $x - $bx * 3 - $lx;
		$gy = $y - $by * 2;

		$deb_lx = ($pos_legende == "d") ? $bx * 2 + $gx : $bx;
		$deb_ly = $by + $gy / 2 - $ly / 2;
		$deb_gx = ($pos_legende == "d") ? $bx : $bx * 2 + $lx;
		$deb_gy = $by;
	}
	elseif ($pos_legende == "h" || $pos_legende == "b") {
		$lx = ($x - $bx * 2) / 2;
		$ly1 = (10 + 5) * sizeof($legende) - 5;
		$ly2 = ($y - $by * 3) / $div;
		$ly = ($ly2 > $ly1) ? $ly2 : $ly1;

		$gx = $x - $bx * 2;
		$gy = $y - $by * 3 - $ly;

		$deb_lx = ($x - $lx) / 2;
		$deb_ly = ($pos_legende == "h") ? $by : $by * 2 + $gy;
		$deb_gx = ($x - $gx) / 2;
		$deb_gy = ($pos_legende == "h") ? $by * 2 + $ly : $by;
	} else {
		$gx = $x - $bx * 2;
		$gy = $y - $by * 2;

		$deb_gx = $bx;
		$deb_gy = $by;
	}

	if ($type == "histogramme") {
		$img_graphique = dessiner_histogramme($gx, $gy, 25, 15, $options, $donnees, $abscisses, $couleurs);
		$img_legende = dessiner_legende($lx, $ly, 5, 5, $options, $legende, $couleurs);
	}
	elseif ($type == "camembert") {
		$img_graphique = dessiner_camembert($gx, $gy, $options, $donnees, $couleurs);
		$img_legende = dessiner_legende($lx, $ly, 5, 5, $options, $legende, $couleurs);
	}

	$img = imagecreatetruecolor($x, $y);
	$img_couleurs["premier_plan"] = ajoute_hexcouleur($img, $couleurs[0][3]);
	$img_couleurs["arriere_plan"] = ajoute_hexcouleur($img, $couleurs[0][5]);
	$img_couleurs["titre"] = ajoute_hexcouleur($img, $couleurs[0][0]);
	$img_couleurs["pied"] = ajoute_hexcouleur($img, $couleurs[0][1]);

	ImageFill($img, 0, 0, $img_couleurs["arriere_plan"]);
	imagerectangle($img, 0, 0, $x - 1, $y - 1, $img_couleurs["premier_plan"]);

	ImageCopyResized($img, $img_graphique, $deb_gx, $deb_gy, 0, 0, $gx, $gy, $gx, $gy);
	ImageCopyResized($img, $img_legende, $deb_lx, $deb_ly, 0, 0, $lx, $ly, $lx, $ly);
        /*
    ImageCopyResampled($img, $img_graphique, $deb_gx, $deb_gy, 0, 0, $gx, $gy, $gx, $gy);
	ImageCopyResampled($img, $img_legende, $deb_lx, $deb_ly, 0, 0, $lx, $ly, $lx, $ly);
           */



	/* Dessiner le texte */
	ImageString($img, $options[0], ($x - (imagefontwidth($options[0]) * strlen($titre))) / 2, ($by - imagefontheight($options[0])) / 2, $titre, $img_couleurs["titre"]);

	//$pied = date("@ d/m/Y - H:i:s")." [GW]";
	//imagestring($img, 1, ($x - (imagefontwidth(1) * strlen($pied)) - 4), ($y - imagefontheight(1) - 4), $pied, $img_couleurs["pied"]);

	/* Envoyer l'image */
	//imageinterlace($img, false);
	//header("Content-type: image/png");
	ImagePng($img,"cache_graph/$graph");
    
	ImageDestroy($img);
}
//<!--</script>-->
?>
