<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

//header("content-type: image/png");

if(! isset($margey)){
  $margey=10;
}

if(! isset($margex)){
  $margex=10;
}


//function dessiner_camembert($x, $y, $options, $donnees, $couleurs) {
/*
       --- Dessin d'un graphique en camembert ---
           => Requis : librairie GD, PHP 4 et les fonctions graphiques, du mme auteur.
       Version : 27/05/2001
       Auteur : BICHLER Olivier - http://www.guidewebmaster.net - <webmaster@guidewebmaster.net>
           Inspir du script de Cedric Fronteau <charlie@nexen.net>.
       Arguments :
       - La hauteur du graphique en pixels.
       - La largeur en pixels.
       - Les options : sous la forme d'un tableau avec
           [1] = Taille legende
           [3] = Taille valeurs
           [4] =    "0" = Pas de valeurs
                   "1" = Valeurs
                   "2" = Valeurs en pourcents
                   "3" = Valeurs en pourcents et valeurs
           Ex: $options = array('', 2, '', 1, 2);
       - Les donnes, sous la forme d'un tableau avec clefs et valeurs. Ex: $donnees = array("10", "25", "19");
       - Les couleurs des diffrentes parts, sous forme d'un tableau. Ex: $couleurs[1] = array("0000FF", "0000FF", "00FF00");
       Au final, la fonction affiche l'image.
  */

$total = 0;
$nb_valeurs = sizeof($donnees);
for ($i = 0; $i < $nb_valeurs; $i++) {
  $total+= $donnees[$i];
}

$img = imagecreate($x, $y);
$maroon = ImageColorAllocate($img,100,0,0);
$white = ImageColorAllocate($img,255,255,255);
$red = ImageColorAllocate($img,255,0,0);
$blue = ImageColorAllocate($img,0,0,255);
$grey = ImageColorAllocate($img,200,200,200);
$black = ImageColorAllocate($img,0,0,0);
//$img_couleurs["texte"] = ajouter_hexcouleur($img, $couleurs[0][2]);
//$img_couleurs["premier_plan"] = ajouter_hexcouleur($img, $couleurs[0][3]);
//$img_couleurs["arriere_plan"] = ajouter_hexcouleur($img, $couleurs[0][5]);
$img_couleurs["texte"] = ajouter_hexcouleur($img, $texte);
$img_couleurs["premier_plan"] = ajouter_hexcouleur($img, $premier_plan);
$img_couleurs["arriere_plan"] = ajouter_hexcouleur($img, $arriere_plan);
//print("Arriere Plan = $arriere_plan<br>");
imagefill($img, 0, 0, $white);



$diametre = min($x, $y);
//$centre_x = floor($diametre / 2) + (int) (($x - $diametre) / 2);
$centre_x = floor($diametre / 2);
$centre_y = floor($diametre / 2) + (int) (($y - $diametre) / 2);
$debut = 0;
$tabCouleur=array();
for ($i = 0; $i < $nb_valeurs; $i++, $debut = $fin) {
  $couleur = ajouter_hexcouleur($img, $couleurs[1][$i]);
  $tabCouleur[$i]=$couleur;
  
  if($donnees[$i]!=0){
    /* Dessin de l'arc */
    $fin = round($debut + $donnees[$i] / $total * 360);
    imagearc($img, $centre_x, $centre_y, $diametre, $diametre, $debut, $fin, $couleur);

    /* Dessin des lignes dlimitants l'arc */
    $ligne1_x = round(cos(deg2rad($debut)) * $diametre / 2 + $centre_x);
    $ligne1_y = round(sin(deg2rad($debut)) * $diametre / 2 + $centre_y);
    $ligne2_x = round(cos(deg2rad($fin)) * $diametre / 2 + $centre_x);
    $ligne2_y = round(sin(deg2rad($fin)) * $diametre / 2 + $centre_y);

    imageline($img, $centre_x, $centre_y, $ligne1_x, $ligne1_y, $couleur);
    imageline($img, $centre_x, $centre_y, $ligne2_x, $ligne2_y, $couleur);

    $valeur_pc = round(($donnees[$i] / $total) * 100)."%";
    $milieu = floor(($fin - $debut) / 2 + $debut);
    $py = round(sin(deg2rad($milieu)) * ($diametre / 3) + $centre_y);
    $px = round(cos(deg2rad($milieu)) * ($diametre / 3) + $centre_x);
    imagefilltoborder($img, $px, $py, $couleur, $couleur);

    if ($debut > 90 && $debut < 180) {
      $py = round(sin(deg2rad($milieu)) * ($diametre / 3) + $centre_y - (imagefontheight($options[3]) / 2));
      $px = round(cos(deg2rad($milieu)) * ($diametre / 3) + $centre_x);
      $px_pc = round(cos(deg2rad($milieu)) * ($diametre / 3) + $centre_x);
    } else {
      $py = round(sin(deg2rad($milieu)) * ($diametre / 3) + $centre_y - (imagefontheight($options[3]) / 2));
      $px = round(cos(deg2rad($milieu)) * ($diametre / 3) + $centre_x - (imagefontwidth($options[3]) * strlen($donnees[$i]) / 2));
      $px_pc = round(cos(deg2rad($milieu)) * ($diametre / 3) + $centre_x - (imagefontwidth($options[3]) * strlen($valeur_pc) / 2));
    }

    if ($options[4] == 1) {
      imagestring($img, $options[3], $px, $py, $donnees[$i], $img_couleurs["texte"]);
    }
    elseif ($options[4] == 2) {
      imagestring($img, $options[3], $px_pc, $py, $valeur_pc, $img_couleurs["texte"]);
    }
    elseif ($options[4] == 3) {
      imagestring($img, $options[3], $px, $py + (imagefontheight($options[3]) / 2), $donnees[$i], $img_couleurs["texte"]);
      imagestring($img, $options[3], $px_pc, $py - (imagefontheight($options[3]) / 2), $valeur_pc, $img_couleurs["texte"]);
    }

    imageline($img, $centre_x, $centre_y, $ligne1_x, $ligne1_y, $img_couleurs["premier_plan"]);
    imageline($img, $centre_x, $centre_y, $ligne2_x, $ligne2_y, $img_couleurs["premier_plan"]);
  }

  imagearc($img, $centre_x, $centre_y, $diametre, $diametre, 0, 360, $img_couleurs["premier_plan"]);
}

//Legende
if(!isset($taillefont)) $taillefont=3;
//On calcul la chaine la plus longue
$chaine_la_plus_longue=0;
while(list($id,$chaine)=each($tabLegende)){
  $tmp=imagefontwidth($taillefont) * strlen($chaine);
  if($chaine_la_plus_longue<$tmp)$chaine_la_plus_longue=$tmp;
}
$espace_entre_ligne=imagefontheight($taillefont);
if(! isset($espace_entre_carre_et_texte)){
  $espace_entre_carre_et_texte=5;
}
$taille_carre=min($taillefont,5)*2;

$i=0;
$j=0;
reset($tabLegende);
while(list($id,$chaine)=each($tabLegende)){
  if($donnees[$j] != 0){
    //On affiche les petits carrs de couleur
    ImageFilledRectangle($img,
			 $x-$chaine_la_plus_longue-$margex-$taille_carre-$espace_entre_carre_et_texte,
			 $margey+($i*$espace_entre_ligne)+$margey/3,
			 $x-$chaine_la_plus_longue-$margex-$taille_carre-$espace_entre_carre_et_texte+$taille_carre,
			 $margey+($i*$espace_entre_ligne)+$taille_carre+$margey/3,
			 $tabCouleur[$j]);
    
    //On affiche la legende
    imagestring($img,$taillefont,$x-$chaine_la_plus_longue-$margex,$margey+($i*$espace_entre_ligne),$chaine,$black);
    $i++;
  }
  $j++;
}

//$black = ImageColorAllocate($image,0,0,0);  
//imagestring($img,$taillefont, );

if(!isset($nom_fic)){
  $nom_fic="cache/monCam2.png";
}

imagePng($img,"cache/$nom_fic");
imageDestroy($img);
//return $img;

// $options = array('', 2, '', 1, 2);
// $donnees = array("10", "25", "19");
// $couleurs[1] = array("0000FF", "0000FF", "00FF00");
// dessiner_camembert($x, $y, $options, $donnees, $couleurs)
?>


