<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*****************************************************************
 * Fichier de fonctions pour les stats en Front-Office
 ****************************************************************/
include("$chemin_fo/stats/constantes.php3");

/*
 * Fonction qui, pour un utilisateur et un calendrier donns, retourne
 * un tableau contenant le libell du QCM, la note, le total et
 * la moyenne sur 20.
 * parametres :
 * $db : la connexion  la base de donn
 * $user : le numero de l'utilisateur
 * $cal : le numero de calendrier (peut etre nul)
 */
function getNoteQcm($db, $user,$cal=0){
  $tabRetour=array();
  //La requete
  if($cal != 0){
    $req_qcm="SELECT result_qstn, total,libelle_qstaire
              FROM questionnaire q,gestionqstn gq
              WHERE q.num_qstaire = gq.gqstn_num_qstaire
              AND gqstn_num_user='$user'
              AND num_cal='$cal' ";
  }
  //Execution de la requete
  $resul=pg_exec($db,$req_qcm);
  $nbQcm=pg_numrows($resul);
  for($i=0;$i<$nbQcm;$i++){
    $rowQcm=pg_fetch_row($resul,$i);
    $lib_qstaire=$rowQcm[2];
    $tabRetour[$lib_qstaire][0]=$rowQcm[0];
    $tabRetour[$lib_qstaire][1]=$rowQcm[1];
    $tabRetour[$lib_qstaire][2]=getMoyenne($rowQcm[0],$rowQcm[1]);
  }
  return($tabRetour);
}



/*
 * Fonction qui, pour un utilisateur et un calendrier donns, retourne
 * un tableau contenant le libell du Blanc, la note, le total et
 * la moyenne sur 20.
 * parametres :
 * $db : la connexion  la base de donn
 * $user : le numero de l'utilisateur
 * $cal : le numero de calendrier (peut etre nul)
 */
function getNoteBlanc($db, $user,$cal=0){
  $tabRetour=array();
   //La requete
  if($cal != 0){
    $req_blanc="select rs.score,se.titre from serie_exo se,res_serie rs
    where se.id=rs.id_serie
    and id_stag='$user' and id_formation='$cal'";

  }
  // excution requete
   $resul=pg_exec($db,$req_blanc);
  $nbBlanc=pg_numrows($resul);
  for($i=0;$i<$nbBlanc;$i++){
    $rowBlanc=pg_fetch_row($resul,$i);
    $lib_blanc=$rowBlanc[1];
    //echo "lib=$lib_blanc<br> score=$rowBlanc[0]";
    $tabRetour[$lib_blanc][0]=$rowBlanc[0];
    $tabRetour[$lib_blanc][1]=20;
    $tabRetour[$lib_blanc][2]=getMoyenne($rowBlanc[0],20);
  }
  return($tabRetour);
}

/*
 * Function qui retourne le total des notes des QCMs pour un
 * calendrier et un utilisateur precis
 * return : tableau  trois cases :
 ** $tab[0] = score
 ** $tab[1] = max possible
 ** $tab[2] = moyenne sur 20
 * parametres :
 * $db : connexion  la base
 * $user : numero d'utilisateur
 * $cal : numero de calendrier
 */
function getTotalUserQcmCal($db,$user,$cal){
  $tabDetail=getNoteQcm($db, $user,$cal);
  $tabRetour=array();
  while(list($libelle,$tabNote)=each($tabDetail)){
    $tabRetour[0]+=$tabNote[0];
    $tabRetour[1]+=$tabNote[1];
  }
  $tabRetour[2]=getMoyenne($tabRetour[0],$tabRetour[1]);
  return($tabRetour);
}

/*
 * Function qui retourne le total des notes des Blanc pour un
 * calendrier et un utilisateur precis
 * return : tableau  trois cases :
 ** $tab[0] = score
 ** $tab[1] = max possible
 ** $tab[2] = moyenne sur 20
 * parametres :
 * $db : connexion  la base
 * $user : numero d'utilisateur
 * $cal : numero de calendrier
 */
function getTotalUserBlancCal($db,$user,$cal){
    $tabDetail=getNoteBlanc($db,$user,$cal);
    $tabRetour=array();
    while(list($libelle,$tabNote)=each($tabDetail)){
        $tabRetour[0]+=$tabNote[0];
        $tabRetour[1]+=$tabNote[1];
    }
    $tabRetour[2]=getMoyenne($tabRetour[0],$tabRetour[1]);
     return($tabRetour);
}

/*
 * Fonction qui, pour un utilisateur et un calendrier donns, retourne
 * un tableau contenant le libell de l'exercice, la note, le total et
 * la moyenne sur 20.
 * parametres :
 * $db : la connexion  la base de donn
 * $user : le numero de l'utilisateur
 * $cal : le numero de calend7rier (peut etre nul)
 */
function getNoteExo($db,$user,$cal=0){
  $tabRetour=array();
  //On cherche les exos avec leurs titres
  $req_exo="SELECT DISTINCT num_exo,titre
            FROM exotlc e, gestexotlc ge, gestionnaire g,gestparcours gp
            WHERE g.g_num_parcours = gp.g_num_parcours 
            AND type_etape='E'
            AND num_c_q_e_d = num_exo
            AND g_num_cal = '$cal'
            AND gesttlc_user = '$user'";
  $resul=pg_exec($db,$req_exo);
  $nbExo=pg_numrows($resul);
  for($i=0;$i<$nbExo;$i++){
    $rowExo=pg_fetch_row($resul,$i);
    //pour chaque exo on cherche le score
    $req_score_exo="SELECT score,surtotal
                    FROM resexouser
                    WHERE num_exo = '$rowExo[0]'
                    AND num_user = '$user' and num_cal=$cal";
                  
    
    $resulNote=pg_exec($db,$req_score_exo);
    if(pg_numrows($resulNote) == 1){
      $rowNote=pg_fetch_row($resulNote,0);
      $label=$rowExo[1];
      $tabRetour[$label][0]=$rowNote[0];
      $tabRetour[$label][1]=$rowNote[1];
      $tabRetour[$label][2]=getMoyenne($rowNote[0],$rowNote[1]);
    }
  }
  return($tabRetour);
}

/*
 * Function qui retourne le total des notes des exos pour un
 * calendrier et un utilisateur precis
 * return : tableau  trois cases : 
 ** $tab[0] = score
 ** $tab[1] = max possible
 ** $tab[2] = moyenne sur 20
 * parametres :
 * $db : connexion  la base
 * $user : numero d'utilisateur
 * $cal : numero de calendrier
 */
function getTotalUserExoCal($db,$user,$cal){
  $tabDetail=getNoteExo($db, $user,$cal);
  $tabRetour=array();
  while(list($libelle,$tabNote)=each($tabDetail)){
    $tabRetour[0]+=$tabNote[0];
    $tabRetour[1]+=$tabNote[1];
  }
  $tabRetour[2]=getMoyenne($tabRetour[0],$tabRetour[1]);
  return($tabRetour);
}

/*
 * Fonction qui retourne le score total des exercices  telecharger
 * pour un calendrier donn
 * return : un tableau  deux cases. $tab[0]=score , $tab[1] = max possible
 * parametres : 
 * $db : connexion  la base
 * $cal : numro de calendrier
 */
function getScoreTotalExoCal($db,$cal){
  //function getNoteExo($db,$user,$cal=0){

  $tabRetour=array();
  //on cherche tous les utilisateurs du calendrier
  $req_user="SELECT DISTINCT gu_num_user
             FROM gestionutil gu, gestionnaire g
             WHERE g.g_num_gest_g = gu.gu_num_gest_gr
             AND g.g_num_cal = '$cal' ";
  $resUser=pg_exec($db,$req_user);
  $nbUser=pg_numrows($resUser);
  //Pour chaque utilisateur, on cherche son score
  for($i=0;$i<$nbUser;$i++){
    $tabNoteUser=array();
    $rowUser=pg_fetch_row($resUser,$i);
    $tabNoteUser=getNoteExo($db,$rowUser[0],$cal);
    while(list($user,$tabResu)=each($tabNoteUser)){
      $tabRetour[0]+=$tabResu[0];
      $tabRetour[1]+=$tabResu[1];
    }
  }
  return($tabRetour);
}

/*
 * Fonction qui retourne une moyenne sur 20 (avec deux 
 * chiffres significatifs)
 * paramtres :
 * $note : la note obtenu
 * $max : le maximum possible du Qcm / Exo
 */
function getMoyenne($note,$max){
    //debug
    //echo "note=$note et max=$max<br>";
  if($max == 0)return("X");
  $moy=($note / $max)*20;
  //on arrondi
  $moy*=100;
  $moy=round($moy);
  $moy/=100;
  //debug
  //echo "moy=$moy<br>";
  return($moy);
}

/*
 * Methode qui renvois une couleur en fonction de la
 * note passe en paramtres
 */
function getCouleur($note){
  global $moyenne_plus, $moyenne_moins;
  if($note >=10)
    return($moyenne_plus);
  else return($moyenne_moins);
}

/*
 * methode qui verifie si un formateur  le droit de voir les
 * scores d'un stagiaire pour un calendrier donn
 * paramtres:
 * $db : la connexion  la base de donne
 * $fo : numero du formateur
 * $cal : le numero du calendrier
 */
function verifFormateur($db,$fo,$cal){
        global $ERROR_0;
  $req_verif="SELECT distinct g_num_user FROM gestionnaire
              WHERE g_num_cal = '$cal'";
  $resul=pg_exec($db,$req_verif);
  $nb=pg_numrows($resul);
  if($nb != 1){
    die("$ERROR_0");//Base de donne corrompue
  }
  
  if($nb == 1){
    $num_fo=pg_fetch_row($resul,0);
    return($num_fo[0] == $fo);
  }
  return(false);
}

/*
 * Function qui retourne 'vrai' si on  le droit de voir ses propres
 * connexions. paramtres :
 * $db : connexion  la base
 * $user : le numero d'utilisateur
 * $cal : numero de calendrier
 */
function droitVoirConnexion($db,$user,$cal){
  //requete pour voir les droits
  $req_droit="SELECT DISTINCT gu_num_user
              FROM gestionnaire g, gestionutil gu, droit d
              WHERE g.g_num_gest_g = gu.gu_num_gest_gr
              AND g.g_num_cal = '$cal'
              AND gu.gu_num_droit = d.num_droit
              AND d.libelle_droit='Voir les connexions' 
              AND gu_num_user='$user'";

  //on execute la requete
  $resDroit=pg_exec($db,$req_droit);
  return(pg_numrows($resDroit) == 1);
}

function getNomMoisParNum($mois){
  switch ($mois){
    case "01";
    return("janvier");
    case "02";
    return("fvrier");
    case "03";
    return("mars");
    case "04";
    return("avril");
    case "05";
    return("mai");
    case "06";
    return("juin");
    case "07";
    return("juillet");
    case "08";
    return("aout");
    case "09";
    return("septembre");
    case "10";
    return("octobre");
    case "11";
    return("novembre");
    case "12";
    return("dcembre");
  }
}

function getNumMois($date){
  list($annee,$mois,$jour)=split('[-\' \']',$date,3);
  return($mois);
}

function getNomMoisBis($mois){
        global $MOIS_1, $MOIS_2,$MOIS_3, $MOIS_4,$MOIS_5,$MOIS_6 ,$MOIS_7, $MOIS_8, $MOIS_9, $MOIS_10,$MOIS_11,$MOIS_12;
  switch($mois){
  case (1):
    return("$MOIS_1");
    break;
  case (2):
    return("$MOIS_2");
    break;
  case (3):
    return("$MOIS_3");
    break;
  case (4):
    return("$MOIS_4");
    break;
  case (5):
    return("$MOIS_5");
    break;
  case (6):
    return("$MOIS_6");
    break;
  case (7):
    return("$MOIS_7");
    break;
  case (8):
    return("$MOIS_8");
    break;
  case (9):
    return("$MOIS_9");
    break;
  case (10):
    return("$MOIS_10");
    break;
  case (11):
    return("$MOIS_11");
    break;
  case (12):
    return("$MOIS_12");
    break;
  }
}

function getTabDate($date){
  $date=ereg_replace(' ','-',$date);
  $date=ereg_replace(':','-',$date);
  //$date=ereg_replace('+','-',$date);
  $stok=explode('-',$date);
  return($stok);
}


function getJour($date){
  $tabDate=getTabDate($date);
  return($tabDate[2]);  
}

function getMois($date){
  $tabDate=getTabDate($date);
  return($tabDate[1]);
  
}

function getAnnee($date){
  $tabDate=getTabDate($date);
  return($tabDate[0]);  
}

function getHeure($date){
  $tabDate=getTabDate($date);
  return($tabDate[3]);  
}

function getMinute($date){
  $tabDate=getTabDate($date);
  return($tabDate[4]);  
}

function getSeconde($date){
  $tabDate=getTabDate($date);
  $sec=$tabDate[5];
  return(substr($sec,0,2));
}

function ajouter_hexcouleur($img, $couleur)
{
        $rouge = HexDec(substr($couleur, 0, 2));
        $vert = HexDec(substr($couleur, 2, 2));
        $bleu = HexDec(substr($couleur, 4, 2));
        return imagecolorallocate($img, $rouge, $vert, $bleu);
}





/**
* Fonction qui retourne le score d'un groupe  une srie
* donn ainsi que le score max de ce qcm
* $cal = le numero de calendrier
* $qcm = le numro du qcm
*/

function getScoreSerieCal($cal,$qcm)
{
        global $db;

        // On rcupre les scores obtenus par un groupe  une srie
        $req_score="SELECT S.score, A.point
                        FROM res_serie_exo S, asso_exo_serie A
                        WHERE S.id_serie=A.id_serie
                        AND S.id_formation = '$cal'
                        AND S.id_serie = '$qcm'
                        AND ordre=ordre_etape;";

        $resScore=pg_exec($db,$req_score);
        $nbScore=pg_numrows($resScore);
        // Initialisation des valeurs
        $score_total=0;
        $score_max=0;

        for($i=0;$i<$nbScore;$i++)
        {
                $rowScore=pg_fetch_row($resScore,$i);
                $score_total+=$rowScore[0]; // On ajoute le score obtenu  cette question
                // $score_max+=20;
                $score_max+=$rowScore[1]; // On ajoute le poids de la question
                // DEBUG echo "score : $rowScore[0]/$rowScore[1]<br>";
        }

        // Score total pour cette srie
        $tabRetour[0]=$score_total;
        // Score maximum possible < on peut calculer une moyenne en rapportant sur 20
        $tabRetour[1]=$score_max;
        return($tabRetour);
}



/**
 * Fonction qui retourne le score d'un groupe  un qcm $qcm
 * donn ainsi que le score max de ce qcm
 * $cal = le numero de calendrier
 * $qcm = le numro du qcm
 */
function getScoreQcmCal($cal,$qcm)
{
        global $db;
        /*
        $req_score="SELECT result_qstn,date_fin,total
                FROM gestionqstn gq,calendrier c
                WHERE gq.num_cal = c.num_cal
                AND c.num_cal = '$cal'
                AND gqstn_num_qstaire = '$qcm'
                ORDER BY date_fin
                ";*/

        // DESORMAIS ON REGARDE AU NIVEAU DES SERIES D'EXERCICE ET NON PAS DANS LES QUESTIONNAIRES
        $req_score="SELECT S.score, A.point
                FROM res_serie_exo S, asso_exo_serie A
                WHERE S.id_serie=A.id_serie
                AND S.id_formation = '$cal'
                AND S.id_serie = '$qcm'
                AND S.type_exo = 'q'
                AND ordre=ordre_etape;";

        $resScore=pg_exec($db,$req_score);
        $nbScore=pg_numrows($resScore);
        $score_total=0;
        $score_max=0;
        for($i=0;$i<$nbScore;$i++)
        {
                        $rowScore=pg_fetch_row($resScore,$i);
                        $score_total+=$rowScore[0];
                        // $score_max+=$rowScore[2];
                        $score_max+=$rowScore[1];
                        // DEBUG echo "QCM score : $rowScore[0]/$rowScore[1]<br>";
        }

        $tabRetour[0]=$score_total;
        $tabRetour[1]=$score_max;
        return($tabRetour);
}

/**
 * Fonction qui retourne le score d'un groupe  un qcm $qcm
 * donn ainsi que le score max de ce qcm
 * $cal = le numero de calendrier
 * $qcm = le numro du qcm
 */
function getScoreBlancCal($cal,$qcm){
  global $db;
  // ANCIENNE REQUETE AVANT LE DEVELOPPEMENT DES SERIES MULTIEXERCICE
  /*
  $req_score="SELECT score,date_fin
              FROM res_serie rs,calendrier c
              WHERE rs.id_formation = c.num_cal
              AND c.num_cal = '$cal'
              AND rs.id_serie = '$qcm'
              ORDER BY date_fin
              ";*/

  // Nouvelle requete, on ne garde que les exercices de remplir les blancs
  // on choppe le score ici
  $req_score="SELECT S.score, A.point
              FROM res_serie_exo S, asso_exo_serie A
              WHERE S.id_serie=A.id_serie
              AND S.id_formation = '$cal'
              AND S.id_serie = '$qcm'
              AND S.type_exo = 'f'
              AND ordre=ordre_etape;";

  // cal>446 et serie>127

  $resScore=pg_exec($db,$req_score);
  $nbScore=pg_numrows($resScore);
  // Initialisation des valeurs
  $score_total=0;
  $score_max=0;

  for($i=0;$i<$nbScore;$i++)
  {
    $rowScore=pg_fetch_row($resScore,$i);
    $score_total+=$rowScore[0]; // On ajoute le score obtenu  cette question
    // $score_max+=20;
    $score_max+=$rowScore[1]; // On ajoute le poids de la question
    // DEBUG echo "score : $rowScore[0]/$rowScore[1]<br>";
  }

  // Score total pour ces remplir les blancs
  $tabRetour[0]=$score_total;
  // Score maximum possible < on peut calculer une moyenne en rapportant sur 20
  $tabRetour[1]=$score_max;
  return($tabRetour);
}


/**
 * Fonction qui retourne le score total d'un groupe pour tous les QCMS
 * donn ainsi que le score max.
 * return : un tableau  deux case : $tab[0]=le score, $tab[1]=le max possible
 * $db : connexion  la base
 * $cal = le numero de calendrier
 */
function getScoreTotalQcmCal($db,$cal){
  $req_score="SELECT result_qstn,date_fin,total
              FROM gestionqstn gq,calendrier c
              WHERE gq.num_cal = c.num_cal
              AND c.num_cal = '$cal'
              ORDER BY date_fin
              ";
  $resScore=pg_exec($db,$req_score);
  $nbScore=pg_numrows($resScore);
  $score_total=0;
  $score_max=0;
  for($i=0;$i<$nbScore;$i++)
  {
    $rowScore=pg_fetch_row($resScore,$i);
    $score_total+=$rowScore[0];
    $score_max+=$rowScore[2];
  }

  $tabRetour[0]=$score_total;
  $tabRetour[1]=$score_max;
  return($tabRetour);
}

/**
 * Methode qui retourne la moyenne ainsi qu'une couleur pour afficher
 * $score : Le score obtenu
 * $max : le max possible
 * return : un tableau de deux cases qui contient:
 * un double : la moyenne sur 20 avec deux chiffres apres la virgule
 * une couleur : pour afficher la cellule
 */
function calculMoyenne($score, $max){
  $tabRetour=array();
  $tabRetour[0]="X";
  $tabRetour[1]="#FFFFFF";

  global $bonne_reponse;
  global $mauvaise_reponse;

  if($max != 0){
    $moy=($score * (20/$max));
    $moy *= 100;
    $moy=round($moy);
    $moy /= 100;
    $tabRetour[0]=$moy;
    if($tabRetour[0]<10){
      $tabRetour[1]="$mauvaise_reponse";
    }
    else $tabRetour[1]="$bonne_reponse";
  }
  return($tabRetour);
}








// QUE POUR LES QCM D'UNE SERIE
// retourne score d'un utilisateur  la partie QCM d'une srie dans une formation et le score maximum possible  cette srie
function getScoreQcm($user,$qcm,$cal){
        // echo "qcm seuls" ;

        global $ERROR_0;
        $Score_Qcm_Fct=0;
        global $Tab_Val_Max_Qcm;
        global $db;
        //pour chaque utilisateur on calcul son score
        if($cal != 0)
        {
                // On rcupre score pour ce stagiare  cet srie
                $req_score_user="SELECT S.score, A.point
                        FROM res_serie_exo S, asso_exo_serie A
                        WHERE S.id_serie=A.id_serie
                        AND S.id_formation = '$cal'
                        AND A.id_serie = '$qcm'
                        AND S.id_stag='$user'
                        AND S.type_exo = 'q'
                        AND ordre=ordre_etape;";
        }
        // Peu importe le calendrier
        else
        {
                // echo "cal == 0" ;
                // On rcupre score pour ce stagiare  cet srie
                $req_score_user="SELECT S.score, A.point
                        FROM res_serie_exo S, asso_exo_serie A
                        WHERE S.id_serie=A.id_serie
                        AND A.id_serie = '$qcm'
                        AND S.id_stag='$user'
                        AND S.type_exo = 'q'
                        AND ordre=ordre_etape;";
        }

        $resulScore=pg_exec($db,$req_score_user);
        $nbScore=pg_numrows($resulScore);

        // Initialisations
        $score_total=0;
        $score_max=0;

        // On calcul el score obtenu par ce stagiaire
        for($i=0;$i<$nbScore;$i++)
        {
                        $rowScore=pg_fetch_row($resulScore,$i);
                        $score_total+=$rowScore[0];
                        // $score_max+=$rowScore[2];
                        $score_max+=$rowScore[1];
                        // DEBUG echo "QCM score : $rowScore[0]/$rowScore[1]<br>";
        }

        // S'il y a des rsultats
        if($nbScore != 0)
        {
                $rowScore=pg_fetch_row($resulScore,0);
                // $Score_Qcm_Fct = $rowScore[0];
                // $Tab_Val_Max_Qcm[$qcm]=$rowScore[1];
                $Score_Qcm_Fct = $score_total ;
                $Tab_Val_Max_Qcm[$qcm]=$score_max ;
                return($Score_Qcm_Fct);
        }
        // S'il n'y a aucun rsultat
        else
        {
                global $pas_repondu;
                $pas_repondu=1;
                return($Score_Qcm_Fct);
        }
}


// QUE POUR LES QCM D'UNE SERIE
// retourne score d'un utilisateur  la partie FTB d'une srie dans une formation et le score maximum possible  cette srie
function getScoreBlanc($user,$blanc,$cal)
{
        // echo "entre getScoreBlanc" ;
        global $ERROR_0;
        $Score_Blanc_Fct=0;
        global $Tab_Val_Max_Qcm;
        global $db;
        //pour chaque utilisateur on calcul son score
        if($cal != 0)
        {
                $req_score_user="SELECT S.score, A.point
                        FROM res_serie_exo S, asso_exo_serie A
                        WHERE S.id_serie=A.id_serie
                        AND S.id_formation = '$cal'
                        AND A.id_serie = '$blanc'
                        AND S.id_stag='$user'
                        AND S.type_exo = 'f'
                        AND ordre=ordre_etape;";
        }
        // Peu importe le calendrier
        else
        {
                // echo "cal == 0" ;

                // On rcupre score pour ce stagiare  cet srie
                $req_score_user="SELECT S.score, A.point
                        FROM res_serie_exo S, asso_exo_serie A
                        WHERE S.id_serie=A.id_serie
                        AND A.id_serie = '$blanc'
                        AND S.id_stag='$user'
                        AND S.type_exo = 'f'
                        AND ordre=ordre_etape;";
        }

        $resulScore=pg_exec($db,$req_score_user);
        $nbScore=pg_numrows($resulScore);

        // Initialisations
        $score_total=0;
        $score_max=0;

        // On calcul el score obtenu par ce stagiaire
        for($i=0;$i<$nbScore;$i++)
        {
                        $rowScore=pg_fetch_row($resulScore,$i);
                        $score_total+=$rowScore[0];
                        // $score_max+=$rowScore[2];
                        $score_max+=$rowScore[1];
                        // DEBUG echo "BLANC score : $rowScore[0]/$rowScore[1]<br>";
        }


        /*if($nbScore >1)
                die("$ERROR_0");//Base de donnes corrompue (erreur 16)*/

        // Il y a des rsultats
        if($nbScore != 0)
        {
                $rowScore=pg_fetch_row($resulScore,0);
                $Score_Blanc_Fct = $score_total ;
                $Tab_Val_Max_Qcm[$blanc]=$score_max ;
                return($Score_Blanc_Fct);
        }
        //On met un boolean a vrai si l'utilisateur n'a pas repondu
        else
        {
                global $pas_repondu;
                $pas_repondu=1;
                return($Score_Blanc_Fct);
        }
}




//-----------------------------------------------------------------------------------------------------------------------
// Fonction qui retourne le score obtenu par un utilisateur  une srie avec la formation connue ou non
//-----------------------------------------------------------------------------------------------------------------------
function getScoreSerie($user,$qcm,$cal){
        global $ERROR_0;
        $Score_Qcm_Fct=0;
        global $Tab_Val_Max_Qcm;
        global $db;
        //pour chaque utilisateur on calcul son score
        if($cal != 0)
        {
                // On rcupre score pour ce stagiare  cet srie
                $req_score_user="SELECT S.score, A.point
                        FROM res_serie_exo S, asso_exo_serie A
                        WHERE S.id_serie=A.id_serie
                        AND S.id_formation = '$cal'
                        AND A.id_serie = '$qcm'
                        AND S.id_stag='$user'
                        AND ordre=ordre_etape;";
        }
        // Peu importe le calendrier
        else
        {
                // echo "cal == 0" ;
                // On rcupre score pour ce stagiare  cet srie
                $req_score_user="SELECT S.score, A.point
                        FROM res_serie_exo S, asso_exo_serie A
                        WHERE S.id_serie=A.id_serie
                        AND A.id_serie = '$qcm'
                        AND S.id_stag='$user'
                        AND ordre=ordre_etape;";
        }

        $resulScore=pg_exec($db,$req_score_user);
        $nbScore=pg_numrows($resulScore);

        // Initialisations
        $score_total=0;
        $score_max=0;

        // On calcul el score obtenu par ce stagiaire
        for($i=0;$i<$nbScore;$i++)
        {
                $rowScore=pg_fetch_row($resulScore,$i);
                $score_total+=$rowScore[0];
                // $score_max+=$rowScore[2];
                $score_max+=$rowScore[1];
                // DEBUG echo "QCM score : $rowScore[0]/$rowScore[1]<br>";
        }

        // S'il y a des rsultats
        if($nbScore != 0)
        {
                $rowScore=pg_fetch_row($resulScore,0);
                // $Score_Qcm_Fct = $rowScore[0];
                // $Tab_Val_Max_Qcm[$qcm]=$rowScore[1];
                $Score_Qcm_Fct = $score_total ;
                $Tab_Val_Max_Qcm[$qcm]=$score_max ;
                return($Score_Qcm_Fct);
        }
        // S'il n'y a aucun rsultat
        else
        {
                global $pas_repondu;
                $pas_repondu=1;
                return($Score_Qcm_Fct);
        }
}


?>