<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


//Script qui trace un graph en barre
//les paramtres  passer : 
// $largeur, $hauteur et un tableau de $points
//Header( "Content-type: image/png");

if(!(isset($largeur))){
  $largeur=750;
}

if(!(isset($hauteur))){
  $hauteur=300;
}
$margex=100;
$margey=40;
$image = imagecreate($largeur,$hauteur);

$maroon = ImageColorAllocate($image,100,0,0);
$white = ImageColorAllocate($image,255,255,255);
$red = ImageColorAllocate($image,255,0,0);
$blue = ImageColorAllocate($image,0,0,255);
$grey = ImageColorAllocate($image,200,200,200);
$black = ImageColorAllocate($image,0,0,0);

ImageFilledRectangle($image,0,0,$largeur,$hauteur,$white);
ImageFilledRectangle($image,$margex,$margey,$largeur-$margex,$hauteur-$margey,$grey);

// //initialisation du tableau de points
// if(!(isset($points))){
//   srand((float) microtime()*1000000);
//   for($i=0;$i<20;$i++){
//     $nb = rand(0,10);
//     $points[$i]=($nb);
//   }
// }

//affichage du titre
if(!(isset($titre))){
  $titre="Titre du Graph";
}
else{
  $titre=ereg_replace("_"," ",$titre);
  $titre=ereg_replace("'","",$titre);
  $titre=ereg_replace("@","'",$titre);
}
$titlefont = 5; 

$txtsz = imagefontwidth($titlefont) * strlen($titre);

$xpos = (int)($margey/2 + ($largeur - $txtsz)/2); // center the title 
$xpos = max(1, $xpos); // force positive coordinates 
$ypos = $margey/3; // distance from top 
imagestring($image, $titlefont, $xpos, $ypos, $titre , $black);




//Tracage de la grille
$taillefont=2;
//$nb_separation=max($points);
$nb_separation=5;
$haut = ($hauteur-(2*$margey)) / ($nb_separation);

for($i=0;$i<=($nb_separation);$i++){

  $ypos=$margey + $hauteur - (int)($i*$haut);
  $ypos=$ypos-(2*$margey);
  //$ypos=$ypos-$haut;

  //$vmargin + $ysize - (int)($i*$haut)
  if(($i%10) == 0 || $nb_separation < 20){
    ImageLine($image,$margex, $ypos,$largeur-$margex,
	      $ypos,$red);


    $valeur=((max($points))/$nb_separation)*$i;
    //$valeur=sprintf("%02.2f",$valeur);
    $valeur=$valeur*100;
    $valeur=round($valeur);
    $valeur=$valeur/100;
    if($round == 0)$valeur=round($valeur);
    $center=imagefontwidth($taillefont) * strlen($valeur);
    $center = (int)($margex - $center);
    imagestring($image, $taillefont, $center,$ypos-(imagefontheight($taillefont)/2) , round($valeur) , $maroon);
  }
  //imagestring($image, $taillefont, $center,$ypos-(imagefontheight($taillefont)/2) , max($points) , $maroon);
}

//fin de la grille

//Debut des barres

$espace_col=3;
$largeur_grille=$largeur-(2*$margex);
$largeur_col=$largeur_grille/(sizeof($points));//+((2*sizeof($points))*$espace_col);

//cacul de l'chelle
$max_val=max($points);
if($max_val==0) $max_val=1;
$echelle=(($hauteur-2*$margey)/($max_val));
//$echelle=round($echelle)+1;
$x=array();$y=array();$xx=array();$yy=array();
//on dessine les barres
for($i=0;$i<sizeof($points);$i++){
  ImageFilledRectangle($image,
		       $margex+($largeur_col*$i)+$espace_col,
		       (($hauteur-$margey)-$echelle*$points[$i]),
		       $margex+($largeur_col*($i+1))-$espace_col,
		       $hauteur-$margey,
		       $blue);
  $x[$i]=round($margex+($largeur_col*$i)+$espace_col);
  $y[$i]=round((($hauteur-$margey)-$echelle*$points[$i]));
  $xx[$i]=round($margex+($largeur_col*($i+1))-$espace_col);
  $yy[$i]=round($hauteur-$margey);
  //label des colonnes
  $taille_label=imagefontwidth($taillefont) * strlen((int)($i+1)); 
  imagestring($image,$taillefont,$margex+($largeur_col*$i)+$taille_label/2+$espace_col,$hauteur-($margey),$i+1,$black);

}

//Legendes des axes
//Axe horizontal
imagestring($image,$taillefont,
	    $largeur-$margex-(imagefontwidth($taillefont)*strlen($axe_hor)),
	    $hauteur-$margey +15,
	    $axe_hor,
	    $black);
//Axe vertical
//On decoupe la legende de l axe vertical pour que l'afficher sur plusieurs lignes
//si ncssaire
$tab_axe=array();
$taille=$margex-imagefontwidth($taillefont)*strlen(max($points));
$tok=strtok($axe_vert," ");
$indice=0;
while($tok){
  if((strlen($tab_axe[$indice])+1+strlen($tok))*imagefontwidth($labelfont)<$taille){
    $tab_axe[$indice].=" $tok";
  }
  else{
    $indice++;
    $tab_axe[$indice]=$tok;
  }
  $tok=strtok(" ");
}
$espace_ligne=2;
$posy=$margey;
while(list(,$valeur)=each($tab_axe)){
  imagestring($image,$taillefont,
	      0,
	      $posy,
	      $valeur,
	      $black);
  $posy=$posy+$espace_ligne+imagefontheight($taillefont);	      
}

ImagePNG($image,"cache/$fic");
ImageDestroy($image);

?>
