<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

//**********************************************************************
// Fichier : /home/cblonde/pub/taff/cache/pdf_Afide.php
// Cration : jeudi 09 mai 2002 16:41:44
// Auteur : Charles Blonde
//
// Fontionnalits : Classe pour creer des fichier PDF personnalise pour Afide
//
//
//**********************************************************************/
//include("../../dbpostgres.php3");

//define('FPDF_FONTPATH',"$chemin_bo/stats/pdf/fpdf/font/");

class pdf_Afide extends FPDF{
  var $header_titre;
  var $widths;
var $aligns;
//variables du parseur html
var $B;
var $I;
var $U;
var $HREF;
var $fontList;
var $issetfont;
var $issetcolor;

  function Header()
    {
      //Police Arial gras 15
      $this->SetFont('Arial','',8);
      //Dcalage
      //$this->Cell(80);
      //Titre encadr
      $this->Cell(210-2*$this->lMargin,5,$this->header_titre,0,0,'R');
      //$this->Cell(210-2*$this->lMargin,5,"Test de haut de page",0,0,'R');
      //Saut de ligne
      $this->Ln(20);
    }

  function setHeaderTitre($titre){
    $this->header_titre=$titre;
  }

  function Footer()
    {
      $this->SetY(-20);
      //Police Arial italique 8
      $this->SetFont('Arial','I',8);      
      $this->Cell(0,10,'Page '.$this->PageNo(),0,0,'C');
    }

function SetWidths($w)
{
    //Tableau des largeurs de colonnes
    $this->widths=$w;
}

function SetAligns($a)
{
    //Tableau des alignements de colonnes
    $this->aligns=$a;
}

function Row($data)
{
    //Calcule la hauteur de la ligne
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=5*$nb;
    //Effectue un saut de page si ncessaire
    $this->CheckPageBreak($h);
    //Dessine les cellules
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        //$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
        $a='C';
        //Sauve la position courante
        $x=$this->GetX();
        $y=$this->GetY();
        //Dessine le cadre
        $this->Rect($x,$y,$w,$h);
        //Imprime le texte
        $this->MultiCell($w,5,$data[$i],0,$a);
        //Repositionne  droite
        $this->SetXY($x+$w,$y);
    }
    //Va  la ligne
    $this->Ln($h);
}

function CheckPageBreak($h)
{
    //Si la hauteur h provoque un dbordement, saut de page manuel
    if($this->GetY()+$h>$this->PageBreakTrigger)
        $this->AddPage($this->CurOrientation);
}

function NbLines($w,$txt)
{
    //Calcule le nombre de lignes qu'occupe un MultiCell de largeur w
    $cw=&$this->CurrentFont['cw'];
    if($w==0)
        $w=$this->w-$this->rMargin-$this->x;
    $wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
    $s=str_replace("\r",'',$txt);
    $nb=strlen($s);
    if($nb>0 and $s[$nb-1]=="\n")
        $nb--;
    $sep=-1;
    $i=0;
    $j=0;
    $l=0;
    $nl=1;
    while($i<$nb)
    {
        $c=$s[$i];
        if($c=="\n")
        {
            $i++;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
            continue;
        }
        if($c==' ')
            $sep=$i;
        $l+=$cw[$c];
        if($l>$wmax)
        {
            if($sep==-1)
            {
                if($i==$j)
                    $i++;
            }
            else
                $i=$sep+1;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
        }
        else
            $i++;
    }
    return $nl;
}

}


?>