<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

define('FPDF_FONTPATH','../font/');
require('../fpdf.php');

class PDF extends FPDF
{
//En-tte
function Header()
{
	//Logo
	$this->Image('logo_pb.png',10,8,33);
	//Police Arial gras 15
	$this->SetFont('Arial','B',15);
	//Dcalage  droite
	$this->Cell(80);
	//Titre
	$this->Cell(30,10,'Titre',1,0,'C');
	//Saut de ligne
	$this->Ln(20);
}

//Pied de page
function Footer()
{
	//Positionnement  1,5 cm du bas
	$this->SetY(-15);
	//Police Arial italique 8
	$this->SetFont('Arial','I',8);
	//Numro de page
	$this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
}
}

//Instanciation de la classe drive
$pdf=new PDF();
$pdf->Open();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Times','',12);
for($i=1;$i<=40;$i++)
	$pdf->Cell(50,10,'Impression de la ligne numro '.$i,0,1);
$pdf->Output();
?>
