<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


    require('../dbpostgres.php3');
    if($archive==1)
        $nombase=$nombase."_archive";
    $db = pg_Connect("$server", "", "", "", "$nombase");

    require('../lib/lib_stats.php');
    $styleCSS="../style/".MY_STYLE."/ressourcesAdministratives.css";
    $titre=MENU_36;
    $nompage="details_type.php";

    include('../entete.php3');

    // affiche l'entete correspondant  la page de stats concern ainsi que le niveau
    // d'information voulue
    if($stats=="formations")
        statsFormation($num_cal,1);
    else
        statsStagiaire($utilisateur,$num_cal,3);

    // selon le type d'exo, on affiche soit le tableaux de notes contenant les diffrentes sries
    if(!isset($type))
    {
        $affiche_tab=tableauNotes($num_grp,$utilisateur,$num_cal,$tabSerie,1,$archive);
        echo "$affiche_tab<br>";
        // remplace les "" par "e" pour l'image du graphique (evite bug d'affichage)
        //$typeSerie=str_replace("","e",$typeSerie);
		if(CHARSET=='UTF-8')
			$typeSerie=utf8_decode($typeSerie);
        $nom_fichier=$num_cal."_".$num_grp."_".$typeSerie;
        $nom_fichier=str_replace(" ","_",$nom_fichier);
        genererGraph($typeSerie,$tab_points,$tab_libelles,550,300,$nom_fichier);
    }
    else
    {
        // soit le tableaux concernant les exos  tlcharger
        switch ($type){
            case "tp" :
                    $affiche_tab=tableauTP($num_grp,$utilisateur,$num_cal,1,$archive);
                    //$affiche_tab=tableauExos($num_grp,$utilisateur,$num_cal,1);
                    echo "$affiche_tab<br>";
                    // remplace les "" par "a" pour l'image du graphique (evite bug d'affichage)
                    //$typeSerie=str_replace("","a",$typeSerie);
                    // remplace les "" par "e" pour l'image du graphique (evite bug d'affichage)
                    //$typeSerie=str_replace("","e",$typeSerie);
					if(CHARSET=='UTF-8'){
						$typeSerie=utf8_decode($typeSerie);
						
					}
                    $nom_fichier=$num_cal."_".$num_grp."_exotlc";
					//print_r($tab_libelles);
                    genererGraph($typeSerie,$tab_points,$tab_libelles,600,300,$nom_fichier);
                    break ;
            // soit le graphique du sondage
            case "sondage" :
                    print("<br><table class=\"tableau_espace\">
                            <tr align=\"center\" class=\"couleur1\">
                                <td width=\"50%\"><b>$MSG_2470</b></td>
                                <td width=\"50%\">$titreSerie</td>
                            </tr>
                    ");
                    $ressondage=get_serie_sondage($id_serie);
					$nb_sondage=pg_num_rows($ressondage);
					for($s=0;$s<$nb_sondage;$s++){
						$row=pg_fetch_row($ressondage,$s);
						$obj_sondage=new Sondage($row[0]);
						$lib_sondage=$obj_sondage->toString() ;
						$pourc=0;
						$non_vote=0;
	
						print("<tr align=\"center\" class=\"couleur2\">
									<td colspan=\"2\"><i>$lib_sondage</i></td>
									</tr>");
	
						// on recupere les propositions rattaches au sondage
						$res=get_sondage_propositions($row[0]);
						$nbpropositions=pg_num_rows($res);
	
						for($i=0;$i<$nbpropositions;$i++){
							$pourc=0;
						$non_vote=0;
							$rw=pg_fetch_row($res,$i);
	
							if($stats=="formations")
								$rez=get_sondage_nbreponses_formation($id_serie,$rw[0],$num_cal);
							else
								$rez=get_sondage_nbreponses_stagiaire($id_serie,$rw[0],$num_cal,$utilisateur);
	
							$row=pg_fetch_row($rez,0);
	
							//calcul du pourcentage
							if($stats=="formations")
							{
								$effectif=get_formation_effectif_groupe($num_cal);
								$pourc=$row[0]/$effectif*100;
							}
							else $pourc=$row[0]*100;
	
							$non_vote+=$pourc ;
	
							print("<tr align=\"center\" class=\"couleur3\"><td>$rw[1]</td>
										<td>$pourc %</td></tr>");
						}
	
						// dans le cas o un stagiaire n'a pas vot, on ajoute une ligne "non vot"
						$non_vote=100-$non_vote ;
						if($non_vote!=0)
							print("<tr align=\"center\" class=\"couleur3\"><td><i>$MSG_1732</i></td>
										<td>$non_vote %</td></tr>");
					}
                    print("</table>");
                    break ;
        }

    }

    // Bouton RETOUR + Pied de page
    print("<br>\n<center><form><input type=\"button\" value=\"$MSG_37\" onClick=\"history.back()\"></form>\n</center>\n");
    include('../piedpage.php3');
?>