<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

if(isset($chemin_bo)){
  include("$chemin_bo/stats/constantes.php3");
}
else{
  include("../constantes.php3");
}

function ajouter_hexcouleur($img, $couleur) {
  $rouge = HexDec(substr($couleur, 0, 2));
  $vert = HexDec(substr($couleur, 2, 2));
  $bleu = HexDec(substr($couleur, 4, 2));
  
  return imagecolorallocate($img, $rouge, $vert, $bleu);
}

function getNomMois($date){
  list($annee,$mois,$jour)=split('[-\' \']',$date,3);
  switch ($mois){
    case "01";
    return("de_janvier");
    case "02";
    return("de_fvrier");
    case "03";
    return("de_mars");
    case "04";
    return("d@avril");
    case "05";
    return("de_mai");
    case "06";
    return("de_juin");
    case "07";
    return("de_juillet");
    case "08";
    return("d@aout");
    case "09";
    return("de_septembre");
    case "10";
    return("d@octobre");
    case "11";
    return("de_novembre");
    case "12";
    return("de_dcembre");
  }
}


function getNomMoisParNum($mois){
  if(MY_LANG=="english"){
         switch ($mois){
                case "01";
                         return("january");
                case "02";
                         return("february");
                case "03";
                        return("march");
                 case "04";
                        return("april");
                case "05";
                        return("may");
                case "06";
                        return("june");
                case "07";
                        return("july");
                case "08";
                        return("august");
                case "09";
                        return("september");
                case "10";
                        return("october");
                case "11";
                        return("november");
                case "12";
                        return("december");
         }
   }
   else{
            switch ($mois){
                case "01";
                         return("janvier");
                case "02";
                         return("fvrier");
                case "03";
                        return("mars");
                 case "04";
                        return("avril");
                case "05";
                        return("mai");
                case "06";
                        return("juin");
                case "07";
                        return("juillet");
                case "08";
                        return("aout");
                case "09";
                        return("septembre");
                case "10";
                        return("octobre");
                case "11";
                        return("novembre");
                case "12";
                        return("dcembre");
         }
   }
}



function getNumMois($date){
  list($annee,$mois,$jour)=split('[-\' \']',$date,3);
  return($mois);
}


$repCache="cache";

function getNomMoisBis($mois){
  switch($mois){
  case (1):
    return("de Janvier");
    break;
  case (2):
    return("de Fvrier");
    break;
  case (3):
    return("de Mars");
    break;
  case (4):
    return("d'Avril");
    break;
  case (5):
    return("de Mai");
    break;
  case (6):
    return("de Juin");
    break;
  case (7):
    return("de Juillet");
    break;
  case (8):
    return("d'Aout");
    break;
  case (9):
    return("de Septembre");
    break;
  case (10):
    return("d'Octobre");
    break;
  case (11):
    return("de Novembre");
    break;
  case (12):
    return("de Dcembre");
    break;
  }
}

function getTabDate($date){
  $date=ereg_replace(' ','-',$date);
  $date=ereg_replace(':','-',$date);
  //$date=ereg_replace('+','-',$date);
  $stok=explode('-',$date);
  return($stok);
}


function getJour($date){
  $tabDate=getTabDate($date);
  return($tabDate[2]);  
}

function getMois($date){
  $tabDate=getTabDate($date);
  return($tabDate[1]);
  
}

function getAnnee($date){
  $tabDate=getTabDate($date);
  return($tabDate[0]);  
}

function getHeure($date){
  $tabDate=getTabDate($date);
  return($tabDate[3]);  
}

function getMinute($date){
  $tabDate=getTabDate($date);
  return($tabDate[4]);  
}

function getSeconde($date){
  $tabDate=getTabDate($date);
  $sec=$tabDate[5];
  return(substr($sec,0,2));  
}


/**
 * Fonction qui retourne le score de l'utilisateur $user et met la variable
 * global val_Max_Qcm si elle n'existe pas deja
 * et le nbre de points possible total du qcm $qcm
 * $user = le numero de l'utilisateur
 * $qcm = le numro du qcm
 * $cal le numro de calendrier = 0 si ce n'est pas important
 **/
function getScoreQcm($user,$qcm,$cal){
  $Score_Qcm_Fct=0;
  global $Tab_Val_Max_Qcm;
  global $db;
  //pour chaque utilisateur on calcul son score
  if($cal != 0){
    $req_score_user="SELECT result_qstn,total
                   FROM gestionqstn gq, calendrier c
                   WHERE gq.num_cal = c.num_cal
                   AND c.num_cal = '$cal'
                   AND gqstn_num_qstaire = '$qcm'
                   AND gqstn_num_user = $user";
  }else{
    $req_score_user="SELECT result_qstn,total
                   FROM gestionqstn gq
                   WHERE gqstn_num_qstaire = '$qcm'
                   AND gqstn_num_user = $user";
  }
  $resulScore=pg_exec($db,$req_score_user);
  $nbScore=pg_numrows($resulScore);
  if($nbScore >1){
    print("gqstn_num_qstaire = $qcm <br>");
    print("gqstn_num_user = $user <br>");
    print("option : num_cal = $cal <br>");
    die("Base de donnes corrompue");
  }
  if($nbScore != 0){
    $rowScore=pg_fetch_row($resulScore,0);
    $Score_Qcm_Fct = $rowScore[0];
    $Tab_Val_Max_Qcm[$qcm]=$rowScore[1];
    return($Score_Qcm_Fct);
  }
  //On met un boolean a vrai si l'utilisateur n'a pas repondu
  else{
    global $pas_repondu;
    $pas_repondu=1;
    return($Score_Qcm_Fct);
  }
}

/**
 * Fonction qui retourne le score de l'utilisateur $user et met la variable
 * global val_Max_Blanc si elle n'existe pas deja
 * et le nbre de points possible total d e la serie $blanc
 * $user = le numero de l'utilisateur
 * $blanc = le numro de la serie
 * $cal le numro de calendrier = 0 si ce n'est pas important
 **/
function getScoreBlanc($user,$blanc,$cal){
  $Score_Blanc_Fct=0;
  global $Tab_Val_Max_Blanc;
  global $db;
  //pour chaque utilisateur on calcul son score
  //if($cal != 0){
    $req_score_user="SELECT score
                   FROM res_serie rs, calendrier c
                   WHERE rs.id_formation = c.num_cal
                   AND c.num_cal = '$cal'
                   AND rs.id_serie = '$blanc'
                   AND rs.id_stag = $user
                   and date_fin>0 ";
  /*
  }else{
    $req_score_user="SELECT result_qstn,total
                   FROM gestionqstn gq
                   WHERE gqstn_num_qstaire = '$qcm'
                   AND gqstn_num_user = $user";
  }
  */
  $resulScore=pg_exec($db,$req_score_user);
  $nbScore=pg_numrows($resulScore);
  if($nbScore >1){
    print("id_serie = $blanc <br>");
    print("gqstn_num_user = $user <br>");
    print("option : num_cal = $cal <br>");
    die("Base de donnes corrompue");
  }
  if($nbScore != 0){
    $rowScore=pg_fetch_row($resulScore,0);
    $Score_Blanc_Fct = $rowScore[0];
    $Tab_Val_Max_Blanc[$blanc]=$rowScore[0];
    return($Score_Blanc_Fct);
  }
  //On met un boolean a vrai si l'utilisateur n'a pas repondu
  else{
    global $pas_repondu;
    $pas_repondu=1;
    return($Score_Blanc_Fct);
  }
}

/**
 * Fonction qui retourne le score d'un groupe  un qcm $qcm
 * donn ainsi que le score max de ce qcm
 * $cal = le numero de calendrier
 * $qcm = le numro du qcm
 */
function getScoreQcmCal($cal,$qcm){
  global $db;
  $req_score="SELECT result_qstn,date_fin,total
              FROM gestionqstn gq,calendrier c
              WHERE gq.num_cal = c.num_cal
              AND c.num_cal = '$cal'
              AND gqstn_num_qstaire = '$qcm'
              ORDER BY date_fin
              ";
  $resScore=pg_exec($db,$req_score);
  $nbScore=pg_numrows($resScore);
  $score_total=0;
  $score_max=0;
  for($i=0;$i<$nbScore;$i++){
    $rowScore=pg_fetch_row($resScore,$i);
    $score_total+=$rowScore[0];
    $score_max+=$rowScore[2];
  }

  $tabRetour[0]=$score_total;
  $tabRetour[1]=$score_max;
  return($tabRetour);
}

/**
 * Fonction qui retourne le score d'un groupe  un blanc $qcm
 * donn ainsi que le score max de ce blanc
 * $cal = le numero de calendrier
 * $qcm = le numro du qcm
 */
function getScoreBlancCal($cal,$blanc){
  global $db;
  $req_score="SELECT score
              FROM res_serie rs,calendrier c
              WHERE rs.id_formation = c.num_cal
              AND c.num_cal = '$cal'
              AND rs.id_serie = '$blanc'
              and date_fin>0
              ORDER BY date_fin";
  $resScore=pg_exec($db,$req_score);
  $nbScore=pg_numrows($resScore);
  $score_total=0;
  $score_max=0;
  for($i=0;$i<$nbScore;$i++){
    $rowScore=pg_fetch_row($resScore,$i);
    $score_total+=$rowScore[0];
    //$score_max+=$rowScore[2];
  }
  $score_max=20;

  $tabRetour[0]=$score_total;
  $tabRetour[1]=$score_max;
  return($tabRetour);
}

/**
 * Methode qui retourne la moyenne ainsi qu'une couleur pour afficher
 * $score : Le score obtenu
 * $max : le max possible
 * return : un tableau de deux cases qui contient:
 * un double : la moyenne sur 20 avec deux chiffres apres la virgule
 * une couleur : pour afficher la cellule
 */
function calculMoyenne($score){
  $tabRetour=array();
  $tabRetour[0]="X";
  $tabRetour[1]="#FFFFFF";

  global $bonne_reponse;
  global $mauvaise_reponse;

  if($score != 0){

    $tabRetour[0]=$score;
    if($tabRetour[0]<10){
      $tabRetour[1]="$mauvaise_reponse";
    }
    else $tabRetour[1]="$bonne_reponse";
  }
  return($tabRetour);
}
// version pour les TP dans fichier react_formateur.php dans le repertoire classement => A revoir car code pas tres propre
function calculMoyenne2($score, $max){
  $tabRetour=array();
  $tabRetour[0]="X";
  $tabRetour[1]="#FFFFFF";

  global $bonne_reponse;
  global $mauvaise_reponse;

  if($max != 0){
    $moy=($score * (20/$max));
    $moy *= 100;
    $moy=round($moy);
    $moy /= 100;
    $tabRetour[0]=$moy;
    if($tabRetour[0]<10){
      $tabRetour[1]="$mauvaise_reponse";
    }
    else $tabRetour[1]="$bonne_reponse";
  }
  return($tabRetour);
}


/**
 * ANCIENNE VERSION NECESSAIRE POUR UPDATER LA BASE GESTIONQSTN
 *                  A EFFACER PAR LA SUITE
 * Fonction qui retourne le score de l'utilisateur $user et met la variable
 * global val_Max_Qcm si elle n'existe pas deja
 * et le nbre de points possible total du qcm $qcm
 * $user = le numero de l'utilisateur
 * $qcm = le numro du qcm
 * $cal le numro de calendrier = 0 si ce n'est pas important
 **/
function getScoreQcmUpdate($user,$qcm,$cal){
  $Score_Qcm_Fct=0;
  //print("ici");
  global $db;
  //pour chaque utilisateur on calcul son score
  if($cal != 0){
    $req_score_user="SELECT result_qstn
                   FROM gestionqstn gq, calendrier c
                   WHERE gq.num_cal = c.num_cal 
                   AND c.num_cal = '$cal'
                   AND gqstn_num_qstaire = '$qcm'
                   AND gqstn_num_user = $user";
  }else{
    $req_score_user="SELECT result_qstn
                   FROM gestionqstn gq                   
                   WHERE gqstn_num_qstaire = '$qcm'
                   AND gqstn_num_user = $user";
  }
  $resulScore=pg_exec($db,$req_score_user);
  $nbScore=pg_numrows($resulScore);
  print("nbScore = $nbScore <br>");
  if($nbScore >1){
    print("user = $user <br>");
    print("qcm = $qcm <br>");
    die("Base de donnes corrompue");  
  }
  if($nbScore != 0){
    $rowScore=pg_fetch_row($resulScore,0);
    $Score_Qcm_Fct = $rowScore[0];
  }
  //On met un boolean a vrai si l'utilisateur n'a pas repondu
  else{
    global $pas_repondu;
    $pas_repondu=1;
    return($Score_Qcm_Fct);
  }


  global $Tab_Val_Max_Qcm;
  //Si val_Max_Qcm est dja valu, c plus la peine de le calculer
  if(isset($Tab_Val_Max_Qcm[$qcm]))
    return($Score_Qcm_Fct);

  //On calcul le nbre de points max du qcm
  //calcul des score max du qcm
  //Question avec poids spcifique  la question
  if($cal != 0){
    $qcm1="SELECT poids 
         FROM elaborqstn,questionnaire,gestionqstn gq 
         WHERE (elaborqstn.num_bareme IS NULL OR elaborqstn.num_bareme = 0) 
         AND gqstn_num_qstaire= num_qstaire
         AND num_qstaire = eq_num_qstaire 
         AND (questionnaire.num_bareme=0 OR questionnaire IS NULL) 
         AND eq_num_qstaire = '$qcm'
         AND gq.num_cal = '$cal'
         AND gq.gqstn_num_user = '$user'";
  }else{
    $qcm1="SELECT poids 
         FROM elaborqstn,questionnaire,gestionqstn gq 
         WHERE (elaborqstn.num_bareme IS NULL OR elaborqstn.num_bareme = 0) 
         AND gqstn_num_qstaire= num_qstaire
         AND num_qstaire = eq_num_qstaire 
         AND (questionnaire.num_bareme=0 OR questionnaire IS NULL) 
         AND eq_num_qstaire = '$qcm'
         AND gq.gqstn_num_user = '$user'";
  }
  $resul2=pg_exec($db,$qcm1);
  $max_points_possible_qcm=0;
  $nb2=pg_numrows($resul2);
  for($j=0;$j<$nb2;$j++){
    $rowresul2=pg_fetch_row($resul2,$j);
    $Tab_Val_Max_Qcm[$qcm] += $rowresul2[0];
  }
   

  //Question avec poids non spcifique  la question
  if($cal != 0){
    $qcm1="SELECT poids_qstaire 
         FROM elaborqstn,questionnaire,gestionqstn gq 
         WHERE (elaborqstn.num_bareme IS NULL OR elaborqstn.num_bareme = 0) 
         AND (poids=0 OR poids IS NULL)
         AND gqstn_num_qstaire= num_qstaire
         AND num_qstaire = eq_num_qstaire 
         AND (questionnaire.num_bareme=0 OR questionnaire IS NULL) 
         AND eq_num_qstaire = '$qcm'
         AND gq.num_cal = '$cal'
         AND gq.gqstn_num_user = '$user'";
  }else{
    $qcm1="SELECT poids_qstaire 
         FROM elaborqstn,questionnaire,gestionqstn gq 
         WHERE (elaborqstn.num_bareme IS NULL OR elaborqstn.num_bareme = 0) 
         AND (poids=0 OR poids IS NULL)
         AND gqstn_num_qstaire= num_qstaire
         AND num_qstaire = eq_num_qstaire 
         AND (questionnaire.num_bareme=0 OR questionnaire IS NULL) 
         AND eq_num_qstaire = '$qcm'
         AND gq.gqstn_num_user = '$user'";
  }
  $resul2=pg_exec($db,$qcm1);
  $nb2=pg_numrows($resul2);
  for($j=0;$j<$nb2;$j++){
    $rowresul2=pg_fetch_row($resul2,$j);
    $Tab_Val_Max_Qcm[$qcm] += $rowresul2[0];
  }
   
  //Question avec bareme. Le bareme de la question est prioritaire a celui du bareme
  if($cal != 0){
    $qcm2="SELECT repok FROM bareme b, elaborqstn e, gestionqstn g
             WHERE e.num_bareme = b.num_bareme
             AND e.eq_num_qstaire = g.gqstn_num_qstaire
             AND g.gqstn_num_qstaire='$qcm'
             AND g.num_cal = '$cal' 
             AND g.gqstn_num_user='$user'";
  }else{
    $qcm2="SELECT repok FROM bareme b, elaborqstn e, gestionqstn g
             WHERE e.num_bareme = b.num_bareme
             AND e.eq_num_qstaire = g.gqstn_num_qstaire
             AND g.gqstn_num_qstaire='$qcm'
             AND g.gqstn_num_user='$user'";
  }

  $resul2=pg_exec($db,$qcm2);
  $nb2=pg_numrows($resul2);
  for($j=0;$j<$nb2;$j++){
    $rowresul2=pg_fetch_row($resul2,$j);
    $Tab_Val_Max_Qcm[$qcm] += $rowresul2[0];
  }

  //Question avec bareme. Pas de bareme individuel pour la question
  if($cal != 0 ){
    $qcm3="SELECT repok 
             FROM bareme b,questionnaire q, elaborqstn e, gestionqstn g 
             WHERE b.num_bareme = q.num_bareme
             AND e.eq_num_qstaire = q.num_qstaire
             AND (e.num_bareme IS NULL OR e.num_bareme=0)
             AND e.eq_num_qstaire = g.gqstn_num_qstaire
             AND g.gqstn_num_qstaire = '$qcm'
             AND g.num_cal = '$cal'
             AND g.gqstn_num_user='$user'";
  }else{
    $qcm3="SELECT repok 
             FROM bareme b,questionnaire q, elaborqstn e, gestionqstn g 
             WHERE b.num_bareme = q.num_bareme
             AND e.eq_num_qstaire = q.num_qstaire
             AND (e.num_bareme IS NULL OR e.num_bareme=0)
             AND e.eq_num_qstaire = g.gqstn_num_qstaire
             AND g.gqstn_num_qstaire = '$qcm'
             AND g.gqstn_num_user='$user'";
  }

  $resul2=pg_exec($db,$qcm3);
  $nb2=pg_numrows($resul2);
  for($j=0;$j<$nb2;$j++){
    $rowresul2=pg_fetch_row($resul2,$j);
    $Tab_Val_Max_Qcm[$qcm] += $rowresul2[0];
  }
  //print("Tab_Val_Max_Qcm[$qcm] = $Tab_Val_Max_Qcm[$qcm]<br>");
  return($Score_Qcm_Fct);
}

/**********************************************
 * Methode qui retourne un tableau contenant
 * tout les QCMs fait par l'utilisateur et 
 * tri par date. Parametres : 
 * $db : Connexion  la base de donne
 * $user : le numero d'utilisateur
 **********************************************/
function getAllQcm($db,$user){
  $tabRetour=array();

  //requete
  $req_all_qcm="SELECT libelle_qstaire, result_qstn, total
                FROM gestionqstn gq, questionnaire q 
                WHERE gq.gqstn_num_qstaire = q.num_qstaire
                AND gq.gqstn_num_user = '$user'
                ORDER BY date_fin";

  $resultat=pg_exec($db,$req_all_qcm);
  $nbRes=pg_numrows($resultat);
  for($i=0;$i<$nbRes;$i++){
    $row=pg_fetch_row($resultat,$i);
    $label=$row[0];
    $tabRetour[$i][0]=$row[0];
    $tabRetour[$i][1]=$row[1];
    $tabRetour[$i][2]=$row[2];

  }

  return($tabRetour);
}
/**********************************************
 * Methode qui retourne un tableau contenant
 * tout les BLANCs fait par l'utilisateur . Parametres :
 * $db : Connexion  la base de donne
 * $user : le numero d'utilisateur
 **********************************************/
function getAllblanc($db,$user){
  $tabRetour=array();

  //requete
  $req_all_blanc="SELECT titre, score
                FROM res_serie rs, serie_exo sx
                WHERE rs.id_serie = sx.id
                AND rs.id_stag = '$user'
                and date_fin>0
                ORDER BY date_fin";

  $resultat=pg_exec($db,$req_all_blanc);
  $nbRes=pg_numrows($resultat);
  for($i=0;$i<$nbRes;$i++){
    $row=pg_fetch_row($resultat,$i);
    $label=$row[0];
    $tabRetour[$i][0]=$row[0];
    $tabRetour[$i][1]=$row[1];

    $tabRetour[$i][2]=20;

  }

  return($tabRetour);
}

/**********************************************
 * Methode qui retourne un tableau contenant 
 * tout les exos fait par l'utilisateur, pour
 * un calendrier donn, et tri par date.
 * Parametres : 
 * $db : Connexion  la base de donne
 * $user : le numero d'utilisateur
 * $cal : le numero du calendrier
 **********************************************/
function getExoCal($db,$user,$cal){

  $tabRetour=array();
  $req="SELECT titre, score, surtotal
        FROM resexouser r, exotlc e
        WHERE r.num_exo = e.num_exo
        AND r.num_cal='$cal'
        AND r.num_user = '$user'
        ORDER BY date_correction ";
  $res=pg_exec($db,$req);
  $nbExo=pg_numrows($res);
  for($i=0;$i<$nbExo;$i++){
    print("ici <br>");
    $rowExo=pg_fetch_row($res,$i);
    $tabRetour[$i][0]=$rowExo[0];
    $tabRetour[$i][1]=$rowExo[1];
    $tabRetour[$i][2]=$rowExo[2];
  }
  return($tabRetour);

}

/*-----------------------------------------------*/
//      Fonction qui retourne le numro du jour (0  n) en fonction de la
//      date et du numero de calendrier
//      Format date : 2002-01-31
/*-----------------------------------------------*/
function numero_du_jour($date,$numcal){
        // recup des jours en prsentiel du calendrier
        $req="select jour from dates where num_date in (select num_date from gest_cal where numtype='3' and gnum_cal='$numcal')";
        $res=pg_exec($req);
        // stockage
        $nb=pg_numrows($res);
        for($i=0;$i<$nb;$i++){
                $row=pg_fetch_row($res,$i);
                $tab[]=$row[0];
        }
        // tri croissant
        sort($tab);
        // recup numero du jour
        for($i=0;$i<$nb;$i++){
                if($tab[$i]==$date)
                        break;
        }
        return $i;

}



?>