<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

// page de stats par calendrier

    require('../dbpostgres.php3');
    if($archive==1)
        $nombase=$nombase."_archive";
    $db = pg_Connect("$server", "", "", "", "$nombase");

    require('../lib/lib_stats.php');
    $styleCSS="../style/".MY_STYLE."/ressourcesAdministratives.css";
    $titre=MENU_36;
    $nompage="statCal.php";
    include('../entete.php3');

    // si on vient de l'arborescence par formation, on dfinit une variable stats qui nous permettra
    // de savoir qu'on vient de l (necessaire pour savoir quels entetes ont affiches)
    if(!isset($stats))
        $stats="formations";

    // donc si on vient de formation on affiche l'entete pour les formations, sinon celle pr les stagiaires
    if($stats=="formations")
        statsFormation($num_cal,0);
    else
        statsStagiaire($utilisateur,$num_cal,2);

    if(!isset($utilisateur)) $utilisateur="";

    // on initialise les variables globales ds les fonctions permettant le calcul de la moyenne gnrale du groupe
    $moyenne_groupe=0;
    $nb_tableaux=0;

    // On commence par rpartir les diffrents types d'exo de la serie dans leurs rubriques correspondantes
    repartirSerie($num_cal,$utilisateur,$blanc,$sondage,$src,$qcm,$qrc,$dragdrop,$multiserie,$aleat,$aleat_mono,$aleat_multi);

    // On fusionne les tableaux de qcm et qrc en un seul, et les tableaux de sondages et src en un seul
    $qcmqrc=array_merge($qcm,$qrc);
    $sondagesrc=array_merge($sondage,$src);
    $aleatoire_tmp=array_merge($aleat,$aleat_mono);
    $aleatoire=array_merge($aleatoire_tmp,$aleat_multi);

    // On rcupere les moyennes generales de chacun des tableaux, et calcul en meme tps la moyenne generale du groupe
    $moy_qcm=tableauNotes($num_grp,$utilisateur,$num_cal,$qcmqrc,0);
    $moy_blanc=tableauNotes($num_grp,$utilisateur,$num_cal,$blanc,0);
    //moy_dragdrop=tableauNotes($num_grp,$num_cal,$dragdrop,0);
    $moy_multi=tableauNotes($num_grp,$utilisateur,$num_cal,$multiserie,0);
    $moy_aleat=tableauNotes($num_grp,$utilisateur,$num_cal,$aleatoire,0);

    $moy_exotlc=tableauTP($num_grp,$utilisateur,$num_cal,0);
    // a supprimer si tableauTP fonctionne correctement
    //$moy_exotlc=tableauExos($num_grp,$utilisateur,$num_cal,0);

    // Si au moins un des types de srie a t effectu par le groupe
    if($nb_tableaux>0){
        // on calcul la moyenne des tableaux (qui sera la moyenne generale du groupe)
        $moyenne_groupe=$moyenne_groupe/$nb_tableaux ;
        $moyenne_groupe=(round($moyenne_groupe*100))/100;

        //On affiche ensuite la moyenne de chacune des sries dans un second tableau
        $tab_recapitulatif="
                <table class=\"tableau_espace\">
                    <tr align=\"center\">
                        <th width=\"40%\">$MSG_2440</th>
                        <th width=\"25%\">$MSG_901</th>
                        <th width=\"35%\">$FORM_36</th>
                    </tr>";
        //Si les qcm sont prsent on ajoute une ligne dans le tableau
        if(isset($moy_qcm)){
            $typeSerie="$MSG_547";
            $lien=creeLien($qcmqrc);                                      
            $tab_recapitulatif.="<tr class=\"couleur3\" align=\"center\">
                        <td>$typeSerie</td>
                        <td>$moy_qcm</td>
                        <td><a class=\"action\" href=\"details_type.php?stats=$stats&num_cal=$num_cal&num_grp=$num_grp&utilisateur=$utilisateur&typeSerie=$typeSerie&$lien&archive=$archive\">$MSG_2469</a></td>
                    </tr>";
        }
        //Si les blancs sont prsent on ajoute une ligne dans le tableau
        if(isset($moy_blanc)){
            $typeSerie="$MSG_1201";
            $lien=creeLien($blanc);
            $tab_recapitulatif.="<tr class=\"couleur3\" align=\"center\">
                        <td>$typeSerie</td>
                        <td>$moy_blanc</td>
                        <td><a class=\"action\" href=\"details_type.php?stats=$stats&num_cal=$num_cal&num_grp=$num_grp&utilisateur=$utilisateur&typeSerie=$typeSerie&$lien&archive=$archive\">$MSG_2469</a></td>
                    </tr>";
        }
        //Si les drag & drop sont prsent on ajoute une ligne dans le tableau
        if(isset($moy_dragdrop)){
            $typeSerie="Drag and drop";
            $lien=creeLien($dragdrop);
            $tab_recapitulatif.="<tr class=\"couleur3\" align=\"center\">
                        <td>$typeSerie</td>
                        <td>$moy_dragdrop</td>
                        <td><a class=\"action\" href=\"details_type.php?stats=$stats&num_cal=$num_cal&num_grp=$num_grp&utilisateur=$utilisateur&typeSerie=$typeSerie&$lien&archive=$archive\">$MSG_2469</a></td>
                    </tr>";
        }
        //Si les multisries sont prsentes on ajoute une ligne dans le tableau
        if(isset($moy_multi)){
            $typeSerie="$MSG_1725";
            $lien=creeLien($multiserie);
            $tab_recapitulatif.="<tr class=\"couleur3\" align=\"center\">
                        <td>$typeSerie</td>
                        <td>$moy_multi</td>
                        <td><a class=\"action\" href=\"details_type.php?stats=$stats&num_cal=$num_cal&num_grp=$num_grp&utilisateur=$utilisateur&typeSerie=$typeSerie&$lien&archive=$archive\">$MSG_2469</a></td>
                    </tr>";
        }
        //Si les sries alatoires sont prsentes on ajoute une ligne dans le tableau
        if(isset($moy_aleat)){
            $typeSerie="$MSG_1726";
            $lien=creeLien($aleatoire);
            $tab_recapitulatif.="<tr class=\"couleur3\" align=\"center\">
                        <td>$typeSerie</td>
                        <td>$moy_aleat</td>
                        <td><a class=\"action\" href=\"details_type.php?stats=$stats&num_cal=$num_cal&num_grp=$num_grp&utilisateur=$utilisateur&typeSerie=$typeSerie&$lien&archive=$archive\">$MSG_2469</a></td>
                    </tr>";
        }
        //Si les multisries sont prsentes on ajoute une ligne dans le tableau
        if(isset($moy_exotlc)){
            $typeSerie="$MSG_1090";
            $tab_recapitulatif.="<tr class=\"couleur3\" align=\"center\">
                        <td>$typeSerie</td>
                        <td>$moy_exotlc</td>
                        <td><a class=\"action\" href=\"details_type.php?type=tp&stats=$stats&num_cal=$num_cal&num_grp=$num_grp&utilisateur=$utilisateur&typeSerie=$typeSerie&$lien&archive=$archive\">$MSG_2469</a></td>
                    </tr>";
        }
        //Dernire entre ligne du tableau : le total
        $tab_recapitulatif.="<tr class=\"couleur2\" align=\"center\">
                        <td><b>$MSG_2441</b></td>
                        <td><b>$moyenne_groupe</b></td>
                        <td><b>&nbsp;</b></td>
                    </tr>
                </table><br>";

        //on affiche
        echo "<br>$tab_recapitulatif";
    }
    else
    {
        if($stats=="formations")
        print("<br><b>$MSG_1574.</b><br>");
    }

    // les sondages :)
    //if($utilisateur=="")
    //{
        $affichage_sondage=tableauSondage($num_cal,$sondagesrc,$utilisateur,$archive);
        echo "<br>$affichage_sondage<br>";
    //}
    //else
    if($utilisateur!="")
        print("<br>\n<center><form><input type=\"button\" value=\"$MSG_37\" onClick=\"history.back()\"></form>\n</center>\n");


    include('../piedpage.php3');

?>