<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


    require('../dbpostgres.php3');
    if($archive==1)
        $nombase=$nombase."_archive";
    $db = pg_Connect("$server", "", "", "", "$nombase");

    require('../lib/lib_stats.php');
    $styleCSS="../style/".MY_STYLE."/ressourcesAdministratives.css";
    $titre=MENU_36;
    $nompage="statUser.php";


    include('../entete.php3');

    // variable permettant de savoir par quel menu on a acceder aux stats, ici c'est par les stagiaires
    if(!isset($stats))
        $stats="stagiaires";

    // on rcupere les formations, qui ont au moins un rsultat dans la table res_serie, et dans l'ordre chronologique
    $res_formation=get_stagiaire_formations_evaluees($num_user);
    $nb_formation=pg_num_rows($res_formation);

    // on affiche la capsule d'entete :
    // le nom et le prenom du stagiaire ainsi que le nombre de formation auquelle il participe
    if($stats=="stagiaires")
        statsStagiaire($num_user,$num_cal,1);

    // verification au cas ou...
    if($nb_formation==0)
        echo "<b>$MSG_1735.</b>";
    else
    {
        // entete du tableau
        print("<br><table class=\"tableau_espace\">
                    <tr>
                        <th width=\"45%\">$MSG_635</td>
                        <th width=\"25%\">$MSG_901</td>
                        <th width=\"30%\">$FORM_36</td>
                    </tr>
        ");

        // on initialise la moyenne generale de tte les formations
        $moy_all_formation=0;
        $nb_formations_notees=0;

        // on parcours les formations une  une
        for($i=0;$i<$nb_formation;$i++)
        {
            $row=pg_fetch_row($res_formation,$i);
            $num_cal=$row[0];

            $utilisateur=$num_user ;


            // $moyenne_groupe quivaut  la moyenne de l'utilisateur concerne uniquement, et correspond 
            // sa moyenne pr la formation courante (variable globale utilise dans d'autres fonctions donc ne
            // pas modifier le nom
            $moyenne_groupe=0;
            $nb_tableaux=0;

            // on vide tt les tableaux de type de srie afin de pouvoir les reremplir avec la formation en cours.
            unset($blanc);
            unset($sondage);
            unset($src);
            unset($qcm);
            unset($qrc);
            unset($dragdrop);
            unset($multiserie);
            unset($aleat);
            unset($aleat_mono);
            unset($aleat_multi);

            // On commence par rpartir les diffrents types d'exo de la serie dans leurs rubriques correspondantes
            repartirSerie($num_cal,$num_user,$blanc,$sondage,$src,$qcm,$qrc,$dragdrop,$multiserie,$aleat,$aleat_mono,$aleat_multi);

            // On fusionne les tableaux de qcm et qrc en un seul, et les tableaux de sondages et src en un seul
            $qcmqrc=array_merge($qcm,$qrc);
            $sondagesrc=array_merge($sondage,$src);
            $aleatoire_tmp=array_merge($aleat,$aleat_mono);
            $aleatoire=array_merge($aleatoire_tmp,$aleat_multi);


            // On rcupere les moyennes generales de chacun des tableaux, et calcul en meme tps la moyenne generale du stagiaire
            $moy_qcm=tableauNotes($num_grp,$utilisateur,$num_cal,$qcmqrc,0);
            $moy_blanc=tableauNotes($num_grp,$utilisateur,$num_cal,$blanc,0);
            //moy_dragdrop=tableauNotes($num_grp,$num_cal,$dragdrop,0);
            $moy_multi=tableauNotes($num_grp,$utilisateur,$num_cal,$multiserie,0);
            $moy_aleat=tableauNotes($num_grp,$utilisateur,$num_cal,$aleatoire,0);
            $moy_exotlc=tableauTP($num_grp,$utilisateur,$num_cal,0);

            $obj_formation=new Formation($row[0]);
            $titre_formation=$obj_formation->toString();
            $num_grp=$obj_formation->groupe->toString("[id]") ;

            // Si au moins un des types de srie a t effectu par le stagiare
            if($nb_tableaux>0)
            {
                // on calcul la moyenne des tableaux (qui sera la moyenne generale du stagiaire)
                $moyenne_groupe=$moyenne_groupe/$nb_tableaux ;
                $moyenne_groupe=(round($moyenne_groupe*100))/100;

                // on stock le nom de la formation et sa note dans des tableaux pour le generer le graphique
                $tab_notes[]=$moyenne_groupe ;
                $tab_labels[]=$titre_formation ;
                // on affiche la ligne courante pr une formation donne
                print("<tr align=\"center\" class=\"couleur3\">
                            <td>$titre_formation</td>
                            <td>$moyenne_groupe</td>
                            <td><a class=\"action\" href=\"statCal.php?stats=$stats&utilisateur=$num_user&num_cal=$row[0]&num_grp=$num_grp&archive=$archive\">$MSG_2415</a></td>
                        </tr>
                ");
                // on incrmente au total de tte les formations pr calculer par la suite la moyenne generale
                $moy_all_formation+=$moyenne_groupe ;
                $nb_formations_notees++ ;
            }
            // dans le cas ou c'est un sondage
            elseif(!empty($sondagesrc))
            {
                print("<tr align=\"center\" class=\"couleur3\">
                            <td>$titre_formation</td>
                            <td><i>$MSG_2461</i></td>
                            <td><a class=\"action\" href=\"statCal.php?stats=$stats&utilisateur=$num_user&num_cal=$row[0]&num_grp=$num_grp&archive=$archive\">$MSG_2471</a></td>
                        </tr>
                ");
            }
            // dans le cas ou c un test de positionnement
            else {
                // on recupere le parcours
                $numparcours=$obj_formation->parcours->toString("[num_parcours]");
                print("<tr align=\"center\" class=\"couleur3\">
                            <td>$titre_formation $nb_finie</td>
                            <td><i>$MSG_2478</i></td>
                            <td><a class=\"action\" href=\"details_pat.php?stats=$stats&num_user=$num_user&num_cal=$row[0]&parcours=$numparcours&archive=$archive\">$MSG_1736</a></td>
                         </tr>
                ");
            }
        }

        // moyenne generale de l'tudiant pr le total de ttes les formations
        if($nb_formations_notees!=0)
        {
            $moy_all_formation=$moy_all_formation/$nb_formations_notees ;
            $moy_all_formation=(round($moy_all_formation*100))/100;
        }
        else $moy_all_formation='X';

        // on affiche la derniere ligne du tableau
        print("<tr class=\"couleur2\" align=\"center\">
                    <td><b>$MSG_2441</b></td>
                    <td><b>$moy_all_formation</b></td>
                    <td>&nbsp;</td>
                </tr>
                </table><br>
        ");

    if($nb_formations_notees!=0)
    {
        // nom du fichier pour le graphique
        $nom_fichier=$nom_user."-".$prenom_user."-global.png";
        // on genere le graphique (param : titre, tableau de notes, tableau de libelles,largeur,hauteur,nom du fichier)
        genererGraph($nom_user." ".$prenom_user,$tab_notes,$tab_labels,600,300,$nom_fichier);
    }

    }

    include('../piedpage.php3');
?>