<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/***************************************************
 * Script qui cre un bouton sous forme d'image.
 * Toutes les images sont stockes dans le rep ./boutons/
 * Parametres : 
 * $label : l'inscription du bouton (deviendra aussi
 *          le nom du fichier.png)
 * $largeur : la largeur de l'image
 * $hauteur : la hauteur de l'image
 * $type : Le type d'image  creer (voir en dessous)
 **************************************************/

/*************************************
 * type = 1 ==> rep boutons/user
 * type = 2 ==> rep boutons
 * type = 3 ==> rep boutons/calendier
 * type = 4 ==> rep boutons/date
 * type = 5 ==> rep boutons/groupe
 * type = 6 ==> rep boutons/qcm
 * type = 7 ==> rep boutons/exo
 * type = 8 ==> rep boutons/blanc
 *************************************/

if(!isset($largeur)){
  $largeur=200;
}
if(!isset($hauteur)){
  $hauteur=30;
}
switch($type){
 case(1):
  $rep="boutons/user";
  break;
 case(2):
  $rep="boutons";
  break;
 case(3):
  $rep="boutons/calendrier";
  break;
 case(4):
  $rep="boutons/date";
  break;
 case(5):
  $rep="boutons/groupe";
  break;
 case(6):
  $rep="boutons/qcm";
  break;
 case(7):
  $rep="boutons/exo";
  break;
  case(8):
  $rep="boutons/blanc";
  break;
 default:
   die("probleme dans le fichier CreerBouton.php3");
}
//debug
//echo "nomfic=$nomFic et label=$label<br>";
$nomFic=ereg_replace(' ','_',$label);
$nomFic=ereg_replace('','e',$nomFic);
$nomFic=ereg_replace('','e',$nomFic);
$nomFic=ereg_replace('','a',$nomFic);
$nomFic="./".$rep . "/" . $nomFic . ".png";
//echo "nomfic=$nomFic<br>";
if(! file_exists($nomFic)){
  
  if(!isset($taillefont)){
    $taillefont=4;
  }
  //On test si le titre est + grd que la largeur de l'image
  if(imagefontwidth($taillefont)*strlen($label)>$largeur){
    if(imagefontwidth($taillefont)*strlen($label) <400){
      $largeur=imagefontwidth($taillefont)*strlen($label);
    }
    else{
      $taillefont--;
      $largeur=imagefontwidth($taillefont)*strlen($label);
    }
  }
  
  $image = imagecreate($largeur,$hauteur);

  $maroon = ImageColorAllocate($image,100,0,0);
  $white = ImageColorAllocate($image,255,255,255);
  $red = ImageColorAllocate($image,255,0,0);
  $blue = ImageColorAllocate($image,0,0,255);
  $grey = ImageColorAllocate($image,200,200,200);
  $black = ImageColorAllocate($image,0,0,0);

  ImageFilledRectangle($image,0,0,$largeur,$hauteur,$grey);

  $posx=imagefontwidth($taillefont)*strlen($label);
  $posx=($largeur-$posx)/2;
  $posy=imagefontwidth($taillefont);
  $posy=($hauteur-$posy)/2;
  imagestring($image, $taillefont,$posx,$posy , $label , $black);
  imagePNG($image,$nomFic);
  imageDestroy($image);
}

?>