<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/* chart.php */ 

if(!isset($donnees)){
  $donnees=array();
  srand(time());
  for($i=1;$i<=24;$i++){
    $r=rand(1,200);
    $donnees[$i]=$r;
  }
}

// Creation de l'image
if(!(isset($largeur))){
  $largeur=600; 
}
if(!(isset($hauteur))){
  $hauteur = 250; 
}

$image = imagecreate($largeur, $hauteur); 
// couleurs
$white = imagecolorallocate($image, 0xFF, 0xFF, 0xFF); 
$navy = imagecolorallocate($image, 0x00, 0x00, 0x80); 
$black = imagecolorallocate($image, 0x00, 0x00, 0x00); 
$gray = imagecolorallocate($image, 0xC0, 0xC0, 0xC0); 
$bleu = imagecolorallocate($image, 0x00, 0x00, 0xFF); 
$rouge = imagecolorallocate($image, 0xFF, 0x00, 0x00); 

if(!isset($couleur)){
  $couleur=$rouge;
}
if(!isset($axe_horinzontal)){
  $axe_horinzontal="Jour du mois";
}

if(!isset($axe_vertical)){
  $axe_vertical="Nombre de minutes de connexions";
}
if(!isset($nomFic)){
  $nomFic="cache/test.png";
}


// layout 
$maxval = max($donnees); 
$nval = sizeof($donnees); 

$vmargin = 40; // top (bottom) vertical margin for title (x-labels) 
$hmargin = 100; // left horizontal margin for y-labels 

$base = floor(($largeur - $hmargin) / $nval); // distance between columns 

$ysize = $hauteur - 2 * $vmargin; // y-size of plot 
$xsize = $nval * $base; // x-size of plot 

// title 
$titlefont = 3; 
if(! isset($title)){
  $title = "Titre du graph"; 
}

$txtsz = imagefontwidth($titlefont) * strlen($title); // pixel-width of title 

$xpos = (int)($hmargin + ($xsize - $txtsz)/2); // center the title 
$xpos = max(1, $xpos); // force positive coordinates 
$ypos = 3; // distance from top 

imagestring($image, $titlefont, $xpos, $ypos, $title , $black); 

// y labels and grid lines 
$labelfont = 2; 
$ngrid = 4; // number of grid lines 

$dydat = $maxval / $ngrid; // data units between grid lines 
$dypix = $ysize / ($ngrid + 1); // pixels between grid lines 

for ($i = 0; $i <= ($ngrid + 1); $i++) { 
  // iterate over y ticks 

  // hauteur of grid line in units of data 
  if($round == 1){
    $ydat = (int)($i * $dydat);
  }else{
    $ydat = ($i * $dydat);
  }

  // hauteur of grid line in pixels
  $ypos = $vmargin + $ysize - (int)($i*$dypix); 

  $txtsz = imagefontwidth($labelfont) * strlen($ydat); // pixel-width of label 
  $txtht = imagefontheight($labelfont); // pixel-height of label 

  $xpos = (int)(($hmargin - $txtsz)-10); 
  $xpos = max(1, $xpos); 

  imagestring($image, $labelfont, $xpos, 
	      $ypos - (int)($txtht/2), $ydat, $black); 

  if (!($i == 0) && !($i > $ngrid)) {
    imageline($image, $hmargin - 3, 
	      $ypos, $hmargin + $xsize, $ypos, $gray); 
    // don't draw at Y=0 and top 
  }
} 

// columns and x labels 
$padding = 3; // half of spacing between columns 
$yscale = $ysize / (($ngrid+1) * $dydat); // pixels per data unit 

for ($i = 0; list($xval, $yval) = each($donnees); $i++) { 

  // vertical columns 
  $ymax = $vmargin + $ysize; 
  $ymin = $ymax - (int)($yval*$yscale); 
  $xmax = $hmargin + ($i+1)*$base - $padding; 
  $xmin = $hmargin + $i*$base + $padding; 

  imagefilledrectangle($image, $xmin, $ymin, $xmax, $ymax, $couleur); 
  $x[$i]=round($xmin);
  $y[$i]=round($ymin);
  $xx[$i]=round($xmax);
  $yy[$i]=round($xmax);

  // x labels 
  $txtsz = imagefontwidth($labelfont) * strlen($xval); 

  $xpos = $xmin + (int)(($base - $txtsz) / 2); 
  $xpos = max($xmin, $xpos); 
  $ypos = $ymax + 3; // distance from x axis 

  imagestring($image, $labelfont, $xpos, $ypos, $xval, $black); 
} 
$pos_x=$largeur/*-($hmargin/2)*/-imagefontwidth($labelfont)*strlen($axe_horinzontal);
imagestring($image, $labelfont, $pos_x, $ypos+15, $axe_horinzontal, $black); 

//On decoupe la legende de l axe vertical pour que l'afficher sur plusieurs lignes
//si ncssaire
$tab_axe=array();
$taille=$hmargin-strlen(max($donnees));
$tok=strtok($axe_vertical," ");
$indice=0;
while($tok){
  if((strlen($tab_axe[$indice])+1+strlen($tok))*imagefontwidth($labelfont)<$taille){
    $tab_axe[$indice].=" $tok";
  }
  else{
    $indice++;
    $tab_axe[$indice]=$tok;
  }
  $tok=strtok(" ");
}

$espace_ligne=2;
$ypos=$vmargin/2;
//On affiche
while(list($id,$valeur)=each($tab_axe)){
  imagestring($image, $labelfont, 0, $ypos, $valeur, $black);
  $ypos=$ypos+$espace_ligne+imagefontheight($labelfont);
}


// plot frame 
imagerectangle($image, $hmargin, $vmargin, 
	       $hmargin + $xsize, $vmargin + $ysize, $black); 

// flush image 
//header("Content-type: image/wbmp"); // or "Content-type: image/png" 
imagePng($image,"$repCache/$nomFic"); // or imagepng($image) 
imagedestroy($image); 

?>