<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/********************************************
 * Script qui affiche les scores d'un groupe
 *******************************************/

include('../dbpostgres.php3');
$path='..';
include('../entete.php3');

$db = pg_Connect("$server", "", "", "", "$nombase");

/**************************************************
 *  PREPARATION DES REQUETES
 *************************************************/

//Requete qui cherche tout les utilisateurs du groupe (sous groupe)

if(isset($ssgrp)){

  $req_util="SELECT num_user,nom,prenom FROM utilisateurs
             WHERE num_user IN(
             SELECT gu_num_user FROM gestionutil,gestiongroupe
             WHERE gu_num_gest_gr=num_gest_groupe)
             ORDER BY nom";

/*
$req_util="SELECT num_user,nom,prenom FROM utilisateurs
             WHERE num_user IN(
             SELECT gu_num_user FROM gestionutil,classe
             WHERE gu_num_gest_gr=id)
             ORDER BY nom";
*/
}else if(isset($sgrp)){
  $req_util="SELECT num_user FROM utilisateurs
             WHERE num_user IN(
             SELECT gu_num_user FROM gestionutil, gestiongroupe 
             WHERE gu_num_gest_gr=num_gest_groupe
             AND gg_num_groupe=$grp and gg_num_s_groupe=$sgrp) order by nom";
}else{
  $req_util="SELECT num_user, nom, prenom FROM utilisateurs 
             WHERE num_user IN(
             SELECT gu_num_user FROM gestionutil,gestiongroupe 
             WHERE gu_num_gest_gr=num_gest_groupe
	     AND gg_num_groupe='$grp') ";
}

//On execute la requete et on recupre les num d'utilisateurs

$resul=pg_exec($db,$req_util);
$nb=pg_numrows($resul);
for($i=0;$i<$nb;$i++){
  $rowresult=pg_fetch_row($resul,$i);
  if($i == 0){
    $condition .= "num_user = $rowresult[0]";
    $condition2 .= "gqstn_num_user = $rowresult[0]";
    $condition3 .= "g_num_user = $rowresult[0]";
  }else {
    $condition .= " OR num_user = $rowresult[0]";
    $condition2 .= " OR gqstn_num_user = $rowresult[0]";
    $condition3 .= " OR g_num_user = $rowresult[0]";
  }
}

/***********************************
 *    SCORE POUR LES EXO
 **********************************/

$score_exo=0;
$max_points_possible_exo=0;
if(isset($condition)){
//   $req_exo="SELECT score,surtotal FROM resexouser WHERE ( $condition )";
  $req_exo="SELECT DISTINCT score,surtotal,num_user, num_exo FROM stat_score_exo_tlc
          WHERE gg_num_groupe = '$grp'";
  print("$req_exo <br>");
  $resul=pg_exec($db,$req_exo);
  $nb=pg_numrows($resul);
  for($i=0;$i<$nb;$i++){
    $rowresult=pg_fetch_row($resul,$i);
    $score_exo += $rowresult[0];
    $max_points_possible_exo += $rowresult[1];
  }
}


/**************************************************
 *    SCORE POUR LES QCM
 *************************************************/
$max_points_possible_qcm=0;

//calcul des score max des qcm
//Question avec poids
if(isset($condition)){
  $qcm1="SELECT poids, poids_qstaire 
         FROM elaborqstn,questionnaire 
         WHERE (elaborqstn.num_bareme IS NULL OR elaborqstn.num_bareme = 0) 
         AND num_qstaire = eq_num_qstaire 
         AND (questionnaire.num_bareme=0 OR questionnaire IS NULL) 
         AND eq_num_qstaire IN (
             SELECT gqstn_num_qstaire 
             FROM gestionqstn 
             WHERE ( $condition2 ) 
         )";
  $resul=pg_exec($db,$qcm1);
  $nb=pg_numrows($resul);
  for($i=0;$i<$nb;$i++){
    $rowresul=pg_fetch_row($resul,$i);
    $max_points_possible_qcm += $rowresul[0];
  }
  
  
//Question avec bareme. Le bareme de la question est prioritaire a celui du bareme
  $qcm2="SELECT repok FROM bareme b, elaborqstn e, gestionqstn g
         WHERE e.num_bareme = b.num_bareme
         AND e.eq_num_qstaire = g.gqstn_num_qstaire
         AND ( $condition2 )";

  $resul=pg_exec($db,$qcm2);
  $nb=pg_numrows($resul);
  for($i=0;$i<$nb;$i++){
    $rowresul=pg_fetch_row($resul,$i);
    $max_points_possible_qcm += $rowresul[0];
  }

  //Question avec bareme. Pas de bareme individuel pour la question
  $qcm3="SELECT repok FROM bareme b,questionnaire q, elaborqstn e, gestionqstn g 
         WHERE b.num_bareme = q.num_bareme
         AND e.eq_num_qstaire = q.num_qstaire
         AND (e.num_bareme IS NULL OR e.num_bareme=0)
         AND e.eq_num_qstaire = g.gqstn_num_qstaire
         AND ( $condition2 )";

  $resul=pg_exec($db,$qcm3);
  $nb=pg_numrows($resul);
  for($i=0;$i<$nb;$i++){
    $rowresul=pg_fetch_row($resul,$i);
    $max_points_possible_qcm += $rowresul[0];
  }
}

$score_qcm=0;
if(isset($condition3)){
  //calcul des points obtenu par les utilisateurs (juste pour les qcm)
  $score_qcm=0;
  $qcm_score="SELECT result_qstn FROM gestionqstn 
              WHERE ( $condition2 )";
  $resul=pg_exec($db,$qcm_score);
  $nb=pg_numrows($resul);
  for($i=0;$i<$nb;$i++){
    $rowresul=pg_fetch_row($resul,$i);
    $score_qcm += $rowresul[0];
  }
}

/***************************************************
 *    Recherche des cours suivis par ce groupe
 **************************************************/
//partie de la requete commune quelque soit le type de groupe
//(groupe, sous-groupe , etc ....)
$req_cour="SELECT DISTINCT gc_num_cours,libelle_cours
           FROM cours c, gestioncours gc ,gestionnaire g, gestiongroupe gg
           WHERE gc.gc_num_cours = c.num_cours
           AND gc.num_gest_cours = g.g_num_gest_c
           AND g.g_num_gest_g = gg.num_gest_groupe";

$lien_grp="grp=$grp";
//On rajoute la suite de la requete suivant que ce soit un grp, un sgrp etc ....=
if(isset($ssgrp)){
  $req_cour .= " AND gg.gg_num_s_s_groupe = '$ssgrp' ";
  $lien_grp.="&sgrp=$sgrp&ssgrp=$ssgrp";
}elseif (isset($sgrp)){
  $req_cour .= " AND gg.gg_num_s_groupe = '$sgrp' ";
  $lien_grp.="&sgrp=$sgrp";
}
else {
  $req_cour .= " AND gg.gg_num_groupe = '$grp' ";
}


/***************************************************
 *    On recupere le nom de groupe
 **************************************************/
$nom_groupe=ereg_replace('_',' ',$nom);


/***************************************************
 *    AFFICHAGE
 **************************************************/
print("<h2>Score total du groupe $nom_groupe</h2>\n");
print("<table border=\"1\">\n");
print("<tr bgcolor=\"#FFCCCC\">\n");
print("<td align=\"center\">Type</td>\n");
print("<td align=\"center\">Rsultat</td>\n");
print("<td align=\"center\">Score sur 20</td>\n");
print("</tr>\n");

//Score qcm
print("<tr>\n");
print("<td align=\"center\">QCM</td>\n");
print("<td align=\"center\"> $score_qcm / $max_points_possible_qcm</td>\n");
if($max_points_possible_qcm != 0){
  print("<td align=\"center\"> ". sprintf("%.2f",$score_qcm * (20 / $max_points_possible_qcm)) . " </td>\n");
}
else {
  print("<td align=\"center\"> X </td>\n");
}
print("</tr>\n");

//Score Exos tlc
print("<tr>\n");
print("<td align=\"center\">Exercices tlchargs</td>\n");
print("<td align=\"center\"> $score_exo / $max_points_possible_exo</td>\n");
if($max_points_possible_exo != 0){
  print("<td align=\"center\"> ". sprintf("%.2f",$score_exo * (20 / $max_points_possible_exo)) . " </td>\n");
}
else {
  print("<td align=\"center\"> X </td>\n");
}

//total
print("<tr>\n");
print("<td align=\"center\"><b>Total</b></td>\n");
print("<td align=\"center\"><b> ");
print(($score_exo+$score_qcm) . " / " . ($max_points_possible_exo + $max_points_possible_qcm));
print("</b></td>\n");
if(($max_points_possible_exo + $max_points_possible_qcm) != 0){
  print("<td align=\"center\"><b> ");
  print(sprintf("%.2f",($score_exo+$score_qcm)*(20/($max_points_possible_exo+$max_points_possible_qcm))));
  print("</b></td>\n");
}
else {
  print("<td align=\"center\"> X </td>\n");
}

print("</table>\n<br><br>\n");

//Affichage du tableau des cours suivis par ce groupe
print("<h2>Cours suivis par le groupe $nom_groupe</h2>\n");
print("<table border=\"1\">\n");
print("<tr bgcolor=\"#FFCCCC\">\n");
print("<td align=\"center\">Libell</td>\n");
print("<td align=\"center\">Action</td>\n");
print("</tr>\n");

//Execution de la requete pour afficher les cours suivis
$resul=pg_exec($db,$req_cour);
$nb=pg_numrows($resul);
for($i=0;$i<$nb;$i++){
  $rowresul=pg_fetch_row($resul,$i);
  print("<tr>\n");
  print("<td align=\"center\">$rowresul[1]</td>\n");
  print("<td align=\"center\"><a href=\"StatGroupeCour.php3?cour=$rowresul[0]&$lien_grp\">");
  print("Dtails</td>\n");
  print("</tr>\n");
}
print("</table>\n<br><br>\n");
print("<form><input type=\"button\" value=\"Retour\" onClick=\"history.back()\"></form>\n");

include('../piedpage.php3');

?>