<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


//************************
//fonction pour gnrer automatiquement les requetes sur
//les cours
//Remarque : Nivo 0 -> libelle_cours
//	     Nivo 1 -> libelle_s_cours ...
//************************

function makereqcours($idgrp,$nivocours,$tabcours,$num) {

	//Test des parametres
	if($idgrp=="" || $nivocours=="") {
		print "Parametres non valides dans makereqgrp()";
		exit;
	}
	
	//Construction de la requete

	$req="select distinct";

	$col=" libelle";
	for($i=0;$i<$nivocours;$i++) { $col.="_s"; }
	$col.="_cours";

	$req.=$col . " from GESTIONNAIRE, GESTIONCOURS, COURS, SOUSCOURS, SOUSOUSCOURS,SOUSOUSOUSCOURS, 
	SOUSOUSOUSOUSCOURS where gc_num_cours=num_cours and gc_num_s_cours=num_s_cours 
        and gc_num_s_s_cours=num_s_s_cours and gc_num_s_s_s_cours=num_s_s_s_cours 
        and gc_num_s_s_s_s_cours=num_s_s_s_s_cours and num_cours!=0 and num_gest_cours=g_num_gest_c 
        and g_num_user=$num and $col!='' and g_num_gest_g=$idgrp";

	if($nivocours>0) $req.=makesubreq($nivocours,$tabcours,"cours");

	$req.=";";

	return($req);
}


//************************
//Pour creer la partie 'where ...' de la requete sur les cours, groupes ...
//************************

function makesubreq($nivo,$tab,$base) {
	$cpt=0;

	if($base=="groupe") {
		$lib.=" and libelle_$base='$tab[$cpt]'";
		$cpt++;
		for($i=0;$i<$nivo;$i++) {
			$lib.=" and libelle";
			for($j=0;$j<$i+1;$j++) $lib.="_s";
			$lib.="_$base='$tab[$cpt]'";
			$cpt++;
		}
	}
	
	if($base=="cours") {
		$cpt=0;
		$lib.=" and libelle_$base='$tab[$cpt]'";
		$cpt++;
		for($i=0;$i<$nivo-1;$i++) {
			$lib.=" and libelle";
			for($j=0;$j<$i+1;$j++) $lib.="_s";
			$lib.="_$base='$tab[$cpt]'";
			$cpt++;
		}
	}
	
	return($lib);
}


//************************
//GROUPES
//meme traitement que pour les cours
//************************

function makereqgrp($nivogrp,$tabgrp,$num) {

	//Test des parametres
	if($nivogrp=="") {
		print "Parametres non valides dans makereqgrp()";
		exit;
	}

	//Construction de la requete

	$req="select distinct";

	$col=" libelle";
	for($i=0;$i<$nivogrp;$i++) { $col.="_s"; }
	$col.="_groupe";

	$req.=$col . " from GESTIONNAIRE, GESTIONGROUPE, GROUPE, SOUSGROUPE, SOUSOUSGROUPE,SOUSOUSOUSGROUPE, 
	SOUSOUSOUSOUSGROUPE where gg_num_groupe=num_groupe and gg_num_s_groupe=num_s_groupe 
	and gg_num_s_s_groupe=num_s_s_groupe and gg_num_s_s_s_groupe=num_s_s_s_groupe and  
	gg_num_s_s_s_s_groupe=num_s_s_s_s_groupe and num_groupe!=0 and num_gest_groupe=g_num_gest_g 
	and g_num_user=$num and $col!=''";

	$cpt=0;
	if($nivogrp>0) {
		$req.=" and libelle_groupe='$tabgrp[$cpt]'";
		$cpt++;
	}
	for($i=0;$i<$nivogrp-1;$i++) {
		$req.=" and libelle";
		for($j=0;$j<$i+1;$j++) $req.="_s";
		$req.="_groupe='$tabgrp[$cpt]'";
		$cpt++;
	}

	$req.=";";

	return($req);
}


//************************
//DROITS
//meme traitement que pour les cours
//************************

function makereqdrt($idgrp,$idcours,$num) {

	//Test des parametres
	if($idgrp=="" || $idcours=="" || $num=="") {
		print "Parametres non valides dans makereqdrt()";
		exit;
	}

	//Construction de la requete
	$req="select * from DROIT";

	$req.=$col . " where num_droit not in (select g_num_droit from GESTIONNAIRE where g_num_gest_c=$idcours 
        and g_num_gest_g=$idgrp and g_num_user=$num";
	
	$req.=");";

	return($req);	
}

//************************
//Pour creer la partie 'where ...' de la requete sur les cours, groupes ...
//pour les droits
//************************

function makesubreqdroit($nivo,$tab,$base) {
	
	$cpt=0;

	if($base=="cours") {
		$lib.=" and num_$base='$tab[$cpt]'";
		$cpt++;
		for($i=0;$i<$nivo;$i++) {
			$lib.=" and num";
			for($j=0;$j<$i+1;$j++) $lib.="_s";
			$lib.="_$base='$tab[$cpt]'";
			$cpt++;
		}
	}

	if($base=="groupe") {
		$lib.=" and num_$base='$tab[$cpt]'";
		$cpt++;
		for($i=0;$i<$nivo;$i++) {
			$lib.=" and num";
			for($j=0;$j<$i+1;$j++) $lib.="_s";
			$lib.="_$base='$tab[$cpt]'";
			$cpt++;
		}
	}
	
	return($lib);
}

//************************
//Fonction pour generer des libelles de type sous_sous ...
//Pour l'affichage
//************************

function makelib($base,$nivo) {
	
	if($nivo!=0) {
		$base="s" . $base;
		for($i=0;$i<$nivo;$i++) { $base="sou" . $base; }
	}

	return($base);
}

//************************
//Fonction pour generer des libelles de type sous_sous ...
//Pour les requetes
//************************

function makelibreq($base,$nivo) {
	
	if($nivo!=0) {
		$lib="libelle_s_";
		for($i=0;$i<$nivo-1;$i++) { $lib .= "s_"; }
		$lib .= $base;
	}	
	else {
		$lib="libelle_" . $base;
	}

	return($lib);
}


//************************
//Pour generer la nom complet de l'arborescence courante (groupe, cours ...)
//************************

function convertlib($libgrp) {
	//print "-$libgrp-<BR>";
	$tab=explode("/",$libgrp);
	//print "count(tab)";
	//print count($tab);
	//print "<BR>";
	return($tab);
}
		

//************************
//Pour transformer les tabgrp et tabcours en tableaux d'indices
//************************

function converttab(&$tab,$base,&$database) {
	//print "$base<BR>";	
	$num=count($tab);
	//print "Num elements : $num <BR>";
	for($i=0;$i<$num;$i++) {
		$select=makelibnum($base,$i);
		$from=maketable(strtoupper($base),$i);
		$where=makelibreq($base,$i);
		$requete="select $select from $from where $where='$tab[$i]';";
		//print "rekete : $requete<BR>";
		$id=pg_exec($database,"$requete");
		$row=pg_fetch_row($id,0);
		$tab[$i]=$row[0];
		//print "indice : $tab[$i] <BR>";
	}

	/*
	for($i=0;$i<$num;$i++) {
		print "tab[$i] : $tab[$i] <BR>";
	}
	*/
}

//************************
//Pour transformer les tabeaux d'indices en tableaux
//de libelles.
//************************

function converttablib($tab,$base,&$database) {
	
	$num=count($tab);
	//print "Num elements : $num <BR>";
	for($i=0;$i<$num;$i++) {
		$select=makelibreq($base,$i);
		$from=maketable(strtoupper($base),$i);
		$where=makelibnum($base,$i);
		$requete="select $select from $from where $where='$tab[$i]';";
		//print "rekete : $requete<BR>";
		$id=pg_exec($database,"$requete");
		$row=pg_fetch_row($id,0);
		$tab[$i]=$row[0];
		//print "indice : $tab[$i] <BR>";
	}

	return(implode("/",$tab));
	/*
	for($i=0;$i<$num;$i++) {
		print "tab[$i] : $tab[$i] <BR>";
	}
	*/
}

//************************
//Fonction pour generer des libelles de type num_s_s...
//************************

function makelibnum($base,$nivo) {
	
	if($nivo!=0) {
		$lib="num_s_";
		for($i=0;$i<$nivo-1;$i++) { $lib .= "s_"; }
		$lib .= $base;
	}
	else {
		$lib= "num_" . $base;
	}
	
	return($lib);
}

//************************
//Fonction pour generer des noms de tables de type SOUSOUS...
//************************

function maketable($base,$nivo) {
	
	if($nivo!=0) {
		$lib="SOUS";
		for($i=0;$i<$nivo-1;$i++) { $lib .= "OUS"; }
		$lib .= $base;
	}
	else {
		$lib=$base;
	}

	return($lib);
}


//************************
//Pour crer la requete de soumission des droits en
//fonction des niveaux de groupes et cours
//************************

/*
select distinct num_gest_groupe,g_num_user,g_num_cal from VIEWGEST where 
	
	num_cours='$id_cours' and num_s_cours='$id_s_cours' and num_s_s_cours='$id_s_s_cours' 
	and g_num_user=$num 
	and num_groupe='$id_groupe' and num_s_groupe='$id_s_groupe' and num_s_s_groupe='$id_s_s_groupe';");
*/

function makereqsubmitdrt($nivogrp,$nivocours,$tabgrp,$tabcours,$num) {

	//Test des parametres
	if($nivogrp=="" || $nivocours=="") {
		print "Parametres non valides dans makereqsubmitdrt()";
		exit;
	}

	//Construction de la requete

	$req="select distinct num_gest_groupe, num_gest_cours, g_num_cal from 
	GESTIONNAIRE, GESTIONCOURS, COURS, SOUSCOURS, SOUSOUSCOURS,SOUSOUSOUSCOURS, 
	SOUSOUSOUSOUSCOURS, GESTIONGROUPE, GROUPE,SOUSGROUPE,SOUSOUSGROUPE,SOUSOUSOUSGROUPE, 
	SOUSOUSOUSOUSGROUPE where gg_num_groupe=num_groupe and gg_num_s_groupe=num_s_groupe and 
	gg_num_s_s_groupe=num_s_s_groupe and gg_num_s_s_s_groupe=num_s_s_s_groupe and 
	gg_num_s_s_s_s_groupe=num_s_s_s_s_groupe and num_groupe!=0 and num_gest_groupe=g_num_gest_g 
	and gc_num_cours=num_cours and gc_num_s_cours=num_s_cours and gc_num_s_s_cours=num_s_s_cours 
	and gc_num_s_s_s_cours=num_s_s_s_cours and gc_num_s_s_s_s_cours=num_s_s_s_s_cours and num_cours!=0 
	and num_gest_cours=g_num_gest_c and g_num_user=$num and ";
	
	$req .= makelibnum("cours",$nivocours) . "=" . $tabcours[0] . " and ";
	for($j=0;$j<$nivocours;$j++) {
		$req .= makelibnum("cours",$nivocours) . "=" . $tabcours[$j] . " and ";
	}
	
	if($nivogroupe==0) $req .= makelibnum("groupe",$groupe) . "=" . $tabgrp[0];
	else $req .= makelibnum("groupe",$groupe) . "=" . $tabgrp[0] . " and ";
	for($j=0;$j<$nivogrp;$j++) {
		if(($j+1)==$nivogrp) $req .= makelibnum("groupe",$groupe) . "=" . $tabgrp[$j];
		else $req .= makelibnum("groupe",$groupe) . "=" . $tabgrp[$j] . " and ";
	}
	$req .= ";";
	
	//...done

	return($req);
}

//************************
//Fonction pour generer des libelles de type gg_num_s ...
//************************

function makelibgestion($base,$nivo) {
	
        if($base=="groupe") $libfield="gg_num_";
        if($base=="cours") $libfield="gc_num_";
        
	if($nivo!=0) {
		$lib= $libfield . "s_";
		for($i=0;$i<$nivo-1;$i++) { $lib .= "s_"; }
		$lib .= $base;
	}
	else {
		$lib= $libfield . $base;
	}
	
	return($lib);
}


//************************
//Fonction pour recupere l'identifiant unique
//des tables de gestion des groupes et des cours
//************************

/*
        $base du type : groupe ou cours
*/
function idGestion(&$database,$base,$nivomax,$nivo,$tab) {
        
        /*
        print "<br>###############";
        print "<br> nivo : $nivo";
        print "<br> nivomax : $nivomax";
        print "<br>###############";
        */
        
        //Transforme le tableau en indices
        converttab(&$tab,$base,&$database);
        
        //Test des parametres
	if($base=="" || $nivo=="" || $nivomax=="" || !database) {
		print "Parametres non valides dans idGestion()";
		exit;
	}
        
        $table= "GESTION" . strtoupper($base);
        
        //on recupere la base de la table de gestion
        if($base=="cours") $baseField="gc_num_";
        if($base=="groupe") $baseField="gg_num_";
        
        $req= "select num_gest_" . $base . " from " . $table . " where ";
        
        $req .= $baseField . $base . "=" . $tab[0];
        
        for($i=1;$i<=$nivo;$i++) {
                $req .= " and " . makelibgestion($base,$i) . "=" . "'" . $tab[$i] . "'";
        }
        
        //On complete le reste de la requete avec des champs=0 pour choisir la ligne exacte
        for($j=$nivo+1;$j<($nivomax-$nivo)-1;$j++) {
                $req .= " and " . makelibgestion($base,$j) . "='0'";
        }
        
        $req .= ";";
        
        //print "<br> REQ : $req";
                
        $res=pg_exec($database,"$req");
        $row=pg_fetch_row($res,0);

        return($row[0]);        
}

?>
