<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**************************************************************
 * Script qui genere un fichier PDF pour les connexions
 * paramtres :
 *  $nom   : Le nom du stagiaire
 *  $pre   : Le prenom du stagiaire
 *  $user  : le numero d'utilisateur
 *  $mois  : Le numro du mois
 *  $annee : L'annee
 * NB : script pret pour le nouveau passage de paramtres
 *************************************************************/

if($PHP_SELF == "/stats/pdf/generePdfConnexion.php")$back = 1;
else $back = 0;
if($back == 1){
  define('FPDF_FONTPATH',"./fpdf/font/");
  require("./fpdf/fpdf.php");
  require("./fpdf/pdf_Afide.php");
  //require('../fonctions_stat.php3');
  //include('../../dbpostgres.php3');
  require("../fonctions_stat.php3");
  $repCache="../cache/";
}
else{
  define('FPDF_FONTPATH',"$chemin_bo/stats/pdf/fpdf/font/");
  require("$chemin_bo/stats/pdf/fpdf/fpdf.php");
  require("$chemin_bo/stats/pdf/fpdf/pdf_Afide.php");
  //require('../fonctions_stat.php3');
  //include('../../dbpostgres.php3');
  require("$chemin_bo/stats/fonctions_stat.php3");
  //$repCache="./cache";
  $repCache="$chemin_fo/stats/cache/";
}

//Recuperation des parametres
$nom=$_GET['nom'];
$pre=$_GET['pre'];
$user=$_GET['user'];
$mois=$_GET['mois'];
$annee=$_GET['annee'];

//print "$nom / $pre / $user / $mois / $annee <br>";

//On cherche les noms de fichier graces au paramtres
//Fichier sur la dure de connexion
$nomFic1=$user;
$nomFic1.="_$mois";
$nomFic1.="_$annee";
$nomFic1.="Duree.png";

//Fichier sur le nombre de connexions
$nomFic2=$user;
$nomFic2.="_$mois";
$nomFic2.="_$annee";
$nomFic2.="Connexion.png";

//Fichier sur le tps de connexions par heure
$nomFic3=$user;
$nomFic3.="_$mois";
$nomFic3.="_$annee";
$nomFic3.="Par_Heure.png";

//Fichier sur la repartition des connexions (camembert)
$nomFic4=$user;
$nomFic4.="_$mois";
$nomFic4.="_$annee";
$nomFic4.="_Camembert.png";

//print "$nomFic1 $nomFic2 $nomFic3 $nomFic4 <br>";

$titre_page="Statistiques de $pre $nom pour le mois " . getNomMoisBis($mois) . " $annee";

//Dimension d'une page A4
$largeur_page=210;
$hauteur_page=297;

//Marges horizontale et verticale
$marge=15;
$margey=25;

//Creation du PDF
$pdf=new pdf_Afide();
$pdf->setMargins($marge,$marge);
$pdf->setHeaderTitre($titre_page);
$pdf->Open();
$pdf->AddPage();
$pdf->setAuthor("AFIDE");
$pdf->setCreator("FPDF");
$pdf->SetFont('Helvetica','B',16);
$pdf->setY($margey);
$pdf->setFillColor(220);
$pdf->Cell(0,10,$titre_page,1,2,'C',1);

//Le cadre de la page
$pdf->Rect($marge,$pdf->getY()+4,$largeur_page-2*$marge,$hauteur_page-$margey-$pdf->getY());
$pdf->setY($pdf->getY()+5);
$pdf->SetFont('Helvetica','',12);
$pdf->Cell(0,10,"Connexions du mois ".getNomMoisBis($mois)." $annee",0,2,'C',0);
$taille_image=getimagesize("$repCache/$nomFic1");
$largeur_image=$taille_image[0]/4;
$hauteur_image=$taille_image[1]/4;

//echo getcwd();
//print "$repCache/$nomFic1";

$pdf->image("$repCache/$nomFic1",($largeur_page/2)-$largeur_image/2,$pdf->getY()+15,$largeur_image);
$pdf->setY($hauteur_image+25+$pdf->getY());
$pdf->image("$repCache/$nomFic2",($largeur_page/2)-$largeur_image/2,$pdf->getY()+15,$largeur_image);

//Deuxieme page
$pdf->addPage();
//Cadre de la page 
$pdf->Rect($marge,$pdf->getY(),$largeur_page-2*$marge,$hauteur_page-$margey-$pdf->getY());
$pdf->setY($pdf->getY()+5);
$taille_image=getimagesize("$repCache/$nomFic3");
$largeur_image=min($taille_image[0]/4,$largeur_page-2*$marge-10);
$hauteur_image=$taille_image[1]/4;
$pdf->image("$repCache/$nomFic3",($largeur_page/2)-$largeur_image/2,$pdf->getY()+15,$largeur_image);
$pdf->setY($hauteur_image+25+$pdf->getY());


$pdf->Cell(0,10,"Rpartition des connexions",0,2,'C',0);
$pdf->image("$repCache/$nomFic4",($largeur_page/2)-$largeur_image/2,$pdf->getY()+15,$largeur_image);

$pdf->Output();


?>