<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Objet de base pour la creation de pages du back-office.
 */
class AstairsPageBO extends AstairsPage{
	
	var $page_debut;
	var $page_fin;
	
	/**
	 * Constructeur.
	 * @param object PageBuilder $pageBuilder L'objet permettant de creer une page
	 * @param Array $templates Les templates autiliser pour la creation de la page
	 * @param Array $style_files Les feuilles de style
	 * @param Array $javascript_files Les fichiers javascript
	 * @param string $javascript_internal_code Le code javascript interne
	 * @param string $astairs_titre Titre de la page (en tete)
	 * @param string $astairs_retour_libelle Libelle du lien retour de la page (en tete)
	 * @param string $astairs_retour_url URL du lien retour de la page (en tete)
	 * @param string $astairs_retour_title Title/Alt du lien retour de la page (en tete)
	 * @param string $page_titre Titre de la page 
	 * @param string $retour_title Title/Alt du lien retour du bas de page (pied page)
	 * @param string $retour_url URL du lien retour du bas de page (pied page)
	 */
	function AstairsPageBO($pageBuilder,$templates,$style_files, $javascript_files,$javascript_internal_code,$astairs_titre="Administration Astairs", $astairs_retour_libelle=MENU_1,$astairs_retour_url="../accueil/accueil.php",$astairs_retour_title=MENU_2562,$page_titre="libelle module",$retour_title=MENU_2579,$retour_url="../module_menu/module_menu.php"){
		global $chemin_bo,$dbpath,$auth,$obj_module;
		
		
		$javascript_files["$dbpath/bo/templates/script"][]="javascript_back.js";
		$javascript_files["$dbpath/lib_graphique/javascript"][]="bulles.js";
		$javascript_files["../module/templates/script"][]="select_module_droits_javascript.js";
		
		$module_id=$obj_module->getId();
		if(!empty($module_id)){
			
			if($auth->is_root()||$obj_module->have_perm('ADMIN')){
				$javascript_internal_code.=get_module_individus_types_droits_tableau_javascript($obj_module->getId());
	       		$page_droits=new guiBoModuleIndividusTypesDroits('page_droits',$obj_module,"$chemin_bo/module/templates/tpl",array('page_droits'=>'gui_bo_module_individus_types_droits.tpl'));
	       		$this->setComponent('page_droits', $page_droits);
//	       		print_rr($this->page_droits);
			}
			//creation des elements de la page
			if(is_object($obj_module))$module_libelle=$obj_module->getLibelle(); 
			else $module_libelle=$page_titre;
			
//print_rr($obj_module);
		//DEBUT
			if(strtolower($obj_module->getType())=='fw'){
				$this->page_debut=new AstairsPageBoDebutAccueil("$chemin_bo/templates/tpl",array('page_header' => 'astairs_page_bo_debut_accueil.tpl'),$astairs_titre, $astairs_retour_libelle,$astairs_retour_url,$astairs_retour_title,$module_libelle);
			}else{
				$this->page_debut=new AstairsPageBoDebut("$chemin_bo/templates/tpl",array('page_header' => 'gui_bo_astairs_page_debut.tpl'),$astairs_titre, $astairs_retour_libelle,$astairs_retour_url,$astairs_retour_title,$module_libelle);
			}
		}
		$this->page_fin=new AstairsPageBoFin("$chemin_bo/templates/tpl",array('page_footer' => 'astairs_page_bo_fin.tpl'), MSG_37,$retour_title,$retour_url);
	
		//affectation des elements
		parent::AstairsPage($pageBuilder,$templates,$style_files, $javascript_files,$javascript_internal_code);
		
		$this->setComponent('page_header', $this->page_debut);
		$this->setComponent('page_footer', $this->page_fin);
	}
	
}
?>