<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    Fichier dbpostgres.php3 ( pour FOAD et PGR sur tous les serveurs )
    Les serveurs :
        - serveur de production
        - serveur de formation
        - serveur en ligne
    Note : gestion dynamique des variables
    
    @package configuration
*/

//---------------------------------------------------------------------------------------------------------------
//                             INCLUSIONS ET INITIALISATIONS
//---------------------------------------------------------------------------------------------------------------
//repertoire des fichiers de configuration
#$NIVEAU_DEBUG = 1;
$conf_dir_name="conf";


if(empty($dbpath)){
	$dbpath=".";
}

//fonction de base
require_once("$dbpath/base/fonctions_base.php");
messageDebug("Configuration des fonctions de base du framework...");

//constantes de base
messageDebug("Configuration des constantes du framework...");
include("$dbpath/base/config_categories.php"); //cat�gories
include("$dbpath/base/config_types.php"); //types
include("$dbpath/base/config_debug.php"); //constantes de d�bug

//---------------------------------------------------------------------------------------------------------------
//                              DETECTION DE L'IP DU SERVEUR
//---------------------------------------------------------------------------------------------------------------
messageDebug("<b>Detection de l'IP...</b>");
$IP=$_SERVER['SERVER_NAME'];
//cas du localhost
messageDebug("IP detectee=$IP");

//---------------------------------------------------------------------------------------------------------------
//                  DETECTION DU REPERTOIRE COURANT 
//---------------------------------------------------------------------------------------------------------------
messageDebug("<b>Detection du repertoire courant...</b>");
$tab_document_root=explode("/",$DOCUMENT_ROOT);
$tab_script_filename=explode("/",$SCRIPT_FILENAME);
$sz_document_root=count($tab_document_root);
$repertoire=$tab_document_root[$sz_document_root-1];
messageDebug("repertoire courant: $repertoire");
messageDebugR("\$tab_document_root (taille=$sz_document_root)",$tab_document_root);
messageDebugR("\$tab_script_filename",$tab_script_filename);
//on test si le repertoire courant est un des document root possible, et on prend le bon repertoire en fonction
if(is_array($documentRoot)&&in_array($repertoire,$documentRoot))
	$repertoire=$tab_script_filename[$sz_document_root];
messageDebug("repertoire courant: $repertoire");   

//---------------------------------------------------------------------------------------------------------------
//                 CONFIGURATION DES REPERTOIRES
//---------------------------------------------------------------------------------------------------------------
//back ou front?
//if(substr($repertoire,-6)=='-admin'){$photo_url='http://'.$serverfront.'/lib_graphique/styles/'.$style_par_defaut.'/img/individu/vide.gif';
//    $nom_site_back=$repertoire;
//    $nom_site_front=substr($nom_site_back,0,-6);
//}
//else {
//    $nom_site_front=$repertoire;
//    $nom_site_back=$nom_site_front;//."-admin";
//}
//$nom_site_back="bo";
//$nom_site_front="fo";


//---------------------------------------------------------------------------------------------------------------
//                 CHARGEMENT CONFIGURATION
//---------------------------------------------------------------------------------------------------------------
messageDebug("<bInclusion des fichiers de configuration...</b>");

//inclusion des parametres de configuration de la plate-forme
messageDebug("Configuration des options de la plate-forme...");
include("$dbpath/$conf_dir_name/lib/contrib/readIni.inc.php");//libraire
$file="$dbpath/$conf_dir_name/generated/config.ini"; //fichier � lire



$plateforme=ReadIniValue($file, 'Plateforme', 'nom');	

$place_max=ReadIniValue($file, 'Ressources humaines', 'nbPlacesMax');
$langue_par_defaut=ReadIniValue($file,'Langues', 'langueParDefaut');
	
$dureeSessionFront=ReadIniValue($file,'Session front office','dureeSessionFront');
$dureeMaxInactifFront=ReadIniValue($file,'Session front office','dureeMaxInactifFront');

$dureeSessionBack=ReadIniValue($file,'Session back office','dureeSessionBack');
$dureeMaxInactifBack=ReadIniValue($file,'Session back office','dureeMaxInactifBack');

$style_par_defaut=ReadIniValue($file,'Affichage', 'styleParDefaut');
$charset=ReadIniValue($file,'Affichage', 'charset');

$serverback=ReadIniValue($file,'Serveurs', 'serverBack');
$serverfront=ReadIniValue($file,'Serveurs', 'serverFront');

$chemin_fo=ReadIniValue($file,'Chemins', 'baseCheminFo');
$chemin_bo=ReadIniValue($file,'Chemins', 'baseCheminBo');
$root=ReadIniValue($file,'Chemins','baseCheminRoot');	
		
$adressebase=ReadIniValue($file,'Db', 'baseAdress');	
$port_base=ReadIniValue($file,'Db', 'basePort');
$base_ref=ReadIniValue($file,'Db', 'baseRef');
$nombase=ReadIniValue($file,'Db', 'baseName');
$login=ReadIniValue($file,'Db', 'baseUser');	
$pass=ReadIniValue($file,'Db', 'basePass');	

$magic_pass_phrase=ReadIniValue($file,'Securite', 'magicPassPhrase');

messageDebug("
BACK OFFICE: $chemin_bo<br/>
FRONT OFFICE: $chemin_fo<br/>
ROOT: $root");
			
//lecture des parametres de configuration
//$plateforme=ReadIniValue($fileconf,'Plateforme','nom');
//$langue_par_defaut=ReadIniValue($fileconf,'Langue','langueParDefaut');
//$style_par_defaut=ReadIniValue($fileconf,'Style','styleParDefaut');
//
//$serverback=ReadIniValue($fileconf,'Ip','serverback');
//$serverfront=ReadIniValue($fileconf,'Ip','serverfront');
//
//$base_chemin_fo=ReadIniValue($fileconf,'Chemins','base_chemin_fo');
//$base_chemin_bo=ReadIniValue($fileconf,'Chemins','base_chemin_bo');
//
////$chemin_fo=$base_chemin_fo.$nom_site_front;
////$chemin_bo=$base_chemin_bo.$nom_site_back;
////$root=$base_chemin_bo;
//$base_ref=ReadIniValue($fileconf,'DB','base_ref');
//$adressebase=ReadIniValue($fileconf,'DB','adressebase');
//$nombase=ReadIniValue($fileconf,'DB','nombase');
//$login=ReadIniValue($fileconf,'DB','login');
//$pass="www";

//$adressebase_archive=ReadIniValue($fileconf,'DB Archive','adressebase_archive');
//$nombase_archive=ReadIniValue($fileconf,'DB Archive','nombase_archive');
//$login_archive=ReadIniValue($fileconf,'DB Archive','login_archive');


//$dureeSessionFront=ReadIniValue($fileconf,'Session front office','DureeSessionFront');
//$dureeMaxInactifFront=ReadIniValue($fileconf,'Session front office','DureeMaxInactifFront');
//
//$dureeSessionBack=ReadIniValue($fileconf,'Session back office','DureeMaxInactifBack');
//$dureeMaxInactifBack=ReadIniValue($fileconf,'Session back office','DureeSessionBack');
//---------------------------------------------------------------------------------------------------------------
//                  DETECTION DE LA PLATEFORME
//---------------------------------------------------------------------------------------------------------------
messageDebug("<b>Detection de la plateforme...</b>");
//on compare l'IP detect�e avec les ip back et front de chacunes des plateformes.
$plateforme_identifiee=false;
if($IP==$serverback||$IP==$serverfront){
	$plateforme_identifiee=true;
	messageDebug("Identifiant detecte: $plateforme");
}

//verification
/*if(!$plateforme_identifiee){
	messageDebug("\$serverback=$serverback et \$serverfront=$serverfront");	
	die("Erreur: configuration de la plateforme d'IP $IP indisponible.");
}*/

//---------------------------------------------------------------------------------------------------------------
//                             INCLUSIONS DES AUTRES FICHIERS DE CONFIGURATION
//---------------------------------------------------------------------------------------------------------------
// Le charset � utiliser
define("CHARSET",$charset);

//Versions de la base de donn�es
messageDebug("Configuration des versions de plate-forme...");
include("$dbpath/$conf_dir_name/generated/default_version.php");

//MODULES DISPONIBLES
messageDebug("Configuration des modules...");
include("$dbpath/$conf_dir_name/modules.php");

messageDebug("Chargement des fonctions de base de donn�es...");
require_once("$root/lib/db/pgsql/fonctions_db.php");

//CONFIGURATION UTILISATEUR DES LANGUES ET STYLES
messageDebug("Chargement des messages de langues...");

// CHOIX DE LA LANGUE
while(!include("$root/langues/default_lang.php")) { set_default_lang(); }
include("$dbpath/$conf_dir_name/lib/contrib/loadGenerated.inc.php");

    // echo $message;
//constantes
define("MAX_UPLOAD_SIZE",substr(get_cfg_var("upload_max_filesize"),0,strlen(get_cfg_var("upload_max_filesize"))-1)); //en MO
define("UPLOAD_EXOTLC_DIR","/data/fichiers_stagiaires/exotlc/");
if(VERSION_BASE>VERSION)
	define("UPLOAD_RESSOURCE_ICONE_DIR","/data/ressources/icones/");		
else
	define("UPLOAD_RESSOURCE_ICONE_DIR","/data/images/ressource");	
//---------------------------------------------------------------------------------------------------------------
//                             DEBUG AFFICHAGE DES VALEURS CONFIGUREES
//---------------------------------------------------------------------------------------------------------------
if($NIVEAU_DEBUG==1){
	astairsinfo();
}

include("$root/lib/lib_framework.php");
messageDebug("<b>Fin de la configuration...</b>");
define("MAX_PHOTO_SIZE",10);
define("MAX_PHOTO_WIDTH",100);
define("MAX_PHOTO_HEIGHT",100);
$astairs_directories['PRIVATE_USER_DATA_URL']='http://'.$serverfront.'/fo/data/fichiers_stagiaires/user_data/private/';
$astairs_directories['PRIVATE_USER_DATA_DIR']=$chemin_fo.'/data/fichiers_stagiaires/user_data/private/';
$astairs_directories['PRIVATE_REGISTERED_URL']='http://'.$serverfront.'/fo/data/fichiers_inscrits/user_data/private/';
$astairs_directories['PRIVATE_REGISTERED_DIR']=$chemin_fo.'/data/fichiers_inscrits/user_data/private/';
define('DEFAULT_PHOTO_PATH','http://'.$serverfront.'/lib_graphique/styles/'.$style_par_defaut.'/img/individu/vide.gif');
?>