<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit le tpl g�n�ral de la page et ins�re les informations n�cessaires 
 * dans les metas et titles de la structure html.
 * 
 * @package accueil
 */ 
class AccueilPage extends AstairsPageFo{
	/**
	 * Constructeur
	 * 
	 * @param object[] $pageBuilder Objet qui regroupe l'ensemble des information necessaire � la construction d'une page
	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
	 * @param string[] $style_files Le tableau contenant les chemins des fichier css 
	 * @param string[] $javascript_files Le tableau contenant les chemins des fichier js
	 * @param string $javascript_internal_code Permet d'afficher dans la structure de la page du code javascript en dur.
	 */
	function AccueilPage($pageBuilder,$templates,$style_files, $javascript_files,$javascript_internal_code){
		
		parent::AstairsPageFo($pageBuilder,$templates,$style_files,$javascript_files,$javascript_internal_code);
		
		$val ['PAGE_TITLE'] = MSG_2265;
		$val ['PAGE_DESCRIPTION']= 'description courte de la page';
		$val ['PAGE_KEYWORD']= 'liste des mots cles';
		$val ['PAGE_SUBJECT']= 'sujet de la page';
		$val ['PAGE_AUTHOR']= 'auteur de la page';
		$val ['PAGE_FAVICO']= '';
		parent::set_var($val);
	}
}
?>