<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche l'ensemble du contenu de l'accueil dont la plupart des titres et les selects.
 * 
 * @package accueil
 */ 
class AccueilPageContenu extends PageComponent{
	/**
	 * Affiche les titres, les selects et le bouton de validation.
	 * 
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function AccueilPageContenu($module_root=null,$templates=null,$change_formation=false){
		
		global $auth,$sess;
		parent::PageComponent($module_root,$templates);
		
		$val ['ACCUEIL_SELECTION_THEME'] = MSG_1303;
		$val ['ACCUEIL_SELECTION_FORMATION'] = MSG_538;
		$val ['SUB_COURS']= '1';
		$val ['MSG_538']=MSG_538;
		$val ['MSG_2361']=MSG_2361;
		$val ['WARN_115']=WARN_115;
		$val ['WARN_118']=WARN_118;
		$val ['ACCUEIL_SELECTION_DEFAUT']=MSG_217;
		$val ['ACCUEIL_SELECTION_VALIDATION']=MSG_2498;
		$val ['ACCUEIL_CHANGE_FORMATION']=$change_formation;
		$val ['ACCUEIL_SELECTION_ACTION']=$sess->self_url();
		$resthem=get_individu_filieres($auth->getUserId()); 
		$nbthem=pg_num_rows($resthem);
		parent::set_var($val);
		
		parent::set_block('contenu', 'filiere', 'bloc_filieres');
		for($i=0;$i<$nbthem;$i++){
			$row=pg_fetch_row($resthem,$i);
			parent::set_var('ACCUEIL_FILIERE_NUM',$row[0]);
			parent::set_var('ACCUEIL_FILIERE_LIB',get_fo_libelle($row[1]));
			Template::parse('bloc_filieres', 'filiere', true);
		}
	}
}
?>