<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche les libelle titre de la categorie et cre le contenu de l'aide.
 * 
 * @package aide
 */
class guiFoAideCategorie extends PageComponent{
	/**
	 * Affiche les libelle titre et creer leur contenu.
	 * 
	 * @param string[] $aide Tableau contenant toutes les information pour l'affichage de l'aide.
	 * @param string $cle Le libelle titre de la categorie d'aide.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
	function guiFoAideCategorie($aide,$cle,$module_root=null,$templates=null){
		global $MSG_1984;
		parent::PageComponent($module_root,$templates);
		
		parent::set_block('block_line','block','bloc_aide_item');
		parent::set_var('LIBELLE_AIDE_CATEGORIE',$cle);
//		parent::set_var('bloc_aide_item',"");
		$i=0;
		while(list($cle2,$val)=each($aide["$cle"])){
			$j=$i%2;	
			$component=new guiFoAideCategorieElement($val,$cle2,$j,$module_root,array('block_line' => 'gui_fo_aide_categorie_element.tpl'));
			$this->setComponent('block_line', $component,true,'block','bloc_aide_item');
			$i++;
		}
	}
}
?>