<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit les lments necessaire  l'affichage de la page aide
 * 
 * @package aide
 */
class guiFoAideModuleContenu extends PageComponent{
	/**
	 * Constructeur
	 * 
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function guiFoAideModuleContenu($module_root=null,$templates=null){
		
		global $MSG_2543,$MSG_2233,$MSG_126,$MSG_549,$MSG_1070,$MSG_1069,$MSG_450,$MSG_2546,$MSG_1622,$MSG_2548,$MSG_2547, $MSG_1623,$MSG_1624,$MSG_1625,$MSG_2544,$MSG_1570,$MSG_2545,$MSG_1062,$MSG_1065,$MSG_1048,$MSG_776,$MSG_1047,$MSG_1049,$MSG_1097,$MSG_1689,$MSG_1201,$MSG_1063;
		global $MSG_1068;
		parent::PageComponent($module_root,$templates);
		
		//$this->set_debug(4);
		// le tableau aide
		$aide [$MSG_2543] = array(
		'ico_etape_type_8'=>"$MSG_2546",
		'ico_etape_type_5'=>"$MSG_776",
		'ico_etape_type_2'=>"$MSG_1047",
		'ico_etape_type_10'=>$MSG_2233,
		'ico_etape_type_7'=>"$MSG_1049",
		'ico_etape_type_6'=>"$MSG_1097",
		'ico_etape_type_scorm'=>"$MSG_1689",
		'ico_etape_type_4_1_2'=>"$MSG_1570",
		'ico_etape_type_test'=>	"$MSG_2544" ,
		'ico_etape_type_4_1_2_3'=>"$MSG_1622",
		'ico_etape_type_4_3'=>"$MSG_2545",
		'ico_etape_type_4_1_0_1'=>"$MSG_1625",
		'ico_etape_type_4_1_0_4'=>$MSG_2547,
		'ico_etape_type_4_1_3_2'=>$MSG_1624,
		'ico_etape_type_src'=>$MSG_2548
		);

		$aide [$MSG_1065] = array(
		'ico_etape_obligatoire' => $MSG_126,
		'ico_etape_libre' => $MSG_450,
		'ico_etape_none' => $MSG_1068 ,
		'ico_etape_begin' => $MSG_1070 ,
		'ico_etape_end' => $MSG_1069
		);
		
		
		
		parent::set_block('contenu','block','bloc_aide_categorie');
		// BOUCLE SUR LES CATEGORIES
		while(list($cle,$val)=each($aide)){
			$page_item=new guiFoAideCategorie($aide,$cle,$module_root,array('block_line' => 'gui_fo_aide_categorie.tpl'));
			$this->setComponent('block_line', $page_item,true,'block','bloc_aide_categorie');
		}
		
	}
}
?>