<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit le tpl gnral de la page et insre les informations ncessaires 
 * dans les metas et titles de la structure html.
 * 
 * @package annuaire
 */ 
class AnnuairePage extends AstairsPageFo{
	/**
	 * Constructeur
	 * 
	 * @param object[] $pageBuilder Objet qui regroupe l'ensemble des information necessaire  la construction d'une page
	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
	 * @param string[] $style_files Le tableau contenant les chemins des fichier css 
	 * @param string[] $javascript_files Le tableau contenant les chemins des fichier js
	 * @param string $javascript_internal_code Permet d'afficher dans la structure de la page du code javascript en dur.
	 */
	function AnnuairePage($pageBuilder,$templates,$style_files, $javascript_files,$javascript_internal_code){
		
		global $MSG_2187, $MSG_2265,$MSG_2263,$MSG_1303,$MSG_915, $MSG_538,$MSG_652a,$WARN_115,$WARN_118;
		global $chemin_fo;
		$pageBuilder->setModuleRoot("$chemin_fo/module/templates/tpl");
		parent::AstairsPageFo($pageBuilder,$templates,$style_files, $javascript_files,$javascript_internal_code);
		
		$val ['PAGE_TITLE'] = $MSG_2187;
		$val ['PAGE_DESCRIPTION']= "";
		$val ['PAGE_KEYWORD']="";
		$val ['PAGE_SUBJECT']= "";
		$val ['PAGE_AUTHOR']= 'AFIDE';
		$val ['PAGE_FAVICO']= '';
		parent::set_var($val);
	}
}
?>