<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit l'ensemble des lments necessaire  l'affichage de la page Annuaire.
 * 
 * @package annuaire
 */
class guiFoAnnuaireModule extends PageComponent{
	/**
	 * @var object Objet graphique contenant l'affichage du debut de l'annuaire.
	 */
	var $debut;
	
	/**
	 * @var object Objet graphique contenant l'affichage du contenu de l'annuaire.
	 */
	var $contenu;
	
	/**
	 * @var object Objet graphique contenant l'affichage de la fin de l'annuaire.
	 */
	var $fin;
	
	 /**
	  * Constructeur
	  * 
	  * @param object[] $obj_DoFormation Objet contenant les informations de la formation.
	  * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	  * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	  */
	function guiFoAnnuaireModule($obj_DoFormation,$module_root=null,$templates=null){
		global $chemin_fo;
		
		parent::PageComponent($module_root,$templates);
		
		$this->debut =new guiFoAnnuaireModuleDebut( "$chemin_fo/annuaire/templates/tpl",array('debut_module' => 'gui_fo_annuaire_module_debut.tpl'));
		$this->setComponent( 'debut_module',$this->debut);
		
		$this->contenu =new guiFoAnnuaireModuleContenu($obj_DoFormation,"$chemin_fo/annuaire/templates/tpl",array('contenu_module' => 'gui_fo_annuaire_module_contenu.tpl'));
		$this->setComponent('contenu_module',$this->contenu);
		
		$this->fin =new guiFoAnnuaireModuleDebut( "$chemin_fo/annuaire/templates/tpl",array('fin_module' => 'gui_fo_annuaire_module_fin.tpl'));
		$this->setComponent( 'fin_module',$this->fin);
		
	}
}
?>