<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit le contenu qui accueillera les individus de chaques categories (ex: stagiaire, formateur...).
 * 
 * @package annuaire
 */ 
class guiFoAnnuaireModuleContenu extends PageComponent{
	/**
	  * Constructeur
	  * 
	  * @param object[] $obj_DoFormation Objet contenant les informations de la formation.
	  * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	  * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	  */
	function guiFoAnnuaireModuleContenu($obj_DoFormation,$module_root=null,$templates=null){
		global $chemin_fo,$MSG_18,$MSG_17;
		parent::PageComponent($module_root,$templates);
		
		//Recuperation du tableau
		$req=get_plateforme_individus_types();
		$nb = pg_num_rows($req);
		//recup classe
		$resclasse=get_formation_classes($obj_DoFormation->getFormation());
		$classe=pg_fetch_result($resclasse,0,0);
			
		parent::set_block('contenu_module','block','bloc_individu');
 		for($i=0; $i<$nb; $i++){
 			$row = pg_fetch_row($req,$i);
 			
 			
			// les stagiaires
			$resstag=get_classe_individus_infos($classe,$row[0],'asc','false');
			$nbstag=pg_num_rows($resstag);
//print_rr($row);
			if($nbstag){
 				$annuaire_module_individu = new guiFoAnnuaireModuleIndividuType($row[0],$row[1],$obj_DoFormation,$module_root,array('block_line'=>'gui_fo_annuaire_module_individu_type.tpl'));
				$this->setComponent('block_line',$annuaire_module_individu,true,'block','bloc_individu');
			}
 		}
	}
}
?>