<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche la photos et les informations de chaques individus
 * 
 * @package annuaire
 */
 class guiFoAnnuaireModuleIndividu extends PageComponent{
 		/**
 		 * Affichage de la photos et des informations de chaques individus
 		 * 
 		 * @param string[] $rowstag
 		 * @param string[] $configuration_affichage Le numro de configuration qui donne l'affichage ou non de la photo
 		 * @param string $tabconfiguration Tableau contenant des numros de configuration d'affichage
 		 * @param string $photo Doit ce trouver le numero de fichier ou le chemin url de la photo de l'individu
 		 * @param string $nom Le libelle nom de l'individu
 		 * @param string $prenom Le libelle prnom de l'individu
 		 * @param string $individu_mail Le libelle du mail de l'individu
 		 * @param string $tel_fixe Le libelle du tlphone fixe de l'individu
 		 * @param string $tel_port Le libelle du tlphone portable de l'individu
 		 * @param string $adresse Le libelle de l'adresse de l'individu
 		 * @param string $module_root Le chemin du dossier contenant les tpl requis
 		 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 		 */
 		function guiFoAnnuaireModuleIndividu($individu,$configuration_affichage,$tabconfiguration,$photo,$nom,$prenom,$individu_mail,$tel_fixe,$tel_port,$adresse,$code_postal,$ville,$module_root=null,$templates=null){
		//$rowstag[14],$rowstag[4],$rowstag[5],$rowstag[9],$rowstag[10],$rowstag[11],$rowstag[6]
			global $chemin_fo,$astairs_directories;		
			parent::PageComponent($module_root,$templates);


//			if(empty($row[14])){
//				$val['PHOTO_URL'] =DEFAULT_PHOTO_PATH;
//			}else{
//				$val['PHOTO_URL'] =$astairs_directories['PRIVATE_USER_DATA_DIR'].$individu.'/';
//			}
//			$val['PHOTO_ALT'] = MSG_15. $row[2];
//			$val['PHOTO_TITLE'] = MSG_15. $row[2];
//			
			//Affichage de la photo
			if(empty($photo)){
				$val['PHOTO_URL']=DEFAULT_PHOTO_PATH;
			}
		    else{
				$val['PHOTO_URL'] =$astairs_directories['PRIVATE_USER_DATA_URL'].$individu.'/'.pg_fetch_result(get_fichier($photo),0,1);
		    }

			$val['NOM']= $nom ;
			$val['PRENOM']= $prenom ;
			$val['MAIL']= "<a href=mailto:$individu_mail>$individu_mail</a>";
			$val['TEL_FIXE']= $tel_fixe;
			$val['TEL_PORT']= $tel_port;
			$val['ADRESSE']= $adresse;
			$val['CP']= $code_postal;
			$val['VILLE']= $ville;
			
	 		parent::set_var($val);
 	}
 }
?>