<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit l'affichage du cadre contenant chaque individu. 
 * 
 * @package annuaire
 */ 
 class guiFoAnnuaireModuleIndividuType extends PageComponent{
	/**
	 * Constructeur
	 * 
	 * @param integer $individu_type Le type de l'individu "2 = formateur","1 = Utilisateur","3 = intervenant".
	 * @param string $libelle_type_individu Le libelle du type.
	 * @param object[] $obj_DoFormation Objet contenant les informations de la formation.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
	function guiFoAnnuaireModuleIndividuType($individu_type,$libelle_type_individu,$obj_DoFormation,$module_root=null,$templates=null){
		global $serverfront, $chemin_fo;
		global $MSG_2187,$MSG_18,$MSG_17,$MSG_1104,$MSG_1078,$MSG_1077,$dbpath;
		parent::PageComponent($module_root,$templates);


		// recup type individu
		$formation=$obj_DoFormation->getFormation();
		$s_numstag=$obj_DoFormation->getIndividu();
		$res=get_individu_types($s_numstag);
		$row=pg_fetch_row($res,0);
		$categorie=$row[0];
		$tabconfiguration=array();
		$configuration_affichage=0;
		$res=get_page_annuaire_configuration($formation,1,$categorie);
		$nb_element=pg_num_rows($res);
		
		if($nb_element>0)
			$configuration_affichage=1;
		
		
		// On met la configuration dans un tableau
		for($i=0;$i<$nb_element;$i++){
			$row=pg_fetch_row($res,$i);
			$tabconfiguration[]=$row[0];
		}
		
		// recup classe
		$resclasse=get_formation_classes($formation);
		$n_group = pg_fetch_array($resclasse);
		
		// les individus
		$resindividu=get_classe_individus_infos($n_group[0],$individu_type,'asc','false');
		$nbindividu=pg_num_rows($resindividu);
		$listDiffIndividu = array();
		
		//La liste de diffusion des individu
		for($i=0;$i<$nbindividu;$i++){
		  $temps=pg_fetch_row($resindividu,$i);
		  if(!empty($temps[9]))
		  $listDiffIndividu[$i]=$temps[9];
		}
		$listDiffIndividu=implode(",",$listDiffIndividu);
		

		eval("\$libelle_type_individu = $libelle_type_individu;");
		
		
		//Affichage 
		$val['ANNUAIRE_INDIVIDU_MAILTO_LISTE_DIFFUSION'] = $listDiffIndividu;
		$val['ANNUAIRE_INDIVIDU_LIBELLE_LISTE_DIFFUSION'] = MSG_1078;
		$val['ANNUAIRE_TYPE_INDIVIDU_URL_FLECHE_GAUCHE'] = "";
	//	$val['URL_IMAGE_FLECHE_GAUCHE']="http://$serverfront/bac_a_sable/AstairsV2/fo/styles/afide/pictures/parcours/flechedirect_gauche.png";
		$val['ANNUAIRE_TYPE_INDIVIDU_URL_FLECHE_DROITE']="";
	//	$val['URL_IMAGE_FLECHE_DROITE']="http://$serverfront/bac_a_sable/AstairsV2/fo/styles/afide/pictures/parcours/flechedirect_droite.png";
		$val['ANNUAIRE_TYPE_INDIVIDU_LIBELLE'] = $libelle_type_individu;
		$val['ANNUAIRE_TYPE_INDIVIDU_ID'] = "_".$individu_type;
		
		//On boucle sur les individus		
		parent::set_block('block_line','block','bloc_individu_infos');		
		for($i=0;$i<$nbindividu;$i++) {
			$rowindividu=pg_fetch_row($resindividu,$i);
			//On affiche les renseignement de l'individu			
			$annuaire_module_individu_infos = new guiFoAnnuaireModuleIndividu($rowindividu[0],$configuration_affichage,$tabconfiguration,$rowindividu[14],$rowindividu[4],$rowindividu[5],$rowindividu[9],$rowindividu[10],$rowindividu[11],$rowindividu[6],$rowindividu[7],$rowindividu[8],$module_root,array('block_line' => 'gui_fo_annuaire_module_individu.tpl'));
			$this->setComponent('block_line',$annuaire_module_individu_infos,true,'block','bloc_individu_infos');
		}
		parent::set_var($val);
	}
}
?>