
/*
 *	Constantes pour moveLayer(Sens)
 */
 var moveLayer = {
	timer : null,
	 
	/*
	 *	Deplace un div de gauche a droite.
	 *	@param String Div Id du div a deplacer
	 *	@param integer Sens Sens de deplacement -1= gauche, 1= droite
	 *	@param integer Pas Vitesse de deplacement
	 */
	move : function(div,sens,pas){
		var scrolledElm = document.getElementById(div);
		if (!scrolledElm.scrollInitialized) {
			var width=0;
			for (var i=0; i<scrolledElm.childNodes.length; i++) {
				var oElm = scrolledElm.childNodes[i];
				if (oElm.nodeType==1)  {
					width+=oElm.offsetWidth+this.intStyle(oElm,'margin-left')+this.intStyle(oElm,'margin-right');
				}
			}
			scrolledElm.style.width = (width+10)+'px';
			scrolledElm.scrollInitialized = true;
		}
		
		scrolledElm.parentNode.scrollLeft+=sens*pas;
		moveLayer.timer = setTimeout(function() {
			moveLayer.move(div, sens, pas);
		},15); 
	},
	
	intStyle : function (oElm, strCssRule) {
		// getStyle : retourne la valeur d'une propriete CSS appliquee  un element
		var strValue = "";
		if(document.defaultView && document.defaultView.getComputedStyle) {
		 try{ strValue = document.defaultView.getComputedStyle(oElm, "" ).getPropertyValue(strCssRule); }
		 catch(e) { strValue = ""; }
		}
		else if(oElm.currentStyle) {
		 try{
		  strCssRule = strCssRule.replace(/\-(\w)/g, function (strMatch, p1){
		   return p1.toUpperCase();
		  });
		  strValue = oElm.currentStyle[strCssRule];
		 } catch(e) {
		  strValue = "";
		 }
		}
		return parseInt(strValue,10);
		
	}
}
 


