<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

class RollingOutlineElement extends PageComponent{
	
	var $debut;
	var $contenu;
	var $fin;
	
	function RollingOutlineElement($titre, $texte_contenu, $module_root=null,$templates=null){
	
		global $chemin_fo;
		
		parent::PageComponent($module_root,$templates);
		
		//les lments pour le component
		$this->debut=new RollingOutlineElementDebut($titre, "$chemin_fo/blanchard/templates/tpl",array('rolling_outline_element_debut' => 'rolling_outline_element_debut.tpl'));
		$this->contenu=new RollingOutlineElementContenu($texte_contenu, "$chemin_fo/blanchard/templates/tpl",array('rolling_outline_element_contenu' => 'rolling_outline_element_contenu.tpl'));
		$this->fin=new RollingOutlineElementFin('','' ,'', "$chemin_fo/blanchard/templates/tpl",array('rolling_outline_element_fin' => 'rolling_outline_element_fin.tpl'));	
		
		//affectation des lments
		$this->setComponent('rolling_outline_element_debut', $this->debut);
		$this->setComponent('rolling_outline_element_contenu', $this->contenu);
		$this->setComponent('rolling_outline_element_fin',$this->fin);
	}
}

?>


