<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit l'ensemble du calendrier, il est composer de trois module.
 * Le module debut qui construit l'affichage de la legende des symboles et des couleurs.
 * Le module contenu qui construit le tableau de cours dans lequelle il y a toute les informations d'un cours pour l'individu.
 * Le module fin qui construit rien, il est vide.
 */
 class guiFoCalendrierModule extends PageComponent{
 	/**
 	 * @var object Objet graphique qui construit le module debut du calendrier
 	 */
 	var $debut;
 	/**
 	 * @var object Objet graphique qui construit le module contenu du calendrier
 	 */
 	var $contenu;
 	/**
 	 * @var object Objet graphique qui construit le module fin du calendrier
 	 */
 	var $fin;
 	/**
 	 * Constructeur
 	 * 
 	 * @param object[] $obj_DoFormation Objet contenant les informations de la formation.
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
 	function guiFoCalendrierModule($obj_DoFormation,$module_root=null,$templates=null){
 		global $chemin_fo,$root;
		parent::PageComponent($module_root,$templates);
		
		if(!isset($num_cal)||$num_cal=="")
        $num_cal=$obj_DoFormation->getFormation();

		// REQUETE SUR INTERVENTION POUR CONNAITRE LES COULEURS
		$res=get_formation_evenements($num_cal);
		$nb=pg_num_rows($res);
		
		//$this->debut = new guiFoCalendrierModuleDebut($largeur,$couleur,$libelle_couleur,"$chemin_fo/calendrier/templates/tpl", array('debut_module'=>'gui_fo_calendrier_module_debut.tpl'));
		// Modif Said (20/01/08) : passe le n de formation: 
		$this->debut = new guiFoCalendrierModuleDebut($num_cal,"$chemin_fo/calendrier/templates/tpl", array('debut_module'=>'gui_fo_calendrier_module_debut.tpl'));
			
		$this->setComponent('debut_module',$this->debut);
		
		$this->contenu = new guiFoCalendrierModuleContenu('contenu_module',$num_cal,"$chemin_fo/calendrier/templates/tpl", array('contenu_module'=>'gui_fo_calendrier_module_contenu.tpl'));
		$this->setComponent('contenu_module',$this->contenu);
		
		$this->fin = new guiFoCalendrierModuleFin("$chemin_fo/calendrier/templates/tpl", array('fin_module'=>'gui_fo_calendrier_module_fin.tpl'));
		$this->setComponent('fin_module',$this->fin);

		$val['NOM_MODULE']="calendrier";
		parent::set_var($val);
	}
}
?>