<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit le tableau du module contenu du calendrier.
 * 
 * @package calendrier
 */
class guiFoCalendrierModuleContenu extends PageComponent{
	/**
	 * Constucteur
	 * 
	 * @param string $block_target Le nom de la variable qui contiendra la boucle dans le tpl.
	 * @param integer $num_cal Le numro de calendrier.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function guiFoCalendrierModuleContenu($block_target,$num_cal,$module_root=null,$templates=null){
		
		global $MSG_650,$MSG_622,  $MSG_652,$MSG_653 ,$MSG_654, $MSG_193,$MSG_197,$MSG_199,$MSG_1360,$MSG_655;
		global $chemin_fo;
		parent::PageComponent($module_root,$templates);
		
		//On rcupere le nom de la formation		
		$resformation=get_formation($num_cal);
		$s_nomcal=pg_fetch_result($resformation,0,1);
		
		//MISE EN PLACE DES TITRES DU TABLEAU
		$val['CALENDRIER_MODULE_CONTENU_TITRE']="Formation : ".get_fo_libelle($s_nomcal);
		$val['CALENDRIER_MODULE_CONTENU_DATE']=$MSG_650;
		$val['CALENDRIER_MODULE_CONTENU_DEBUT']=$MSG_652;
		$val['CALENDRIER_MODULE_CONTENU_FIN']=$MSG_653;
		$val['CALENDRIER_MODULE_CONTENU_INTITULE']=$MSG_654;
		$val['CALENDRIER_MODULE_CONTENU_MODALITE']=$MSG_655;
		$val['CALENDRIER_MODULE_CONTENU_INTERVENANT']=$MSG_197;
		$val['CALENDRIER_MODULE_CONTENU_SALLE']=$MSG_199;
		$val['CALENDRIER_MODULE_CONTENU_ALERTE']=$MSG_1360;	
		
		// REQUETE SUR GESTCAL POUR CONNAITRE LES COURS ET EVENEMENTS DE CETTE FORMATION
		$result=get_formation_evenements($num_cal);
		$nb_result=pg_num_rows($result);
		parent::set_block($block_target,'block','bloc_calendrier');
		// PARCOURS DES RESULTATS
		for($i=0; $i<$nb_result;$i++){
		$row=pg_fetch_row($result,$i);
		//print_rr($row);	
			// recup date courante,debut et fin
			$td=explode(" ",$row[2]);
			//echo "td=$td[1]<br>";
			$heure_debut=substr($td[1],0,-3);
			$t=explode("-",$td[0]);
			$tb=explode(":",$row[3]);
			$fin=dbstamp2tstamp($row[2]) +hms_to_secondes($tb);
			$periode_fin=date("y/m/d H:i:s",$fin);
			$hf = split(" ",$periode_fin);
			$heure_fin = substr($hf[1],0,-3);
			
			$tabdate=split("-",$td[0]);
			$libelle_date=$tabdate[2]."/".$tabdate[1]."/".substr($tabdate[0],2,2);

			$periode="a suivre...";
			if($row[6]!=""){
				$resuse=get_individu_nom_prenom($row[6]);
				$formateur=pg_result($resuse,0,1)." ".pg_result($resuse,0,2);
			}
			else
				$formateur="&nbsp;";
	
	        if ($row[7] != "") {
				$ressal=get_salle($row[7]);
				$salle=pg_fetch_result($ressal,1);
	        }
	        else
	                $salle="&nbsp;";
	
	        //recup de la couleur en fonction du type d'intervention (ex: runion,confrence ...)
	        $rescoul=get_intervention($row[5]);
	        $rowcoul=pg_fetch_row($rescoul,0);
	        $couleur=$rowcoul[2];
//	        $couleur=get_couleur($numcoul);
//	        $couleur=$numcoul;
//			$intitule = $row[1];
			
	        //recup image en fonction de la modalite
//	        $num_image = $row[4];
	        switch($row[4])
	        {
	                case 1:$image_mod="synch.gif";
	                        break;
	                case 2:$image_mod="asynch.gif";
	                        break;
	                case 3:$image_mod="presentiel.gif";
	                        break;
	        }

	        // test si alert sur date de cours
	        $numdate=$row["num_date"];
			$resalert=get_formation_alerte($num_cal,$td[0]);
			$rowalert=pg_fetch_row($resalert,0);
			//print_rr($rowalert);
			
	        if($rowalert[0]>0)
	        {
	                $rowalert=pg_fetch_row($resalert,0);
	                $texte=$rowalert[5];
	                $alerte=$rowalert[0];
	        }
			else{
				$alerte=0;
				$texte="";	
			}
			//echo "texte=$texte<br>";
			$ligne_calendrier = new guiFoLigneCalendrier($salle,$formateur,$couleur,$row[4],$image_mod,$libelle_date,$periode,$heure_debut,$heure_fin,$row[1],$texte,$alerte,$module_root,array('block_line'=>'gui_fo_ligne_calendrier.tpl'));
			$this->setComponent('block_line',$ligne_calendrier,true,'block','bloc_calendrier');
	
	}
		parent::set_var($val);
		
	}
}
?>
