<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche le module debut du calendrier comportant la legende des symboles et la legende des couleurs.
 * 
 * @package calendrier.
 */
class guiFoCalendrierModuleDebut extends PageComponent{
	/**
	 * Affichage du module debut du calendrier.
	 * 
	 * @param integer $largeur ne correspond a rien.
	 * @param $couleur La valeur de la couleur en, hexadecimal de l'icone.
	 * @param string $couleur Le libelle de l'intitul correspondant  sa couleur.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	//function guiFoCalendrierModuleDebut($largeur,$couleur,$num_cal,$libelle_couleur,$module_root=null,$templates=null){
	function guiFoCalendrierModuleDebut($num_cal,$module_root=null,$templates=null){
		
		global $MSG_194,$MSG_195,$MSG_196,$path;
		global $MSG_2603,$MSG_2604;
		parent::PageComponent($module_root,$templates);

		$val['CALENDRIER_MODULE_DEBUT_TITRE']=$MSG_2603;//"Lgende des symboles";
		$val['CALENDRIER_MODULE_DEBUT_SYNCHRONE'] = $MSG_194."<img src=\"$path/data/images/synch.gif\">";
		$val['CALENDRIER_MODULE_DEBUT_ASYNCHRONE'] = $MSG_195."<img src=\"$path/data/images/asynch.gif\">";
		$val['CALENDRIER_MODULE_DEBUT_PRESENTIEL'] = $MSG_196."<img src=\"$path/data/images/presentiel.gif\">";
		
		$val['CALENDRIER_MODULE_DEBUT_TITRE_LC']=$MSG_2604;//"Lgende des couleurs";
		
		// recup des evnements
		$res=get_formation_evenements($num_cal);
		$nb=pg_num_rows($res);
		// Nombre de couleurs par ligne
		$nbC=4 ;
		parent::set_block('debut_module','block','calendrier_module_debut_contenu');
		$tab_intervention=array();
		for($i=0;$i<$nb;$i++){
			$row=pg_fetch_row($res,$i);
			// filtre sur les couleur
			if(!in_array($row[5],$tab_intervention)){
				$tab_intervention[]=$row[5];
			$ncoul=$row[5];
				$rescoul=get_intervention($ncoul);
				$couleur=pg_fetch_result($rescoul,0,2);
				$lib=pg_fetch_result($rescoul,0,1);
				//$coul=get_couleur($couleur);
				//echo "coul=$coul<br>";
		        $largeur = round(50/$nbC, 1) ;
				$libelle_couleur=$row[1];
				$libelle_couleur=$lib;
				//$couleur=$coul;
				$component=new guiFoCalendrierLegendeCouleur($couleur,$libelle_couleur,$module_root,array('block_legende' => 'gui_fo_calendrier_legende_couleur.tpl'));
				$this->setComponent('block_legende', $component,true,'block','calendrier_module_debut_contenu');
			}		
		}
		//$val['CALENDRIER_MODULE_DEBUT_LC_LIBELLE']=$libelle_couleur."<div id=\"couleur_lc_$couleur\"></div>";
		
		parent::set_var($val);
	}
}
?>
