<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche l'icone color et de son image associ.
 * 
 * @package calendrier
 */
class guiFoColonneCalendrierImage extends PageComponent{
 	/**
 	 * Affichage de l'icone color et de son contenu.
 	 * 
 	 * @param string $couleur La valeur de la couleur en, hexadecimal de l'icone.
 	 * @param integer $num_image L'identifiant de l'image.
 	 * @param string $image_mod Le libelle de l'image avec son extension.
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
 	function guiFoColonneCalendrierImage($couleur,$num_image,$image_mod,$module_root=null, $templates=null){
		global $path; 		
 		parent::PageComponent($module_root,$templates);

 		$val['CONTENU_COULEUR_IMAGE']=$couleur;
 		$val['CONTENU_IMAGE']="<img src=\"$path/data/images/$image_mod\">";
 		
 		parent::set_var($val);
 	}
 }
?>