<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit toute les colonnes du calendrier afin de pouvoir afficher 
 * ligne par ligne les differents cours prsent pour un individu.
 * 
 * @package calendrier
 */
class guiFoLigneCalendrier extends PageComponent{
 	/**
 	 * Constructeur
 	 * 
 	 * @param string $salle Le libelle du numro de salle ou ce trouve le cours (ex: salle 121).
 	 * @param string $formateur Le libelle du formateur
 	 * @param string $couleur La valeur de la couleur en, hexadecimal de l'icone.
 	 * @param integer $num_image L'identifiant de l'image.
 	 * @param string $image_mod Le libelle de l'image avec son extension.
 	 * @param string $libelle_date Le libelle de la date
 	 * @param string $periode Le libelle de la periode du cours.
 	 * @param string $heure_debut Le libelle de l'heure de debut
 	 * @param string $heure_fin Le libelle de l'heure de fin.
 	 * @param string $intitule Le libelle de l'intitul du cours.
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
 	function guiFoLigneCalendrier($salle,$formateur,$couleur,$num_image,$image_mod,$libelle_date,$periode,$heure_debut,$heure_fin,$intitule,$texte,$alerte,$module_root=null, $templates=null){
 		global $chemin_fo;
 		parent::PageComponent($module_root,$templates);
 		
 		$colonne_calendrier_date = new guiFoColonneCalendrierDate($libelle_date,"$chemin_fo/calendrier/templates/tpl",array('colonne_calendrier_date'=>'gui_fo_colonne_calendrier_date.tpl'));
 		$this->setComponent('colonne_calendrier_date',$colonne_calendrier_date);
 		
 		$colonne_calendrier_heure_debut = new guiFoColonneCalendrierHeureDebut($heure_debut,"$chemin_fo/calendrier/templates/tpl",array('colonne_calendrier_heure_debut'=>'gui_fo_colonne_calendrier_heure_debut.tpl'));
		$this->setComponent('colonne_calendrier_heure_debut',$colonne_calendrier_heure_debut);
		
 		$colonne_calendrier_heure_fin = new guiFoColonneCalendrierHeureFin($heure_fin,"$chemin_fo/calendrier/templates/tpl",array('colonne_calendrier_heure_fin'=>'gui_fo_colonne_calendrier_heure_fin.tpl'));
		$this->setComponent('colonne_calendrier_heure_fin',$colonne_calendrier_heure_fin);
		
 		$colonne_calendrier_intitule = new guiFoColonneCalendrierIntitule($intitule,"$chemin_fo/calendrier/templates/tpl",array('colonne_calendrier_intitule'=>'gui_fo_colonne_calendrier_intitule.tpl'));
		$this->setComponent('colonne_calendrier_intitule',$colonne_calendrier_intitule);
		
 		$colonne_calendrier_image = new guiFoColonneCalendrierImage($couleur,$num_image,$image_mod,"$chemin_fo/calendrier/templates/tpl",array('colonne_calendrier_image'=>'gui_fo_colonne_calendrier_image.tpl'));
		$this->setComponent('colonne_calendrier_image',$colonne_calendrier_image);
		
 		$colonne_calendrier_formateur = new guiFoColonneCalendrierFormateur($formateur,"$chemin_fo/calendrier/templates/tpl",array('colonne_calendrier_formateur'=>'gui_fo_colonne_calendrier_formateur.tpl'));
		$this->setComponent('colonne_calendrier_formateur',$colonne_calendrier_formateur);
		
 		$colonne_calendrier_salle = new guiFoColonneCalendrierSalle($salle,"$chemin_fo/calendrier/templates/tpl",array('colonne_calendrier_salle'=>'gui_fo_colonne_calendrier_salle.tpl'));
		$this->setComponent('colonne_calendrier_salle',$colonne_calendrier_salle);
		
		if($alerte){
 			$colonne_calendrier_alerte = new guiFoColonneCalendrierAlerte($texte,$alerte,"$chemin_fo/calendrier/templates/tpl",array('colonne_calendrier_alerte'=>'gui_fo_colonne_calendrier_alerte.tpl'));
 			$this->setComponent('colonne_calendrier_alerte',$colonne_calendrier_alerte);
		}else{
			$colonne_calendrier_alerte = new guiFoColonneCalendrierNoAlerte($texte,$alerte,"$chemin_fo/calendrier/templates/tpl",array('colonne_calendrier_alerte'=>'gui_fo_colonne_calendrier_no_alerte.tpl'));
 			$this->setComponent('colonne_calendrier_alerte',$colonne_calendrier_alerte);
		}
 	}
 }
?>