<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*-------------------------------------------------------*/
//  Fichier alert.php
// Action : Propose la saisie d'une alerte pour les stagiaire en front office
// Donnes reues : $date (ex 2003-02-28) et $num_cal
/*-------------------------------------------------------*/
/*--------------------------------------------------*/
//                      IDENTIFICATION
/*--------------------------------------------------*/
$dbpath="..";
include('../lib/identification.php3');
/*--------------------------------------------------*/
require('../dbpostgres.php3');
$db = pg_Connect("$server", "", "", "", "$nombase");
require("./functions.inc.php");
// debug
//echo "nous sommes le ".date("m-d-Y");
/*-------------------------------------------------------*/
//          FONCTIONS PHP
/*-------------------------------------------------------*/
// fonction qui retourne la periode max disponible
function calcul_periode($num_cal,$date){
    //recup des jours > $date
    $req="select jour from dates where num_date in
    (select num_date from alert where num_cal='$num_cal') and jour>'$date' order by jour";
    $res=pg_query($req);
    if(pg_numrows($res)>0){
        // recup du premier jour
        $row=pg_fetch_row($res,0);
        $tabjour=explode("-",$row[0]);
        $tabdate=explode("-",$date);
        $jour = mktime( 0, 0, 0, $tabjour[1], $tabjour[2], $tabjour[0] );
        $dt = mktime( 0, 0, 0, $tabdate[1], $tabdate[2], $tabdate[0] );

        $dif=($jour-$dt) / (60*60*24);
        if($dif>15)
            $periode=15;
        else
            $periode=$dif -1;
    }
    else
        $periode=15;
    return $periode;
}
// fonction de mise  jours des periodes prcdentes
// ex : si le 15/03/2003 il y a une alerte pour 15 jours
//        et qu'on met une alerte le 25/03/2003 alors
//        il faut reduire la periode  9 jours
function maj_periode($num_cal,$num_date){
    // recup de la date de num_date
    $req="select jour from dates where num_date='$num_date'";
    $res=pg_query($req);
    $row=pg_fetch_row($res,0);
    $date=$row[0];
    //recup des jours < $date
    $req="select jour,num_date from dates where num_date in
    (select num_date from alert where num_cal='$num_cal') and jour<'$date' order by jour desc";
    $res=pg_query($req);
    if(pg_numrows($res)>0){
        //recup du jour precedent
        $row=pg_fetch_row($res,0);

        // recup de la periode de ce jour
        $req="select periode from alert where num_cal='$num_cal' and num_date='$row[1]'";
        $resperiode=pg_query($req);
        $rowperiode=pg_fetch_row($resperiode,0);
        $periode=$rowperiode[0];
        $tabjour=explode("-",$row[0]);
        $tabdate=explode("-",$date);
        $jour = mktime( 0, 0, 0, $tabjour[1], $tabjour[2], $tabjour[0] );
        $dt = mktime( 0, 0, 0, $tabdate[1], $tabdate[2], $tabdate[0] );
        $dif=($dt -$jour) / (60*60*24);
        if($periode>$dif){
            $periode=$dif -1;
            $req="update alert set periode='$periode' where num_cal='$num_cal' and num_date='$row[1]'";
            $res=pg_query($req);
        }

    }
}

/*-------------------------------------------------------*/
//          SOUMISSION FORMULAIRE
/*-------------------------------------------------------*/
if(isset($subalert)){

        // debug
        //echo "date=$date <br>num_cal=$num_cal<br>alert=$alert<br>periode=$periode<br>titre=$titre<br>num_date=$num_date";
        $alert=addslashes($alert);
        $alert=nl2br($alert);
        $titre=addslashes($titre);
        // test existence alert pour le calendrier et la date de l'alert
        $req="select * from alert where num_cal=$num_cal and num_date=$num_date";
        $res=pg_query($req);
        if(pg_numrows($res)==0){
            $sql="insert into alert (num_cal,num_date,periode,intitule,texte) values('$num_cal','$num_date','$periode','$titre','$alert');";
            $ins=pg_query($sql);

            $mesg=$MSG_1313;
        }
        else {
            $sql="update alert set periode='$periode',intitule='$titre',texte='$alert' where num_cal='$num_cal' and num_date='$num_date';";
                $maj=pg_query($sql);

                $mesg=$MSG_1314;
        }
        // mise  jour des periodes prcdentes
        maj_periode($num_cal,$num_date);

        // On reload le pere et on ferme cette fenetre
        reload_father();
        print("<script>window.close()</script>");
}


/*-------------------------------------------------------*/
//          FONCTIONS JAVASCRIPT
/*-------------------------------------------------------*/
print("
<script language=\"javascript\">
function validealert(){
    document.formalert.submit();
}
</script>
");
// debug
//echo "alert=$selalert<br>";

$date_du_jour=fr_txt_date($date,MY_LANG);

$num_date=get_num_date($date);
print("
<html>
<body bgcolor=\"#FFFFFF\">
");
/*
if(isset($mesg))
{

        print("
        <center><table><tr><td height=200 align=middle align=center>
        <font face=\"Arial,Helvetica\" size=3 color=\"#ff0000\">$mesg</font><br>
        <form>
        <input type=\"button\" value=\"$FORM_22\" onclick='javascript:window.close()'>
        </form>
        </td></tr></table>
        </center>
        ");

        reload_father();
}
else
{*/
        print("
        <center>
        <form name=\"formalert\">
        <table border=1 cellspacing=0 cellpading=10 width=\"90%\">
        <tr><td bgcolor=\"#CCCCCC\" colspan=1 height=30>
                <font face=\"Arial,Helvetica\" size=3 align=center><b>Selection d'une alerte existante</b></font></td>
                <td rowspan=10 bgcolor=#CCCCCC>&nbsp;&nbsp;</td></tr>

        <tr><td><br>
        <table width=\"100%\"><tr>
        <td width=40%><font face=\"Arial,Helvetica\" size=2><b>$MSG_650 :</b></font></td>
        <td><font face=\"Arial,Helvetica\" size=2>$date_du_jour</font></td></tr>
        ");
        // recup des alert
        $req="select * from alert ";
        $resalert=pg_query($req);
        $nbalert=pg_numrows($resalert);
        if($nbalert>0){
        print("
        <tr><td nowrap>
        <font face=\"Arial,Helvetica\" size=2><b>Slection une alerte :</b></font></td>
        <td><font face=\"Arial,Helvetica\" size=2><select name=\"selalert\" onchange=\"validealert();\">
        <option value=\"\">Slectionnez
        ");
        for($a=0;$a<$nbalert;$a++){
                $rowalert=pg_fetch_row($resalert,$a);
                if($selalert==$rowalert[0])
                print("
                <option value=\"$rowalert[0]\" selected>$rowalert[4]</option>
                ");
                else
                print("
                <option value=\"$rowalert[0]\">$rowalert[4]</option>
                ");

        }
        print("
        </select></font></td></tr>
        ");
//}
if($selalert>0)
{
    unset($periode);
    //recup des valeurs
    $req="select * from alert where num_alert='$selalert'";
    $res=pg_query($req);
    $row=pg_fetch_row($res,0);
     $row[5]=str_replace("<br />","","$row[5]");
    // debug
    //echo "selalert=$selalert<br>row[3]=$row[3]<br>periode=$periode";

}

print("


</td></tr></table><br></td></tr>


<tr><td colspan=1 bgcolor=#CCCCCC height=30><font face=\"Arial,Helvetica\" size=3><b>Ou crer une alerte</b></font></td></tr>

<tr><td><br><table width=\"100%\">

<tr><td width=40%><font face=\"Arial,Helvetica\" size=2><b>$MSG_590 :</b></font></td>

<td><font face=\"Arial,Helvetica\" size=2><input type=text name=\"titre\" size=40 value=\"$row[4]\"></font></td></tr>
<tr><td><font face=\"Arial,Helvetica\" size=2><b>Alerte :</b></font></td><td><textarea name=\"alert\" rows=3 cols=40>$row[5]</textarea></font></td></tr>
<tr><td nowrap><font face=\"Arial,Helvetica\" size=2><b>Valable pendant :</b></font></td><td align=center>
<font face=\"Arial,Helvetica\" size=2><select name=\"periode\">
<option value=\"\">Slectionnez</option>
");
// calcul de la priode disponible  raison de 15 jours max
$maxperiode=0;
$maxperiode=calcul_periode($num_cal,$date);
for($i=1;$i<$maxperiode +1;$i++){
    if($i==$periode || $i==$row[3])
        print("
        <option value=\"$i\" selected>$i jour(s)</option>
        ");
    else
        print("
        <option value=\"$i\">$i jour(s)</option>
        ");
}
print("
</select></font></td></tr>

</table><br></td></tr>

<input type=hidden name=\"date\" value=\"$date\">
<input type=hidden name=\"num_cal\" value=\"$num_cal\">

<input type=hidden name=\"num_date\" value=\"$num_date\">
<tr><td colspan=1 align=center bgcolor=#CCCCCC height=40 valign=middle>
        <font face=\"Arial,Helvetica\" size=2><input type=submit name=\"subalert\" value=\"$FORM_6\"></font></td></tr>
");

print("
</table>
</form></center>
");
}
print("
</body>
</html>
");
?>