<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

// On crait l'objet    :
//  $objet=new planning;
//  on donne un titre :
//     $objet->titre="Le titre";
//
//     on crait un element :
//      $objet->new_elt("Nom de l'lment");
//             on rajoute des evnement d l'lment :
//                        $objet->add($label1, $debut, $fin, 0);
//                        $objet->add($label2, $debut2, $fin2, 1);
//                        $objet->add($label3, $debut3, $fin3, 0);
//                $label contient le descriptif de l'evnement
//                $debut contient l'heure de dbut ( format 09:00 )
//                $fin contient l'heure de fin (format 12:00)
//                0 met la couleur en rouge,
//                1 met la couleur en vert
//
//        on crait un second elment
//        $objet->new_elt("Nom du deuxime elment ");
//                ...
//                ...
//                ...
//
//        Pour afficher le planning :
//        $objet->affiche();

function strip_zero($num)
{
        if($num[0]==0){
                $num=$num[1];
        }
        return($num);
}

function mkcolor($image,$color)
{
        $color = eregi_replace("#","",$color);
        $red = hexdec(substr($color,0,2));
        $green = hexdec(substr($color,2,2));
        $blue = hexdec(substr($color,4,2));

        $out = ImageColorAllocate($image, $red, $green, $blue);
        return($out);
}


// La classe element
class element
{
        var $nom;
        var $nb;

        var $tab;

        // Constructeur
        function element()
        {
                $nom="nom";
                $nb=0;
        }

        // Procdure d'ajout d'un element
        function add($label,$debut,$fin,$type=0)
        {
                $test=0;
                $i=0;
                $d=ereg_replace(':','',$debut);
                $f=ereg_replace(':','',$fin);
               // Correspond  la couleur
               if($type!=1)
                        $type=0;

               // Premier ajout
               if($this->nb==0)
               {
                        $this->tab[0]["label"]=$label;
                        $this->tab[0]["debut"]=$debut;
                        $this->tab[0]["fin"]=$fin;
                        $this->tab[0]["type"]=$type;
                        $this->nb=1;
               }
               // Autres ajouts
               else
               {
                        while($i< ($this->nb)  &&  $test==0)
                        {
                                if($d< ereg_replace(':','',$this->tab[(($this->nb)-($i+1))]["debut"]))
                                {
                                        $this->tab[(($this->nb)-($i))]=$this->tab[(($this->nb)-($i+1))];
                                        $i++;
                                }
                                else
                                {
                                        $this->tab[(($this->nb)-($i))]["label"]=$label;
                                        $this->tab[(($this->nb)-($i))]["debut"]=$debut;
                                        $this->tab[(($this->nb)-($i))]["fin"]=$fin;
                                        $this->tab[(($this->nb)-($i))]["type"]=$type;
                                        $test=1;
                                        $this->nb++;
                                }
                        }
                        if($test==0)
                        {
                                $this->tab[(($this->nb)-($i))]["label"]=$label;
                                $this->tab[(($this->nb)-($i))]["debut"]=$debut;
                                $this->tab[(($this->nb)-($i))]["fin"]=$fin;
                                $this->tab[(($this->nb)-($i))]["type"]=$type;
                                $this->nb++;
                        }
               }

        }

        // Retourne le contenu de la case i de tab
        function infos($i){
               return($this->tab[$i]);
        }

        // Affiche les dtails
        function details()
        {
                echo 'Il y a '.$this->nb.' entres<br>' ;
                for($i=0;$i<$this->nb;$i++)
                {
                        echo 'Label : '.$this->tab[$i]["label"].'<br>';
                        echo 'Debut : '.$this->tab[$i]["debut"].'<br>';
                        echo 'Fin : '.$this->tab[$i]["fin"].'<br>';
                        echo 'Dure : '.$this->duree($i).'<br><br>';
                }

        }

        // Accesseurs sur nb
        function nb()
        {
                return($this->nb);
        }
        // Accesseurs sur nom
        function nom()
        {
                return($this->nom);
        }
}


// LA CLASSE PLANNING
class planning{

        var $couleur;
        var $altcouleur;

        var $marge;
        var $bord;

        var $titre;
        var $date;

        var $tab_elt;
        var $nb;
        var $im;

        var $cpt;

        // Constructeur reoit une chaine de caractre
        function planning($titre="Titre")
        {
                // Initialisations
                $this->nb=0;
                $this->marge=100;
                $this->titre=$titre;
        }

         // Dclaration d'un lment
         function new_elt($nom){
                $this->nb++;
                $this->tab_elt[($this->nb-1)]=new element;
                $this->tab_elt[($this->nb-1)]->nom=$nom;
        }

         // Ajout d'un lment
         function add($label,$debut,$fin,$type=0){
                $this->tab_elt[($this->nb-1)]->add($label,$debut,$fin,$type);
         }



        // Procdure d'affichage de l'image
        function afficheIMG()
        {
                Header("Content-type:image/jpeg");
                $hauteur=($this->nb * 40)+40;
                $this->im = ImageCreate(721+$this->marge,$hauteur+40);

                $blanc=mkcolor($this->im, '#FFFFFF');
                $this->bord = mkcolor($this->im, '#000000');
                $this->couleur = mkcolor($this->im, '#FF0000');
                $this->altcouleur = mkcolor($this->im, '#00FF00');

                $gris1=   mkcolor($this->im, '#CCCCCC');
                $gris0=  mkcolor($this->im, '#999999');

                imagestring ($this->im, 2,350,$hauteur+20, $this->titre, $this->bord );

                ImageLine($this->im,0+$this->marge,30,720+$this->marge,30,$this->bord);
                ImageLine($this->im,0+$this->marge,12,0+$this->marge,30,$this->bord );
                imagestring ($this->im, 2,0+$this->marge,0, 0, $this->bord );
                ImageLine($this->im,720+$this->marge,13,720+$this->marge,30,$this->bord );
                imagestring ($this->im, 2,710+$this->marge,0, 24, $this->bord );

               $alterne=0;

                for($i=-15;$i<720;$i+=15)
                {
                        $ton="gris$altern";
                        imageFilledrectangle ($this->im, $i+$this->marge,35, $i+30+$this->marge, $hauteur,$$ton);
                        switch($altern){
                                case 0 :
                                        $altern=1;
                                        break;
                                case 1:
                                        $altern=0;
                                        break;
                        }
                }

                for($i=1;$i<720;$i++){
                        if( $i % 360 ==0){
                        ImageLine($this->im,$i+$this->marge,12,$i+$this->marge,30,$this->bord);
                        imagestring ($this->im, 2,($i-4)+$this->marge,0, ($i/30), $this->bord );
                        //imagedashedline($this->im,$i+$this->marge,35,$i+$this->marge,$hauteur,$this->bord );
                        }
                        elseif($i  % 180 == 0){
                                ImageLine($this->im,$i+$this->marge,14,$i+$this->marge,30,$this->bord );
                                imagestring ($this->im, 2,($i-4)+$this->marge,0, ($i/30), $this->bord );
                                //imagedashedline($this->im,$i+$this->marge,35,$i+$this->marge,$hauteur,$this->bord );


                        }
                        elseif($i %  30 == 0 ){
                                ImageLine($this->im,$i+$this->marge,18,$i+$this->marge,30,$this->bord );
                                imagestring ($this->im, 2,($i-4)+$this->marge,0, ($i/30), $this->bord );
                                //imagedashedline($this->im,$i+$this->marge,35,$i+$this->marge,$hauteur,$this->bord );


                        }
                        elseif($i %  15 == 0 ){
                                ImageLine($this->im,$i+$this->marge,22,$i+$this->marge,30,$this->bord );

                        }
                }
                $y=45;
                for($i=0;$i<$this->nb;$i++){
                        $x=0;
                        $nb=$this->tab_elt[$i]->nb();
                        $nom=$this->tab_elt[$i]->nom();
                        imagestring($this->im,2,0,$y+5, $nom, $this->bord );

                        if($nb ==0 ){
                                //$this->barre($x,$y,720,0);
                        }
                        else{
                                if($this->tab_elt[0]->tab[0]["debut"]=='00:00'){
                                        $type=1;
                                }
                                else{
                                        //$this->barre('00:00',$this->tab_elt[$i]->tab[0]["debut"],$y,0);

                                }
                                for($j=0;$j<$nb;$j++){
                                        $infos=$this->tab_elt[$i]->infos($j);
                                        $this->barre($infos["debut"],$infos["fin"],$y,$infos["type"]);

                                        if($i==$this->nb-1)
                                                $end='24:00';
                                        else
                                                $end=$this->tab_elt[$i]->tab[($j+1)]["debut"];

                                        //$this->barre($infos["fin"],$end,$y,0);
                                }


                        }
                        $y+=40;
                        if($i!=$this->nb-1){
                                imagedashedline($this->im,0,$y-7,720+$this->marge,$y-7,$this->bord );

                        }
                }
                ImageJPEG($this->im);
        }

        function afficheMAP()
        {
                $this->cpt=1;
                echo "<script language=\"Javascript\">

                function MM_findObj(n, d) { //v4.0
                        var p,i,x;  if(!d) d=document; if((p=n.indexOf(\"?\"))>0&&parent.frames.length) {
                        d=parent.frames[n.substring(p+1)].document; n=n.substring(0,p);}
                        if(!(x=d[n])&&d.all) x=d.all[n]; for (i=0;!x&&i<d.forms.length;i++) x=d.forms[i][n];
                        for(i=0;!x&&d.layers&&i<d.layers.length;i++) x=MM_findObj(n,d.layers[i].document);
                        if(!x && document.getElementById) x=document.getElementById(n); return x;
                }

                // Affichage des informations
                function show(num){ //v3.0
                        if ((obj=MM_findObj(num))!=null){
                                v='show';
                                if (obj.style)
                                {
                                        obj=obj.style; v=(v=='show')?'visible':(v='hide')?'hidden':v;
                                }

                                hide(current);
                                obj.visibility=v;
                                current=num;
                        }
                }

                // On cache l'information
                function hide(id) { //v3.0
                        if ((div=MM_findObj(id))!=null)
                        {
                                mode='hide';
                                if (div.style)
                                {
                                        div=div.style; mode=(mode=='show')?'visible':(mode='hide')?'hidden':v;
                                }
                                div.visibility=mode;
                        }
                }
                var current='com0';
                </script>";


                echo ' <map name="planning">';
                $hauteur=($this->nb * 40)+40;

                $y=45;
                for($i=0;$i<$this->nb;$i++){
                        $x=0;
                        $nb=$this->tab_elt[$i]->nb();
                        $nom=$this->tab_elt[$i]->nom().':';
                        // imagestring($this->im,2,5,$y+5, $nom, $this->bord );

                        if($nb ==0 ){
                                //$this->barreMAP($x,$y,720,0);
                        }
                        else{
                                if($this->tab_elt[0]->tab[0]["debut"]=='00:00'){
                                        $type=1;
                                }
                                else{
                                        //$this->barre('00:00',$this->tab_elt[$i]->tab[0]["debut"],$y,0);

                                }
                                for($j=0;$j<$nb;$j++){
                                        $infos=$this->tab_elt[$i]->infos($j);

                                        $this->barreMAP($infos["debut"],$infos["fin"],$y);

                                        //$js.='tab['.$this->cpt.']="'.$infos["label"].'";
                                        $js.='<div id="com'.$this->cpt.'" style="position:absolute; left:'.($this->marge+20).'px; top:'.($hauteur+300).'px; z-index:'.$this->cpt.'; visibility: hidden"><font size="3" face="Arial">'.$infos["label"].'</font></div>
                                        ';
                                        $this->cpt=$this->cpt+1;
                                }

                        }
                        $y=$y+40;
                }

                echo '</map>';

                 /*
                 echo "<script language=\"Javascript\">
                         tab=new Array;
                         $js
                         </script>";
                 */
                 echo $js;

        }

        function barre($debut,$fin,$y,$type){

                $largeur=$duree*0.5;

                switch($type){
                        case 0 :
                                $fill=$this->couleur;
                                break;
                        case 1 :
                                $fill=$this->altcouleur;
                                break;
                }
                 imageFilledrectangle ($this->im, $this->difference('00:00',$debut)*0.5+$this->marge+2, $y+2,  $this->difference('00:00',$fin)*0.5+$this->marge-2, ($y+25)-2,$fill);
                 imagerectangle ($this->im, $this->difference('00:00',$debut)*0.5+$this->marge, $y,  $this->difference('00:00',$fin)*0.5+$this->marge-1, ($y+25),$this->bord);
                 imagerectangle ($this->im, $this->difference('00:00',$debut)*0.5+$this->marge+1, $y+1,  $this->difference('00:00',$fin)*0.5+$this->marge-2, ($y+25)-1,$this->bord);

        }
         function barreMAP($debut,$fin,$y){


                 $start=$this->difference('00:00',$debut);
                 $start=round($start/2);
                 $start+=$this->marge;
                 $start+=2;

                 $end=$this->difference('00:00',$fin);
                 $end=round($end/2);
                 $end+=$this->marge;
                 $end-=2;
                 echo '<area shape="rect" coords="'.$start.','.($y+2).','.$end.','.($y+25-2).'" href="#down" OnClick="show(\'com'.$this->cpt.'\')">';


        }


        function nb(){
                return($this->nb);
        }
        function titre(){
                return($this->titre);
        }

        function difference($debut,$fin){
        /* retourne la diffrence en minute entre deux heures donnes */

                $total=0;

                list($hdeb,$mdeb)=split(':',$debut);
                list($hfin,$mfin)=split(':',$fin);
                $hdeb=strip_zero($hdeb);
                $mdeb=strip_zero($mdeb);

                $hfin=strip_zero($hfin);
                $mfin=strip_zero($mfin);

                if($mdeb>$mfin){
                        $total +=-60;
                        $total +=$mdeb-$mfin;
                }
                else
                        $total += $mfin-$mdeb ;


                $total+=($hfin-$hdeb)*60;
                return($total);
        }


        function duree($num){
                return($this->difference($this->tab[$num]["debut"], $this->tab[$num]["fin"]));
        }

        function affiche(){
                $contents=serialize($this);

                $seconds = rand(0,999);
                $thirds = rand(0,999);
                $fourths = rand(0,999);
                $file = $firsts.$seconds.$thirds.$fourths.'.dat';

                $fp=fopen($file,"w");                     // 1.On ouvre le fichier en lecture/criture
                fputs($fp,$contents);            // 2.On crit dans le fichier l'objet
                fclose($fp);
                echo '<img src="planning.class.php?invoque='.$file.'" usemap="#planning" border="0">';
                echo '<br><a name="down"></a>';
                $this->afficheMAP();
                //echo '<br><center><div id="com0">Cliquez sur un cours pour avoir son dtail ..</div></center>';

        }


}

function invoqueIMG($file){

          $fp = @fopen($file,"rb");
          while(!feof($fp)){
                $contents.= fread($fp,1024);
          }
         fclose($fp);
         $objet=unserialize($contents);
         $objet->afficheIMG();
         unlink($file);
}

if($invoque){
        invoqueIMG($invoque);
}

?>